@echo off
rem
rem Aufruf (unter DOS, KEINE DOS-Box):
rem wswap [Backup-Nummer]
rem (Der Parameter in eckigen Klammern ist optional.)
rem
rem (c) Marco Vieth, 1998
rem
rem 1.0  16.08.1999
rem 1.1  05.01.1999
rem 1.2  31.01.1999
rem
echo WinSwap (v1.2) - Windows mit Backup vertauschen
echo Marco Vieth, 31.01.1999 (http://www.benchmarko.de/)

rem We assume that WRESTORE is under C:\BATCH
set WRESTORE1=C:\BATCH\WRESTORE.BAT

rem Check that we are NOT running under Windows
rem -- cannot check this -- if not "%winbootdir%"==""  goto E_WIN

rem Check that "WINDOWS" and "PROGRA~1" exist
if not exist C:\WINDOWS\NUL  goto E_NO_WINDIR
if not exist C:\PROGRA~1\NUL  goto E_NO_PRGDIR

rem Check that no wininit.ini exist
if exist C:\WINDOWS\WININIT.INI  goto E_WINIT_EX
:START1

rem We do not expect more than 1 parameter
if not "%2"==""  echo Warnung: Parameter "%2" ignoriert!

rem Optional parameter 1: backup number
set BACKUP_NUM=%1
if not "%1"==""  goto WINSWAP1

rem Now we use BACKUP_NUM as selection list
rem Non existing backups have Code ALT-255
if exist C:\BAK_WIN0\NUL  set BACKUP_NUM=%BACKUP_NUM%0
if not exist C:\BAK_WIN0\NUL  set BACKUP_NUM=%BACKUP_NUM%
if exist C:\BAK_WIN1\NUL  set BACKUP_NUM=%BACKUP_NUM%1
if not exist C:\BAK_WIN1\NUL  set BACKUP_NUM=%BACKUP_NUM%
if exist C:\BAK_WIN2\NUL  set BACKUP_NUM=%BACKUP_NUM%2
if not exist C:\BAK_WIN2\NUL  set BACKUP_NUM=%BACKUP_NUM%
if exist C:\BAK_WIN3\NUL  set BACKUP_NUM=%BACKUP_NUM%3
if not exist C:\BAK_WIN3\NUL  set BACKUP_NUM=%BACKUP_NUM%
if exist C:\BAK_WIN4\NUL  set BACKUP_NUM=%BACKUP_NUM%4
if not exist C:\BAK_WIN4\NUL  set BACKUP_NUM=%BACKUP_NUM%
choice /C:%BACKUP_NUM%e "Nummer des zu vertauschenden Backups (E=Ende) "
rem the following IFs are ">=" comparisions
set BACKUP_NUM=0
if errorlevel 1  set BACKUP_NUM=0
if errorlevel 2  set BACKUP_NUM=1
if errorlevel 3  set BACKUP_NUM=2
if errorlevel 4  set BACKUP_NUM=3
if errorlevel 5  set BACKUP_NUM=4
if errorlevel 6  goto EXIT
:WINSWAP1

rem test
rem echo BACKUP_NUM=%BACKUP_NUM%

set BACKUP_WIN=BAK_WIN%BACKUP_NUM%
set BACKUP_PRG=BAK_PRG%BACKUP_NUM%

if not exist C:\%BACKUP_WIN%\NUL  goto E_NO_BACKUP
if not exist C:\%BACKUP_PRG%\NUL  goto E_NO_BACKUP
if exist C:\BAK_WTMP  goto E_TMP_EXIST
if exist C:\BAK_PTMP  goto E_TMP_EXIST
if not exist %WRESTORE1%  goto E_NO_WRESTORE

"attrib" -H -R C:\%BACKUP_WIN%
"attrib" -H -R C:\%BACKUP_PRG%
"attrib" -H -R C:\WINDOWS
"attrib" -H -R C:\PROGRA~1

ren C:\WINDOWS BAK_WTMP
ren C:\%BACKUP_WIN% WINDOWS
ren C:\BAK_WTMP %BACKUP_WIN%

ren C:\PROGRA~1 BAK_PTMP
ren C:\%BACKUP_PRG% PROGRA~1
ren C:\BAK_PTMP %BACKUP_PRG%

rem We do not need the Windows Swap File in our backup.
if exist C:\%BACKUP_WIN%\WIN386.SWP  DEL C:\%BACKUP_WIN%\WIN386.SWP

set BACKUP_LOG=C:\%BACKUP_WIN%\WBACKUP.LOG
if exist %BACKUP_LOG%  goto WSWAP3
echo *** Backup log started with swap to "%BACKUP_LOG%" > %BACKUP_LOG%
:WSWAP3
echo *** Swapped to C:\%BACKUP_WIN% >> %BACKUP_LOG%
rem Fast hack to show date/time
dir %BACKUP_LOG% >> %BACKUP_LOG%

set BACKUP_LOG=C:\%BACKUP_PRG%\WBACKUP.LOG
if exist %BACKUP_LOG%  goto WSWAP4
echo *** Backup log started with swap to "%BACKUP_LOG%" > %BACKUP_LOG%
:WSWAP4
echo *** Swapped to C:\%BACKUP_PRG% >> %BACKUP_LOG%
dir %BACKUP_LOG% >> %BACKUP_LOG%

set BACKUP_LOG=C:\WINDOWS\WBACKUP.LOG
if exist %BACKUP_LOG%  goto WSWAP5
echo *** Backup log started with swap to "%BACKUP_LOG%" > %BACKUP_LOG%
:WSWAP5
echo *** Swapped to C:\WINDOWS >> %BACKUP_LOG%
dir %BACKUP_LOG% >> %BACKUP_LOG%

set BACKUP_LOG=C:\PROGRA~1\WBACKUP.LOG
if exist %BACKUP_LOG%  goto WSWAP6
echo *** Backup log started with swap to "%BACKUP_LOG%" > %BACKUP_LOG%
:WSWAP6
echo *** Swapped to C:\PROGRA~1 >> %BACKUP_LOG%
dir %BACKUP_LOG% >> %BACKUP_LOG%

"attrib" +R C:\PROGRA~1
"attrib" +H +R C:\%BACKUP_WIN%
"attrib" +H +R C:\%BACKUP_PRG%

rem WRESTORE.BAT will restore "Programme" directory name
rem First create a new restore file winstar2.bat
rem (It will be renamed to winstart.bat later).
echo @ECHO OFF > C:\WINDOWS\WINSTAR2.BAT
rem If winstart.bat exist, use it as restore file winstar2.bat
if exist C:\WINDOWS\WINSTART.BAT  copy /Y C:\WINDOWS\WINSTART.BAT C:\WINDOWS\WINSTAR2.BAT

rem Create winstart.bat (if not exist)
copy /Y C:\WINDOWS\WINSTAR2.BAT C:\WINDOWS\WINSTART.BAT
rem Append a call to the original winstart.bat...
echo call %WRESTORE1% >> C:\WINDOWS\WINSTART.BAT

echo Windows mit Backup %BACKUP_NUM% vertauscht.
goto EXIT


:E_WIN
echo Fehler: WSwap.BAT bitte nicht unter Windows aufrufen, damit
echo Windows-Verzeichnis verschoben werden kann!
goto ERREXIT

:E_NO_WINDIR
echo Fehler: Verzeichnis "C:\WINDOWS" nicht gefunden.
goto ERREXIT

:E_NO_PRGDIR
echo Fehler: Verzeichnis "C:\PROGRA~1" nicht gefunden.
goto ERREXIT

:E_WINIT_EX
echo Warnung: Die Datei "C:\WINDOWS\WININIT.INI" existiert, d.h.
echo Windows mchte Dateien beim Neustart aktualisieren.
echo Sie sollten zuvor Windows neu starten.
echo Mchten Sie trotzdem vertauschen?
choice
rem "ja"
if errorlevel 1 goto START1
rem "nein"
rem if errorlevel 2 goto EXIT
goto ERREXIT

:E_NO_BACKUP
echo Fehler: Backup mit Nummer %BACKUP_NUM% existiert nicht!
echo Bitte erstellen Sie eins unter Windows mit WBackup.BAT.
goto ERREXIT

:E_TMP_EXIST
echo Fehler: Verzeichnis C:\BAK_PTMP oder C:\BAK_WTMP existiert bereits!
echo Bitte vorher lschen.
goto ERREXIT

:E_NO_WRESTORE
echo Fehler: "%WRESTORE1%" nicht gefunden.
goto ERREXIT

:ERREXIT
echo Es ist ein Fehler aufgetreten im Programm "%0"
pause
goto EXIT

:EXIT
rem Unset the variables
set BACKUP_NUM=
set BACKUP_WIN=
set BACKUP_PRG=
set BACKUP_LOG=
set WRESTORE1=
echo Ende.
