@echo off
rem
rem Aufruf (unter Windows):
rem wrestore
rem
rem (c) Marco Vieth, 1998
rem
rem 1.0  18.06.1998
rem 1.1  05.01.1999
rem 1.2  31.01.1999
rem
echo WinRestore (v1.2) - "PROGRA~1" nach "Programme" umbenennen
echo Marco Vieth, 31.01.1999 (http://www.benchmarko.de/)

set RESTORE_SRC=PROGRA~1
set RESTORE_DST=Programme

rem Check that we are running under Windows
if "%winbootdir%"==""  goto E_NO_WIN

rem Check that C:\PROGRA~1 does exist.
if not exist C:\%RESTORE_SRC%\NUL goto E_PRG1

rem Check that C:\Programme does not exist.
if exist C:\%RESTORE_DST%\NUL goto E_PRG2

rem We do not expect any parameter
if not "%1"==""  echo Warnung: Parameter "%1" ignoriert!

echo Erstelle Verzeichnisname "%RESTORE_DST%" zu "%RESTORE_SRC%"...
rem PROGRA~1 may have no long filename associated with it.
rem We cannot rename it directly because this will create [PROGRA~3]
ren C:\%RESTORE_SRC% BAK_TMP
rem Create  Programme [PROGRA~1]
ren C:\BAK_TMP %RESTORE_DST%

set BACKUP_LOG=C:\%RESTORE_DST%\WBACKUP.LOG
if exist %BACKUP_LOG%  goto WRES3
echo *** Backup log started with restore to "%BACKUP_LOG%" > %BACKUP_LOG%
:WRES3
echo *** Restore >> %BACKUP_LOG%
dir %BACKUP_LOG% >> %BACKUP_LOG%

rem See that all is ok...
"attrib" C:\%RESTORE_DST% >> %BACKUP_LOG%

goto EXIT


:E_NO_WIN
echo Fehler: WRestore bitte nur unter Windows aufrufen, damit
echo langer Dateiname erstellt werden kann!
goto ERREXIT

:E_PRG1
echo Fehler: Verzeichnis "C:\%RESTORE_SRC%" nicht gefunden!
goto ERREXIT

:E_PRG2
echo Warnung: Verzeichnis "C:\%RESTORE_DST%" gibt es bereits!
echo Aktuelle Zuordnung:
"attrib" C:\%RESTORE_DST%
echo Falls Zuordnung nicht stimmt, "C:\%RESTORE_DST%" lschen und
echo WRESTORE.BAT aufrufen...
goto ERREXIT

:ERREXIT
echo Es ist ein Fehler aufgetreten im Programm "%0"
pause
goto EXIT

:EXIT
rem Unset the variables
set RESTORE_SRC=
set RESTORE_DST=
if not exist C:\WINDOWS\WINSTAR2.BAT  goto EXIT2
rem Restore old WINSTART.BAT ...
echo Restauriere Datei "C:\WINDOWS\WINSTART.BAT"
move /Y "C:\WINDOWS\WINSTAR2.BAT" "C:\WINDOWS\WINSTART.BAT"
:EXIT2
echo Ende.