/* cm_lib_r4k_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_R4K_EVCNT_H_
#define CM_LIB_R4K_EVCNT_H_ 

#include "../driver/sinix/rxk_evcnt/evcnt_rxk.h"

/* general parameters */
#define CM_TYPE CM_T_R4K	/* defined in cm_lib.h */
#define CM_VERSION 1		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 18		/* number of events */
#define CM_P_CNT_BITS 40 	/* physical counter bits */
#define CM_USER_MODE_F 0	/* special user mode measurement, 1=possible */

/* #define CM_NEED_SETCNTS0 */	/* need to use 0 to init with EV_SETCNTS */
#define CM_SETEV_RESET		/* SET_EVENT resets the counters with 0 */

/* user mode parameters (impossible) */
#define USER_RANGE 0
/* #define ALL_RANGE USER_RANGE */


#define CM_GET_RANGE(mask)  USER_RANGE


/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt) ((event) % CM_P_CNT_NUM)

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) ((int)((event) / CM_P_CNT_NUM))


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "inst", "ldst", "picm", "pdcm", "sicm", "sdcm", \
    "ld", "st", "taken", "untkn", "o_int", "flt+i", \
    "kill", "prim", "other", "mp", "sec", "cycle"

/* event descriptions */
#define CM_EVENT_DESCR \
    "instructions", \
    "load and store operations", \
    "primary instruction cache misses", \
    "primary data cache misses", \
    "secondary instruction cache misses", \
    "secondary data cache misses", \
    "load instructions", \
    "store instructions", \
    "taken branches (conditional only, no jump instructions)", \
    "untaken branches", \
    "other integer instructions", \
    "floating point (and some integer) instructions", \
    "killed cycles", \
    "primary stall cycles", \
    "other stall cycles", \
    "multi processor stall cycles", \
    "secondary stall cycles", \
    "external clock cycles (internal= mult 2)"



/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
/* The R4K CPU monitor supports 6 event counters. */
/* So we need some additional code to find the first unused event and convert */
/* it to a mode value ... */
#define CM_SAMPLE2MODE \
  register int i = 0; \
  while ((sample[i] == EVENT_UNUSED) && (i < CM_P_CNT_NUM)) { \
    i++; \
  } \
  ev0 = (sample[i] == EVENT_UNUSED) ? 0 : sample[i]; \
  ev0 = CM_GET_MODE(ev0); \
  if (ev0 > 2) { \
    fprintf(stderr, "cm_lib PRG error: anamd %u\n", ev0); \
    return ERROR; \
  } \
  ev1 = 0;	/* mode value 1 not used. */


#endif /* CM_LIB_R4K_EVCNT_H_ */
/* end */
