/* cm_lib_r10k_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_R10K_EVCNT_H_
#define CM_LIB_R10K_EVCNT_H_ 

#include "../driver/sinix/rxk_evcnt/evcnt_rxk.h"

/* general parameters */
#define CM_TYPE CM_T_R10K	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 32		/* number of events */
#define CM_P_CNT_BITS 32	/* physical counter bits */
#define CM_USER_MODE_F 15	/* special user mode measurement poss.flag */

/* #define CM_NEED_SETCNTS0 */	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define USER_RANGE    0x08
#define SUPERV_RANGE  0x04
#define KERNEL_RANGE  0x02
#define EXCEP_RANGE   0x01
/* #define ALL_RANGE (USER_RANGE | SUPERV_RANGE | KERNEL_RANGE | EXCEP_RANGE) */


#define CM_GET_RANGE(mask) \
  ((mask & 0x08) ? USER_RANGE : 0) | \
  ((mask & 0x04) ? SUPERV_RANGE : 0) | \
  ((mask & 0x02) ? KERNEL_RANGE : 0) | \
  ((mask & 0x01) ? EXCEP_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt) ((event) & 0x01)
 /* even event numbers only on counter 0, odd event numbers only on counter 1 */

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "cycles", "cycles", \
    "inst_issue", "inst", \
    "ld_issue", "ld", \
    "st_issue", "st", \
    "st_con_issue", "st_con", \
    "st_con_fail", "float", \
    "branch_dec", "pc_qw_wbk", \
    "sc_qw_wbk", "TLBmiss", \
    "sc_ECC_corr", "branch_misp", \
    "picm", "pdcm", \
    "sicm", "sdcm", \
    "sicw_misp", "sdcw_misp", \
    "ext_intrv", "ext_intrv_hit", \
    "ext_inval", "ext_inval_hit", \
    "vc_cond", "st_hnt_CE", \
    "inst", "st_hnt_S"

/* event descriptions */
#define CM_EVENT_DESCR \
    "clock cycles", \
    "clock cycles", \
    "instructions issued", \
    "instructions graduated", \
    "loads issued (load/prefetch/sync/CacheOp issued)", \
    "loads (load/prefetch/sync/CacheOp graduated)", \
    "stores issued", \
    "stores", \
    "store conditionals issued", \
    "store conditionals", \
    "store conditionals failed", \
    "floating-point instructions graduated", \
    "branches decoded", \
    "primary (data) cache quadword written back", \
    "secondary cache quadword written back", \
    "TLB misses (TLB refill exceptions)", \
    "secondary cache ECC error corrected", \
    "branches mispredicted", \
    "primary instruction cache misses", \
    "primary data cache misses", \
    "secondary instruction cache misses", \
    "secondary data cache misses", \
    "secondary instruction cache way mispredicted", \
    "secondary data cache way mispredicted", \
    "external intervention requests", \
    "external intervention request hits", \
    "external invalidate requests", \
    "external invalidate request hits", \
    "virtual coherency conditions", \
    "stores or prefetches with store hint to Clean Exclusive sec.cache blocks", \
    "instructions graduated", \
    "stores or prefetches with store hint to Shared sec.cache blocks"





#define SET_EVENT(x) ((x) << 5)

/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
#define CM_SAMPLE2MODE \
  ev0 /= 2;		/* convert even value 0..30 to 0..15 */  \
  ev1 = (ev1 - 1) / 2;	/* convert odd value 1..31 to 0..15 */  \
  ev0 = SET_EVENT((unsigned int)ev0) | range_flg; \
  ev1 = SET_EVENT((unsigned int)ev1) | range_flg;


#endif /* CM_LIB_R10K_EVCNT_H_ */
/* end */
