/* cm_lib_ppc604_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_PPC604_EVCNT_H_
#define CM_LIB_PPC604_EVCNT_H_ 

#include "../driver/aix/ppc604/evcnt_ppc604.h"

/* general parameters */
#define CM_TYPE CM_T_PPC604	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 0x31	/* number of events */
#define CM_P_CNT_BITS 32 	/* physical counter bits */
#define CM_USER_MODE_F 3	/* special user mode measurement */

#define CM_NEED_SETCNTS0	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define USER_RANGE 0x01
#define OS_RANGE 0x02		/* supervisor (privileged) */


#define CM_GET_RANGE(mask) \
  ((mask & 0x02) ? USER_RANGE : 0) | \
  ((mask & 0x01) ? OS_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt) ((event) & 0x01)
/* even event numbers only on counter 0, odd event numbers only on counter 1 */

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
	"", "", "cycles", "cycles", "inst", "inst", "RTCSEL", "RTCSEL", \
	"inst_disp", "inst_disp", "picm", "cyc_ld_miss", "dTLBmiss", \
	"pdcm", "br_misp", "iTLBmiss", "reserv_req", "br_comp", \
	"pdcm_ld_l2", "reserv_got", "pdcm_st_l2", "mfspr_disp", "mtspr_disp", \
	"icbi", "sync", "pipe_flush", "eieio", "BRU_result", "int", \
	"SCIU0_result", "float", "MCIU_result", "LSU_result", "BRU_disp", \
	"SCIU1_result", "SCIU0_disp", "FPU_result", "load", "LSU_disp", \
	"MCIU_disp", "SCIU1_disp", "snoop_hit", "FPU_disp", "", \
        "snoop_req", "", "pdcm_ld", "", "pdcm_st"

/* event descriptions */
#define CM_EVENT_DESCR \
	"", \
	"", \
	"cycles (processor cycles)", \
	"cycles (processor cycles)",  \
	"instructions (instructions completed per cycle)", \
	"instructions (instructions completed per cycle)", \
	"RTCSELECT bit transition (from time-base lower register TBL)", \
	"RTCSELECT bit transition (from time-base lower register TBL)", \
	"inst disp (instructions dispatched)", \
	"inst disp (instructions dispatched)", \
	"primary instruction cache miss (speculative instruction cache line fill)", \
	"cycles load miss (cycles a load miss takes)", \
	"data TLB miss (not speculative)", \
	"primary data cache miss (data cache line fill)", \
	"br mispredicted (branch incorrectly predicted)", \
	"instruction TLB miss", \
	"reserv req (reservations requested)", \
	"br completed (branches completed)", \
	"pdcm ld l2 (load data cache misses with lateral L2 cache intervention)", \
	"reserv got (reservations successfully obtained)", \
	"pdcm st l2 (store data cache misses with lateral L2 cache intervention)", \
	"mfspr disp (mfspr instuctions dispatched)", \
	"mtspr disp (mtspr instuctions dispatched)", \
	"icbi (icbi instuctions; may not hit in cache)", \
	"sync (sync instuctions completed)", \
	"pipe flush (pipeline-flushing operations: sc,isync,mtspr[xer],...)", \
	"eieio (eieio instuctions completed)", \
	"BRU result (branch unit produced result (br, CR-log. instr. finished)", \
	"int (integer instuctions completed; no load, store)", \
	"SCIU0 result (unit result: add, sub, cmp, rotate, shift, logical)", \
	"float (floating-point instuctions completed; no load, store)", \
	"MCIU result (unit result: mult, div or SPR)", \
	"LSU result (load/store unit result without exception condition)", \
	"BRU disp (instructions dispatched to the branch unit)", \
	"SCIU1 result (unit result: add, sub, cmp, rotate, shift, logical)", \
	"SCIU0 disp (instructions dispatched to the SCIU0 unit)", \
	"FPU result (floating-point unit produced result)", \
	"load (loads completed; cache op., tlbie, tlbsync, sync, eieio, icbi)", \
	"LSU disp (instructions dispatched to the load/store unit)", \
	"MCIU disp (instructions dispatched to the MCIU unit)", \
	"SCIU1 disp (instructions dispatched to the SCIU1 unit)", \
	"snoop hit (snoop hits occured)", \
	"FPU disp (instructions dispatched to the floating-point unit)", \
	"", \
        "snoop req (snoop requests received; valid snoops from outside)", \
        "", \
        "pdcm ld (marked load data cache misses wo. lat. L2 cache invervention)", \
        "", \
        "pdcm st (marked store data cache misses wo. lat. L2 cache invervention)"


/* event registers/numbers, CM_EVENT_NUM different */
/* #define CM_EVENT_REG ... */

/*
 * If CM_EVENT_REG is defined, event register mapping will be created as
 * cm_event_reg in cm_lib.c
 */


/* #define SET_EVENT0(x) ((x) << 19) */
/* #define SET_EVENT1(x) ((x) << 26) */
#define SET_EVENT0(x) ((x) << 6) /* PMC1 */
#define SET_EVENT1(x) (x)	/* PMC2 */

/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
/*
 * CM_SAMPLE2MODE:
 * set event for counter 0 in bit 6-12;
 * set event for counter 1 in bit 0-5;
 * set (inverted) range in bit 29 (not user), bit 30 (not system);
 * set threshold value in bit 16-21 (if needed, not used);
 * disable counting with bit 31 (not used);
 */
#define CM_SAMPLE2MODE \
  ev0 /= 2;		/* convert even value 0..50 to 0..25 */ \
  ev1 = (ev1 > 0) ? (ev1 - 1) / 2 : 0;	/* convert odd value 1..49 to 0..24 */ \
  ev0 = SET_EVENT0((unsigned int)ev0) | SET_EVENT1((unsigned int)ev1) | (((unsigned int)range_flg ^ 0x03) << 29); \
  ev1 = 0;	/* not needed. */

#endif /* CM_LIB_PPC604_EVCNT_H_ */
/* end */
