/* cm_lib_i586mmx_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_I586MMX_EVCNT_H_
#define CM_LIB_I586MMX_EVCNT_H_ 

#ifdef LINUX
#include "../driver/linux/ix86/evcnt_ix86.h"
#endif
#ifdef SOLARIS
#include "../driver/solaris/ix86/evcnt_ix86.h"
#endif

/* general parameters */
#define CM_TYPE CM_T_I586MMX	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 0x4d	/* number of events */
#define CM_P_CNT_BITS 40 	/* physical counter bits */
#define CM_USER_MODE_F 3	/* special user mode measurement */

#define CM_NEED_SETCNTS0	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define CPL2_RANGE 0x01
#define USER_RANGE 0x02	/* CPL3 */
/* #define ALL_RANGE (USER_RANGE | CPL2_RANGE) */


#define CM_GET_RANGE(mask) \
  ((mask & 0x02) ? USER_RANGE : 0) | \
  ((mask & 0x01) ? CPL2_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
/*
 * events 0..41 are possible on both counter 0 and 1 (same as on standard i586),
 * event 42 is a pseudo event on counter 2,
 * events 43..76 are possible on counter 0 (odd ones) or counter 1 (even) only.
 */
#define CM_GET_CNT(event, cnt) (((event < 0x2a) ? (cnt & 1) : \
   (event == 0x2a) ? 2 : ((event + 1) & 0x01)))

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "ld", "st", "dTLBmiss", "pdcm_ld", "pdcm_st", "ME_wr", \
    "dcl_wbk", "dc_sno", "dc_sno_hit", "mem_conf", "bank_conf", \
    "data_misa", "code_rd", "cTLBmiss", "picm", "seg_ld", "seg_c", \
    "seg_c_hit", "branch", "BTBhit", "branch_tkn", "pipe_flu", \
    "inst", "inst_v", "bus_wait", "wrt_s", "dta_rd_s", \
    "ME_wr_s", "bus_lock", "IO_rdwr", "nonc_rd", "AGI_s", \
    "", "", "float", "brk_0", "brk_1", "brk_2", "brk_3", \
    "hard_int", "ldst", "pdcm", "cycles", \
    "MMX_inst_u", "MMX_inst_v", "", "", \
    "EMMS_inst", "MMX_FP_trans", "", "nonc_wr", \
    "MMX_sat_exec", "MMX_sat_perf", "cpu_non_HLT", "", \
    "MMX_ld", "", "FP_s", "branch_tkn", \
    "FIFO_empty_s", "FIFO_1inst_s", "MMX_st", "MMX_st_miss", \
    "pipe_flu_br", "pipe_flu_WB", "MMX_dta_misa", "MMX_dta_rd_s", \
    "ret_misp", "ret_pred", "MMX_mult_s", "MOVD_Q_s", \
    "returns", "RSB_oflow", "BTB_false", "BTB_misp_utkn", \
    "MMX_wrtbuf_s", "MMX_EM_s"

/* event descriptions */
#define CM_EVENT_DESCR \
    "load (Data Read)", \
    "store (Data Write)", \
    "data TLB miss (Data TLB Miss)", \
    "primary data cache miss during load (Data Read Miss)", \
    "primary data cache miss during store (Data Write Miss)", \
    "modified or exclusive write (Write (hit) to M or E state lines)", \
    "data cache lines written back (Data Cache Lines Written Back)", \
    "data cache snoops (External Data Cache Snoops)", \
    "data cache snoop hits (External Data Cache Snoop Hits)", \
    "memory conflicts (Memory Accesses in Both Pipes)", \
    "bank conflicts (Bank Conflicts)", \
    "data misaligned (Misaligned Data Memory or I/O References)", \
    "code read (Code Read)", \
    "code TLB miss (Code TLB Miss)", \
    "primary instruction cache miss (Code Cache Miss)", \
    "segment register load (Any Segment Register Loaded)", \
    "segment cache (Segment Descriptor Cache Access; undocumented)", \
    "segment cache hits (Segment Descriptor Cache Hits; undocumented)", \
    "branches (Branches)", \
    "BTB hits (Branch Target Buffer predictions)", \
    "branch taken (Taken Branch or BTB hit)", \
    "pipeline flushes (Pipeline Flushes)", \
    "instructions (Instructions Executed)", \
    "instructions V (Instructions Executed in the V-pipe)", \
    "bus wait (Clocks while a bus cycle is in progress; bus utilisation)", \
    "write stall (Number of clocks stalled due to full write buffers)", \
    "data read stall (Pipeline stalled waiting for data memory read)", \
    "modified exclusive write stall (Stall on write to an E or M state line)", \
    "bus locked (Locked Bus Cycles; undocumented)", \
    "I/O read write (I/O Read or Write Cycle)", \
    "non-cacheable reads (Non-cacheable memory reads)", \
    "AGI stalls (Pipeline stalled because of an address generation interlock)", \
    "(Reserved)", \
    "(Reserved)", \
    "floating-point operations (FLOPs)", \
    "breakpoint 0 match (Breakpoint match on DR0 Register)", \
    "breakpoint 1 match (Breakpoint match on DR1 Register)", \
    "breakpoint 2 match (Breakpoint match on DR2 Register)", \
    "breakpoint 3 match (Breakpoint match on DR3 Register)", \
    "hardware interrupts (Hardware Interrupts)", \
    "load store (Data Read or Data Write)", \
    "primary data chache misses (Data Read Miss or Data Write Miss)", \
    "cycles (Clock cycles; cycles from time stamp counter)", \
    "MMX instructions U (MMX instructions executed in U-pipe)", \
    "MMX instructions V (MMX instructions executed in V-pipe)", \
    "", \
    "", \
    "EMMS instructions (EMMS instructions executed)", \
    "MMX FP transition (Transition between MMX instruction and FP instruction)", \
    "", \
    "non-cacheable writes (Writes to Non-Cacheable Memory)", \
    "MMX saturate exec (Saturating MMX instructions executed)", \
    "MMX saturations performed (Saturations performed)", \
    "cpu non HALT (Number of Cycles the CPU is Not in HLT State)", \
    "", \
    "MMX load (MMX instruction data reads)", \
    "", \
    "FP stalls (Floating-Point Stalls)", \
    "branch taken (Taken Branches)", \
    "FIFO empty stall (D1 starvation and FIFO is empty)", \
    "FIFO one inst. stall (D1 starvation and only one instruction in FIFO)", \
    "MMX store (MMX instruction data writes)", \
    "MMX_store miss (MMX instruction data write misses)", \
    "pipeline flush branch (Pipeline flushes due to wrong branch prediction)", \
    "pipeline flush WB (Pipeline flushes due to wrong branch pred. in WB state)", \
    "MMX data misaligned (Misaligned data memory reference on MMX instruction)", \
    "MMX data read stall (Pipeline stalled waiting for MMX instruction data mem. rd.)", \
    "returns mispredicted (Returns Predicted Incorrectly)", \
    "returns predicted (Returns Predicted Correctly and Incorrectly)", \
    "MMX mult stall (MMX instruction multiply unit interlock)", \
    "MOVD MOVQ stall (MOVD/MOVQ store stall due to previous operation)", \
    "returns (Returns)", \
    "RSB oflow (Return Stack Buffer overflows)", \
    "BTB false (BTB false entries)", \
    "BTB mispredicted untaken (BTB miss prediction on a Not-Taken Branch)", \
    "MMX writebuffer stall (Clocks stalled due to full write buffers while MMX inst.)", \
    "MMX_EM_s (Stall on MMX instruction write to E or M line)"

#define CM_I586_TYPE_TICKS 0

/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
/*
 * events 0..41 are taken directly (same as on standard i586),
 * event 42 is taken directly
 * events 43..76 are divided by 2 because 2 succeeding events use same mode
 *   value.
 */
#define CM_SAMPLE2MODE \
  if (ev0 >= 0x2b) { ev0 = ((ev0 - 0x2b) / 2) + 0x2b; } \
  if (ev1 >= 0x2b) { ev1 = ((ev1 - 0x2b) / 2) + 0x2b; } \
  ev0 = ev0 | ((CM_I586_TYPE_TICKS << 2) | range_flg) << 16; \
  ev1 = ev1 | ((CM_I586_TYPE_TICKS << 2) | range_flg) << 16;


#endif /* CM_LIB_I586MMX_EVCNT_H_ */
/* end */
