/* cm_lib_athlon_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_ATHLON_EVCNT_H_
#define CM_LIB_ATHLON_EVCNT_H_ 

#ifdef LINUX
#include "../driver/linux/ix86/evcnt_ix86.h"
#endif
#ifdef SOLARIS
#include "../driver/solaris/ix86/evcnt_ix86.h"
#endif

/* general parameters */
#define CM_TYPE CM_T_ATHLON	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 39 	/* number of events */
#define CM_P_CNT_BITS 48 	/* physical counter bits */
#define CM_USER_MODE_F 3	/* special user mode measurement */

#define CM_NEED_SETCNTS0	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define USER_RANGE 0x01	/* CPL1..CPL3 */
#define OS_RANGE 0x02	/* CPL0 */
/* #define ALL_RANGE (USER_RANGE | OS_RANGE) */


#define CM_GET_RANGE(mask) \
  ((mask & 0x02) ? USER_RANGE : 0) | \
  ((mask & 0x01) ? OS_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
/*
 * The Athlon can count any event with a counter.
 *
 */
/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt)   (cnt & 0x03)


/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "", \
    "dc_access", "dc_miss", \
    "dc_ref_L2", "dc_ref_L2_M", "dc_ref_L2_O", "dc_ref_L2_E", "dc_ref_L2_S", "dc_ref_L2_I", \
    "sdcm", "sdcm_M", "sdcm_O", "sdcm_E", "sdcm_S", "sdcm_I", \
    "dc_wb", "dc_wb_M", "dc_wb_O", "dc_wb_E", "dc_wb_S", "dc_wb_I", \
    "L1_dTLBm", "dTLBm", "data_misa", \
    "ic_fetch", "icm", \
    "L1_iTLBm", "iTLBm", \
    "inst_ret", "ops_ret", \
    "br_ret", "br_ret_misp", \
    "br_tkn_ret", "br_tkn_ret_misp", \
    "farctl_ret", "br_resy_ret", \
    "int_masked", "int_masked_pend", "hw_int"


/* event descriptions */ 
#define CM_EVENT_DESCR \
    "", \
    "dc access (Data cache accesses)", \
    "dc miss (Data cache misses)", \
    "dc ref L2 (Data cache refills from L2)", \
    "dc ref L2 M (Data cache refills from L2; modified)", \
    "dc ref L2 O (Data cache refills from L2; owner)", \
    "dc ref L2 E (Data cache refills from L2; exclusive)", \
    "dc ref L2 S (Data cache refills from L2; shared)", \
    "dc ref L2 I (Data cache refills from L2; invalid)", \
    "sdcm (Secondary data cache misses; refills from system)", \
    "sdcm M (Secondary data cache misses; refills from system; modified)", \
    "sdcm O (Secondary data cache misses; refills from system; owner)", \
    "sdcm E (Secondary data cache misses; refills from system; exclusive)", \
    "sdcm S (Secondary data cache misses; refills from system; shared)", \
    "sdcm I (Secondary data cache misses; refills from system; invalid)", \
    "dc wb (Data cache writebacks)", \
    "dc wb M (Data cache writebacks; modified)", \
    "dc wb O (Data cache writebacks; owner)", \
    "dc wb E (Data cache writebacks; exclusive)", \
    "dc wb S (Data cache writebacks; shared)", \
    "dc wb I (Data cache writebacks; invalid)", \
    "L1 dTLBm (L1 data TLB misses and L2 dTLB hits)", \
    "dTLBm (data TLB misses; L1 and L2)", \
    "data misa (Misaligned data references)", \
    "ic fetch (Instruction cache fetches)", \
    "icm (Instruction cache misses)", \
    "L1 iTLBm (L1 instruction TLB misses and L2 iTLB hits)", \
    "iTLBm (Instruction TLB misses; L1 and L2)", \
    "inst ret (retired instructions; exceptions, interrupts, resyncs)", \
    "ops ret (Retired Ops)", \
    "br ret (Retired branches (conditional, uncond, exception, interrupt)", \
    "br ret misp (Retired branches mispredicted)", \
    "br tkn ret (Retired taken branches)", \
    "br tkn ret misp (Retired taken branches mispredicted)", \
    "farctl ret (Retired far control transfers)", \
    "br resy ret (Retired resync branches; only non-control transfers)", \
    "int masked (Interrupts masked cycles; IF=0)", \
    "int masked pend (Interrupts masked while pending cycles; INTR while IF=0)", \
    "hw int (Taken hardware interrupts)"


/* event registers/numbers, CM_EVENT_NUM different */
#define CM_EVENT_REG \
    0x00, \
    0x40, 0x41, \
    0x42 | 0x1f00, 0x42 | 0x1000, 0x42 | 0x0800, 0x42 | 0x0400, 0x42 | 0x0200, 0x42 | 0x0100, \
    0x43 | 0x1f00, 0x43 | 0x1000, 0x43 | 0x0800, 0x43 | 0x0400, 0x43 | 0x0200, 0x43 | 0x0100, \
    0x44 | 0x1f00, 0x44 | 0x1000, 0x44 | 0x0800, 0x44 | 0x0400, 0x44 | 0x0200, 0x44 | 0x0100, \
    0x45, 0x46, 0x47, \
    0x80, 0x81, \
    0x84, 0x85, \
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, \
    0xcd, 0xce, 0xcf


/*
 * If CM_EVENT_REG is defined, event register mapping will be created as
 * cm_event_reg in cm_lib.c
 */


#define CM_I686_TYPE_TICKS 1 /* also for Athlon */

/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
#define CM_SAMPLE2MODE \
  ev0 = cm_event_reg[ev0] | ((CM_I686_TYPE_TICKS << 2) | range_flg) << 16; \
  ev1 = cm_event_reg[ev1] | ((CM_I686_TYPE_TICKS << 2) | range_flg) << 16; 

/* to do:
  ev2 = cm_event_reg[ev2] | ((CM_I686_TYPE_TICKS << 2) | range_flg) << 16; \
  ev3 = cm_event_reg[ev3] | ((CM_I686_TYPE_TICKS << 2) | range_flg) << 16;
*/

#endif /* CM_LIB_ATHLON_EVCNT_H_ */
/* end */
