/* cm_lib.h */

#ifndef CM_LIB_H_
#define CM_LIB_H_

/*
 * Currently, there are evcnt devices for MIPS R4K, MIPS R10K,
 * Intel Pentium (i586), Intel Pentium MMX (i586MMX),
 * Intel Pentium Pro (i686), Intel Pentium II (i686MMX),
 * AMD Athlon, PowerPC 604 and HP PA1 (not implemented yet).
 * Use -D <name> to select one:
 * R4K_EVCNT
 * R10K_EVCNT
 * I586_EVCNT
 * I586MMX_EVCNT
 * I686_EVCNT
 * I686MMX_EVCNT
 * ATHLON_EVCNT
 * PPC604_EVCNT
 * PA1_EVCNT
 *
 */

#include "general.h" /* ErrCode */

enum cmi_type_e {
  CM_T_UNKNOWN, CM_T_R4K, CM_T_R10K, CM_T_I586, CM_T_I586MMX, CM_T_I686,
  CM_T_I686MMX, CM_T_ATHLON, CM_T_PPC604, CM_T_PA1
};

/* includes depending on the machine */

#ifdef R4K_EVCNT
#include "cm_lib_r4k_evcnt.h"
#endif /* R4K_EVCNT */

#ifdef R10K_EVCNT
#include "cm_lib_r10k_evcnt.h"
#endif /* R10K_EVCNT */

#ifdef I586_EVCNT
#include "cm_lib_i586_evcnt.h"
#endif /* I586_EVCNT */

#ifdef I586MMX_EVCNT
#include "cm_lib_i586mmx_evcnt.h"
#endif /* I586MMX_EVCNT */

#ifdef I686_EVCNT
#include "cm_lib_i686_evcnt.h"
#endif /* I686_EVCNT */

#ifdef I686MMX_EVCNT
#include "cm_lib_i686mmx_evcnt.h"
#endif /* I686MMX_EVCNT */

#ifdef ATHLON_EVCNT
#include "cm_lib_athlon_evcnt.h"
#endif /* ATHLON_EVCNT */ 

#ifdef PPC604_EVCNT
#include "cm_lib_ppc604_evcnt.h"
#endif /* PPC604_EVCNT */

#ifdef PA1_EVCNT
#include "cm_lib_pa1_evcnt.h"
#endif /* PA1_EVCNT */

#define CM_DEFAULT_MASK 255


/* CPU monitor info structure */
struct cm_info_s {
  int type;		/* type of CPU monitor, 0=unknown, 1=R4K (cpum), */
    /* 2=R10K, 3=i586, 4=i586mmx, 5=i686, 6=i686mmx, 7=PowerPC604 */
  int version;		/* version number */
  int event_num;	/* number of events */
  int p_cnt_num;	/* number of physical counters */
  int p_cnt_bits;	/* physical counter bits */
  int user_mode_f;	/* set, if counters support user mode counting */
    /* in addition to system wide counting */
};


typedef double cm_counter_t;

struct cm_mode_s {
  unsigned ev_mode[2];    /* event mode */
};

struct cm_lib_c {
  int fd;
  int stop_flg;		/* flag if counters are stopped */
  int event_num;	/* number of events in use */
  int *events;		/* event numbers */

  int sample_num;
  int *samples;
  int sample_pos;	/* position in event2 buffer */
  struct cm_mode_s *cmd; /* event mode array (for all samples) */

  cm_counter_t *old_event; /* old event values */
  struct cpum_erg *c_result; 	/* pointer to current c_result */
    /* struct cpum_erg is defined elsewere inside cm_lib.c */
};


extern ErrCode cm_get_info(struct cm_info_s *cmi);
extern char *cm_get_eventtxt(const int event);
extern char *cm_get_eventdescr(const int event);
extern ErrCode cm_test_cnt_event(const int p_cnt, const int event);

extern ErrCode cm_open(struct cm_lib_c *cml, const int cnt_num, const int *events, const int measure_mask);
extern ErrCode cm_get_sample_num(struct cm_lib_c *cml, int *sample_num);
extern ErrCode cm_close(struct cm_lib_c *cml);
extern ErrCode cm_init(struct cm_lib_c *cml);
extern ErrCode cm_start(struct cm_lib_c *cml);
extern ErrCode cm_stop(struct cm_lib_c *cml);
extern ErrCode cm_read0_diff(struct cm_lib_c *cml, cm_counter_t *cnt);

#endif /* CM_LIB_H_ */
/* end */
