//: SNA2GIF.H
//.
// Marco Vieth, 27.1.1997
//

#ifndef SNA2GIF_H_
#define SNA2GIF_H_

#include "sna2_gen.h"	// general prototypes, defines



class screen {
  enum { s_max_multi = 6 };

  byte *cpc_palette;

  int width;	// pixels across the screen (640, 320, 160)
  int height;	// pixles down the screen (200)
  int numcolours;	// number of different colours (2, 4, 16, 32?)
  int bits_pr_prim_colour;	// bits per primary colour
  //
  static int hori_fact; 	// horizontal factor to expand width
  static int verti_fact;	// vertical factor to expand height
  //
  byte ga_inkval[17];
  static byte ga_mode;
  byte ga_mmode[s_max_multi];
  static byte crtc_data[18];
  static fbyte *mem_ptr;
  fbyte *mem_bptr;
  //
  static word cpc_offset;
  static int pix_p_byte;	// pixels per byte
  static int scr_hori;		// screen characters horizontal
  static int scr_verti;		// screen characters vertical
  static int scr_char_raster;	// screen character raster
  static int overscan;		// overscan flag
  //
  ErrCode load_sshot(char *fname);
  ErrCode compress(void);
public:
  enum {
    paltab_size = 32*3
  };
  static void set_paltab(const int col_flg, const byte paltab[paltab_size]);
  ErrCode init(char *filename);
  static int gpixel(int x, int y);
  ErrCode create(char *filename);
  screen(int colour_flg, int hori_f, int verti_f);
  ~screen(void);
};


#endif				// SNA2GIF_H__
//end of sna2gif.h
