//: SNA2_S2.CPP   (SYMTAB.CPP - Symbol table)
//.
// Marco Vieth, 17.12.1995
//


#include <string.h>	// strcmp()
//#include <iostream.h>	// cerr

#include "sna2_s2.h"
#include "sna2_gen.h"




int symtab::look(const char *s, int insert) {
  int i = 0;	// hash
  const char *p = s;
  while (*p)  i = (i<<1) ^ *p++;
  if (i < 0)  i = -i;
  i %= TABLSZ;

  for (name *n = table[i]; n; n = n->next)	// search
    if (strcmp(s, n->string) == 0)  return(n->code);

  if (insert == 0) {	// not found, and no insert!
    return (0);
  }

  name *nn = new name;	// insert
  if (nn == (name *)0) { return(0); }
  nn->string = new char[strlen(s)+1];
  if (nn->string == (char *)0) { return(0); }
  strcpy(nn->string, s);
  nn->code = max_code++;
  nn->next = table[i];
  table[i] = nn;
  return(nn->code);
}

symtab::symtab(void) {
  max_code = 0;
  for (int i = 0; i < TABLSZ; i++)  table[i] = (name *)0;
}

symtab::~symtab(void) {
  name *help1, *help2;
  for (int i = 0; i < TABLSZ; i++) {
    help1 = table[i];
    while (help1 != (name *)0) {
      help2 = help1;
      help1 = help1->next;
      delete help2->string;
      delete help2;
    }
  }
}

// End of symtab.cpp
