//: SCAN.CPP - Scan the configuration
//.
// Marco Vieth, 17.12.1995
//


#include <ctype.h>	// isalpha()
#include <iostream.h>
#include <fstream.h>	// ifstream

#include "sna2_s1.h"
#include "sna2_gen.h"


scan::scan(void) {
  col = 0;
  line = 1;
  t_col = 0;
  number = 0;
  name[0] = '\0';
  errors = 0;
}

scan::~scan(void) {
}

//ErrCode scan::errout(const char *message) {
//  cerr << "Error: " << message << " at column " << col << ", line " << line
//       << endl;
//  return ERROR;
//}

int /* near */ scan::warnout(const char *msg1, const char *tok_txt) {
  cout << "Warning: ";
  if (tok_txt[0] != '\0')  cout << "(" << tok_txt << ") ";
  cout << msg1 << " at column " << t_col << ", line " << line << endl;
  return (++errors);
}

int near scan::get_number(const int radix) {
  int n = 0, i;
  char ch;
  int save_col = col;
  do {
    if (!get(ch))  return(n);
    if (isalpha(ch))  i = toupper(ch) - 'A' + 10;  else i = ch - '0';
    if ((i >= 0) && (i < radix))  { n *= radix; n+= i; col++; }
  } while ((i >= 0) && (i < radix));
  putback(ch);
  if (col == save_col)  warnout("no number");
  return(n);
}

scan::scan_e /* near */ scan::get_scan(void) {
  char ch = '\0';
  do {
    if (ch == ';') {
      do {
	if (!get(ch))  return ENDTOK;
	//col++  not needed
      } while (ch != '\n');	// overread comment until EOL
      col = 0; line++;
    }
    do {
      if (!get(ch))  return ENDTOK;
      update_linecol(ch);
    } while (isspace(ch));
  } while (isspace(ch) || (ch == ';'));
  //
  t_col = col;		// save position of scan start;
  if (ch == '=')  return EQUAL;
  else if (ch == ',')  return COMMA;
  else if ((ch == '#') || isalpha(ch) || (ch == '_')) {
    char *p = name;
    int cnt = MAXSTRLEN-1;
    *p++ = toupper(ch);
    while (--cnt && get(ch) && (isalnum(ch) || (ch == '_'))) {
      *p++ = toupper(ch);
      col++;
    }
    putback(ch);
    *p = 0;
    return NAME;
  }
  else if (ch == '"') {
    char *p = name;
    int cnt = MAXSTRLEN;
    while (--cnt && get(ch) && (ch != '"') && (ch != '\n')) {
      *p++ = toupper(ch);
      col++;
    }
    *p = 0;
    if (ch == '"')  col++;
    if (ch == '\n') {
      warnout("string terminator '\"' missing");
      col = 0; line++;
    }
    return STRING;
  }
  else if (ch == '%') {
    number = get_number(2);
    return NUMBER;
  }
  else if (ch == '&') {
    number = get_number(16);
    return NUMBER;
  }
  else if ((ch >= '0') && (ch <= '9')) { // isdigit() does not work for ae
    putback(ch); col--;
    if (ch != '0') {
      number = get_number(10);
    }
    else {	// number starts with '0', so maybe '0x' or '0X' which is hex
      number = get_number(10);	// assume it is decimal
      if ((number == 0) && (col == t_col)) {   // 0=maybe hex?
	get(ch);
	if ((ch == 'x') || (ch == 'X')) {  // check if it is hex
	  col++;
	  number = get_number(16);
	}
	else putback(ch);		// no, it is really decimal 0
      }
    }
    return NUMBER;
  }

//  {
//    char buf[MAXSTRLEN];
//    sprintf(buf, "Wrong character '%c'", ch);
//    warnout(buf);
//  }
  return NOTOK;
}

void /* near */ scan::flush_line(void) {
  char ch;
  do {
    if (!get(ch))  return;
  } while (ch != '\n');
  col = 0;
  line++;
}


#ifdef DEBUG
void near scan::test_tok(enum scan_e te) {
    cout << "scan=" << te << "; ";
    switch(te) {
      case NAME:
	cout << name;
      break;
      case NUMBER:
	cout << number;
      break;
      case STRING:
	cout << name;
      break;
      case EQUAL:
	cout << "=";
      break;
      case COMMA:
	cout << ",";
      break;
      default:
	cout << "?";
      break;
    }
    cout << endl;
}
#endif
// End of scan.cpp
