//: GENERAL.H - General prototypes, defines for CPCEMU
//.
// Marco Vieth, 12.2.1995
//
// developed from CPCPROT.H.

#ifndef GENERAL_H_
#define GENERAL_H_


// use -DUNIX to compile for unix (-DMSDOS is default)
#ifdef __BORLANDC__
// #define Use_Windows
#define MY_MALLOC farmalloc
#define MY_FREE farfree
#define MY_FAR far
#else /* UNIX, windows 32 bit */
#define MY_MALLOC malloc
#define MY_FREE free
#define MY_FAR
#endif

//#define BIG_ENDIAN
// if your machine uses big endian byte order, needed in z80_c.cpp

#define R_REG
// R-register-emulation
// don't forget to change _R_REG_TOO in Z80EMU.ASM, too!

//#define COZ80
// emulation with COZ80
// don't forget to change _CPC_CO in Z80EMU.ASM, too!

#define NDEBUG
// nodebug: ignore assert

// for optimization: concatenate some modules and use -DNEAR=near
#ifndef NEAR
#define NEAR		// not near
#endif

// define near, far as nothing
#ifdef UNIX
#define near
#define far
#endif


typedef unsigned char byte;
typedef unsigned short int word;
typedef unsigned long ulong;
typedef byte far fbyte;		// far byte


typedef int ErrCode;
#define OK		0
#define ERROR		1

#define MAXSTRLEN 200


// ------------------
// start myassert
#undef assert
#ifdef NDEBUG
#define assert(p)   ((void)0)
#else
//void brk::assert_failed(char *, char *, int);
#include "brk.h"
#define assert(p) ((p) ? (void)0 : (void) brk::assert_failed(#p, __FILE__, __LINE__) )
#endif
// end myassert

#endif			// GENERAL_H_
// end of general.h
