//: K_MATRIX.CPP -- simplified matrix class for kohonens algorithm
//. 31.12.1994
//

#include <stdlib.h>	// exit()
#include <math.h>	// fabs()
#include <iostream.h>
#include <iomanip.h>	// setw(), setprecision()
#include "k_matrix.h"


#define FAST_ACCESS	// fast access to matrix members
			// (without out of bounds check ?)


const scalar limit = scalar(1e-14);

// output format for cout:
#define WID setw(6)
//#define PREC setprecision(3)
#define PREC setprecision(6)



void matrix::error(char *msg1, char *msg2) {
  cerr << "matrix error: " << msg1 << " " << msg2 << endl;
  exit(1);
}

// create the matrix ...
void *matrix::create(int mrows, int mcols) {
  p = new matrep;	// create the scructure
  p->r = mrows;
  p->c = mcols;
  p->m = new scalar *[mrows];	// allocate memory ...
  for (int i = 0; i < mrows; i++)
    p->m[i] = new scalar[mcols];	// ... for the actual matrix
  p->n = 1;	// so far, there's one referenct to this data
  return p;
}

// dispose the matrix, if no references any more
void matrix::dispose(void) {
  if (--p->n == 0) {	// if nobody else is refering us...
    for (int i = 0; i < rows(); i++)
      delete p->m[i];
    delete p->m;	// delete data
    delete p;
  }
}


matrix::matrix(int mrows, int mcols, scalar initval) {
  create(mrows, mcols);
  for (int i = 0; i < mrows; i++)
    for (int j = 0; j < mcols; j++)
      mval(i, j) = initval;
}


matrix::matrix(char *flag, int mrows, int mcols, scalar *initvalues) {
  if (flag[0] != 'D')
    error("to create a defined matrix: matrix(\"D\", ...)");
  create(mrows, mcols);
  for (int i = 0; i < mrows; i++)
    for (int j = 0; j < mcols; j++)
      mval(i, j) = *initvalues++;
}


// create an identity matrix
matrix::matrix(char *flag, int dimension) {
  if (flag[0] != 'I')
    error("to create an identity matrix: matrix(\"I\", dimension)");
  create(dimension, dimension);
  for (int i = 0; i < dimension; i++)
    for (int j = 0; j < dimension; j++)
      mval(i, j) = ((i == j) ? 1 : 0);
}


matrix::matrix(matrix& x) {
  x.p->n++;	// we're adding another reference.
  p = x.p;	// point to the new matrep.
}

matrix::~matrix() {
  dispose();	// dispose the matrix, if reference count goes to 0
}


#ifndef VAL_INLINE
scalar& matrix::val(int row, int col) {
#ifndef FAST_ACCESS
  if (row < 0 || row >= rows() || col < 0 || col >= cols())
    error("index out of range");
#endif
  return(mval(row, col));
}
#endif


void matrix::resize_matrix(int mrows, int mcols, scalar initval) {
  dispose();
  create(mrows, mcols);
  for (int i = 0; i < mrows; i++)
    for (int j = 0; j < mcols; j++)
      mval(i, j) = initval;
}

void matrix::print(char *msg) {
  if (*msg) cout << msg << ":" << endl;
  for (int i = 0; i < rows(); i++) {
    for (int j = 0; j < cols(); j++) {
      scalar result = mval(i, j);
      if (fabs(result) < limit) result = 0;
      cout << WID << PREC << result << "  ";
    }
    cout << endl;
  }
}

//end
