//: BGI.CPP -- class to "wrap" around Borland Graphics Interface
// Taken from Bruche Eckel: C++ Inside & Out, Osborne McGraw-Hill 1993
// 31.12.1994
//

#include "bgi.h"
//#include <graphics.h>
#include <iostream.h>
#include <stdlib.h>
#include <conio.h>

// static data member definitions:
COLORS Graphics::maxcolor;
int Graphics::gdriver, Graphics::gmode, Graphics::errorcode,
    Graphics::X_max, Graphics::Y_max,
    Graphics::X_win, Graphics::Y_win;

Graphics::Graphics(char *path, graphics_drivers gdriv) {
  // initialize graphics and local variables:
  gdriver = gdriv;

  //detectgraph(&gdriver, &gmode);
  initgraph(&gdriver, &gmode, path);

  // read result of initialization:
  errorcode = graphresult();
  while (errorcode != grOk) {	// error -> try local directory
    initgraph(&gdriver, &gmode, ".");
    errorcode = graphresult();
    if (errorcode == grOk) break;
    cerr << "Graphics error: " << grapherrormsg(errorcode) << endl
      << "Maybe a BGI driver is missing in the local directory.\n"
      << "Press any key to exit:";
    getch();
    exit(1);	// terminate with an error code
  }
  X_max = getmaxx();
  Y_max = getmaxy();
  X_win = X_max;
  Y_win = Y_max;
  maxcolor = (COLORS)getmaxcolor();
}

void Graphics::on() {
  setgraphmode(getgraphmode());
}

void Graphics::off() {
  restorecrtmode();
}

void Graphics::bottomprompt(char *prompt) {
  const clipping = 0;	// off
  setviewport(0, Y_max - textheight(prompt), X_max, Y_max, clipping);
  clearviewport();
  outtextxy(0, 0, prompt);
  setviewport(0, 0, X_max, Y_max, clipping);
}

void Graphics::window(int x_width, int y_width) {
  const clipping = 0;
  int x_off = (X_max - x_width)/2;
  int y_off = (Y_max - y_width)/2;
  X_win = x_width;
  Y_win = y_width;
//  cout << x_off << "+" << x_width << "=" << x_off + x_width << "; ";
//  cout << y_off << "+" << y_width << "=" << y_off + y_width << endl;
  setviewport(x_off, y_off, x_off+x_width, y_off+y_width, clipping);
}

void Graphics::clearwindow() {
  clearviewport();
}

//end
