;b8cpm - 8 bit Druckerausgabe (v1.1)
;8.1.1994
;for CPC 664/6128, 8 bit, ...
;
nolist

write"b8cpm.com"

BDOS equ 5

PATCHADDR EQU #bdf1       ;#bd2b is before char translation -> not useable

org #100
        call MESSAGE
        call TRANSLATE

        ld hl,PATCHADDR
        ld de,NEWJP
        ld b,3
        call CPMDEHL
        ld de,ALREADY
        jr Z,MOUT         ;already installed

        ld hl,PSTART
        ld de,DEST
        ld bc,PEND-PSTART
        LDIR              ;copy patch
        ;Patch einhaengen
        ld hl,PATCHADDR
        push hl
        ld de,DRUCKE+OFF  ;new
        ld bc,3
        ldir              ;save old routine
        pop de
        ld hl,NEWJP
        ld bc,3
        ldir              ;set new
        ret
;
NEWJP   JP DEST
;

CPMDEHL ld a,(de)
        inc de
        cp (hl)
        inc hl
        ret nz
        djnz CPMDEHL
        ret
;
TRANSLATE
        LD C,0            ;ROM 0
        CALL #B915        ;KL PROBE ROM
        CP #80
        ld de,UNKNROM
        jr nz,MOUT        ;unknown ROM
        LD A,H
        OR A              ;version 1.0 = cpc 464 ?
        ld de,CPC464
        jr Z,MOUT         ;yes
        LD HL,TRTAB

        ;CALL #BD58        ;MC PRINT TRANSLATION
        ;scheint's unter CP/M 2.2 nicht zu geben !!, also ...
        rst 1
        dw #880c          ;only for cpc 6128 !!

        ld de,TRANS
        CALL MOUT
        RET

TRTAB   DB 7              ;# substitutions
        DB 91, 142        ;Ae
        DB 92, 153        ;Oe
        DB 93, 154        ;Ue
        DB 123, 132       ;ae
        DB 124, 148       ;oe
        DB 125, 129       ;ue
        DB 126, 225       ;ss
;
;


MESSAGE
        LD DE,MSTR1
        CALL MOUT
        RET

MOUT
        LD C,9
        CALL BDOS
        RET

MSTR1
        DB "b8cpm - 8bit printer patch with german character translation"
        DB 10, 13, "$"

TRANS
        DB "character translation installed."
        DB 10, 13, "$"
UNKNROM
        DB "unknown ROM found."
        DB 10, 13, "$"
ALREADY
        DB "Patch already installed !"
        DB 10, 13, "$"
CPC464  DB "CPC 464 found. Translation only for CPC 664/6128."
        DB 10, 13, "$"
;

PSTART
        CP #80            ;ZEICHEN<#80?
        JR C,DRUCKE       ;JA NORMAL AUSGEBEN
        PUSH BC
        LD BC,#F620
        OUT (C),C         ;set bit
        POP BC
        CALL DRUCKE+OFF
        PUSH BC
        LD BC,#F600
        OUT (C),C         ;clear bit
        POP BC
        RET
;
DRUCKE
        jp 0              ;a jump to the correct routine is inserted
;RST 8
;DEFW 0            ;#81B+#8000   ;CPC 6128 PRINT CHAR !! can't use !
PEND


;
;Basic Stack 6128 von &AE6F bis &B06E
;DEST EQU #B06E-PENDE+PSTART  ;im BASIC-STACK 6128
DEST EQU #be00   ;im freien Bereich #be00-#be3f 


OFF EQU DEST-PSTART
;
;to check the borders ...
list
deststart equ DEST
destend equ DEST+PEND-PSTART
END
;
