#!/usr/bin/perl -w
# bmcreate1.pl - BM PerlGen v1.07
# Benchmarko Perl Generator for Websites
# (c) Marco Vieth, 2001
#
# 1.00  02.02.2001  first tests;
#                   copy only modified files (with newer timestamps);
#                   rename files to index.html, if they are named like the directory;
# 1.01  03.02.2001  replace special characters
#                   nested '##INCLUDE "<file>"' possible!
# 1.02  09.02.2001  ##DEFINE <key>='<value>' (value can be a ##<file>)
#                   ##INCLUDE '##<file>' (no double quotes any more, '##' needed to search file)
# 1.03  10.02.2001  destination tree check; some statistical output
# 1.04  13.02.2001  support index_e.html for English pages
# 1.05  14.09.2001  ##VFILE to create virtual files
#       17.09.2001  new internal parameter _BM_TAG to modify the tag '##', _BM_NOCOPY;
#                   open optional definition file bmcreate1.def first
# 1.06  11.11.2001  support for French and Spanish pages;
#                   new commands ##IF, ##ELSE, ##ENDIF
#       12.11.2001  parameters are now defined in one html file context only
# 1.07  19.01.2002  Problem with uppercase filenames under Windows: convert all to lowercase
#
#
#
# To Do:
# - files with same name (path is allowed, but not checked, yet)
# - not existing names from virtual files are reported as having no source
#

use 5.004;
use strict;

use Getopt::Std;
use File::Find ();  # find
use File::Copy ();  # copy
use File::Path qw(mkpath);  # mkpath
use Cwd ();         # cwd


# some predefined parameters '##<parameter>'
%::g_para = ( 
  'AUTHOR' =>    'Marco Vieth',
  'DATE' =>      '', 	# will be set later
  'GENERATOR' => 'BM PerlGen v1.0',
  'MAILTO' =>    'mail@benchmarko.de',
  'TIME' =>      '',	# will be set later
  'CHARMAP' =>   '1',	# replace special characters
  '_BM_TAG' =>   '##',  # the tag for new parameters
  '_BM_NOCOPY' => "^inc_(.*)\.txt\$|(.*)\.(pl|bat)\$" # do not copy includes, .pl, .bat...
);  

# html extension
$::g_htmlext = ".html";

$::g_index = "index";

# language markers/signs
# If we find <name>/<name><langsign>.html, we convert it to <name>/$::g_index<langsign>.html
$::g_langsigns = '|_e|_f|_s'; # the first empty extension '' is default (not needed here)


# some characters to convert
%::g_charmap = (
  "" => "&auml;",
  "" => "&Auml;",
  "" => "&ouml;",
  "" => "&Ouml;",
  "" => "&uuml;",
  "" => "&Uuml;",
  "" => "&szlig;"
);


#
#
#

$::g_debug = 0;

# filenames and directories under source
%::c_fname = ();

# statistics class
$::g_stat="";



#
# IO_File - replacement for new IO::File("name", "mode")
#
# call it the traditional way: IO_File("<fname") or similar.
sub IO_File($) {
  #printf STDERR "fast_IO_File: '@_'\n";
  # open my $fh, "@_" or return undef(); # only possible with perl 5.6.0
  local *FH; # to be compatible with Perl 5.004...
  open (FH, "@_") or return undef();
  return *FH;
}


#
# rename HTML file to index[_x].html, if same name as directoy
#
sub adapt_fname($$) {
  my($fname, $dir) = @_;
  if ($fname =~ /(\w+)$::g_htmlext$/c) { # html file?
    my $find = $1;
    my $langext = '';
    if ($find =~ s/($::g_langsigns)$//o) { # remove language extension from filename
      $langext = $1; # memorize language extension, if found
    }
    if ($dir =~ /${find}$/) { # name of file (without language ext.) also found in path?
      if ($::g_debug > 1) {
        print STDERR "DEBUG: adapt_fname: dir='$dir', file='$fname', find='$find', langext='$langext'\n";
      }
      $fname = $::g_index . $langext . $::g_htmlext; # yes, use index<langext>.html
    }
  }
  return($fname);
}


#
# copy from one file to another until a pattern found and convert special characters
# (If $outf is undefined, output is ignored.)
#
sub copy_until_pattern($$$@) {
  my($inf, $outf, $charmap_f, @patterns) = @_;
  my $pattern = join("|", @patterns);

  my $findchars = join("", keys %::g_charmap); # ""

  if ($::g_debug > 1) { print STDERR "copy_until_pattern: pattern='$pattern'\n"; }
  if ($pattern ne "") {
    while (<$inf>) {
      if ($charmap_f) {
        $_ =~ s/([$findchars])/$::g_charmap{$1}/g; # convert 'Umlaute' to HTML notation (not needed for HTML 4.0)
      }
      if (/$pattern/) {
        if ($::g_debug > 1) { print STDERR "Pattern found in: $_"; }
        return $_;
      }
      if (defined $outf) {
        print $outf ($_);
      }
    }
  } else {
    if ($::g_debug > 1) { print STDERR "Copy rest of file.\n"; }
    while (<$inf>) { if (defined $outf) { print $outf ($_); } }
  }
  return(defined($_) ? $_ : "");
}

#
# copy html file
# convert special patterns starting with '##' and special characters
# src_dir, dest_dir are maybe needed for VFILE
#
sub copy_html($$$$$$$) {
  my($src, $dest, $dir, $fname, $fn_r, $src_dir, $dest_dir) = @_;
  my $rc = 1;

  my %l_para = %::g_para; # get global parameter into local ones
  my $bm_tag = $l_para{'_BM_TAG'}; # normally '##'
  if ($::g_debug > 0) {   
    printf STDERR "DEBUG: copy_html: src='$src', dest=$dest'\n";
  }
  $::g_stat->add_val('30 - files analyzed (HTML)', 1);

  my %stat = ( 
    'I' => 0,  # includes
    'D' => 0,  # defines
    'V' => 0,  # virtual files
    'ud' => 0, # used defines
    'uf' => 0  # used files
  );

  my $inf = IO_File("<$src") || (warn("WARNING: $!: '$src'\n"), return undef);
  my @in_f = ();
  push(@in_f, $inf); # descriptor to stack of input files
  my $outf = IO_File(">$dest") || (warn("WARNING: $!: '$dest'\n"), return undef);

  #printf STDERR "'$dir', NUM=%d\n", scalar(($dir =~ tr#/#/#));
  my $dirback = "../" x scalar(($dir =~ tr#/#/#));
  my $tmp_line;
  my $tmp;
  my $f; # temporary filename
  my @condition = (1); # condition array for nested if's, 1= output is active
  while ($inf = pop(@in_f)) {
    while (($tmp_line = copy_until_pattern($inf, ($condition[0]) ? $outf : undef(), $l_para{'CHARMAP'}, $bm_tag)) ne "") {
      my $cond = ""; # no condition (control command)
      my $cmd = ""; # no command
      while ($tmp_line =~ /$bm_tag([\w.\/]+)/g) { # run through all bm_tags in line...
        $f = $1;
        #print "TEST: '$1'\n";
        if ($f =~ /^(IF|ELSE|ENDIF)$/o) { # control command?
          $cond = $1;
          #print STDERR "DEBUG: f='$f', cond='$cond'\n";
          $tmp_line =~ s/$bm_tag/aa/; # modify parameter so it won't be replaced below ??

        } elsif ($f =~ /^(INCLUDE|DEFINE|VFILE)$/o) { # special command?
          $cmd = substr($1, 0, 1); # set command for later
          #print STDERR "f= '$f', cmd='$cmd'\n";
          $tmp_line =~ s/$bm_tag/$cmd$cmd/; # modify parameter so it won't be replaced below
          $stat{$cmd}++;

        } elsif (exists $l_para{$f}) { # parameter set?
          if ($::g_debug > 0) {
            print STDERR "DEBUG ($fname): Replacing '$f' -> '$l_para{$f}'\n";
          }
          $tmp_line =~ s/$bm_tag([\w.\/]+)/$l_para{$f}/;
          $stat{'ud'}++;

        } else { # assume it is a file
          #$f = $x0; # short filename to find
          if (exists $fn_r->{$f}) { # assume filename
            $tmp = "${dirback}$fn_r->{$f}/". adapt_fname($f, $fn_r->{$f});
              # rename HTML file to index.html, if same name as directoy
            $tmp =~ s/\/\.\//\//; # replace '/./' -> '/'
            if ($::g_debug > 0) {
              print STDERR "DEBUG ($fname): Replacing '$f' -> '$tmp'\n";
            }
            $tmp_line =~ s/$bm_tag([\w.\/]+)/$tmp/;
            $stat{'uf'}++;
          } else {
            if ($condition[0]) { # only if output is active
              print "Warning ($fname): referenced file/definition not found: '$f'.\n";
              $::g_stat->add_val('41 - references not found', 1);
            }
          }
        }
      }

      if ($cond eq '') {
        ; # nothing to do
      } elsif ($cond eq 'IF') {
        if ($tmp_line =~ /IF\s*(\w+)\s*(=|!=)\s*'(.*?)'/) {
          if ($::g_debug > 0) {
            print STDERR "DEBUG ($fname): IF '$1' $2 '$3'\n";
          }
          if (!$condition[0]) { # condition false?
            unshift(@condition, 0); # yes, do not analyze new condition
          } elsif ($2 eq '=') {
            unshift(@condition, (defined $l_para{$1}) ? ($l_para{$1} eq $3) : 0);
          } elsif ($2 eq '!=') {
            unshift(@condition, (defined $l_para{$1}) ? ($l_para{$1} ne $3) : 0);
          }
          if ($::g_debug > 0) {
            print STDERR "DEBUG: IF: condition='$condition[0]'\n";
          }
        } else {
          chomp $tmp_line;
          print "Warning ($fname): Ignoring line '$tmp_line'\n";
        }
 
      } elsif ($cond eq 'ELSE') {
        $condition[0] = !$condition[0]; # invert flag

      } elsif ($cond eq 'ENDIF') {
        if ($#condition > 0) {
          shift(@condition); # remove condition from stack
        } else {
          print STDERR "WARNING ($fname): 'ENDIF' without 'IF'!\n";
        }
      }
      #print STDERR "DEBUG: f='$f', condition='$condition[0]'\n";

      if (!$condition[0] || ($cond ne '')) {
        if ($::g_debug > 0) {
          chomp $tmp_line;
          print STDERR "DEBUG ($fname): Condition false. Ignoring line '$tmp_line'.\n";
        } 
        $cmd = "";
        #next; # ignore output, command

      } elsif ($cmd eq "") { # no special cmd -> print line
        print $outf ($tmp_line);

      } elsif ($cmd eq 'I') { # INCLUDE
        #print STDERR "DEBUG ($fname): tmp_line='$tmp_line'\n";
        if ($tmp_line =~ /IIINCLUDE\s*(.)([\w.\/-]+)\1/) {
          $f = "$dir/$2";
          if ($::g_debug > 0) {
            print STDERR "DEBUG ($fname): Including '$f'...\n";
          }
          if (-r $f) {
            push(@in_f, $inf); # current descriptor back on stack
            $inf = IO_File("<$f") || (warn("WARNING: Open Include: $!: '$f'\n"), pop(@in_f)); 
          } else {
            print "Warning ($fname): include file not found: '$f'.\n";
          }
        } else {
          chomp $tmp_line;
          print "Warning ($fname): Ignoring line '$tmp_line'\n";
        }

      } elsif ($cmd eq 'D') { # DEFINE
        #print STDERR "DEBUG ($fname): '$tmp_line'\n";
        if ($tmp_line =~ /DDDEFINE\s*(\w+)\s*=\s*'(.*?)'/) {
          if ($::g_debug > 0) {
            print STDERR "DEBUG ($fname): Define '$1' = '$2'\n";
          }
          $l_para{$1} = $2;
          if ($1 eq '_BM_TAG') {
            $bm_tag = $2; # set also to local variable
          }
        } else {
          chomp $tmp_line;
          print "Warning ($fname): Ignoring line '$tmp_line'\n";
        }

      } elsif ($cmd eq 'V') { # VFILE
        #print STDERR "DEBUG ($fname): '$tmp_line'\n"; 
        if ($tmp_line =~ /VVVFILE\s*(.)([\w.\/-]+)\1/) {
          $f = $2;
          if ((my $ri = rindex($f, '/')) > 0) { # path specified?
            #$dir .= "/" . substr($f, 0, $ri);
            $dir = substr($f, 0, $ri);
            $dirback = "../" x scalar(($dir =~ tr#/#/#)); # set new dirback
            if (! -d "$dest_dir/$dir") { # maybe we need a new path
              mkpath("$dest_dir/$dir", ($::g_debug > 3), 0711);
            }
            $dir = "$src_dir/$dir";
            if (! -d "$dir") { # create dir also in source tree!
              print "Warning ($fname): VFILE: directory created in SOURCE: '$dir'.\n";
              mkpath("$dir", ($::g_debug > 3), 0711);
            }
          } else { # just a filename
            #$f = "$dir/$f";
            $f = "$src_dir/$f";
          }
          if ($::g_debug > 0) {
            print STDERR "DEBUG ($fname): Creating virtual file '$f'...\n";
            if (-r $f) {
              print STDERR "Note ($fname): Virtual file already exists: '$f'\n";
            }
          }
          #print "Note: ($fname): should create virtual file '$f'.\n";
          # start new output file...
          close($outf);
          $dest = "$dest_dir/$f";
          $outf = IO_File(">$dest") || (warn("WARNING: $!: '$dest'\n"), return undef);
        } else {
          chomp $tmp_line;
          print "Warning ($fname): Ignoring line '$tmp_line'\n";
        }

      } else { # undefined command (programming error?)
        chomp $tmp_line;
        print "Warning ($fname): Undefined command '$cmd' in line '$tmp_line'\n";
      }
    }
    close($inf);
  }
  close($outf);

  if ($stat{'I'}) { $::g_stat->add_val('31 - ##INCLUDE', $stat{'I'}); }
  if ($stat{'D'}) { $::g_stat->add_val('32 - ##DEFINE', $stat{'D'}); }
  if ($stat{'ud'}) { $::g_stat->add_val('33 - ##<define>', $stat{'ud'}); }
  if ($stat{'uf'}) { $::g_stat->add_val('34 - ##<file>', $stat{'uf'}); }
  if ($stat{'V'}) { $::g_stat->add_val('35 - ##VFILE', $stat{'V'}); }

  return $rc;
}


#
# copy files from source to publishing destination
#
sub copyfiles($$$$) {
  my($src_dir, $dest_dir, $fn_r, $force_f) = @_;

  foreach my $f (keys %$fn_r) {
    if ($f =~ /$::g_para{'_BM_NOCOPY'}/c) {
      $::g_stat->add_val('20 - files ignored (nocopy)', 1);
      if ($::g_debug > 1) {
        print STDERR "DEBUG: copyfiles: ingoring file '$f'\n";
      }
      next;
    }
    if ($::g_debug > 2) {
      print STDERR "DEBUG: copyfiles: processing file '$f'\n";
    }
    my $src = "${src_dir}/$fn_r->{$f}/$f";
    my $dest = "${dest_dir}/$fn_r->{$f}/". adapt_fname($f, $fn_r->{$f});
      # rename HTML file to index.html, if same name as directoy

    if ($force_f || (! -f $dest) || -M $src < -M $dest) {
      if (! -d "${dest_dir}/$fn_r->{$f}") {
        mkpath("${dest_dir}/$fn_r->{$f}", ($::g_debug > 3), 0711);
      }
      if ($f =~ /(.*)$::g_htmlext$/c) {
        if ($::g_debug > 0) {
          printf "$::g_htmlext: '$fn_r->{$f}/$f'\n";
        }
        copy_html($src, $dest, $fn_r->{$f}, $f, $fn_r, $src_dir, $dest_dir);
      } else {
        if ($::g_debug > 0) {
          print "Copying '$src' -> '$dest'\n";
        }
        File::Copy::copy($src, $dest) || warn "'$src'->'$dest': $!\n";
        $::g_stat->add_val('22 - files copied', 1);
      }
    } else {
      $::g_stat->add_val('21 - files ignored (timestamp)', 1);
    }
  }
}


#
# get local date
#
sub get_ldate() {
  my($mday, $month, $year) = (localtime())[3..5];
  return sprintf("%02d.%02d.%04d", $mday, $month + 1, $year + 1900);
}

#
# get local time
#
sub get_ltime() {
  my($sec, $min, $hour) = (localtime())[0..2];
  return sprintf("%02d:%02d:%02d", $hour, $min, $sec);
}


sub win_lc($) {
  return(lc($_[0]));
}

#
# collect filenames from source tree
#
sub collectfilenames_s() {
  if ($::g_debug > 2) {
    printf STDERR "DEBUG: collectfilenames: processing file '%s'\n", $File::Find::name;
  }
  if (-f $_) {
    my $fn = win_lc($_); # needed for Windows: convert to lowercase
    $::g_stat->add_val('10 - source files (total)', 1);
    if (defined $::c_fname{$fn}) {
      printf STDERR "Warning: file '$fn' already defined ($File::Find::name)!\n";
      $::g_stat->add_val('11 - source files (same name)', 1); 
    } else {
      $::c_fname{$fn} = win_lc($File::Find::dir);
      # $::c_fname{$fn} =~ s/^\.\///; # remove leading './' from directory path
    }
  }
}



my $loc_dest_path = "";

#
# check filenames from destination tree
#
sub checkfilenames_d() {
  if ($::g_debug > 3) {
    printf STDERR "DEBUG: checkfilenames: processing file '%s'\n", $File::Find::name;
  }
  if (-f $_) {
    my $fn = win_lc($_); # needed for Windows: convert to lowercase
    if ($fn =~ /$::g_index($::g_langsigns)$::g_htmlext/) { #renamed file index_x.html?
      my $langext = $1; # memorize language extension
      if (win_lc($File::Find::dir) =~ /$loc_dest_path.*\/([^ \/]+)$/) {
        $fn = $1 . $langext . $::g_htmlext;
      }
      #print STDERR "DDD: strange name found: ", $File::Find::dir, ": '$fn'\n";
    }
    $::g_stat->add_val('80 - destination files (total)', 1);
    if (!defined $::c_fname{$fn}) {
      if ($fn =~ /^ws_ftp\.log$/) { # ignore this... (fast hack)
        $::g_stat->add_val('81 - destination files ignored', 1);
      } else {
        printf STDERR "WARNING: file without source: '%s'\n", $File::Find::name;
        $::g_stat->add_val('82 - destination files without source', 1); 
      }
    }
  }
}

#
# main
#
sub main() {
  my %opts = (
   'f' => 0,
   's' => undef,
   'd' => '0',
  );
  if (!getopts("fhd:", \%opts) or (@ARGV == 0) or exists($opts{'h'})) {
    require File::Basename;  # load dynamically for help
    import File::Basename qw(basename);
    print STDERR "Usage: ". basename($0) ." [options] <destination dir>\n";
    print STDERR "-f         : force copy\n";
    print STDERR "-h         : help\n";
    print STDERR "-d  level  : debug level (0=off, 1=normal, >1=extended)\n";
    print STDERR "\n";
    exit 1;
  }

  $::g_debug = $opts{'d'};

  if ($::g_debug > 0) {
    printf STDERR "DEBUG: Debugging switched on.\n";
  }
  $::g_para{'DATE'} = get_ldate(); # initialize date
  $::g_para{'TIME'} = get_ltime(); # initialize time

  $::g_stat = Mystat->new();

  my $s_dir = Cwd::cwd();
  print "Using source directory '$s_dir'\n";

  my $d_dir = $ARGV[0];
  print "Using destination directory '$d_dir'\n";
  if (! -d $d_dir) {
    print "Creating destination directory '$d_dir'\n";
    mkpath($d_dir, ($::g_debug > 2), 0711) || die "Warning: '$d_dir': $!";
  }

  File::Find::find(\&collectfilenames_s, ".");

  my $def_file = "bmcreate1.def";
  if (-r $def_file) {
    print "Copying definition file '$def_file' first...\n";
    copy_html("$s_dir$def_file", "$d_dir$def_file", "", $def_file, \%::c_fname, $s_dir, $d_dir);
    delete $::c_fname{$def_file}; # remove def_file from file list
  }
  
  #foreach my $i (keys %::c_fname) {
  #  printf "%20s: %s\n", $i, $::c_fname{$i};
  #}

  copyfiles($s_dir, $d_dir, \%::c_fname, $opts{'f'});

  # additional check
  $loc_dest_path = $d_dir;
  $loc_dest_path =~ tr#/.#.#; # pattern for destination path, which should be found in directory if index_x.html found
  #print "DDD: path='$loc_dest_path'\n";
  File::Find::find(\&checkfilenames_d, $d_dir);

  print "Summary:\n";
  $::g_stat->print_all();

  return 0;
}

exit(main());


################################################


package Mystat;

use strict;

sub new {
  my $class = shift;
  my $self = {};
  $self->{'debug'} = 0;
  %{$self->{'stat'}} = ();
  bless($self, $class);
  if (@_ > 0) {
    die "Unknown parameter: '@_'\n";
  }
  return $self;
}


sub set_debug {
  my($self, $debug) = @_;
  $self->{'debug'} = $debug;
  return 1;
}


#
# debug_msg - print a debug message
# IN : <preamble> <message>
# OUT: 1=ok
# The message is written to STDERR.
#
sub debug_msg {
  my($self, $preamble, $message) = @_;
  print STDERR "$preamble: ${message}\n";
  return 1;
}

sub set_val($$) {
  my($self, $key, $value) = @_;
  $self->{'stat'}->{$key} = $value;
  return 1;
}

sub add_val($$) {
  my($self, $key, $value) = @_;
  #print STDERR "DEBUG: add_val: '$key' += '$value'\n";
  $self->{'stat'}->{$key} += $value;
  return 1;
}

sub get_val($) {
  my($self, $key) = @_;
  return $self->{'stat'}->{$key};
}


sub print_all() {
  my($self, $key) = @_;
  #print STDERR "DEBUG: print_all\n";
  foreach my $i (sort keys %{$self->{'stat'}}) {
    print "$i: $self->{'stat'}->{$i}\n";
  }
}

# end
