#!/bin/sh
# run_bench1.sh
# Marco Vieth, 2002 (http://www.benchmarko.de)
#
# 29.01.2003  0.041 some improvements
# 05.04.2003  0.05  define tools at the beginning
#
#
#
# Usage:
# ./run_bench1.sh > 00results1_log_linux05.txt
# (./run_bench1.sh | tee 00results1_log_linux05.txt)
#

#
#
#
AWK="gawk"
BASH="bash"
BWBASIC="bwbasic"
BC="bc"
GCC="gcc"
HTCOBOL="htcobol -L$HOME/bin"
GFORTH="gforth"
G77="g77"
F2C="f2c"
JAVADIR_SUN="/usr/lib/SunJava1-1.1.8/bin"
JAVADIR_IBM="/usr/lib/IBMJava2-1.3.0/bin"
GUAVAC="/usr/lib/guavac/bin/guavac"
JS_NGS="js"
JS_RHINOJAR="js.jar"
JS_SPIDERMONKEY="js_sp"
CLISP="clisp"
MOCKA="mocka"
GPC="gpc"
P2C="p2c"
PERL4="perl4"
PERL="perl"
PYTHON="python"
GST="gst"
TCLSH="tclsh"
ZSH="zsh"
#
#
#


#if [ ! -d ./tmp ]; then
#  echo "local tmp directory not found."
#  exit 1
#fi

#cp -p bmbench1.* ./tmp/

if [ -d ./tmp ]; then
  cd ./tmp
fi


SYSNAME=`uname -s`
# e.g. Linux

echo $SYSNAME
date

#echo "." > /dev/stderr
echo ""
echo "----------"
echo "AWK"
$AWK --version
(time $AWK -f ./bmbench1.awk) 2>&1

echo ""
echo "----------"
echo "bash"
$BASH --version
(time $BASH -f ./bmbench1.bash) 2>&1


echo ""
echo "----------"
echo "bwbasic"
(time $BWBASIC ./bmbench1.bas) 2>&1

echo ""
echo "----------"
echo "BC"
export BC_LINE_LENGTH=80
(time $BC ./bmbench1.bc) 2>&1

echo "----------"
echo "C (-O0)"
($GCC -v) 2>&1
# -pedantic could slow down code!
$GCC -Wall -Wtraditional bmbench1.c -o bmbench1_c_o0_${SYSNAME}
(time ./bmbench1_c_o0_${SYSNAME}) 2>&1

echo "----------"
echo "C (-O2)"
#($GCC -v) 2>&1
$GCC -Wall -Wtraditional -O2 bmbench1.c -o bmbench1_c_o2_${SYSNAME}
(time ./bmbench1_c_o2_${SYSNAME}) 2>&1


echo "----------"
echo "Cobol (htcobol)"
#($HTCOBOL -hhh) 2>&1
$HTCOBOL -o bmbench1_cob_${SYSNAME}
(time ./bmbench1_cob_${SYSNAME}) 2>&1


echo "----------"
echo "Forth"
($GFORTH -v) 2>&1
(time $GFORTH ./bmbench1.fs -e bye) 2>&1

#Benchmarks:
#bubble.fs siev.fs matrix.fs fib.fs


echo "----------"
echo "Fortran (g77 -O0)"
($G77 -v) 2>&1
#g77 -Wall -Wsurprising -Wunused -fpedantic bmbench1.f -o bmbench1_f_o0_${SYSNAME}
#-fpedantic seems to compile slow code, so we don't use it!
$G77 -Wall -Wsurprising -Wunused bmbench1.f -o bmbench1_f_o0_${SYSNAME}
(time ./bmbench1_f_o0_${SYSNAME}) 2>&1

echo "----------"
echo "Fortran (g77 -O2)"
$G77 -Wall -Wsurprising -Wunused -O2 bmbench1.f -o bmbench1_f_o2_${SYSNAME}
(time ./bmbench1_f_o2_${SYSNAME}) 2>&1


echo "----------"
echo "Fortran (f2c -O2)"
ln -s bmbench1.f bmbench1_f_f2c_${SYSNAME}.f
($F2C -A -a bmbench1_f_f2c_${SYSNAME}.f) 2>&1
$G77 -O2 bmbench1_f_f2c_${SYSNAME}.f -o bmbench1_f_f2c_o2_${SYSNAME}
(time ./bmbench1_f_f2c_o2_${SYSNAME}) 2>&1



echo "----------"
echo "Java (Sun) (-O)"
(${JAVADIR_SUN}/java -version) 2>&1
ln -s bmbench1.java bmbench1_sun118.java
${JAVADIR_SUN}/javac -O bmbench1_sun118.java
(time ${JAVADIR_SUN}/java bmbench1_sun118) 2>&1

echo "----------"
echo "Java (IBM) (-O)"
(${JAVADIR_IBM}/java -version) 2>&1
ln -s bmbench1.java bmbench1_ibm130.java
${JAVADIR_IBM}/javac -O bmbench1_ibm130.java
(time ${JAVADIR_IBM}/java bmbench1_ibm130) 2>&1

echo "----------"
echo "Java (IBM, compiled with guavac)"
($GUAVAC -version) 2>&1
ln -s bmbench1.java bmbench1_guavac12.java
$GUAVAC bmbench1_guavac12.java
(time ${JAVADIR_IBM}/java bmbench1_guavac12) 2>&1


echo "----------"
echo "JavaScript"
echo "Start browser yourself... (script run_bench_browser1.sh)"

echo "----------"
echo "JavaScript (NGS js) (-O2)"
$JS_NGS -V
$JS_NGS -c -O2 bmbench1.js
(time $JS_NGS bmbench1.jsc) 2>&1

echo "----------"
echo "JavaScript (Rhino)"
(time ${JAVADIR_IBM}/java -jar $JS_RHINOJAR bmbench1.js) 2>&1
# Needs Rhino Java archive: ...rhino1_5R3/js.jar

echo "----------"
echo "JavaScript (SpiderMonkey)"
$JS_SPIDERMONKEY -h
(time $JS_SPIDERMONKEY bmbench1.js) 2>&1


echo "----------"
echo "Lisp (clisp)"
($CLISP --version) 2>&1
$CLISP -c bmbench1.lisp
(time $CLISP bmbench1.fas) 2>&1


echo "----------"
echo "Modula-2"
echo "q" | $MOCKA
$MOCKA -noindex -norange -nog -c bmbench1
$MOCKA -p bmbench1
mv ./bmbench1 bmbench1_mi_${SYSNAME}
(time ./bmbench1_mi_${SYSNAME}) 2>&1


echo "----------"
echo "Pascal (gpc -O2)"
($GPC -v) 2>&1
$GPC bmbench1.p -O2 -o bmbench1_p_${SYSNAME}
(time ./bmbench1_p_${SYSNAME}) 2>&1

echo "----------"
echo "Pascal (p2c -O2)"
$P2C -LHP -a -o bmbench1_p2c_${SYSNAME}.c bmbench1.p
$GCC -O2 bmbench1_p2c_${SYSNAME}.c -lp2c -o bmbench1_p2c_${SYSNAME}
# we skip -Wall -Wtraditional
(time ./bmbench1_p2c_${SYSNAME}) 2>&1


echo "----------"
echo "Perl 4"
$PERL4 -v
(time $PERL4 ./bmbench1.pl4) 2>&1

echo "----------"
echo "Perl"
$PERL -v
(time $PERL ./bmbench1.pl) 2>&1


echo "----------"
echo "Python (-O)"
($PYTHON -V) 2>&1
(time $PYTHON -O ./bmbench1.py) 2>&1


echo "----------"
echo "Smalltalk"
$GST -v
(time $GST ./bmbench1.st) 2>&1


echo "----------"
echo "Tcl"
(time $TCLSH ./bmbench1.tcl) 2>&1


echo ""
echo "----------"
echo "zsh (uses bash script)"
$ZSH --version
(time $ZSH -f ./bmbench1.bash) 2>&1


echo "----------"
date
echo "finished."
