#!/bin/sh
# run_bench1.sh
#
# Usage:
# ./run_bench1.sh | tee 00results1_log_linux1.txt
# (./run_bench1.sh 2>&1 | tee 00results1_log_linux1.txt)
#


#if [ ! -d ./tmp ]; then
#  echo "local tmp directory not found."
#  exit 1
#fi

#cp -p bmbench1.* ./tmp/

if [ -d ./tmp ]; then
  cd ./tmp
fi


SYSNAME=`uname -s`
# e.g. Linux

echo $SYSNAME

#echo "." > /dev/stderr
echo ""
echo "----------"
echo "AWK"
gawk --version
(time gawk -f ./bmbench1.awk) 2>&1


echo ""
echo "----------"
echo "bwbasic"
(time bwbasic ./bmbench1_bw.bas) 2>&1

echo ""
echo "----------"
echo "BC"
export BC_LINE_LENGTH=80
(time bc ./bmbench1.bc) 2>&1

echo "----------"
echo "C (-O0)"
(gcc -v) 2>&1
#gcc -Wall -pedantic bmbench1.c -o bmbench1_c_o0_${SYSNAME}
gcc -Wall -Wtraditional bmbench1.c -o bmbench1_c_o0_${SYSNAME}
(time ./bmbench1_c_o0_${SYSNAME}) 2>&1

echo "----------"
echo "C (-O2)"
(gcc -v) 2>&1
gcc -Wall -Wtraditional -O2 bmbench1.c -o bmbench1_c_o2_${SYSNAME}
(time ./bmbench1_c_o2_${SYSNAME}) 2>&1

echo "----------"
echo "Forth"
#gforth bmbench1.fs -e bye
(time gforth ./bmbench1.fs -e bye) 2>&1

#Benchmarks:
#bubble.fs siev.fs matrix.fs fib.fs


echo "----------"
echo "Fortran (-O0)"
(g77 -v) 2>&1
#g77 -Wall -Wsurprising -Wunused -fpedantic bmbench1.f -o bmbench1_f_o0_${SYSNAME}
#pedantic seems to compile slow code, so we don't use it!
g77 -Wall -Wsurprising -Wunused bmbench1.f -o bmbench1_f_o0_${SYSNAME}
(time ./bmbench1_f_o0_${SYSNAME}) 2>&1

echo "----------"
echo "Fortran (-O2)"
g77 -Wall -Wsurprising -Wunused bmbench1.f -O2 -o bmbench1_f_o2_${SYSNAME}
(time ./bmbench1_f_o2_${SYSNAME}) 2>&1

echo "----------"
echo "Java (Sun) (-O)"
(/usr/lib/SunJava1-1.1.8/bin/java -version) 2>&1
/usr/lib/SunJava1-1.1.8/bin/javac -O bmbench1.java
(time /usr/lib/SunJava1-1.1.8/bin/java bmbench1) 2>&1
mv ./bmbench1.class ./bmbench1.class_sun118

echo "----------"
echo "Java (IBM) (-O)"
(/usr/lib/IBMJava2-1.3.0/bin/java -version) 2>&1
/usr/lib/IBMJava2-1.3.0/bin/javac -O bmbench1.java
(time /usr/lib/IBMJava2-1.3.0/bin/java bmbench1) 2>&1
mv ./bmbench1.class ./bmbench1.class_ibm130

echo "----------"
echo "Java (IBM, compiled with guavac)"
(/usr/lib/guavac/bin/guavac -version) 2>&1
/usr/lib/guavac/bin/guavac bmbench1.java
(time /usr/lib/IBMJava2-1.3.0/bin/java bmbench1) 2>&1
mv ./bmbench1.class ./bmbench1.class_guavac12


echo "----------"
echo "JavaScript"
echo "Start browser yourself... (script run_bench_browser1.sh)"

echo "----------"
echo "JavaScript (NGS) (-O2)"
js -V
js -c -O2 bmbench1.js
(time js bmbench1.jsc) 2>&1

echo "----------"
echo "JavaScript (Rhino)"
(time /usr/lib/IBMJava2-1.3.0/bin/java -jar js.jar bmbench1.js) 2>&1
# Needs Rhina Java archive: ...rhino1_5R3/js.jar


echo "----------"
echo "Modula-2"
echo "q" | mocka
mocka -noindex -norange -nog -c bmbench1
mocka -p bmbench1
mv ./bmbench1 bmbench1_mi_${SYSNAME}
(time ./bmbench1_mi_${SYSNAME}) 2>&1

echo "----------"
echo "Pascal (-O2)"
(gpc -v) 2>&1
gpc bmbench1.p -O2 -o bmbench1_p_${SYSNAME}
(time ./bmbench1_p_${SYSNAME}) 2>&1

echo "----------"
echo "Perl"
perl -v
(time perl ./bmbench1.pl) 2>&1

echo "----------"
echo "Python (-O)"
(python -V) 2>&1
(time python -O ./bmbench1.py) 2>&1

echo "----------"
echo "Smalltalk (not yet implemented)"
gst -v
#(time ./bmbench1_c_o2_${SYSNAME}) 2>&1

echo "----------"
echo "Tcl"
(time tclsh ./bmbench1.tcl) 2>&1

echo "----------"
echo "finished."
