//
// debug.js - debug module
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 0.10 21.01.2003 OO design
// 0.11 30.11.2003 also reopen window if closed
//
//

// Use for debugging:
// 1. At top of every Javascript file:
// var g_debug = null; // maybe changed later...

// 2. For every debug output (in js):
// if (g_debug) { g_debug.writeln(<message>); }

// Activate debugging (in HTML, write as last js because g_debug is overwritten otherwise!):
// <script language="JavaScript" src="debug1.js" type="text/javascript">
// </script>

//
// Notes:
// - load this module to get a debug object g_debug
// - Checked with NGS 0.2.5
//



// Constructor for class Debug
function Debug(debug_level) {
  this.debug_level = debug_level;
  this.win = null; // will be opened in the first writeln (for NGS not before calling main!)

  if (!Debug.prototype) { // old browsers < JS 1.2 get the methods directly into the object...
    this.open = Debug_open;
    this.writeln = Debug_writeln;
  }

}


// normally we would create unnamed functions here but for old browsers...

// For new browsers (JS 1.2) set the prototypes...
new Debug(); // force old browsers to create prototype
if (Debug.prototype) {
  Debug.prototype.open = Debug_open;
  Debug.prototype.writeln = Debug_writeln;
}


function Debug_open() {
  this.win = window.open("about:blank","Debug","width=640,height=300,resizable=yes,scrollbars=yes,dependent=yes");
  if (this.win && !this.win.closed) {
    this.win.document.open("text/html", "reuse");
    this.win.document.writeln("<h4>Debug output</h4>\n<pre>"); // for some older Netscapes...
    if (this.win.focus) { this.win.focus(); }
  }
}


//
// write a debug message
// Output only if debug_level > specified level (or 0).
function Debug_writeln(str, level) {
  if (this.debug_level >= (level || 0)) {
    if (!this.win || this.win.closed) {
      this.open(); // open the debug window before the first writeln (NGS compatible)
    }
    if (this.win) { // maybe blocked
      this.win.document.writeln("DEBUG: "+ str);
    }
  }
}


var g_debug = new Debug(1); // here: show messages up to level 1


// --------------------------------------------------------

//end
