//
// advent1_main.js - adventure interpreter main (for debugging with NGS js)
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 21.01.2003 1.2  separated from advent1.js
// 30.01.2006 1.21 support more JS engines
//
//

//
// 1. Checked with NGS 0.2.5: (TTT: test again!)
//   js -Wall -t -l advent1_data_home1.js advent1.js sshow1.js timer1.js -f advent1_main.js
// -Wall (all warnings); -t (stack trace), -l (load multiple files) -f (load last file)
//
// Note:
// - *_main.js must be the last file!
// - include timer.js even if Timer is not used in sshow
// - For debugging:  put debug1.js before *_main.js
//
// 2. Spidermonkey 1.5
//   js -f advent1_data_home1.js -f advent1.js -f sshow1.js -f timer1.js -f advent1_main.js
//
// 3. Rhino
//   java -jar ~/usr/bin/js.jar -f advent1_data_home1.js -f advent1.js -f sshow1.js -f timer1.js -f advent1_main.js
//


// You can also append this to the original file (syntax is also ok for browsers).

//
// start this if we are outside of a browser (stand alone JS engines)...
//
function main(args) {
  // Use either global data from file advent1_data_home1.js or (if not specified) some dummy data...
  var verbs1 = (typeof g_verbs1 != "undefined") ? g_verbs1 : new Array("V0", "V1");
  var messages1 = (typeof g_messages1 != "undefined") ? g_messages1 : new Array("M0", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "M13", "M14", "M15", "M16");
  var rooms1 = (typeof g_rooms1 != "undefined") ? g_rooms1 : new Array("  0,  0,  0,  0,  0,  0,  0,R0", "  0,  0,  0,  0,  0,  0,  0,R1");
  var objects1 = (typeof g_objects1 != "undefined") ? g_objects1 : new Array("  0,  0, 0,0,  0,^Dummy5,,,,,,,");
  var images1 = (typeof g_images1 != "undefined") ? g_images1 : new Array("image0.jpg");
  var players1 = (typeof g_players1 != "undefined") ? g_players1 : new Array("  0,  0,P0,");
  var lmaps1 = (typeof g_lmaps1 != "undefined") ? g_lmaps1 : new Array("  0,  0,  0,  0");

  //args = args;
  var adv = new Adv(verbs1, messages1, rooms1, objects1, images1, players1, lmaps1);
  var adv_frm = new Object();
  adv.init_frm(adv_frm, 0);
  adv.dump_data();
  //adv.play_events("0,1,0.0");
}


// ---------------------------------------

// simulate window object for stand alone JS engines...

// DMDScript does not like functions inside "if", so define them outside...
  function window_open1() {
    return this;
  }

  function window_writeln1() {
    var str = ""; // does not work: arguments.join(" ");
    for (var i = 0; i < arguments.length; i++) {
      str += arguments[i]; // copy arguments
    }
    switch(window.js_engine1) {
      case 1: // NGS JS Engine
        System.print(str +"\n"); //or: System.stdout.writeln(str);
      break;
      case 2: // Rhino, SpiderMonkey
        print(str);
      break;
      case 3: // DMDScript
        println(str);
      break;
      case 4: // Windows JScript (cscript)
        WScript.Echo(str);
      break;
    }
  }

if (typeof window == "undefined") { // are we outside of a browser in a standalone JS engine?
  window = new Object(); // NGS: how to avoid warning about undefined global 'window'?
  window.open = window_open1;
  window.focus = window_open1; // dummy
  window.document = new Object();
  window.document.open = window_open1; // dummy
  window.document.close = window_open1; // dummy
  window.js_engine1 = 0; // js engine for writeln
  window.document.writeln = window_writeln1;
  window.alert = window.document.writeln; // same as writeln
  if (typeof System != "undefined") { // System object is available with NGS JS Engine
    window.js_engine1 = 1;
    // convert to integer with NGS JS Engine engine, use Math.floor for others...
    eval("myint = int"); // set integer cast; avoid warning 'int' is reserved identifier in browsers
    if (typeof ARGS != "undefined") {
      if ((Math.max(5, 8) != 8) || (Math.pow(0.5, 2) != 0.25)) {
        window.alert("ERROR: Buggy NGS Javascript Engine! Correct b_math.c and try again...");
      } else {
        ARGS.shift(); // remove program name in ARGV[0]
        main(ARGS); // start script
      }
    }
  } else if (typeof arguments != "undefined") { // Rhino, SpiderMonkey, DMDScript...
    if (typeof println != "undefined") { // DMDScript
      window.js_engine1 = 3;
      // Note: arguments for DMDScript do not work.
    } else { // Rhino, SpiderMonkey
      window.js_engine1 = 2;
    }
    main(arguments); // start script
  } else if (typeof WScript != "undefined") { // JScript (cscript)...
    window.js_engine1 = 4;
    var args = new Array(); // copy arguments into array
    for (var i = 0; i < WScript.Arguments.length; i++) {
      args[i] = WScript.Arguments(i);
    }
    main(args);
  } else {
    main(); // unknown engine, call without arguments
  }
}

// end
