//
// cookie1.js - cookie handling
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 17.01.2003 0.10 first tests
// 31.12.2003 0.11 debug: days -> expiredays
//
//

var g_debug = null; // maybe changed later...


function Cookie_get(name) {
  if (document.cookie.length > 0) {
    var begin = document.cookie.indexOf(name + "=");
    if (begin != -1) {
      begin += name.length + 1;
      var end = document.cookie.indexOf(";", begin);
      if (end == -1) {
        end = document.cookie.length;
      }
      if (g_debug) { g_debug.writeln("Cookie_get: name="+ name +", value="+ document.cookie.substring(begin, end)); }
      return unescape(document.cookie.substring(begin, end));
    }
  }
  if (g_debug) { g_debug.writeln("Cookie_get: name="+ name +", not found."); }
  return null;
}


function Cookie_set(name, value, expiredays) {
  if (g_debug) { g_debug.writeln("Cookie_set: name="+ name +", value="+ value +", expiredays="+ expiredays); }
  var expire_date = new Date();
  expire_date.setTime(expire_date.getTime() + (expiredays * 24 * 3600 * 1000));
  document.cookie = name + "=" + escape(value) +
  ((expiredays == null) ? "" : "; expires=" + expire_date.toGMTString());
}


function Cookie_delete(name) {
  if (g_debug) { g_debug.writeln("Cookie_delete: name="+ name); }
  if (Cookie_get(name)) {
    document.cookie = name + "=" + "; expires=Thu, 01-Jan-70 00:00:01 GMT";
  }
}

//end
