//
// Page Boost 1
// Marco Vieth, 04.06.2001
// 0.01  04.06.2001  first tests;
//                   some animation for IE, tested for Netscape 4.x and Opera 5.x
// 0.02  05.09.2001  adapted for Netscape 6.x
// 0.03  23.09.2001  all global variables start with this.boost_*
// 0.04  19.01.2002  new object-oriented design
//       20.01.2002  do not use unnamed functions, prototypes -> useful for old browsers with Javascript 1.1
// 0.05  18.06.2003  use class Timer for timer handling; corrected Boost_page_forid: call this.page()
// 0.06  22.06.2003  adapted for sshow version 0.10
// 0.061 23.11.2003  use hex values for document.bgColor
//

// To do: Correct layer (span) with Netscape 4.79 under Linux (line 122); need to position absolute??

// the page booster requires sshow1.js and timer1.js!

//
// Strange browser dependent things:
// - IE, Netscape 4.x cann pass textidx as object to boost_page(), but not Netscape 6
// - Netscape 4.x, 6 allow passing object document['textidx'] but not IE (needs all?)
// - so we pass 'textidx' as text.
// - Opera (in IE mode) knows img1.style but not img1.filters
// - to access span, div objects with Netscape 6, use document.getElementById()
//   (there are no layers any more)
//   


var g_debug_flg = 0;            // global debug flag (1 = debugging activated)


// Constructor for class Boost
function Boost(images) {
  // attributes
  this.boost_id = new Array();  // array of id's
  this.boost_id_idx = -1;       // -1 = undefined, otherwise index for this.boost_id
  this.boost_transition = 0;    // image transition for IE
  this.boost_chgimg = 1;        // index for image to change

  // for boost_mover1, boost_mout1...
  this.boost_savecolor1 = 0;
  this.boost_saveimg = new Array();

  // methods
  if (!Boost.prototype) { // old browsers get the methods directly into the object...
    this.change_it1 = Boost_change_it1;
    this.page = Boost_page;
    this.page_forid = Boost_page_forid;
    this.mover1 = Boost_mover1;
    this.mout1 = Boost_mout1;
  }

  if (images) {
    this.sshow = new Sshow(images, null, Boost_set_image_func);
  }
}



///////////////////////

//
// normally we would create unnamed functions here but for old browsers...
// Boost.prototype.change_it1 = function() { ... }
//

// For new browsers (JS 1.2) set the prototypes...
new Boost(); // force old browsers to create prototype
if (Boost.prototype) {
  Boost.prototype.change_it1 = Boost_change_it1;
  Boost.prototype.page = Boost_page;
  Boost.prototype.page_forid = Boost_page_forid;
  Boost.prototype.mover1 = Boost_mover1;
  Boost.prototype.mout1 = Boost_mout1;
}


function Boost_set_image_func(img, idx, descr, arg) {
  var windoc = window.document;
  if (windoc.images) {
    if (isNaN(arg)) {
      arg = windoc.images.length - 1; // last image
    }
    if (g_debug) { g_debug.writeln("Boost_set_image_func: idx+1="+ idx +", arg="+ arg); }

    windoc.images[arg].src = img;
  }
}

//
// change the id properties...
//
function Boost_change_it1() {
  if (++this.boost_id_idx >= this.boost_id.length) {
    this.boost_id_idx = 0;
  }

  var img1 = document.images[this.boost_chgimg];

  if (this.boost_id_idx == 0) {
    if (img1.style) {  // only IE
      img1.style.filter = "revealTrans(Duration=1,Transition="+ this.boost_transition +")";
      if (img1.filters) { // only IE; Netscape and Opera have no such property...
        img1.filters.revealTrans.Apply();
      }
    }
    //g_ppos = 0; // fast hack
    this.sshow.change_image_abs(6, this.boost_chgimg);
    if (img1.filters) {
      img1.filters.revealTrans.Play();
    }

  } else if (this.boost_id_idx == (this.boost_id.length - 1)) {
    //img1.style.filter = "revealTrans(Duration=1,Transition="+ this.boost_transition +")";
    if (++this.boost_transition > 23) {
      this.boost_transition = 0;
    }
      
    if (img1.filters) {
      img1.filters.revealTrans.Apply();
    }
    this.sshow.change_image_abs(3, this.boost_chgimg);
    if (img1.filters) {
      img1.filters.revealTrans.Play();
    }
  }

  for (var i = 0; i < this.boost_id.length; i++) {
    if (document.all) { // IE 5.x (maybe IE 4.0)
      document.all[this.boost_id[i]].style.color = (this.boost_id_idx == i) ? "yellow" : "white";
      document.all[this.boost_id[i]].style.top   = (this.boost_id_idx == i) ? "-5" : "0";

    } else if (document.layers) { // Netscape 4.x can only move things around...
      //alert('DDD: i='+ i +', boost_id[i]='+ this.boost_id[i]);
      // Problems with Netscape 4.9 under Linux:
      //alert('DDD: '+ document.layers.length);
      if (document.layers[this.boost_id[i]]) { // you never know...
        document.layers[this.boost_id[i]].top = (this.boost_id_idx == i) ? "-5" : "0";
      }

    } else if (document.getElementById) { // Netscape 6.x (would also work for IE)
      document.getElementById(this.boost_id[i]).style.color = (this.boost_id_idx == i) ? "yellow" : "white";
      document.getElementById(this.boost_id[i]).style.top   = (this.boost_id_idx == i) ? "-5px" : "0px";
    }
  }

}


// boost page
function Boost_page() {
  //alert(arguments.length);
  for (var i = 0; i < arguments.length; i++) {
    this.boost_id[i] = arguments[i]; // copy arguments
  }
  if (this.boost_id_idx < 0) { // only the first time (when index is undefined)
    this.sshow.change_image_abs(2, 2); // load animated gif for German/English flag
    this.sshow.change_image_abs(0, 0); // ... and BM logo
  }

  this.sshow.change_image_auto(0);  // remove itimer
  this.change_it1();
  this.sshow.change_image_auto(4, this, 'change_it1'); // start itimer with 4 seconds
}


function Boost_page_forid(idx) {
  if ((this.boost_id_idx >= 0) && (idx == this.boost_id_idx)) {
    this.page(); // no arguments -> keep this.boost_id...
  }
}


function Boost_rndhex_local() {
  var hex_digit = new Array("0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F");
  var d1 = Math.floor(Math.random() * 16);
  var d2 = Math.floor(Math.random() * 16);
  return hex_digit[d1] + hex_digit[d2];
}


//
// some special mouse over effects
// effect does not work for NE 4.x since it allows no events for span??
//
function Boost_mover1(p1) {
  if (this.boost_id_idx >= 0) { // only if boost is active
    //alert(this.boost_id_idx);
    if (document.all) { // IE
      p1 = document.all[p1];
      this.boost_savecolor1 = p1.style.color; // save color
      p1.style.color = "green";

      // hide some navigation images
      for (var i = 0; i < 7; i += 2) {
        this.boost_saveimg[i] = document.all.tags("td")[i + 3].background;  // save image
        document.all.tags("td")[i + 3].background = ""; // test
      }

    } else if (document.layers) { // Netscape 4.x
      p1 = document.layers[p1];
      p1.visibility = "hide"; // want to see something... (does not work?)

    } else if (document.getElementById) { // Netscape 6.x
      p1 = document.getElementById(p1);
      this.boost_savecolor1 = p1.style.color; // save color
      p1.style.color = "green";
    }

    document.bgColor = "#" + Boost_rndhex_local() + Boost_rndhex_local() + Boost_rndhex_local();
    // change background color (must be hex value)

  }
}


//
// some special mouse out effects
//
function Boost_mout1(p1) {
  if (this.boost_id_idx >= 0) { // only if boost is active
    if (document.all) { // IE
      p1 = document.all[p1];
      p1.style.color = this.boost_savecolor1;	// restore color

      // restore navigation images
      for (var i = 0; i < 7; i += 2) {
        document.all.tags("td")[i + 3].background = this.boost_saveimg[i]; // test: restore img
      }

    } else if (document.layers) { // Netscape 4.x
      p1 = document.layers[p1];
      p1.visibility = "show";

    } else if (document.getElementById) { // Netscape 6.x
      p1 = document.getElementById(p1);
      p1.style.color = this.boost_savecolor1;
    }
  }
}

// end
