//
// advent1_main.js - adventure interpreter main (for debugging with NGS js)
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 21.01.2003 1.2 separated from advent1.js
//
//

//
// Checked with NGS 0.2.5:
//   js -Wall -t -l advent1_data_home1.js advent1.js sshow1.js timer1.js -f advent1_main.js
// -Wall (all warnings); -t (stack trace), -l (load multiple files) -f (load last file)
//
// Note:
// - *_main.js must be the last file!
// - include timer.js even if Timer is not used in sshow
// - For debugging:  put debug1.js before *_main.js
//


// You can also append this to the original file (syntax is also ok for browsers).

//
// start this if we are outside of a browser (stand alone JS engines)...
//
function main(args) {
  // Use either global data from file advent1_data_home1.js or (if not specified) some dummy data...
  var verbs1 = g_verbs1 || new Array("V0", "V1");
  var messages1 = g_messages1 || new Array("M0", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "M13", "M14", "M15", "M16");
  var rooms1 = g_rooms1 || new Array("  0,  0,  0,  0,  0,  0,R0", "  0,  0,  0,  0,  0,  0,R1");
  var objects1 = g_objects1 || new Array("  0,  0,0,^OO,,");
  var images1 = g_images1 || new Array("image0.jpg");
  var players1 = g_players1 || new Array("  0,  0,P0,");

  //args = args;
  var adv = new Adv(verbs1, messages1, rooms1, objects1, images1, players1);
  var adv_frm = new Object();
  adv.init_frm(adv_frm, 0);
  adv.dump_data();
  //adv.play_events("0,1,0.0");
}


// simulate window object for stand alone JS engines...
if (typeof window == "undefined") { // are we outside of a browser in a standalone JS engine?
  function window_open1() {
    return this;
  }

  function window_writeln_system1() { // for NSG JS Engine
    var str = ""; // does not work: arguments.join(" ");
    for (var i = 0; i < arguments.length; i++) {
      str += arguments[i]; // copy arguments
    }
    System.print(str +"\n"); //or: System.stdout.writeln(str);
  }

  function window_writeln_print1() { // for Rhino, SpiderMonkey
    var str = ""; // does not work: arguments.join(" ");
    for (var i = 0; i < arguments.length; i++) {
      str += arguments[i]; // copy arguments
    }
    print(str);
  }

  window = new Object(); // NGS: how to avoid warning about undefined global 'window'?
  window.open = window_open1;
  window.focus = window_open1; // dummy
  window.document = new Object();
  window.document.open = window_open1; // dummy
  window.document.close = window_open1; // dummy
  if (typeof System != "undefined") { // System object is available with NGS JS Engine
    window.document.writeln = window_writeln_system1;
    window.alert = window.document.writeln; // same as writeln
    // convert to integer with standalone engine, use Math.floor for others...
    eval("myint = int"); // set integer cast; avoid warning 'int' is reserved identifier in browsers
    if (typeof ARGS != "undefined") {
      if ((Math.max(5, 8) != 8) || (Math.pow(0.5, 2) != 0.25)) {
        window.alert("ERROR: Buggy NGS Javascript Engine! Correct b_math.c and try again...");
      } else {
        ARGS.shift(); // remove program name in ARGV[0]
        main(ARGS); // start script
      }
    }
  } else { // Rhino, SpiderMonkey...
    if (typeof arguments != "undefined") {
      window.document.writeln = window_writeln_print1; // for Rhino, SpiderMonkey
      window.alert = window.document.writeln; // same as writeln
      main(arguments); // start script
    }
  }
}

// end