//
// Situations 1
// based on situ1.c (MV, 1995)
// Marco Vieth
//
// 0.01  09.12.2000  first tests
//       04.06.2001  inserted some comments, interval delay changed to seconds
// 0.02  23.09.2001  all global variables start with this.situ_*, functions with situ_*;
// 0.03  19.01.2002  new object-oriented design
//         20.01.2002  do not use unnamed functions, prototypes -> useful for old browsers with Javascript 1.1
//
//



// (Normally we would use the Array creator [] here, but to give JS 1.1 browsers (Staroffice 5.2) a chance...)
// And we would also put the data into the prototype, but...

//
// Coding for declension of nouns: <coding character>.<noun>
// m=masculine noun, f=feminine noun, s=neuter, p=plural (same as f)

// Umgebungen (surroundings)
var Situ_situ_surroundings = new Array(
  "m.Basar", "p.Berge", "f.Burg",
  "s.Dach", "s.Dorf",
  "p.Ebenen", "f.Eisscholle",
  "s.Feld", "s.Flo", "m.Flu", "m.Friedhof",
  "m.Graben", "f.Grotte",
  "m.Hafen", "s.Haus", "s.Hochland", "f.Hhle", "s.Hgelland", "f.Htte",
  "f.Insel", "m.Irrgarten",
  "f.Karavane", "p.Katakomben", "m.Keller", "m.Kerker",
    "f.Kultsttte", "f.Kche",
  "s.Labyrinth", "s.Lager", "f.Lichtung", "f.Lwengrube",
  "m.Markt", "s.Meer",
  "s.Rasthaus", "s.Rathaus",
  "f.Savanne", "f.Schatzkammer", "s.Schlachtfeld", "s.Schlo", "f.Schlucht",
    "f.Schneelandschaft", "m.See", "f.Stadt", "m.Stall", "f.Steppe",
    "f.Strae", "m.Sumpf",
  "s.Tal", "p.Tler", "m.Trampelpfad", "m.Turm",
  "m.Urwald",
  "s.Verlies",
  "m.Wald", "m.Wasserfall", "m.Weg", "s.Wirtshaus", "f.Wste",
  "s.Zelt"
);


// Ereignisse (events)
var Situ_situ_events = new Array(
  "m.Angriff",
  "m.Baum", "m.Blitz", "m.Busch",
  "s.Erdbeben", "m.Erdrutsch", "f.Explosion",
  "f.Falle", "f.Falltr", "s.Feuer", "f.Flamme", "f.Frau",
    "s.Fundstck", "m.Funke",
  "f.Gefangenname", "s.Gerippe", "s.Gewitter",
  "m.Handel", "f.Hecke", "s.Hindernis",
  "m.Kfig", "f.Krankheit", "m.Krieg",
  "f.Lava", "f.Lawine", "s.Licht",
  "m.Mann", "f.Mauer",
  "m.Obstbaum", "m.Orkan",
  "f.Ruhe",
  "f.Sackgasse", "m.Sandsturm", "m.Schiffbruch", "m.Schlangenbi",
    "s.Seebeben",
    "m.Steinschlag", "f.Stille", "f.Stromschnelle", "m.Strudel",
    "f.Sturmflut",
  "f.Tanne", "m.Tornado", "s.Treibgut", "m.Teibsand",
  "f.Verteidigung", "m.Vulkanausbruch",
  "f.Weggabelung", "f.Windstille", "m.Wirbelsturm", "m.Wirbelwind"
);


// Begegnungen (meetings)
var Situ_situ_meetings = new Array(
  "m.Aasgeier", "m.Adler",
  "m.Br", "p.Bewohner der Gegend",
  "m.Delphin", "m.Drache",
  "s.Einhorn", "m.Einsiedler", "m.Eisbr", "m.Esel",
  "m.Geier", "m.Geist", "s.Gespenst", "m.Gnom",
  "m.Hai", "m.Hase", "m.Herrscher", "f.Hexe", "f.Horde",
  "p.Indianer",
  "s.Kamel", "m.Kmpfer", "p.Kannibalen", "m.Knig", "f.Krake", "m.Krieger",
  "f.Leiche", "m.Lindwurm", "m.Lwe",
  "f.Mrchengestalt", "p.Moskitos",
  "f.Person", "f.Pflanze", "p.Piranhas", "m.Pirat", "m.Priester",
  "s.Reh", "m.Riese",
  "f.Sagengestalt", "f.Schlange", "m.Soldat", "f.Spinne", "f.Stechmcke",
  "f.Tarantel", "p.Termiten", "s.Tier", "m.Troll",
  "s.Ungeheuer",
  "s.Volk",
  "m.Wchter", "m.Wal", "m.Wrter", "s.Wesen", "f.Wilde", "m.Wilder",
    "s.Wildpferd", "s.Wolfsrudel",
  "m.Zauberer", "m.Zwerg"
);


// Adjektive (adjectives)
var Situ_situ_adjectives = new Array(
 "abstoend", "abwartend", "achtend", "chzend", "aggressiv",
    "alt", "angeberisch", "angenehm", "angepat", "angriffslustig",
    "ngstlich",
    "annehmbar", "anpassungsfhig",
    "anziehend", "aufbrausend",
  "beachtlich", "bedauernswert", "bedrohlich", "befreiend", "befreit",
    "beglckt", "beglckend", "beherrschend", "belehrend", "beleuchtet",
    "bemitleidenswert", "benebelt", "bequem", "beschdigt",
    "besitzergreifend", "besondere", "besonnen",
    "besorgt", "betrunken", "bevlkert", "bewegt",
    "bewundernswert", "breit", "bunt",
  "dicht", "dick", "diesig", "direkt", "duftend", "dumm",
    "dunkle", "dnn", "dunstig",
  "edel", "egoistisch", "ehrhaft", "ehrlich", "eigenntzig",
    "eigensinnig", "eigenwillig", "eingebildet",
    "einfach", "einfallslos", "einfallsreich", "eingeschrnkt",
    "einladend", "einnehmend",
    "einsam", "einzelgngerisch", "eklig", "entartet",
    "entdeckend", "entfesselt",
    "entrstend", "entschlossen", "entzckend",
    "erfinderisch", "erfllt", "erfllend", "ergreifend",
    "erhoben", "erleuchtet",
    "erstaunlich",
  "fahl", "fair", "farbenfroh", "faul", "feige",
    "fein", "feindlich", "fern", "fett",
    "feucht", "folgsam", "frei", "freigiebig",
    "freundlich", "friedlich",
    "frhlich", "frchterlich",
  "geborgen", "geduldig", "gefangen", "gefrig",
    "geheim", "geheimnisvoll", "gehorsam", "geizig", "gelassen",
    "genial", "gepflegt", "gerade", "geruschvoll", "gerecht",
    "gerissen", "gerstet",
    "geschftig", "geschickt", "gesellig", "gesittet",
    "gewaltttig", "gewandt", "gewhnlich",
    "gierig", "glcklich",
    "gndig",
    "grlich", "grausam", "grob", "gro", "grospurig", "grozgig",
    "gutglubig", "gutmtig",
  "habgierig", "hart", "hlich", "hektisch", "heimisch", "heimlich",
    "hei", "hell", "herablassend", "herrlich",
    "heruntergekommen", "herzerweichend", "herzlich",
    "herzzerreiend", "hilfsbereit", "hinterfotzig",
    "hinterhltig", "hochmtig", "hoffnungslos", "hoffnungsvoll",
    "hohe", "humorlos", "humorvoll", "hungrig",
  "ideal", "ideenreich", "idyllisch", "interessant", "intolerant",
  "jhzornig", "jung",
  "kahl", "kalt", "kmpferisch", "kampflustig", "kantig", "kaputt",
    "klglich", "klar", "klein", "klug",
    "komisch", "kontaktscheu", "krftig", "kritisierend", "krumm",
    "kurz",
  "labil", "lang", "langsam", "langweilig", "lrmend",
    "laut", "lebendig", "lebensfroh",
    "leicht", "leichtglubig", "leise",
    "lieblich", "listig", "lustig",
  "machtschtig", "mig", "matschig", "merkwrdig",
    "mickrig", "milchig", "mitleidsvoll", "murmelnd", "mutig", "mysteris",
  "nachdenklich", "nachtragend", "nah", "naiv", "nrrisch", "nass",
    "neblig", "negativ", "nett", "neu", "neugierig",
    "niedrig", "nimmersatt", "nrgelnd", "normal",
  "oberflchlich", "de", "offen", "optimistisch",
  "pessimistisch", "phantastisch", "pingelig", "platt",
    "pltzlich", "plump", "positiv", "prahlerisch", "protzend",
    "protzig", "prunkvoll",
  "ruberisch", "redselig", "rasend", "rastlos", "rechthaberisch",
    "rein", "reformierend", "revolutionr",
    "riesig", "romantisch", "ruhig",
  "sanft", "sanftmtig", "sauber", "schbbig", "scheinheilig",
    "scheu", "schief",
    "schlafend", "schlau", "schleimig", "schlicht",
    "schmal", "schmierig", "schmutzig",
    "schnell", "schnuckelig", "schnffelnd", "schn",
    "schrecklich", "schwach", "schweigsam", "schwer",
    "selbstndig", "selbstgefllig", "seltsam", "sittlich",
    "spaig", "speziell", "spielerisch",
    "stabil", "stark", "stinkend", "sthnend", "stolz", "strrisch", "s",
  "tapfer", "tauglich", "tiefgrndig", "tobend", "toll", "tolerant",
    "tratschend", "traurig", "treu", "trickreich", "trinkschtig",
    "trocken", "trstlich", "trotzig",
    "trb", "trbsinnig", "tckisch",
  "bermtig", "berwltigend", "belriechend", "ble",
    "umwerfend", "unangenehm", "unanpassungsfhig", "unbedeutend",
    "unbekannt",
    "undefinierbar", "unehrlich", "uneingeschrnkt",
    "unfhig", "unfair", "unfreundlich", "ungeduldig",
    "ungehobelt", "ungerecht", "ungeschickt", "uninteressant", "unmig",
    "unruhig", "unselbstndig",
    "untauglich", "unterdrckend", "unterdrckt", "unterhaltsam",
    "unterwrfig",
    "unbersehbar", "unwrdig",
    "uralt",
  "verantwortungslos", "verantwortungsvoll", "verborgen",
    "vergebend", "vergeblich",
    "vergessen", "verhllt",
    "verlassen", "verletzt", "verloren", "vernebelt", "verschlossen",
    "verschwommen", "verspielt", "versteckt",
    "verteilt", "verwegen", "verwildert",
    "verwirrend", "verwundernd",
    "verwundert", "verwundet", "verzaubert", "voll",
    "vorausplanend", "vorausschauend", "vorteilsbedacht", "vorzglich",
  "warm", "weich", "weissagend", "weit", "wertlos",
    "wertvoll", "wild", "windig",
    "winzig", "witzig", "wundervoll", "wrdevoll",
  "zahm", "zart", "zrtlich", "zerstrerisch",
    "zurckhaltend", "zutraulich", "zuversichtlich"
);


// Constructor for class Situ
function Situ() {
  // attributes
  this.situ_txtval = 0; // ??
  this.situ_itimer = 0; // interval timer

  // methods
  if (!Situ.prototype) { // old browsers get the methods directly into the object...
    this.get_rnd_index1 = Situ_get_rnd_index1;
    this.select_rnd_adjnoun = Situ_select_rnd_adjnoun;
    this.change_text = Situ_change_text;
    this.auto_change_text = Situ_auto_change_text;
    // simulate class attributes
    this.situ_surroundings = Situ_situ_surroundings;
    this.situ_events = Situ_situ_events;
    this.situ_meetings = Situ_situ_meetings;
    this.situ_adjectives = Situ_situ_adjectives;
  }
}


//
// normally we would create unnamed functions here but for old browsers...
// Situ.prototype.get_rnd_index1 = function(list) { ... }
//

// For new browsers (JS 1.2) set the prototypes...
if (Situ.prototype) {
  Situ.prototype.get_rnd_index1 = Situ_get_rnd_index1;
  Situ.prototype.select_rnd_adjnoun = Situ_select_rnd_adjnoun;
  Situ.prototype.change_text = Situ_change_text;
  Situ.prototype.auto_change_text = Situ_auto_change_text;
  // class attributes
  Situ.prototype.situ_surroundings = Situ_situ_surroundings;
  Situ.prototype.situ_events = Situ_situ_events;
  Situ.prototype.situ_meetings = Situ_situ_meetings;
  Situ.prototype.situ_adjectives = Situ_situ_adjectives;
}



//
// situ_get_rnd_index1 - get random index
// IN:  <list>
// OUT: random index to a list element
//
function Situ_get_rnd_index1(list) {
  return Math.floor(Math.random() * list.length);
}

//
// situ_select_rnd_adjnoun - select random adjective, noun
// IN:  <list of adjectives>, <list of nouns>
// OUT: random adjective+noun, with proper declension
//
function Situ_select_rnd_adjnoun(adj_l, noun_l) {
  var a = this.get_rnd_index1(adj_l);
  var n = this.get_rnd_index1(noun_l);
  var parts = noun_l[n].split("."); // split into noun "sex" and noun
  var ending = (adj_l[a].substr(adj_l[a].length - 1, 1) == "e") ? "" : "e"; 
    // append "e" if adj not ending with it (IE does not know -1=last character)
  switch(parts[0]) {
    case "m": // masculine noun
      ending += "r";
      break;
    case "f": // feminine noun
    case "p": // plural: no ending for both
      //ending += "";
      break;
    case "s":
      ending += "s";
      break;
    default:
      alert("Unknown noun code "+ parts[0]);
      break;
  }
  //alert(parts[0] +": "+ adj_l[a] + ending +" "+ parts[1]);
  return(adj_l[a] + ending +" "+ parts[1]);
}


//
// situ_change_text - change text (of e.g. input field)
// IN:  [<txtval> = text field]
// OUT: txt = new random situation, also set as txtval.value, if specified (before)
//
function Situ_change_text(txtval) {
  if (txtval) { // if text value specified, save it
    this.situ_txtval = txtval;
  }
  var txt = this.select_rnd_adjnoun(this.situ_adjectives, this.situ_surroundings) + "\n\n" +
            this.select_rnd_adjnoun(this.situ_adjectives, this.situ_events) + "\n\n" +
            this.select_rnd_adjnoun(this.situ_adjectives, this.situ_meetings);
  
  if (this.situ_txtval) {
    this.situ_txtval.value = txt;
    //e.g. document.Situation.description.value = txt;
  }
  return txt;
}


var g_situ_this; // very ugly to save object for timeout...

//
// situ_auto_change_text - automatically change text
// IN:  <delay>
// OUT: -
// Stop a running interval timer and restart it with <delay> seconds to change text automatically.
// Use delay=0 to switch the timer off.
// Note: Before using this function call change_text() with a parameter.
//
function Situ_auto_change_text(delay) {
  if (this.situ_itimer > 0) { // timer active?
    window.clearInterval(this.situ_itimer);
    this.situ_itimer = 0;
  }    
  if (delay > 0) {
    g_situ_this = this;
    this.situ_itimer = window.setInterval("g_situ_this.change_text()", delay * 1000);
  }
}

// end
