nolist

JU1		EQU	1
JU2		EQU	1

sprites		equ	16384
mapasuper	equ	30208
virtual		equ	32768
grafdeco	equ	43008
buffcar		equ	47104
infosuper	equ	47744

		IF	JU1=1

		org	#0400

		IF	JU2=1
		.start
		ENDIF

RUN start
		di
		ld	hl,int
		ld	(#0039),hl
		ei

		call	setpanta
		call	ponetintas
		call	borrapanta
		call	creascanes
princi		call	menu
		call	sacacartel

		ld 	a,3
		ld	(vidas),a

init		call	creabufcar
		call	creabufdur
		call	borravir
		call	pinvirtu
		call	papavi

main		call	mira2game
		call	mapkey
		call	leeteclado

		ld	a,(keys)
		bit	7,a
		ret	nz
		bit	6,a
		call	nz,pausa

		call	muevprota	; mueve al prota
		call	gravedad
		call	dureprota	; mira durezas del prota

		call	muevebala

		call	barrespri	; mira si entran enemigos
		call	muevenemi	; mueve enemigos

		call	michopro	; mira choques con prota
		call	michobalas	; mira choques con balas
		call	muerenemi	; mira si mueren enemigos

		call	contadores
		call	cafiac
		call	creavi
		call	papavi
		jr	main


mira2game	ld	a,(columsupe)
mira2gam1	cp	89
		jr	z,busnave
		ret

busnave		call	nosalta
		call	desacene

		ld	hl,tprota+1	; coor y
		ld	(hl),3
		call	pinvirtu
		call	papavi

		ld	ix,tenemi
		ld	(ix+5),#40
		ld	(ix+1),16
		ld	(ix+0),6
		ld	(ix+2),12	; es. nave
		push	ix
		call	pinvirtu
		call	papavi
		pop	ix

novanave	ld	a,3
		cp	(ix+1)
		jr	z,sevanave
		dec	(ix+1)
		push	ix
		call	retardo
		call	creavi
		call	papavi
		call	retardo
		pop	ix
		jr	novanave

sevanave	ld	hl,tprota+5
		res	6,(hl)	; desc. prota
sevanav1	ld	a,16
		cp	(ix+1)
		jr	z,va2game
		inc	(ix+1)
		push	ix
		call	retardo
		call	creavi
		call	papavi
		call	retardo
		pop	ix
		jr	sevanav1
va2game		ld	hl,tprota+5
		set	6,(hl)
		jp	ini2game

pausa		call	mkey
		call	ekey
		ret


gravedad	ld	a,(estasaltan)
		cp	1
		ret	z
		ld	ix,tprota
		ld	a,3
		cp	(ix+1)
		ret	nc
		dec	(ix+1)
		ld	a,1
		ld	(marcascrol),a
		call	dureprota
		ld	a,(marcascrol)
		cp	0
		jr	z,graveda1
		xor	a
		ld	(marcascrol),a
		ret
graveda1	inc	(ix+1)
		ret

;*****************************************
;*	MUEVE AL PROTA		 	 *
;*****************************************

muevprota	ld	ix,tprota
	
		ld	a,(ix+0)
		ld	(antcoorx),a
		ld	a,(ix+1)
		ld	(antcoory),a	; pasa las coor a las antig.

		set	1,(ix+5)	; se mueve
		ld	(ix+3),0	; estado andando
		ld	a,(estasalta2)
		cp	1
		jp	z,segsalto
		ld	a,(estasaltan)
		cp	1
		jr	z,salta
		ld	de,(keys)
		bit	0,e
		jr	nz,salto
		bit	1,e
		jp	nz,agacha
		bit	2,e
		jp	nz,izquierda
		bit	3,e
		jp	nz,derecha
		bit	4,e
		jp	nz,fuego
		call	caesta
		res	1,(ix+5)	; no se mueve
		ret

salto		ld	hl,sonisalta
		call	sonido
		xor	a
		ld	(bitsalto),a
		ld	a,(keys)
		bit	3,a
		jr	z,salt0
		xor	a
		set	0,a
		jr	salt2
salt0		bit	2,a
		jr	z,salta
		xor	a
		set	1,a
salt2		ld	(bitsalto),a	

salta		ld	a,(keys)
		bit	2,a
		jr	z,salt01
		set	0,(ix+5)	; mira a la izq
salt01		bit	3,a
		jr	z,salt02
		res	0,(ix+5)	; mira a la dere	

salt02		ld	(ix+3),1	; estado salto
		ld	a,1
		ld	(estasaltan),a
		ld	a,(subebaja)
		cp	1
		jr	z,salbaja
	
		ld	a,(contsal1)
		inc	a
		ld	(contsal1),a
		cp	6
		jr	z,caesalto
		cp	5	
		jr	nc,mira2sal

		ld	a,9
		cp	(ix+1)
		ret	c

salt4		inc	(ix+1)
	
		ld	a,(bitsalto)
		bit	0,a
		jp	nz,deresal
		bit	1,a
		jp	nz,izquisal

		ld	a,(keys)
		bit	4,a
		jp	nz,fuego
		ret
salbaja		ld	a,(contsal1)
		dec	a
		ld	(contsal1),a
		cp	0
		jr	z,vuelsalt
		dec	(ix+1)

		ld	a,(bitsalto)
		bit	0,a
		jp	nz,deresal
		bit	1,a
		jp	nz,izquisal

		ld	a,(keys)
		bit	4,a
		jp	nz,fuego
		ret
mira2sal	ld	a,(keys)
		bit	0,a
		jr	nz,segsalto
		jr	salt4

caesalto	ld	a,1
		ld	(subebaja),a	
		ret

vuelsalt	xor	a
		ld	(subebaja),a
		ld	(estasaltan),a
		ret

segcaesalto	ld	a,1
		ld	(subebaja2),a
		ret

segvuelsalt	xor	a
		ld	(subebaja2),a
		ld	(estasalta2),a
		ld	a,1
		ld	(subebaja),a
		ret

nosalta		xor	a
		ld	(subebaja),a
		ld	(subebaja2),a
		ld	(estasaltan),a
		ld	(estasalta2),a
		ld	(contsal1),a
		ld	(contsal2),a
		ret

segsalto	ld	a,(keys)
		bit	2,a
		jr	z,segsalt01
		set	0,(ix+5)	; mira a la izq
segsalt01	bit	3,a
		jr	z,segsalt02
		res	0,(ix+5)	; mira a la dere	

segsalt02	ld	(ix+3),1	; estado salto
		ld	a,1
		ld	(estasalta2),a
		ld	a,(subebaja2)
		cp	1
		jr	z,segsalbaja	
		ld	a,(contsal2)
		inc	a
		ld	(contsal2),a
		cp	5
		jr	z,segcaesalto
		inc	(ix+1)

		ld	a,(bitsalto)
		bit	0,a
		jr	nz,deresal
		bit	1,a
		jr	nz,izquisal

		ld	a,(keys)
		bit	4,a
		jp	nz,fuego
		ret
segsalbaja	ld	a,(contsal2)
		dec	a
		ld	(contsal2),a
		cp	0
		jr	z,segvuelsalt
		dec	(ix+1)

		ld	a,(bitsalto)
		bit	0,a
		jr	nz,deresal
		bit	1,a
		jr	nz,izquisal

		ld	a,(keys)
		bit	4,a
		jp	nz,fuego
		ret



subebaja	defb	0
contsal1	defb	0
estasaltan	defb	0
subebaja2	defb	0
contsal2	defb	0
estasalta2	defb	0
bitsalto	defb	0


agacha		ld	(ix+3),2	; estado agachado
		ld	a,(keys)
		bit	2,a
		jr	z,agach1
		set	0,(ix+5)	; izqui
agach1		bit	3,a
		jr	z,agach2
		res	0,(ix+5)	; dere
agach2		bit	4,a
		jr	nz,fuego
		ret


izquierda	set	0,(ix+5)	; va a la izq
izquisal	ld	a,(keys)
		bit	4,a
		call	nz,fuego
		ld	a,0
		cp	(ix+0)
		ret	z
		dec	(ix+0)
		ret

derecha		res	0,(ix+5)	; va a la derecha
deresal		ld	a,(keys)
	bit	4,a
	call	nz,fuego
	ld	a,8
	cp	(ix+0)
	jp	z,scrolliz
	inc	(ix+0)
	ret

fuego	ld	a,(oldkeys)
	bit	4,a
	ret	nz
	push	ix
	call	metebala
	pop	ix
	ret


muerto	ld	hl,sonimorio
	call	sonido
	ld	ix,tprota
	set	1,(ix+5)	; se mueve
	ld	(ix+3),3	; estado muerto
	ld	(ix+4),0	; fase a cero

muert1	push	ix
	call	unfiac
	call	creavi
	call	papavi
	call	retardo
	pop	ix
	ld	a,7
	cp	(ix+4)	; fase de estado
	jp	z,inicia
	jr	muert1

inicia		ld	ix,tprota
	ld	a,(columsupe)
	cp	90
	jr	c,tercio1
	cp	187
	jr	c,tercio2

	ld	a,187
	jr	terfin

tercio1	xor	a
	jr	terfin

tercio2	ld	a,90

terfin	ld	(columsupe),a
	ld	(ix+0),4
	ld	(ix+1),3	; coor de inicio
	xor	a
	ld	(quescroll),a
	call	nosalta
	call	inibichos
	call	metecartel
	ld	a,(vidas)
	sub	1
	cp	0
	jp	z,princi
	ld	(vidas),a
	jp	init

inibichos	ld	a,(columsupe)
	cp	0
	jr	z,inibich0
	cp	90
	jr	z,inibich1
	ld	a,100	; a cambiar	
	ld	(contspri),a
	ret
inibich0	xor	a
	ld	(contspri),a
	ret
inibich1	ld	a,34
	ld	(contspri),a
	ret

;	*******************
;	*	MENU	  *
;	*******************

menu	call	sacacartel
	call	borravir

	ld	ix,tenemi
	ld	(ix+5),#41
	ld	(ix+0),22	; x
	ld	(ix+1),7	; y
	ld	(ix+2),4
	call	pospb1
	call	pispv2
	ld	(ix+5),0	; lo desactivo
	ld	ix,tenemi+16
	ld	(ix+5),#40
	ld	(ix+0),2
	ld	(ix+1),7
	ld	(ix+2),1
	ld	(ix+4),3
	call	pospb1
	call	pispv2
	ld	(ix+5),0	; lo desactivo
	ld	ix,tenemi+32
	ld	(ix+5),#40
	ld	(ix+0),9
	ld	(ix+1),15
	ld	(ix+2),18	; cartel
	call	pospb1
	call	pispv2
	ld	(ix+5),0	; lo desactivo

	call	papa
	call	metecartel
 	ld	hl,txtvacio
	call	escrilista

	ld	hl,txtmenu2
	call	escrilista
	ld	hl,txtmenu4
	call	escrilista

;	call	rotando

	ld	a,0	;opcion de teclado
mnjg0	ld	c,a
	ld	hl,txtmenu2+1
	ld	de,16	;longitud de cada texto
	ld	b,3
mnjg00	ld	(hl),0
	ld	a,3
	sub	b
	cp	c
	jr	nz,mnjg01
	ld	(hl),2
mnjg01	add	hl,de
	djnz	mnjg00
	ld	l,c
	ld	h,0
	add	hl,hl
	ld	de,opciones
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl
	ld	de,tablakeys
	ld	bc,8
	ldir
	ld	hl,txtmenu2
	call	escrilista

mnjg1	call	mapkey
	ld	ix,kmapa
	bit	0,(ix+4)	;0?
	jr	z,mnjg3
	ld	a,0
	bit	0,(ix+8)	;1?
	jr	z,mnjg2
	ld	a,1
	bit	1,(ix+8)	;2?
	jr	z,mnjg2
	ld	a,2
	bit	1,(ix+7)	;3?
	jr	nz,mnjg1       
mnjg2	push	af
	ld	hl,sonidispa
	call	sonido
	pop	af
	jr	mnjg0


mnjg3	call	borrapanta
	ret


int	ret


numsca	equ	20*8

creascanes	ld	ix,tablascan
	ld	hl,#c000+4

	ld	b,20	; num de filas
cts0	push	bc
	push	hl
	ld	b,8
	ld	de,2048
cts1	ld	(ix+0),l
	inc	ix
	ld	(ix+0),h
	inc	ix
	add	hl,de
	djnz	cts1
	pop	hl
	ld	bc,64
	add	hl,bc
	pop	bc
	djnz	cts0
	ret

tablascan	defs	numsca*2



pinvirtu	call	pospbu

	ld	ix,buffcar	; dir buffer de caracteres
	ld	de,virtual
	ld	b,20	; numero de filas
pinvi0	ld	c,32	; OJO varia segun par-impar
pinvi1	push	bc
	ld	a,c
	push	de
pinvi2	ld	c,a
	ld	a,1
	cp	(ix+0)	; es cero ?
	ld	a,c
	jr	z,pinvi4
	ld	l,(ix+0)
	inc	ix
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	bc,grafdeco	; dir banco de caracteres
	add	hl,bc	; dir del caracter

	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	set	7,e
	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	res	7,e
	set	0,d
	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	set	7,e
	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi

	res	6,e
	res	7,e
	res	0,d


pinvi5	dec	a
	jr	nz,pinvi2
	pop	de
	inc	d
	inc	d
;	ld	bc,96	;(128-32) !OJO! que varia
;	add	ix,bc
	pop	bc
	djnz	pinvi1
	ret
pinvi4	inc	de
	inc	de
	inc	ix
	jr	pinvi5


borravir	ld	a,#ff
	ld	hl,virtual
	ld	b,20*8	
brrvr1	push	bc
	push	hl
	push	hl
	pop	de
	inc	de
	ld	(hl),a
	ld	bc,64-1
	ldir
	pop	hl
	ld	bc,64
	add	hl,bc
	pop	bc
	djnz	brrvr1
	ret



borramivir	ld	a,#ff
	ld	hl,virtual
	ld	b,14*8	
brrmvr1	push	bc
	push	hl
	push	hl
	pop	de
	inc	de
	ld	(hl),a
	ld	bc,64-1
	ldir
	pop	hl
	ld	bc,64
	add	hl,bc
	pop	bc
	djnz	brrmvr1
	ret


	;*********************************
	;* PAPAVI  pasa pantalla virtual *
	;*         a pantalla visual     *
	;*********************************
	
papavi	call	pispvi

papa	di
	call	raster

	ld	(auxsp),sp
	ld	sp,tablascan
	ld	hl,virtual
	ld	bc,56*160	; 28 ancho * 20 alto
ppv0	pop	de

;REPEAT 56
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi

	ld	de,8
	add	hl,de
	jp	pe,ppv0
	ld	sp,(auxsp)
	ei
	ret

auxsp	defw	0



creabufcar	ld	a,(columsupe)
		ld	e,a
		ld	d,0
		ld	ix,mapasuper
		add	ix,de
		ld	de,buffcar

		ld	b,10	; filas/2
creabufca1	push	bc
		ld	b,16	; columnas/2
creabufca2	push	bc

		ld	l,(ix+0)
		ld	h,0
		inc	ix
		add	hl,hl
		add	hl,hl
		ld	bc,infosuper
		add	hl,bc

		ld	a,(hl)
		ld	(de),a
		inc	de
		inc	hl
		ld	a,(hl)
		ld	(de),a
		inc	hl
		ex	de,hl
		ld	bc,31
		add	hl,bc
		ex	de,hl
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	de
		ld	a,(hl)
		ld	(de),a
		ex	de,hl
		ld	bc,31
		or	a
		sbc	hl,bc
		ex	de,hl
		pop	bc
		djnz	creabufca2
		ld	bc,256-16
		add	ix,bc
		ld	bc,32
		ex	de,hl
		add	hl,bc
		ex	de,hl
		pop	bc
		djnz	creabufca1
		ret



scrolliz	ld	a,1
	ld	(marcascrol),a
	call	muevenemi
	call	dureprota
	ld	a,(marcascrol)
	cp	0
	ret	z
	xor	a
	ld	(marcascrol),a
	ld	hl,(puntos)
	inc	hl
	ld	(puntos),hl
	ld	a,(quescroll)
	cp	1
	jr	z,scroll2
	inc	a
	ld	(quescroll),a

scroll1	call	creavi
	call	scroizqui
	call	scroizbuf
	call	scroizdur
	ld	ix,tprota
	call	unfiac
	ret

scroll2	xor	a
	ld	(quescroll),a

	call	creavi
	call	scroizqui

	ld	hl,columsupe
	inc	(hl)
	call	creabufcar
	call	creabufdur
	ld	ix,tprota
	call	unfiac

	call	ponfi3132
	ret

quescroll	defb	0
marcascrol	defb	0

ponfi3132	ld	hl,mapafino+30
		ld	b,20
ponfi311	push	bc
		push	hl
		ld	(hl),1
		inc	hl
		ld	(hl),1
		pop	hl
		ld	bc,32
		add	hl,bc
		pop	bc
		djnz	ponfi311
		ret


;	*****************************************
;	*	SCROIZQU scroll izquierda      *
;	*****************************************
scroizqui	ld	hl,virtual+2
		ld	de,virtual
		ld	bc,10240-320

scroizqu1	;REPEAT 62
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi

	inc	hl
	inc	hl
	inc	de
	inc	de
	jp	pe,scroizqu1
	ret


scroizdur	ld	hl,buffdur+1
		ld	de,buffdur
		ld	bc,32*20-20
scroizdu1 	;REPEAT 31
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi

	inc	hl
	inc	de
	jp	pe,scroizdu1
	ret

scroizbuf 	ld	hl,buffcar+1
		ld	de,buffcar
		ld	bc,32*20-20
scroizbu1	;REPEAT 31
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi

	inc	hl
	inc	de
	jp	pe,scroizbu1
	ret


retardo	push	bc
	ld	bc,1000
retard1	dec	bc
	ld	a,b
	or	c
	jr	nz,retard1
	pop	bc
	ret




creabufdur	ld	a,(columsupe)
	ld	e,a
	ld	d,0
	ld	ix,mapasuper
	add	ix,de
	ld	de,buffdur

	ld	b,10	; filas/2
creabufdu1	push	bc
		ld	b,16	; columnas/2
creabufdu2	push	bc


		ld	hl,tdurvacio

	; MIRO SI ES UN CRATER

	ld	a,28
	cp	(ix+0)
	jr	nc,miraagua	; no lo es
	ld	a,38
	cp	(ix+0)
	jr	c,miraagua	; no lo es

	ld	hl,tdurmuer

	; MIRO SI ES AGUA

miraagua	ld	a,79
	cp	(ix+0)
	jr	nc,miraduro
	ld	a,84
	cp	(ix+0)
	jr	c,miraduro

	ld	hl,tdurmuer

	; MIRO SI ES DURO

miraduro	ld	a,15
	cp	(ix+0)
	jr	nc,otroduro
	ld	a,28
	cp	(ix+0)
	jr	c,otroduro

	jr	reviduro
;	ld	hl,tdurduro

otroduro	ld	a,105
	cp	(ix+0)
	jr	nc,creabufdu3
	ld	a,191
	cp	(ix+0)
	jr	c,creabufdu3

reviduro	push	de
	ld	hl,tdurduro
	push	hl
	ld	l,(ix+0)
	ld	h,0
	add	hl,hl
	add	hl,hl
	ld	de,infosuper
	add	hl,de
	ex	de,hl
	pop	hl
	ld	b,4
revidur1	ld	a,(de)
	cp	1	; miro si es negro
	jr	z,revidur2
	ld	(hl),2	; es duro
revidur3	inc	de
	inc	hl
	djnz	revidur1
	ld	de,4
	or	a
	sbc	hl,de
	pop	de
	jr	creabufdu3
revidur2	ld	(hl),0	; no es duro!
	jr	revidur3

creabufdu3	inc	ix

	ld	a,(hl)
	ld	(de),a
	inc	de
	inc	hl
	ld	a,(hl)
	ld	(de),a
	inc	hl
	ex	de,hl
	ld	bc,31
	add	hl,bc
	ex	de,hl
	ld	a,(hl)
	ld	(de),a
	inc	hl
	inc	de
	ld	a,(hl)
	ld	(de),a
	ex	de,hl
	ld	bc,31
	or	a
	sbc	hl,bc
	ex	de,hl
	pop	bc
	dec	b
	xor	a
	or	b
	jp	nz,creabufdu2
	ld	bc,256-16
	add	ix,bc
	ld	bc,32
	ex	de,hl
	add	hl,bc
	ex	de,hl
	pop	bc
	dec	b
	xor	a
	or	b
	jp	nz,creabufdu1
	ret

tdurvacio	defb	0,0,0,0
tdurmuer	defb	1,1,1,1
tdurduro	defb	2,2,2,2


dureprota	ld	ix,tprota
		ld	hl,buffdur+608
		ld	a,(ix+1)	; coor y
		ld	b,a
dureprot1	ld	de,32
	or	a
	sbc	hl,de
	djnz	dureprot1
	ld	e,(ix+0)	; coor x
;	srl	e
	ld	d,0
	add	hl,de
	ld	(auxsp),hl

; MIRO SI ES MUERTE

	ld	b,(ix+9)	; dim x
	srl	b
dureprot2	ld	a,1
	cp	(hl)
	inc	hl	
	jp	z,muerto
	djnz	dureprot2

; MIRO SI ES DURO

	ld	hl,(auxsp)
	ld	b,(ix+9)
	srl	b
dureprot3	ld	a,2
	cp	(hl)
	inc	hl
	jr	z,dureprot4
	djnz	dureprot3
	ret

dureprot4	; ha chocado. pongo las coor ant.

	call	nosalta
	ld	a,(marcascrol)
	cp	1
	jr	nz,dureprot5
	xor	a
	ld	(marcascrol),a
	ret

dureprot5	ld	a,(antcoorx)
	ld	(ix+0),a
	ld	a,(antcoory)
	ld	(ix+1),a
	ret



;	*****************************************
;	*  MICHOPRO  mira los choques con en.   *
;	*****************************************

michopro	ld	ix,tprota
	ld	a,(ix+0)	; coorx
	inc	a
	inc	a
	ld	(choquex),a
	ld	a,(ix+1)	; coory
	inc	a
	inc	a
	ld	(choquey),a
	ld	ix,tenemi
	ld	b,numene	; num. ene.
michopr1	push	bc
	call	michopr2
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	michopr1
	ret

michopr2	bit	6,(ix+5)	; esta activado?
	ret	z
	bit	5,(ix+5)	; ha chocado ya ?
	ret	nz

	ld	a,(choquey)
	ld	c,a
	cp	(ix+1)
	ret	c
	ld	a,(ix+8)	; scanes
	srl	a
	srl	a
	srl	a
	add	(ix+1)	; coory
	cp	c
	ret	c

	ld	a,(choquex)
	ld	c,a
	cp	(ix+0)
	ret	c
	ld	a,(ix+9)	; dimx
	srl	a
	add	(ix+0)	; coory
	cp	c
	ret	c

	; HA CHOCADO

	call	mataenemi
	ld	hl,(puntos)
	ld	bc,10
	add	hl,bc
	ld	(puntos),hl
	ld	hl,explobicho
	call	sonido
	call	flash
	call	decenergia
	call	decenergia
	ret


mataenemi	set	5,(ix+5)	; ha muerto
	ld	(ix+3),3	; estado muerto
	ld	(ix+4),0	; fase a 0
	ld	a,3
	cp	(ix+2)	; tipo
	ret	c
	ld	a,2
	add	(ix+1)	; coory
	ld	(ix+1),a
	ret


choquex	defb	0
choquey	defb	0




;	**************************
;	*  MIRA CHOQUES BALAS    *
;	**************************

michobalas
	ld	ix,tbalas
	ld	b,nubalas
michobala1	push	bc
	bit	6,(ix+5)	; esta activada?
	jr	z,michobala2
	ld	a,(ix+0)	; coor x bala
	ld	(choquex),a
	ld	a,(ix+1)	; coor y ''
	inc	a
	ld	(choquey),a
	push	ix
	call	michoene
	pop	ix
	ld	a,(chobala)
	cp	0
	jr	z,michobala2	; no hay choque
	set	7,(ix+5)	; desac. la bala
michobala2	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	michobala1
	ret


michoene	xor	a
	ld	(chobala),a
	ld	ix,tenemi
	ld	b,numene	; num. ene.
michoen1	push	bc
	call	michoen2
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	michoen1
	ret

michoen2	bit	6,(ix+5)	; esta activado?
	ret	z
	bit	5,(ix+5)	; ha chocado ya ?
	ret	nz

	ld	a,(choquey)
	ld	c,a
	cp	(ix+1)
	ret	c
	ld	a,(ix+8)	; scanes
	srl	a
	srl	a
	srl	a
	add	(ix+1)	; coory
	cp	c
	ret	c

	ld	a,(choquex)
	ld	c,a
	cp	(ix+0)
	ret	c
	ld	a,(ix+9)	; dimx
	srl	a
	add	(ix+0)	; coory
	cp	c
	ret	c

	; HA CHOCADO

	call	mataenemi
	ld	hl,(puntos)
	ld	bc,10
	add	hl,bc
	ld	(puntos),hl
	ld	hl,explobicho
	call	sonido
	ld	a,1
	ld	(chobala),a
	ret

chobala	defb	0

;	*****************************************
;	*	MUERENEMI. muerte enemigos	*
;	*****************************************

muerenemi
	ld	ix,tenemi
	ld	b,numene
muerenem1	push	bc
	call	muerenem2
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	muerenem1
	ret

muerenem2	bit	5,(ix+5)	; esta muerto?
	ret	z
	ld	a,2
	cp	(ix+4)	; fase
	ret	nz
	set	7,(ix+5)	; hay que desactivarlo
	ret


ponetintas	
	ld hl,tintas
pontintas
	di
	call pontin
	ei
	ret
pontin
	ld	bc,#7f00
	out	(c),c
	xor	a	; mode 0
	or	#9c
	out	(c),a

	ld	b,16	;pone tintas
ink1	push	bc
	ld 	a,16
	sub	b
	ld	c,a
	ld	b,#7f
	out	(c),c
	ld	a,(hl)
	or	64
	out	(c),a
	inc	hl
	pop	bc
	djnz	ink1
setborder
	or	64
	ld	bc,#7f10
	out	(c),c	; pone border
	out	(c),a	;tinta 15
	ret

setpanta
	ld h,24	;lineas
	ld l,32	;columnas
	ld d,30
	ld e,43
setpan
	ld bc,#bc01
	out (c),c
	inc b
	out (c),l
	dec b
	inc c
	out (c),c
	inc b
	out (c),e
	ld bc,#bc06
	out (c),c
	inc b
	out (c),h
	dec b
	inc c
	out (c),c
	inc b
	out (c),d
	ret

rotando	ld	ix,tabla2
	call	rotatitulo
	ret


rotatitulo	; el IX info de la tabla

	ld	hl,#c050
	ld	b,32	; lineas
rotatitu2	push	bc
	push	hl

	ld	hl,0
	ld	b,(ix+0)
rotatitu4	ld	de,20
	add	hl,de
	djnz	rotatitu4

	ld	de,cartel	; dir del sp
	add	hl,de
	ex	de,hl
	pop	hl
	push	hl
	ex	de,hl
	ld	bc,20
	ldir
	pop	hl
	ld	a,h
	add	a,8
	ld	h,a
	jr	nc,rotatitu1
	ld	bc,#c040
	add	hl,bc
rotatitu1	inc	ix
	pop	bc
	djnz	rotatitu2
	ret


tabla1	defb	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22
	defb	23,24,25,29,27,28,29,30,31,32

tabla2	defb	32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12
	defb	11,10,9,8,7,6,5,4,3,2,1,0

sacacartel
		ld	hl,#cd04	; dir panta
		ld	de,virtual	; dir marcador
		ld	b,31	; dim y
sacacarte1	push	bc
		push	hl
		ex	de,hl
		ld	bc,56	; dim x
		ldir
		ex	de,hl
		pop	hl
		ld	a,h
		add	8
		ld	h,a
		jr	nc,sacacarte2
		ld	bc,#c040
		add	hl,bc
sacacarte2	pop	bc
		djnz	sacacarte1
		ret

metecartel
		ld	hl,#cd04
		ld	de,virtual
		ld	b,31
metecarte1	push	bc
		push	hl
		ld	bc,56
		ldir
		pop	hl
		ld	a,h
		add	8
		ld	h,a
		jr	nc,metecarte2
		ld	bc,#c040
		add	hl,bc
metecarte2	pop	bc
		djnz	metecarte1
		ret


decenergia
	ld	hl,(dirdecener)
	ld	(hl),255	; negro
	inc	hl
	ld	(hl),255
	inc	hl
	ld	(hl),255
	dec	hl
	dec	hl
	ld	a,h
	add	8
	ld	h,a
	jr	nc,decenergi1
	ld	bc,#c040
	add	hl,bc
decenergi1	ld	(dirdecener),hl

	ld	a,(energia)
	sub	1
	cp	0
	jr	z,decenergi4
	ld	(energia),a
	ret
decenergi4	ld	a,22
	ld	(energia),a
	ld	hl,#f530	; dir a borrar
	ld	(dirdecener),hl
	jp	muerto

dirdecener	defw	#f530





;*****************************************************************
;** LEETECLADO MIRA SI SE HAN APRETADO LAS TECLAS DE LA TABLA   **
;**             Y LAS COLOCA EN LA VARIABLE DE FLAGS 'KEYS'     **
;**  bb 0-arri 1-abaj 2-izda 3-dech 4-bang 5-boom 6-paus 7-esc  **
;**  ba ??????????????????????????????????????????????????????  **
;*****************************************************************

leeteclado	ld	de,(keys)
	ld	(oldkeys),de
	ld	de,0
	ld	hl,tablakeys
	ld	b,8
ltcld1	srl	d
	rr	e
	ld	a,(hl)
	call	recotecla
	jr	nz,ltcld2
	set	7,e	;ya que son 8 teclas
ltcld2	inc	hl
	djnz	ltcld1

	ld	(keys),de
	ret


recotecla		;pone Z si se ha apretado la tecla a
	push	ix
	ld	ix,kmapa
	ld	c,a
	srl	a
	srl	a
	srl	a	;miramos el byte
	ld	(rctcl1+2),a
	ld	a,7
	and	c	;miramos el bit
	sla	a
	sla	a
	sla	a
	ld	c,a
	ld	a,(rctcl1+3)
	and	%11000111	;borramos el codigo de bit del BIT b,(IX+n)
	or	c
	ld	(rctcl1+3),a
rctcl1	bit	0,(ix+00)
	pop	ix
	ret


;**************************************************
;***  MAPKEY LEE TODO EL TECLADO DE UNA SOLA VEZ  *
;***  LKEY  MIRA SI SE HA APRETADO ALGUNA TECLA   *
;***  EKEY  ESPERA QUE SE APRIETE UNA TECLA       *
;***  MKEY  ESPERA QUE SE SUELTE UNA TECLA        *
;**************************************************

ekey	call lkey
	jr z,ekey
mkey	call lkey
	jr nz,mkey
	ret
lkey	call mapkey
	ld hl,kmapa
	ld b,10
	ld a,#ff
lk	and (hl)
	inc hl
	djnz lk
	cp #ff
	ret

mapkey
	di
	ld bc,#f40e
	out (c),c
	ld b,#f6
	in a,(c)
	and #30
	ld c,a
	or #c0
	out (c),a
	out (c),c
	inc b
	ld a,#92
	out (c),a
	push bc
	ld hl,kmapa
	ld de,mapbis
ciklo	set 6,c
	ld b,#f6
	out (c),c
	ld b,#f4
	in a,(c)
	ld b,a
;	or (hl)
;	cpl
	ld (hl),b
;	ld b,a
	ld a,(de)
;	and b
;	or (hl)
	XOR	B
	CPL		;CON ";" ANTERIOR, CON MAY ACUMULA TECLAS
	ld (de),a
	inc c
	inc de
	inc hl
	ld a,c
	and #f
	cp 10
	jr c,ciklo
	pop bc
	ld a,#82
	out (c),a
	dec b
	out (c),c
	ei
	ret

kmapa	defw #ffff,#ffff,#ffff,#ffff,#ffff
mapbis	defw #ffff,#ffff,#ffff,#ffff,#ffff



raster
	push	bc
	ld	b,#f5
rast1	in	a,(c)
	rra
	jr	nc,rast1
	pop	bc
	ret


flash
	ld	a,11	;blanco
	ld	hl,3000
flsh0	push	hl
	di
	call	setborder
	ei
	pop	hl
flsh1	nop
	dec	hl
	ld	a,l
	or	h
	jr	nz,flsh1
	ld	a,(tintas+15)
	di
	call	setborder
	ei
	ret


sonido
	ld	b,14
poregs	push	bc
	ld	a,14	;A= registo al que mandar
	sub	b
	ld	c,(hl)	;C= dato a mandar
	inc	hl
	call	poreg
	pop	bc
	djnz	poregs
	ret
poreg
	cp	7
	jr	nz,prg1
	ld	b,a
	ld	a,%111111
	and	c
	ld	c,a
	ld	a,b
prg1	di
	ld	b,#f4
	out	(c),a
	ld	b,#f6
	in	a,(c)
	or	#c0
	out	(c),a
	and	#3f
	out	(c),a
	ld	b,#f4
	out	(c),c
	ld	b,#f6
	ld	c,a
	or	#80
	out	(c),a
	out	(c),c
	ei
	ret


aleatorio	push	hl	;sale en A un No entre 0 y 255
	ld	a,r
	ld	h,a
	ld	a,r
	xor	h
	ld	l,a
	ld	a,r
	xor	(hl)
	pop	hl
	ret


sonidispag	defb	0,58,0,2,0,5,17,232+1,16,16,16,0,10,16
explobicho	defb	23,6,0,3,0,5,17,232,16,16,16,0,17,16
sonicarro	defb	56,0,58,0,92,0,0,248,16,16,16,0,16,0
sonilata	defb	36,0,58,0,22,0,0,248,16,16,16,0,16,0
sonidispa	defb	0,4,0,0,0,5,17,232,16,16,16,0,5,16
sonisalta	defb	251,16,255,10,190,2,23,180,21,23,32,255,20
sonimorio	defb	255,15,0,0,0,0,0,230,16,16,16,23,10,16


keysok	defw	0
keys	defw	0
oldkeys	defw	0


tablakeys
karriba		defb	67	;"q"
kabajo		defb	69	;"a"
kizquierda	defb	34	;"o"
kderecha	defb	27	;"p"
kbang		defb	47	;"SPACE"
kboom		defb	23	;"CONTROL"
kpausa		defb	44	;"h"
kfin		defb	66	;"ESC"



opciones	defw	kopcion0,kopcion1,kopcion2

kopcion0
		defb	67	;"q"
		defb	69	;"a"
		defb	34	;"o"
		defb	27	;"p"
		defb	47	;"SPACE"
		defb	23	;"CONTROL"
		defb	44	;"h"
		defb	66	;"ESC"

kopcion1
		defb	72	;"J1-arriba"
		defb	73	;"J1-abajo"
		defb	74	;"J1-izquierda"
		defb	75	;"J1-derecha"
		defb	76	;"J1-fire1"
		defb	47	;"SPACE"
		defb	44	;"h"
		defb	66	;"ESC"

kopcion2
		defb	0	;"fle-arriba"
		defb	2	;"fle-abajo"
		defb	8	;"fle-izquierda"
		defb	1	;"fle-derecha"
		defb	9	;"copia-fire1"
		defb	23	;"control"
		defb	44	;"h"
		defb	66	;"ESC"



tintas
		defb	4,7,14,28,22,18,11,0
		defb	4,21,12,3,29,15,24,20


columsupe	defb	0	;90
contspri	defb	0	;34

txtvacio	defb	22,20,2,"                            "
		defb	22,21,2,"                            "
		defb	22,22,2,"                            "
		defb	22,23,2,"                            ",0

txtmenu2	defb	16,1,22,8,10,"1- TECLADO",9
		defb	16,0,22,10,10,"2- JOYSTICK"
		defb	16,0,22,12,10,"3- CURSORES"
		defb	16,0,22,14,10,"0- JUGAR",9,9,9,0

txtmenu4	defb	22,18,2,16,0,"PROGRAMADO POR CESAR GIMENEZ"
		defb	22,20,3,16,0,"GRAFICOS POR JAVIER CERVERA"
		defb	22,22,5,16,2,"COPYRIGHT ZAFIRO",9,16,0,"1989",0


numene	equ	6
nubalas	equ	4

;	*****************************************
;	*  MIRA SI PUEDE ENTRAR UN ENEMIGO      *
;	*****************************************

miraenemi	xor	a
	ld	(posptabla),a

	ld	b,numene	; numero de enemigos
	ld	ix,tenemi
	ld	c,0	; contador a 0
miraenem1	bit	6,(ix+5)	; esta activado
	jr	z,miraenem2
	inc	c
	ld	de,16
	add	ix,de
	djnz	miraenem1
	ret
miraenem2	ld	a,c
	set	7,a	; hay sitio
	ld	(posptabla),a
	ret

posptabla	defb	0

;	*****************************************
;	*	   BARRE Y MIRA SI HAY SP.      *
;	*****************************************

barrespri	call	miraenemi	; mira si hay sitio

	ld	a,(posptabla)
	bit	7,a	; hay sitio ?
	ret	z
	and	%111	; quito el control
	ld	(posptabla),a

	ld	a,(contspri)
	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,taenemi
	add	hl,de

	ld	a,(columsupe)
barrespr1	cp	(hl)
	ret	nz
	ld	a,(contspri)
	inc	a
	ld	(contspri),a
	jr	metespri


;	*****************************************
;	*	METE UN SP EN EL BUFFER           *
;	*	HL apunta a la info de 8 bytes	   *
;	*****************************************

metespri
	; MIRO DONDE METERLO

	push	hl	; dir de la info
	ld	a,(posptabla)
	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,tenemi
	add	hl,de	; dir a meterlo
	push	hl
 	pop	ix	; dir tabla
	pop	iy	; dir info

	; PASO DATOS

	ld	a,(iy+1)	; coor y
	ld	(ix+1),a
	ld	a,(iy+2)	; tipo
	ld	(ix+2),a
	ld	a,(iy+3)	; vida
	ld	(ix+13),a
	ld	a,(iy+4)	; veloc
	ld	(ix+14),a
	ld	(ix+3),0 	; estado a 0
	ld	(ix+4),0	; fase a 0
	ld	(ix+5),64	; esta activado!
	set	0,(ix+5)	; va a la izq
	set	1,(ix+5)	; se mueve
 
	; CALCULO DE LA X

	ld	a,1
	ld	(vimesp),a
	call	pospb1
	xor	a
	ld	(vimesp),a

	ld	c,0
	ld	a,(ix+9)	; dimx
	srl	a
	inc	a	; por los medios
	cp	4
	jr	nc,metespr2
	sub	4
	ld	c,a	; resto
metespr2	ld	a,28
	sub	c	; resta lo que sobra
	ld	(ix+0),a	; coor x
	ret

vimesp	defb	0 


;	*****************************************
;	*	MUEVE LOS ENEMIGOS		           *
;	*****************************************

muevenemi
	ld	b,numene	; num. enemigos
	ld	ix,tenemi	; tabla de info
muevenem0	push	bc
	call	muevenem1
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	muevenem0
	ret


muevenem1	bit	6,(ix+5)	; esta activado ?
	ret	z
	bit	5,(ix+5)	; esta muerto ?
	ret	nz
	ld	l,(ix+2)	; tipo
	ld	h,0
	add	hl,hl
	ld	de,timovi	; tipo de movimi.
	add	hl,de
	ex	de,hl
	ld	a,(de)
	ld	l,a
	inc	de
	ld	a,(de)
	ld	h,a
	jp	(hl)

timovi	defw	movien1	; 0
	defw	movien6
	defw	movien1
	defw	movien1
	defw	movien1
	defw	movien1
	defw	movien1
	defw	movien3
	defw	movien1
	defw	movien2
	defw	movien4
	defw	movien1	; 11

	defw	movien1
	defw	movien1
	defw	movien1
	defw	movien2
	defw	movien5
	defw	movien1


movien1	ld	a,(ix+14)	; veloc
	ld	(muevenem4+1),a
	ld	c,a
	ld	a,(ix+0)	; coor x
	sub	c
muevenem4	cp	1
	jr	nc,muevenem2
	set	7,(ix+5)	; hay que desactivarlo en POSPBU
muevenem2	ld	(ix+0),a
	ret



movien2	dec	(ix+0)	; decremento la x
	ld	a,(ix+0)
	cp	1
	jr	nc,movien20
	set	7,(ix+5)	; hay que desactivarlo

movien20	ld	a,(arriaba)
	cp	0
	jr	nz,movien21
	ld	(ix+3),0	; estado subiendo
	inc	(ix+1)	; coory
	ld	a,14
	cp	(ix+1)
	ret	nc
	ld	a,1
	ld	(arriaba),a
	ret
movien21	ld	(ix+3),1	; estado bajando
	dec	(ix+1)
	ld	a,(ix+1)
	cp	3
	ret	nc
	inc	(ix+1)	; lo dejo bien
	xor	a
	ld	(arriaba),a
	ret

arriaba	defb	0


movien3	ld	a,(marcascrol)
	cp	0
	ret	nz
	call	aleatorio	; A 0 a 255
	and	%1
	ret	z	; aleat. cuando 0 sale.

	ld	iy,tprota
	ld	a,(ix+0)	; x ene
	cp	(iy+0)	; x prota
	jr	z,movien30
	jr	c,movien31
	dec	(ix+0)	; coorx
	set	0,(ix+5)	; lado iz
	ret
movien31	inc	(ix+0)
	res	0,(ix+5)	; lado der
	ret
movien30	ret



movien4	ld	a,20
	cp	(ix+0)	; coor x
	jr	nc,movie40

	ld	(ix+3),0	; estado rodando
	dec	(ix+0)
	ret

movie40	ld	a,10
	cp	(ix+0)
	jr	nc,movie41

	ld	(ix+3),1	; estado largo
	dec	(ix+0)
	dec	(ix+0)
	ret

movie41	ld	(ix+3),0	; estado rodando
	ld	c,1
	ld	a,(ix+0)	; coor x
	sub	c
	cp	1
	jr	nc,movie42
	set	7,(ix+5)	; hay que desactivarlo en POSPBU
movie42	ld	(ix+0),a
	ret


movien5	ld	hl,tprota+1	; coor y
	ld	a,(hl)
	cp	(ix+1)	; coor y en
	jr	nc,movie51
	dec	(ix+1)
	jr	movie52
movie51	inc	(ix+1)
movie52	dec	(ix+0)
	dec	(ix+0)
	ld	a,2
	cp	(ix+0)	; coor x
	ret	c
	set	7,(ix+5)	; hay que desactivarlo!
	ret


movien6	ld	a,(contmov6)	; cont . movim. 6
	cp	0
	jr	z,movie61
	cp	2
	jr	z,movie61
	cp	4
	jr	z,movie66
	cp	6
	jr	z,movie63
movie65	inc	a
	ld	(contmov6),a

	ld	a,(ix+14)	; veloc
	ld	(movie64+1),a
	ld	c,a
	ld	a,(ix+0)	; coor x
	sub	c
movie64	cp	1
	jr	nc,movie62
	set	7,(ix+5)	; hay que desactivarlo en POSPBU
	push	af
	xor	a
	ld	(contmov6),a
	pop	af
movie62	ld	(ix+0),a
	ret

movie61	inc	(ix+1)	; y
	jr	movie65

movie63	dec	(ix+1)	; y
	ld	a,-1
	jr	movie65

movie66	dec	(ix+1)
	jr	movie65

contmov6	defb	0

;	*****************************************
;	*	 MIRA SI PUEDE ENTRAR UNA BALA    *
;	*****************************************

mirabala	xor	a
	ld	(pospbala),a

	ld	b,nubalas	; numero de balas
	ld	ix,tbalas
	ld	c,0	; contador a 0
mirabal1	bit	6,(ix+5)	; esta activado
	jr	z,mirabal2
	inc	c
	ld	de,16
	add	ix,de
	djnz	mirabal1
	ret
mirabal2	ld	a,c
	set	7,a	; hay sitio
	ld	(pospbala),a
	ret

pospbala	defb	0



metebala	ld	hl,tprota+5
	bit	0,(hl)	; esta a la iz?
	jr	z,metebal1
	ld	hl,tprota
	ld	a,1
	cp	(hl)
	ret	nc	; si las posx del prota es <=1  si es no dispara

metebal1	call	mirabala	; mira si hay sitio

	ld	a,(pospbala)
	bit	7,a	; hay sitio ?
	ret	z
	and	%111	; quito el control

	; MIRO DONDE METERLO

	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,tbalas
	add	hl,de	; dir a meterlo
	push	hl
	pop	ix	; dir tabla
	ld	iy,tprota

	; PASO DATOS

	bit	0,(iy+5)	; el prota izq o der
	jr	z,balader

	ld	a,(iy+0)	; coor x
	ld	(ix+0),a
	set	0,(ix+5)	; va a la izqu
	jr	balafin
balader	ld	a,(iy+0)	; coor x
	inc	a
	ld	(ix+0),a
	res	0,(ix+5)	; va a la der

balafin
	ld	a,(iy+1)	; coor y
	inc	a
	inc	a
	ld	(ix+1),a
	ld	a,2
	cp	(iy+3)	; estado prota agachado?
	jr	nz,metebal6
	dec	(ix+1)	; bajo el tiro

metebal6	ld	(ix+2),11	; tipo bala

	ld	(ix+3),0 	; estado a 0
	ld	(ix+4),0	; fase a 0
	set	6,(ix+5)	; esta activado!
	set	1,(ix+5)	; se mueve

	ld	hl,sonidispa
	call	sonido 
	ret


;	*************************
;	*	MUEVE LAS BALAS   *
;	*************************

muevebala	ld	ix,tbalas
	ld	b,nubalas
muevebal1	push	bc
	call	muevebal2
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	muevebal1
	ret

muevebal2	bit	6,(ix+5)	; esta activado?
	ret	z
	bit	0,(ix+5)	; lado?
	jr	z,muevebal3	; der
	ld	a,(ix+0)
	dec	a
	dec	a
	cp	2
	jr	nc,muevebal4 
	set	7,(ix+5)	; hay que desactivarlo
	ret
muevebal3	ld	a,(ix+0)
	inc	a
	inc	a
	cp	28
	jr	c,muevebal4
	set	7,(ix+5)
	ret

muevebal4	ld	(ix+0),a
	ret



contadores	xor	a
	ld	(colorletra),a
	ld	e,13
	ld	d,21
	ld	(cocursor),de
	ld	hl,(puntos)
	call	escindigi
	ld	e,9
	ld	d,22
	ld	(cocursor),de
	ld	a,(vidas)
	call	esundigito


	ld	e,15
	ld	d,23
	ld	(cocursor),de
	ld	a,(columsupe)
	call	estredigi

	ret




  
esundigito
	and	15
	add	a,"0"
	jp	piunchar

esdosdigi	push	af
	call	caldiple
	pop	af
	ld	l,a
	ld	h,0
	ld	b,2
	jp	enedigito

estredigi	push	af
	call	caldiple
	pop	af
	ld	l,a
	ld	h,0
	ld	b,3
	jp	enedigito

escindigi
	push	hl
	call	caldiple
	pop	hl
	ld	b,5
enedigito	dec	b
	push	hl
	ld	e,b
	sla	e
	ld	d,0
	ld	hl,tabladeci
	sbc	hl,de
	ex	de,hl
	pop	hl
ndg1	push	bc
	push	de
	ld	a,(de)
	ld	c,a
	inc	de
	ld	a,(de)
	ld	b,a
	ld	a,-1
ndg2	inc	a
	sbc	hl,bc
	jr	nc,ndg2
	add	hl,bc
	add	a,"0"
	push	hl
	call	pichar
	pop	hl
	pop	de
	inc	de
	inc	de
	pop	bc
	djnz	ndg1
	ld	a,l
	add	a,"0"
	jp	pichar

	defw 10000,1000,100,10
tabladeci	


escrilista
	ld	a,0
	ld	(colorletra),a
scrlst0
	ld	(dirtexto),hl
scrlst1	ld	hl,(dirtexto)
	ld	a,(hl)
	and	a
	ret	z
	call	esunchar
	jr	scrlst1

esunchar
	ld	(char),a
	ld	hl,(dirtexto)
	inc	hl
	ld	(dirtexto),hl
	cp	32
	jp	nc,piunchar	;no es de control
	cp	8	;*BS  retrocede una posicion el cursor
	jp	z,snchr1
	cp	9	;*TAB avanza el cursor una posicion
	jp	z,snchr2
	cp	10	;*LF  hace bajar el cursor una linea
	jp	z,snchr3
	cp	11	;*VT  hace subir el cursor una linea
	jp	z,snchr4
	cp	13	;*CR  lleva el cursor al ext izdo de la linea
	jp	z,snchr5
	cp	30	; RS  lleva el cursor al ext sup izdo
	jp	z,snchr6
	cp	22	; US  equivale a AT lin,col
	jp	z,snchr7
	cp	16	; INK color
	jp	z,snchr8

	ret


snchr1	ld	a,(cocursor)	;retrocede el cursor una columna
	dec	a
	and	31
	ld	(cocursor),a
	ld	hl,(diple)
	dec	hl
	dec	hl
	ld	(diple),hl
	cp	31
	ret	nz
	ld	a,(licursor)
	dec	a
	ld	(licursor),a
	ret	nc
	ld	a,23
	ld	(licursor),a
	ld	hl,#c000+1598
	ld	(diple),hl
	ret

snchr2	ld	a,(cocursor)
	inc	a
	and	31
	ld	(cocursor),a
	ld	hl,(diple)
	inc	hl
	inc	hl
	ld	(diple),hl
	ret	nz
	ld	a,(licursor)
	inc	a
	ld	(licursor),a
	cp	24
	ret	c
	xor	a
	ld	(licursor),a
	ld	hl,#c000
	ld	(diple),hl
	ret

snchr3	ld	a,(licursor)
	dec	a
	ld	(licursor),a
	jp	nc,caldiple
	ld	a,23
	ld	(licursor),a
	jp	caldiple

snchr4	ld	a,(licursor)
	inc	a
	ld	(licursor),a
	cp	24
	jp	c,caldiple
	xor	a
	ld	(licursor),a
	jp	caldiple

snchr5	xor	a
	ld	(cocursor),a
	jp	caldiple

snchr6	ld	hl,0
	ld	(cocursor),hl
	ld	hl,#c000
	ld	(diple),hl
	ret

snchr7	ld	d,(hl)
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	(dirtexto),hl
	ld	(cocursor),de
	jp	caldiple

snchr8	ld	a,(hl)
	inc	hl
	ld	(dirtexto),hl
	ld	(colorletra),a
	ret


piunchar
	push	af
	call	caldiple
	pop	af
pichar	
	ld	de,(diple)
	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	bc,caracteres-512
	add	hl,bc

picha	ld	a,(colorletra)
	and	a
	jp	nz,picharcolo

	ldi
	ldi
	dec	de
	dec	de
	set	3,d	;pasa a C8
	ldi
	ldi
	dec	de
	dec	de
	res	3,d
	set	4,d	;pasa a D0
	ldi
	ldi
	dec	de
	dec	de
	set	3,d	;pasa a D8
	ldi
	ldi
	dec	de
	dec	de
	res	3,d
	res	4,d
	set	5,d	;pasa a E0
	ldi
	ldi
	dec	de
	dec	de
	set	3,d	;pasa a E8
	ldi
	ldi
	dec	de
	dec	de
	res	3,d
	set	4,d	;pasa a F0
	ldi
	ldi
	dec	de
	dec	de
	set	3,d	;pasa a F8 ( 1111111000b )
	ldi
	ldi
	ld	a,#c8	;( 11001000b )  2do scan
	add	a,d
	ld	d,a
pchr1	ld	(diple),de
	ld	a,(cocursor)
	inc	a
	and	31
	ld	(cocursor),a
	ret	nz
	ld	a,(licursor)
	inc	a
	ld	(licursor),a	
	ld	bc,#c000+1599	;primera direccion no permitida
	sbc	hl,bc
	ret	c
	ld	hl,#c000
	ld	(diple),hl
	xor	a
	ld	(licursor),a
	ret
picharcolo
	ld	a,(colorletra)
	ld	c,a
	ld	b,0
	push	hl
	ld	hl,tablacole
	add	hl,bc
	ld	c,(hl)
	pop	hl
	push	de
	ld	b,8
pchrcl1	ld	a,(hl)
	or	c
	ld	(de),a
	inc	de
	inc	hl
	ld	a,(hl)
	or	c
	ld	(de),a
	inc	hl
	dec	de
	ld	a,d
	add	a,8
	ld	d,a
	djnz	pchrcl1
	pop	de
	inc	de
	inc	de
	jp	pchr1


caldiple
	ld	de,(cocursor)
	ld	hl,#c000
	xor	a
	cp	d
	jr	z,caldipl2
	ld	b,d
caldipl1	push	bc
	ld	bc,#40
	add	hl,bc
	pop	bc
	djnz	caldipl1
caldipl2	ld	a,e
	add	a,a
	ld	d,0
	ld	e,a
	add	hl,de
	ld	(diple),hl
	ret



borrapanta
	ld	hl,#c000
	ld	b,8
brrpnt1	push	bc
	push	hl
	push	hl
	pop	de
	inc	de
	ld	(hl),#ff
	ld	bc,2048
	ldir
	pop	hl
	ld	bc,2048
	add	hl,bc
	pop	bc
	djnz	brrpnt1
	ret

vidas	defb	3
energia	defb	22
puntos	defw	00


decofin		defb	0
char		defb	32
cocursor	defb	0
licursor	defb	0
diple		defw	#c000
dirtexto	defw	0


CAMBIOCOLU	DEFB	0
colorletra	defb	0

tablacole	defb	0,192,12,204,48,240,60,252,3,195,15,207,51,243,63,255,255






	;****************************************
	;* CAFIAC  calcula el fin de una accion *
	;*         cambia las fases de los spri.*
	;****************************************
	
cafiac	
	ld	ix,tprota
	ld	b,11
cafia0	push	bc
	call	unfiac
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	cafia0
	ret
	
unfiac
	bit	1,(ix+5)	; se mueve el mu|eco ?
	ret	z	; suma 16 a ix - sig. sprite
	ld	l,(ix+2)	; tipo de bicho
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,tabtip	; tabla de posturas segun tipo
	add	hl,de
	ld	e,(ix+3)	; estado
	sla	e
	ld	d,0
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ld	(dicoes),de	; direccion de comienzo estado
	ld	a,(ix+4)	; fase
	inc	a
	and	%111
cafia3	ld	(ix+4),a
	ld	c,a
	ld	b,0
	ld	hl,(dicoes)
	add	hl,bc
	ld	a,(hl)
	and	a
	ld	a,0
	jp	m,cafia3
	ret	; suma a ix 16
	
caesta
	bit	1,(ix+5)	; se mueve el mu|eco ?
	ret	nz	; suma 16 a ix - sig. sprite
	ld	l,(ix+2)	; tipo de bicho
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,tabtip	; tabla de posturas segun tipo
	add	hl,de
	ld	e,(ix+3)	; estado
	sla	e
	ld	d,0
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ld	(dicoes),de	; direccion de comienzo estado
	ld	a,(ix+4)	; fase
cst3	ld	(ix+4),a
	ld	c,a
	ld	b,0
	ld	hl,(dicoes)
	add	hl,bc
	ld	a,(hl)
	and	a
	ld	a,0
	jp	m,cst3
	ret	; suma a ix 16

	;**************************************************************
	;* PONE LOS BICHOS COMO SPRITES EN EL MAPA DE CHRS ************
	;**************************************************************
	
pospbu	ld	ix,tprota
	ld	b,11
pospb0	push	bc
	call	pospb1
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	pospb0
	ret

pospb1	bit	6,(ix+5)	; esta activado ?
	ret	z
	ld	l,(ix+2)	;tipo de bicho
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,tabtip	;tabla de dir. de posturas segun tipo
	add	hl,de
	ld	e,(ix+3)	;estado
	sla	e
	ld	d,0
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl	;hl=dir comienzo tabla fases de estado
	ld	c,(ix+4)	;fase de estado
	ld	b,0
	add	hl,bc
	ld	a,(hl)	;no. sprite fisico f(tipo,estado,fase)
;	ld	(ix+8),a	;SF
	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	ld	de,taspfi	;comienzo tabla de sprites fisicos
	add	hl,de
	;ld (dispri),hl
	ex	de,hl
	push	ix
	pop	hl
	ld	bc,6
	add	hl,bc
	ex	de,hl
	ld	bc,4
	ldir		;pasa info de SF a IX+9
	ld	a,(vimesp)
	cp	1
	ret	z

pospb7
	ld	hl,virtual+10240-64
	ld	b,(ix+1)	; coor y
	ld	a,(ix+8)	; scanes
	srl	a
	srl	a
	srl	a
	add	b
	ld	b,a
pospb8	ld	de,512	; resta 512
	or	a
	sbc	hl,de
	djnz	pospb8

	ld	e,(ix+0)	; coor x
	sla	e	; quitar en spectrum
	ld	d,0
	add	hl,de

	ld	(ix+10),l	; dir panta
	ld	(ix+11),h


	ld	hl,mapafino+608	; 640-32
	ld	a,(ix+8)	; scanes
	srl	a
	srl	a
	srl	a
	add	a,(ix+1)	; coor y
;	inc	a
	ld	b,a
pospb4	ld	de,32
	or	a
	sbc	hl,de
	djnz	pospb4
	ld	e,(ix+0)	; coor x
	ld	d,0
;	dec	de
	add	hl,de	; dir a pokear

	ld	a,(ix+8)	; scanes
	srl	a
	srl	a
	srl	a
	inc	a
	inc	a
	ld	b,a	; filas
	ld	a,(ix+9)	; dim x
	srl	a
	inc	a
pospb5	push	bc
	push	hl
	ld	b,a	; columnas
pospb6	set	0,(hl)	; a pintar
	set	1,(hl)	; es un sp
	inc	hl
	djnz	pospb6
	pop	hl
	ld	bc,32
	add	hl,bc
	pop	bc
	djnz	pospb5
	bit	7,(ix+5)	; hay que desactivarlo ?
	ret	z
	xor	a
	ld	(ix+5),a	; desactivo el sprite y flags
	ret


	;**************************************************************
	;* PINTA LOS SPRITES ACTIVADOS EN LA PANTALLA VIRTUAL *********
	;**************************************************************
	
pispvi	ld	ix,tprota
	ld	b,11
pispv0	push	bc
	call	pispv2
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	pispv0
	ret


pispv2
	bit	6,(ix+5)	; esta activado ?
	ret	z
	;ahora gira el sprite y lo guarda en BUFSPR
	ld	e,(ix+6)
	ld	d,(ix+7)	;direccion del SF
	ld	c,(ix+9)	;bytes de ancho SF
	ld	hl,bufspr
	ld	b,0
	dec	c
	add	hl,bc
	inc	c
	ld	b,(ix+8)	;scanes de alto SF
smsp1	push	bc
	ld	b,c
smsp2	ld	a,(de)
	sla	a
	and	%10101010
	ld	(hl),a
	ex	af,af'
	ld	a,(de)
	srl	a
	and	%01010101
	or	(hl)
	ld	(hl),a
	inc	de
	dec	hl
	djnz	smsp2
	sla	c
	add	hl,bc
	pop	bc
	djnz	smsp1
	
	bit	0,(ix+5)	;lado
	jr	z,pispv1	;si z va a la dcha
	ld	hl,bufspr
	ld	(ix+6),l
	ld	(ix+7),h	;direccion SPRITE
	;dirvir=panvir+scanvir*64+x-colum

pispv1	ld	h,(ix+11)
	ld	l,(ix+10)	; dir en virtual

	;ahora pinta el sprite a partir de DIRVIR
	ld	e,(ix+6)
	ld	d,(ix+7)	;dir SF
	ld	b,(ix+8)	;scanes
	ld	c,(ix+9)	;bytes ancho
pspv2	push	bc
	ld	b,c
pspv3	push	bc

	ld	a,(de)
	and	%01010101
	ld	c,a
	jr	nz,pspv7
	ld	a,(hl)
	and	%01010101
	ld	c,a
pspv7	ld	a,(de)
	and	%10101010
	jr	nz,pspv8
	ld	a,(hl)
	and	%10101010
pspv8	or	c
	ld	(hl),a

pspv5	inc	hl
	inc	de
	pop	bc
	djnz	pspv3	;siguiente byte
	ld	a,64
	sub	c	;ancho en bytes
	ld	c,a
	;b=0 ya que es fin de djnz
	add	hl,bc
	pop	bc
	djnz	pspv2	;siguiente scan

	ret


;	*********************************************
;	*	CREAVI crea virtual segun (mapafino)	*
;	*********************************************


creavi	call	pospbu

	ld	ix,buffcar
	ld	iy,mapafino
	ld	de,virtual
	ld	b,20	; numero de filas
creav0	ld	c,32	; OJO varia segun par-impar
creav1	push	bc
	ld	a,c
	push	de
creav2	bit	1,(iy+0)	; miro si es un sp
	jr	nz,creav5	; es un sprite
	bit	0,(iy+0)	; miro si hay que pintarlo
	jr	z,creav4
	res	0,(iy+0)
creav6	ld	l,(ix+0)
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	bc,grafdeco	; dir banco de caracteres
	add	hl,bc	; dir del caracter

	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	set	7,e
	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	res	7,e
	set	0,d
	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	set	7,e
	ldi
	ldi
	dec	de
	dec	de
	set	6,e
	ldi
	ldi
	dec	de
	dec	de
	res	6,e
	res	7,e
	res	0,d


creav4	inc	ix
	inc	iy
	inc	de
	inc	de
	dec	a
	jr	nz,creav2
	pop	de
	inc	d
	inc	d
	pop	bc
	djnz	creav1
	ret

creav5	res	1,(iy+0)	; quito sp y pinto
	jr	creav6


mapafino	defs	32*20,0
buffdur	defs	32*20,0
bufspr	defs	32*20,0

dicoes	defw	0


antcoorx	defb	0
antcoory	defb	0



; 0 1   2    3     4    5    6 7     8     9    10 11   12   13   14

; x y tipo estado fase bits dir-sp scanes dimx dirpanta arma vida vel



tprota	defb	4,3,0,0,0,64,0,0,0,0,0,0,0,0,0,0

tenemi	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

tbalas	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	defb	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0



tabtip	defw	proanda,prosalta,proagacha,promuer


	defw	piean,piean,piean,explota
	defw	narizan,narizan,narizan,explota
	defw	ancien,ancien,ancien,explota
	defw	roboan,roboan,roboan,explota
	defw	abevue,abevue,abevue,explota
	defw	robovu,robovu,robovu,explota
	defw	navue,navue,navue,explota
	defw	gusan,gusan,gusan,explota
	defw	rasube,rabaja,rabaja,explota
	defw	birueda,bilargo,birueda,explota

	defw	dispro,dispro,dispro,dispro

	; a partir de aqui son los del 2 juego

	defw	provue,provue,provue,provue
	defw	mar1an,mar1an,mar1an,explota
	defw	mar2an,mar2an,mar2an,explota
	defw	mar3an,mar3an,mar3an,explota
	defw	mar4an,mar4an,mar4an,explota
	defw	mar5an,mar5an,mar5an,explota
	defw	nacart,nacart,nacart,nacart	



proanda		defb	0,0,1,1,2,2,1,1
prosalta	defb	3,3,3,3,3,3,3,3
proagacha	defb	4,4,4,4,4,4,4,4
promuer		defb	5,6,5,6,5,6,5,6

piean	defb	7,7,8,8,9,9,8,8
narizan	defb	10,10,11,11,12,12,11,11
ancien	defb	13,13,14,14,15,15,14,14
roboan	defb	16,16,17,17,18,18,17,17
abevue	defb	19,20,19,20,19,20,19,20
robovu	defb	21,22,21,22,21,22,21,22
navue	defb	23,23,23,23,-1,-1,-1,-1
gusan	defb	24,25,24,25,24,25,24,25
rasube	defb	26,26,26,26,-1,-1,-1,-1
rabaja	defb	27,27,27,27,-1,-1,-1,-1
birueda	defb	28,29,30,29,-1,-1,-1,-1
bilargo	defb	31,32,31,32,-1,-1,-1,-1

explota	defb	33,34,33,34,-1,-1,-1,-1
dispro	defb	35,35,35,35,35,35,35,35

provue	defb	36,36,36,36,36,36,36,36
mar1an	defb	37,38,37,38,-1,-1,-1,-1
mar2an	defb	39,40,39,40,-1,-1,-1,-1
mar3an	defb	41,42,41,42,-1,-1,-1,-1
mar4an	defb	43,44,43,44,-1,-1,-1,-1
mar5an	defb	45,46,45,46,-1,-1,-1,-1
nacart	defb	47,47,47,47,-1,-1,-1,-1

taspfi	; SPRITES DEL PROTA

	defw	spprota1
	defb	36,6

	defw	spprota2
	defb	36,6

	defw	spprota3
	defb	34,6

	defw	spprosal
	defb	36,6

	defw	spprorodi
	defb	28,6

	defw	sppromuer
	defb	36,6

	defw	spprovacio
	defb	36,6


	; SPRITES ROCA

	defw	roca1
	defb	26,8

	defw	roca2
	defb	35,8

	defw	roca3
	defb	43,8

	; SPRITES DEL NARICES

	defw	nariz1
	defb	35,11

	defw	nariz2
	defb	35,11

	defw	nariz3
	defb	35,11

	; SPRITES DEL CIEMPIES

	defw	ciempie1
	defb	18,16

	defw	ciempie2
	defb	18,16

	defw	ciempie3
	defb	18,16

	; SPRITES DE ROBOT

	defw	robot1
	defb	33,10

	defw	robot2
	defb	34,9

	defw	robot3
	defb	34,10

	; SPRITES ABEJA

	defw	abeja1
	defb	24,10

	defw	abeja2
	defb	19,10

	; SPRITES ROBOT VOLADOR

	defw	rovola1
	defb	36,6

	defw	rovola2
	defb	36,6

	; SPRITE DE LA NAVE

	defw	nave1
	defb	28,8

	; SPRITE DEL GUSANO

	defw	gusano1
	defb	15,11

	defw	gusano2
	defb	15,11

	; SPRITE RANA SUBE-BAJA

	defw	ranasu
	defb	36,6

	defw	ranaba
	defb	30,6

	; SPRITE RUEDA

	defw	rued1
	defb	22,6

	defw	rued2
	defb	22,6

	defw	rued3
	defb	22,6

	defw	larg1
	defb	11,14

	defw	larg2
	defb	11,13

	; SPRITE DE EXPLOSION

	defw	spexplo1
	defb	23,7
	
	defw	spexplo2
	defb	13,4

	; SPRITE BALA 1

	defw	spbala1
	defb	8,3

; aqui sp del 2 game

	; SPRITE NAVE PROTA

	defw	navepro
	defb	16,10


	; SPRITE MARCIANO1

	defw	mar1ac1
	defb	23,7

	defw	mar1ac2
	defb	15,7

	; SPRITE MARCIANO2

	defw	mar2ac1
	defb	15,12

	defw	mar2ac2
	defb	17,11

	; SPRITE MARCIANO3

	defw	mar3ac1
	defb	19,5

	defw	mar3ac2
	defb	19,5

	; SPRITE MARCIANO4

	defw	mar4ac1
	defb	11,10

	defw	mar4ac2
	defb	11,10

	; SPRITE MARCIANO5

	defw	mar5ac1
	defb	18,8

	defw	mar5ac2
	defb	18,8

	; SPRITE DEL CARTEL

	defw	cartel
	defb	32,20


	; TAENEMI TABLA DE ENEMIGOS

;    0      1   2     3    4     5     6   7

; COLUMNA   Y  TIPO  VIDA  VEL  BITS

;	!!! ATENCION !!!

;	! NO MAS DE DOS SPRITES POR COLUMNA !


taenemi	defb	000,03,4,0,1,0,0,0
	defb	001,03,2,0,2,0,0,0
	defb	002,03,1,0,1,0,0,0
	defb	004,10,6,0,2,0,0,0
	defb	005,12,5,0,1,0,0,0
	defb	008,14,5,0,1,0,0,0
	defb	010,12,6,0,1,0,0,0
	defb	012,12,9,0,1,0,0,0
	defb	016,12,7,0,1,0,0,0
	defb	019,10,6,0,1,0,0,0
	defb	022,06,5,0,1,0,0,0
	defb	024,12,7,0,2,0,0,0
	defb	024,03,3,0,1,0,0,0	
	defb	027,03,4,0,1,0,0,0
	defb	027,12,9,0,1,0,0,0
	defb	028,06,5,0,1,0,0,0
	defb	029,03,10,0,1,0,0,0
	defb	031,03,1,0,1,0,0,0
	defb	034,08,6,0,1,0,0,0
	defb	036,10,5,0,1,0,0,0
	defb	037,12,9,0,1,0,0,0
	defb	038,06,7,0,2,0,0,0
	defb	040,03,3,0,1,0,0,0
	defb	043,12,7,0,2,0,0,0
	defb	045,09,5,0,1,0,0,0
	defb	046,03,1,0,1,0,0,0
	defb	048,15,6,0,1,0,0,0
	defb	048,10,7,0,2,0,0,0
	defb	050,07,5,0,1,0,0,0
	defb	052,12,9,0,1,0,0,0
	defb	054,05,7,0,1,0,0,0
	defb	056,10,6,0,1,0,0,0
	defb	060,07,5,0,1,0,0,0
	defb	061,03,1,0,1,0,0,0
	defb	062,03,2,0,2,0,0,0
	defb	063,03,3,0,1,0,0,0
	defb	065,11,6,0,1,0,0,0
	defb	067,12,7,0,1,0,0,0
	defb	070,07,5,0,1,0,0,0
	defb	075,10,6,0,1,0,0,0
	defb	077,07,7,0,1,0,0,0
	defb	082,03,4,0,1,0,0,0
	defb	086,03,1,0,1,0,0,0
	defb	088,03,2,0,2,0,0,0
	defb	089,03,3,0,1,0,0,0

	defb	090,10,5,0,1,0,0,0	; 35
	defb	091,03,2,0,1,0,0,0
	defb	093,03,1,0,1,0,0,0
	defb	094,12,9,0,1,0,0,0
	defb	098,10,7,0,1,0,0,0
	defb	100,14,5,0,2,0,0,0
	defb	102,04,8,0,1,0,0,0
	defb	104,12,9,0,1,0,0,0
  	defb	106,10,6,0,1,0,0,0
	defb	108,04,10,0,1,0,0,0
	defb	111,10,5,0,1,0,0,0
	defb	113,04,8,0,2,0,0,0
	defb	116,12,6,0,1,0,0,0
	defb	120,04,8,0,2,0,0,0
	defb	123,06,6,0,1,0,0,0
	defb	126,12,7,0,2,0,0,0
	defb	130,10,5,0,1,0,0,0
	defb	132,14,6,0,1,0,0,0
	defb	134,12,7,0,1,0,0,0
	defb	138,07,5,0,1,0,0,0
	defb	141,03,4,0,1,0,0,0
	defb	144,06,6,0,1,0,0,0
	defb	148,12,7,0,1,0,0,0
	defb	151,12,5,0,1,0,0,0
	defb	151,16,5,0,1,0,0,0


caracteres		;banco de 64 caracteres= 1024 bytes


	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#D5,#FF,#5D,#FF,#5D,#FF,#5D,#FF,#FF,#FF,#5F,#FF,#FF
	defb #FF,#FF,#FF,#FF,#AE,#AE,#0C,#0C,#AF,#AF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #BA,#30,#BA,#30,#BA,#30,#BA,#30,#BA,#30,#BA,#30,#BA,#30,#FE,#FC
	defb #AF,#0F,#AF,#0F,#AF,#0F,#AF,#0F,#AF,#0F,#AF,#0F,#AF,#0F,#FE,#FC
	defb #EE,#CD,#AF,#EF,#AF,#EE,#EE,#CC,#FF,#DD,#EE,#94,#EA,#D5,#EE,#C4
	defb #5F,#FF,#DD,#FF,#CC,#FF,#4E,#DD,#CC,#DD,#EE,#DD,#FF,#CC,#C4,#EE
	defb #EA,#C0,#EE,#C0,#FF,#C8,#FF,#C8,#FF,#EA,#FF,#EE,#FF,#FF,#FF,#FF
	defb #C0,#EE,#C8,#DD,#CC,#DD,#D5,#DD,#FF,#D5,#C0,#D5,#C4,#D5,#EA,#FF
	defb #FF,#FF,#FF,#AF,#FF,#EE,#FF,#CC,#FF,#8D,#EE,#8D,#EE,#4F,#EE,#CC
	defb #1E,#CC,#9C,#AF,#CC,#AF,#4E,#CC,#DD,#DF,#CA,#CF,#C0,#C5,#9C,#C0
	defb #EE,#EA,#FF,#C8,#FF,#C8,#FF,#CC,#FF,#EA,#FF,#DD,#FF,#C4,#FF,#C8
	defb #DD,#C4,#C0,#C0,#C8,#C4,#C0,#D5,#EA,#D5,#C0,#FF,#C0,#FF,#C4,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#AE,#0C,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#5D,#FF,#5F,#FF,#FF,#FF,#FF
	defb #FF,#D5,#FF,#D5,#AE,#D5,#AE,#FF,#0E,#FF,#5F,#FF,#5F,#FF,#5F,#FF
	defb #F3,#B7,#F3,#B7,#1D,#1D,#1D,#1D,#1D,#1D,#1F,#1F,#0F,#1F,#0F,#1F
	defb #7B,#B7,#F3,#B7,#2E,#1D,#2E,#1D,#2E,#1D,#2F,#1F,#2F,#1F,#2F,#1F
	defb #F3,#B7,#F3,#B7,#3F,#1D,#0C,#1D,#1D,#3F,#0F,#1F,#0F,#1F,#0F,#1F
	defb #F3,#B7,#F3,#B7,#3F,#1D,#2E,#1D,#3F,#1D,#0F,#1F,#0F,#1F,#0F,#1F
	defb #B7,#3F,#B7,#B7,#1D,#1D,#0C,#1D,#0C,#1D,#2F,#1F,#2F,#1F,#2F,#1F
	defb #F3,#B7,#F3,#B7,#1D,#3F,#0C,#1D,#3F,#1D,#0F,#1F,#0F,#1F,#0F,#1F
	defb #F3,#3F,#F3,#3F,#1D,#3F,#0C,#1D,#1D,#1D,#1F,#1F,#0F,#1F,#0F,#1F
	defb #F3,#B7,#F3,#B7,#3F,#1D,#3F,#1D,#3F,#1D,#3F,#1F,#3F,#1F,#3F,#1F
	defb #F3,#B7,#F3,#B7,#1D,#1D,#0C,#1D,#0C,#1D,#1F,#1F,#0F,#1F,#0F,#1F
	defb #F3,#B7,#F3,#B7,#1D,#1D,#0C,#1D,#0C,#1D,#3F,#1F,#0F,#1F,#0F,#1F
	defb #FF,#FF,#FF,#FF,#FF,#5D,#FF,#5D,#FF,#FF,#FF,#5F,#FF,#5F,#FF,#FF
	defb #75,#FF,#30,#FF,#30,#30,#B0,#30,#30,#F0,#F0,#FF,#F5,#FF,#FF,#FF
	defb #FF,#FF,#BA,#75,#30,#30,#70,#B0,#F0,#F0,#FA,#F5,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#C3,#C3,#C3,#03,#EB,#03,#EB,#57,#EB,#57,#EB,#57
	defb #FF,#FF,#FF,#FF,#D7,#FF,#83,#FF,#83,#FF,#83,#FF,#83,#FF,#83,#FF
	defb #EB,#57,#EB,#57,#EB,#57,#EB,#03,#EB,#03,#C3,#C3,#FF,#FF,#FF,#FF
	defb #83,#FF,#83,#FF,#83,#FF,#83,#FF,#83,#57,#C3,#57,#FF,#FF,#FF,#FF
	defb #C0,#D5,#C0,#D5,#5D,#5D,#5D,#5D,#0C,#5D,#5F,#5F,#5F,#5F,#5F,#5F
	defb #C0,#FF,#C0,#D5,#5D,#5D,#5D,#5D,#0C,#FF,#5F,#5F,#5F,#5F,#0F,#FF
	defb #C0,#D5,#C0,#D5,#5D,#FF,#5D,#FF,#5D,#FF,#5F,#FF,#0F,#5F,#0F,#5F
	defb #C0,#FF,#C0,#D5,#5D,#5D,#5D,#5D,#5D,#5D,#5F,#5F,#0F,#5F,#0F,#FF
	defb #C0,#D5,#D5,#FF,#5D,#FF,#0C,#FF,#0C,#FF,#5F,#FF,#0F,#5F,#0F,#5F
	defb #C0,#D5,#D5,#FF,#5D,#FF,#0C,#FF,#0C,#FF,#5F,#FF,#5F,#FF,#5F,#FF
	defb #C0,#FF,#C0,#FF,#5D,#FF,#5D,#FF,#5D,#5D,#5F,#5F,#5F,#5F,#0F,#5F
	defb #D5,#D5,#D5,#D5,#5D,#5D,#0C,#5D,#5D,#5D,#5F,#5F,#5F,#5F,#5F,#5F
	defb #EA,#D5,#FF,#FF,#AE,#5D,#AE,#5D,#AE,#5D,#AF,#5F,#AF,#5F,#AF,#5F
	defb #EA,#D5,#EA,#D5,#FF,#5D,#FF,#5D,#FF,#5D,#5F,#5F,#0F,#5F,#AF,#5F
	defb #D5,#D5,#D5,#D5,#0C,#FF,#0C,#FF,#0C,#FF,#0F,#FF,#5F,#5F,#5F,#5F
	defb #D5,#FF,#D5,#FF,#5D,#FF,#5D,#FF,#5D,#FF,#0F,#5F,#0F,#5F,#0F,#5F
	defb #D5,#D5,#C0,#D5,#0C,#5D,#0C,#5D,#5D,#5D,#5F,#5F,#5F,#5F,#5F,#5F
	defb #C0,#D5,#D5,#D5,#5D,#5D,#5D,#5D,#5D,#5D,#5F,#5F,#5F,#5F,#5F,#5F
	defb #C0,#D5,#D5,#D5,#5D,#5D,#5D,#5D,#5D,#5D,#5F,#5F,#5F,#5F,#0F,#5F
	defb #C0,#FF,#D5,#D5,#5D,#5D,#5D,#5D,#0C,#FF,#5F,#FF,#5F,#FF,#5F,#FF
	defb #C0,#D5,#D5,#D5,#5D,#5D,#5D,#5D,#0C,#5D,#0F,#5F,#5F,#5F,#0F,#5F
	defb #C0,#FF,#D5,#D5,#5D,#5D,#5D,#5D,#0C,#5D,#0F,#FF,#5F,#5F,#5F,#5F
	defb #EA,#D5,#C0,#D5,#5D,#FF,#0C,#FF,#AE,#5F,#FF,#5F,#0F,#5F,#0F,#FF
	defb #C0,#D5,#C0,#D5,#AE,#FF,#AE,#FF,#AE,#FF,#AF,#FF,#AF,#FF,#AF,#FF
	defb #D5,#D5,#D5,#D5,#5D,#5D,#5D,#5D,#5D,#5D,#5F,#5F,#0F,#5F,#0F,#5F
	defb #FF,#D5,#D5,#D5,#5D,#5D,#5D,#5D,#5D,#5D,#5F,#5F,#0F,#5F,#AF,#FF
	defb #D5,#D5,#D5,#D5,#0C,#5D,#0C,#5D,#0C,#5D,#0F,#5F,#0F,#5F,#AF,#FF
	defb #D5,#D5,#D5,#D5,#0C,#5D,#AE,#FF,#0C,#5D,#5F,#5F,#5F,#5F,#5F,#5F
	defb #D5,#D5,#D5,#D5,#5D,#5D,#0C,#5D,#AE,#FF,#AF,#FF,#AF,#FF,#0F,#5F
	defb #C0,#D5,#C0,#D5,#FF,#5D,#AE,#FF,#5D,#FF,#0F,#5F,#0F,#5F,#0F,#5F
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00





;	*****************************************
;	*	SEGUNDO JUEGO. MATAR NAVECITAS    *
;	*	SE JUGARA ENTRE FASE Y FASE       *
;	*****************************************


ini2game

	call	borrabuf	; pone a 1 todo el buffer
	call	borradur	; pone a 0 las durezas
	call	desacene	; desactiva los enemigos anteriores
	call	cambiprota	; cambia el tipo de bicho al prota
	call	borravir
 	call	rellemapa
	call	pinvirtu
	call	papavi


main2game
	call	mapkey
	call	leeteclado


	ld	a,(keys)
	bit	7,a
	jr	nz,vuel1game
	bit	6,a
	call	nz,pausa

	ld	a,(fingame2)
	cp	1
	jr	z,vuel1game

	call	muevnave	; mueve la nave
;	call	gravedad
;	call	dureprota	; mira durezas del prota

	call	muevebala

	call	mete2ene	; mira si entran enemigos
	call	muevenemi	; mueve enemigos

	call	michopro	; mira choques con prota
	call	michobalas	; mira choques con balas
	call	muerenemi	; mira si mueren enemigos

	call	contadores
	call	cafiac
	call	creavi
	call	papavi
	jr	main2game

vuel1game
	call	cambiprota
	call	creabufcar
	call	creabufdur
	call	borravir
	call	pinvirtu
	call	papavi
	ld	a,181
	ld	(mira2gam1+1),a
;	ret

	call	desacene

	ld	hl,tprota+1	; coor y
	ld	(hl),3
	dec	hl
	ld	(hl),8	; coor x
	ld	hl,tprota+5
	res	6,(hl)	; desact.


	ld	ix,tenemi
	ld	(ix+5),#40
	ld	(ix+1),16
	ld	(ix+0),6
	ld	(ix+2),12	; es. nave
	push	ix
	call	pinvirtu
	call	papavi
	pop	ix
	

andanave	ld	a,3
	cp	(ix+1)
	jr	z,sefuenave
	dec	(ix+1)
	push	ix
	call	retardo
	call	creavi
	call	papavi
	call	retardo
	pop	ix
	jr	andanave

sefuenave	ld	hl,tprota+5
	set	6,(hl)	; act. prota
sefuenav1	ld	a,16
	cp	(ix+1)
	jr	z,va1game
	inc	(ix+1)
	push	ix
	call	retardo
	call	creavi
	call	papavi
	call	retardo
	pop	ix
	jr	sefuenav1
va1game
	res	6,(ix+5)	; desac. nave
	ld	hl,tprota+5
	set	6,(hl)
	ret


;*****************************************
;*	MUEVE LA NAVE		 *
;*****************************************

muevnave	ld	ix,tprota
	
	set	1,(ix+5)	; se mueve
	res	0,(ix+5)	; siempre derecha
	ld	(ix+3),0	; estado andando

	ld	de,(keys)
	bit	0,e
	jr	nz,arrinave
	bit	1,e
	jr	nz,abanave
	bit	2,e
	jr	nz,izquinave
	bit	3,e
	jr	nz,derenave
	bit	4,e
	jp	nz,fue2game
	call	caesta
	res	1,(ix+5)	; no se mueve
	ret



arrinave	ld	a,(keys)
	bit	4,a
	push	af
	call	nz,fue2game
	pop	af
	push	af
	bit	2,a
	call	nz,izquina
	pop	af
	bit	3,a
	call	nz,derena

	ld	a,15
	cp	(ix+1)	; coor y
	ret	z
	inc	(ix+1)
	ret

abanave
	ld	a,(keys)
	bit	4,a
	push	af
	call	nz,fue2game
	pop	af
	push	af
	bit	2,a
	call	nz,izquina
	pop	af
	bit	3,a
	call	nz,derena

	ld	a,3
	cp	(ix+1)
	ret	z
	dec	(ix+1)
	ret


izquinave
	ld	a,(keys)
	bit	4,a
	call	nz,fue2game
izquina	ld	a,0
	cp	(ix+0)
	ret	z
	dec	(ix+0)
	ret

derenave
	ld	a,(keys)
	bit	4,a
	call	nz,fue2game
derena	ld	a,20
	cp	(ix+0)
	ret	z
	inc	(ix+0)
	ret

fue2game	push	ix
	call	metebala
	dec	(ix+1)	; coor y
	dec	(ix+1)
	inc	(ix+0)	; coor x
	inc	(ix+0)
	pop	ix
	ret

mete2ene
	call	miraenemi	; mira si hay sitio

	ld	a,(posptabla)
	bit	7,a
	ret	z
	res	7,a
	ld	(posptabla),a

	ld	a,(numapasp)
	inc	a
	ld	(numapasp),a
	cp	70
	jr	z,fin2game
	ld	l,a
	ld	h,0
	ld	de,tapabi
	add	hl,de	; dir de el numero del bicho
	ex	de,hl
	ld	a,(de)
	ld	l,a
	ld	h,0
	xor	a
	cp	l
	ret	z	; no hay sp
	dec	l
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	de,tdisp
	add	hl,de	; dir de la info
	call	metespri
	ret

numapasp	defb	0
fingame2	defb	0

fin2game	ld	a,1
	ld	(fingame2),a
	ret


borrabuf	ld	hl,buffcar
	ld	de,buffcar+1
	ld	bc,32*20-1
	ld	(hl),1	; caracter negro
	ldir
	ret

borradur	ld	hl,buffdur
	ld	de,buffdur+1
	ld	bc,32*20-1
	ld	(hl),0	; nada durezas
	ldir
	ret

desacene	ld	ix,tenemi	; borra enemigos y balas
	ld	b,numene
desacen1	push	bc
	res	6,(ix+5)	; lo desactivo
	ld	bc,16
	add	ix,bc
	pop	bc
	djnz	desacen1
	ret


cambiprota	ld	ix,tprota
	xor	a
	cp	(ix+2)	; tipo
	jr	z,cambiprot1
	ld	(ix+2),a
	ret
cambiprot1
	ld	(ix+2),12	; tipo nave
	ret



rellemapa	ld	hl,buffcar
	ld	bc,640	; long

rellemap1	ld 	de,init
	call	aleatorio
	add	a,e
	ld	e,a
	call	aleatorio
	add	a,e
	ld	d,a
	ld	a,(de)
	and	%111
	cp	4
	jr	nc,rellemap2
	inc	a
	inc	a
	inc	a
	cp	4
	jr	nz,rellemap3
	dec	a
rellemap3	ld	(hl),a	; poke del caracter
	inc	hl
	dec	bc
	ld	a,b
	or	c
	jr	nz,rellemap1
	ret

rellemap2	ld	a,1	; car. negro
	jr	rellemap3



tapabi	defb	0,0,0,0,0,0,0,0,3,0,3,0,3,0,3,0,3,0,0,0,0,0,1,6,0
	defb	0,0,0,0,4,5,2,0,0,0,0,0,0,0,0,4,2,5,0,0,0,0,0,0,0
	defb	3,0,3,0,3,0,0,6,1,0,0,1,6,0,0,0,0,0,0,0,0,0,0,0,0


	;	col,y,t,v,ve

tdisp	defb	000,02,16,0,2,0,0,0
	defb	000,05,14,0,2,0,0,0
	defb	000,07,15,0,2,0,0,0
	defb	000,09,13,0,2,0,0,0
	defb	000,12,17,0,2,0,0,0

	defb	000,15,16,0,2,0,0,0

fin	defb	0






spprota1
	defb #00,#00,#BE,#77,#00,#00,#00,#55,#3C,#39
	defb #AA,#00,#00,#55,#79,#77,#00,#00,#00,#00
	defb #FB,#77,#FF,#00,#00,#FF,#FF,#B3,#7F,#00
	defb #55,#FE,#BB,#BB,#7F,#00,#55,#58,#FD,#FF
	defb #AA,#00,#55,#D7,#FD,#77,#00,#00,#55,#58
	defb #AF,#FF,#00,#00,#55,#D6,#4E,#DD,#00,#00
	defb #55,#5C,#FF,#DD,#FF,#FF,#55,#86,#79,#FF
	defb #FF,#FF,#55,#0C,#79,#BE,#7C,#3C,#55,#B0
	defb #CC,#FE,#FC,#FF,#55,#B0,#79,#FF,#FC,#7C
	defb #55,#B0,#79,#F3,#FD,#FF,#55,#B0,#BE,#F3
	defb #FF,#00,#55,#BA,#75,#FF,#AA,#00,#00,#FF
	defb #EF,#FF,#00,#00,#00,#55,#8E,#5D,#00,#00
	defb #00,#55,#8E,#5D,#AA,#00,#00,#55,#AE,#AE
	defb #AA,#00,#00,#55,#5D,#8E,#FF,#00,#00,#FF
	defb #0C,#8E,#5D,#00,#FF,#AF,#0C,#EF,#18,#AA
	defb #5F,#18,#75,#FF,#25,#AA,#5F,#0C,#FF,#55
	defb #0F,#AA,#DD,#FF,#AA,#55,#30,#AA,#88,#FF
	defb #00,#55,#AE,#AA,#AA,#00,#00,#00,#EF,#FF
	defb #AA,#00,#00,#00,#EF,#5D,#00,#00,#00,#00
	defb #AE,#5D,#00,#00,#00,#00,#55,#0D,#00,#00
	defb #00,#00,#55,#0F,#00,#00,#00,#00,#55,#5F
	defb #00,#00,#00,#00,#00,#AA

spprota2
	defb #00,#00,#55,#39,#AA,#00,#00,#00,#BE,#3C
	defb #77,#00,#00,#00,#BE,#B3,#AA,#00,#00,#00
	defb #FF,#B3,#FF,#AA,#55,#FF,#55,#FB,#37,#AA
	defb #FF,#FD,#FF,#77,#37,#AA,#AE,#F4,#FF,#FF
	defb #FF,#00,#EB,#FE,#BB,#AA,#00,#00,#AE,#F5
	defb #5F,#AA,#00,#00,#EB,#AD,#CC,#AA,#00,#00
	defb #AE,#FD,#EE,#FF,#FF,#FF,#EB,#1C,#F7,#FD
	defb #FF,#FF,#AE,#1C,#F7,#3C,#BC,#7D,#FA,#64
	defb #DD,#BC,#FD,#FF,#FA,#34,#F7,#FF,#3C,#FD
	defb #FA,#34,#F3,#F6,#FF,#FF,#FA,#75,#79,#F7
	defb #AA,#00,#FF,#30,#FF,#FF,#00,#00,#55,#FF
	defb #DF,#AA,#00,#00,#00,#EF,#0C,#AA,#00,#00
	defb #00,#EF,#0C,#5D,#00,#00,#00,#FF,#5D,#5D
	defb #AA,#00,#00,#55,#AE,#AE,#AA,#00,#00,#55
	defb #8E,#BA,#FF,#00,#00,#55,#4D,#5D,#5F,#00
	defb #00,#55,#EF,#5D,#DD,#00,#00,#FF,#18,#5F
	defb #AA,#00,#55,#AE,#0D,#5F,#00,#00,#55,#0E
	defb #BA,#75,#00,#00,#55,#5F,#EF,#5D,#00,#00
	defb #55,#DD,#4D,#FF,#00,#00,#00,#FF,#AE,#AA
	defb #00,#00,#00,#55,#DD,#00,#00,#00,#00,#55
	defb #5F,#00,#00,#00,#00,#55,#4E,#AA,#00,#00
	defb #00,#00,#AF,#AA,#00,#00

spprota3
	defb #00,#00,#00,#FF,#AA,#00,#00,#00,#55,#BE,#77,#00,#00,#00,#55,#3C,#39,#AA,#00,#00
	defb #55,#79,#77,#00,#00,#FF,#55,#FB,#77,#FF,#55,#FE,#FF,#BB,#B3,#7F,#55,#58,#FD,#FF
	defb #BB,#7F,#55,#D7,#FD,#77,#FF,#AA,#55,#58,#AF,#FF,#00,#00,#55,#D6,#4E,#DD,#00,#00
	defb #55,#5C,#FF,#DD,#FF,#FF,#55,#86,#79,#FE,#FF,#FF,#55,#0C,#79,#BE,#7C,#3C,#55,#B0
	defb #CC,#FE,#FC,#FF,#55,#B0,#79,#FF,#FC,#7C,#55,#B0,#79,#F3,#FD,#FF,#55,#B0,#BE,#F3
	defb #FF,#00,#55,#BA,#75,#FF,#AA,#00,#00,#FF,#EF,#FF,#00,#00,#00,#55,#8E,#5D,#00,#00
	defb #00,#55,#8E,#5D,#AA,#00,#00,#55,#AE,#AE,#FF,#00,#00,#FF,#DF,#AE,#5D,#00,#00,#EF
	defb #0C,#AE,#5D,#AA,#00,#EF,#0C,#FF,#0C,#AA,#55,#BA,#5D,#55,#8D,#AA,#FF,#8F,#5F,#55
	defb #30,#AA,#EF,#18,#AA,#55,#0C,#AA,#0E,#5D,#AA,#55,#0C,#AA,#0E,#FF,#00,#00,#AE,#FF
	defb #5F,#AA,#00,#00,#AE,#DD,#AF,#AA,#00,#00,#AF,#8D,#FF,#AA,#00,#00,#AF,#5F,#55,#00
	defb #00,#00,#55,#AA


spprosal
	defb #00,#00,#55,#39,#AA,#00,#00,#00,#BE,#3C,#77,#00,#00,#00,#BE,#B3,#AA,#00,#00,#00
	defb #55,#B3,#FF,#AA,#55,#AA,#55,#FB,#37,#AA,#FF,#FD,#FF,#77,#37,#AA,#AE,#F4,#FF,#FF
	defb #FF,#00,#EB,#FE,#BB,#AA,#00,#00,#AE,#F5,#5F,#AA,#00,#00,#EB,#AD,#CC,#AA,#00,#00
	defb #AE,#FD,#EE,#FF,#FF,#FF,#EB,#1C,#F7,#FD,#FF,#FF,#AE,#1C,#F7,#3C,#BC,#7D,#FA,#64
	defb #DD,#BC,#FD,#FF,#FA,#34,#F7,#FF,#3C,#FD,#FA,#34,#F3,#F6,#FF,#FF,#FA,#75,#79,#F7
	defb #00,#00,#FF,#30,#FF,#AA,#00,#00,#55,#FF,#DF,#FF,#00,#00,#00,#EF,#0C,#FF,#00,#00
	defb #00,#EF,#0C,#AE,#AA,#00,#00,#55,#5D,#AE,#5D,#00,#00,#55,#AE,#AE,#5D,#00,#00,#55
	defb #8E,#FF,#25,#AA,#00,#55,#4D,#5D,#DD,#AA,#00,#00,#EF,#75,#AE,#AA,#00,#55,#AF,#5F
	defb #0C,#AA,#00,#FF,#9A,#FF,#0C,#AA,#00,#EF,#0C,#AA,#AE,#AA,#55,#AE,#5D,#55,#5F,#FF
	defb #AF,#FF,#AA,#FF,#AF,#5F,#AF,#AA,#00,#EF,#FF,#FF,#DF,#5F,#55,#DF,#DF,#00,#EF,#FF
	defb #55,#EF,#FF,#00,#EF,#AA,#00,#FF,#AA,#00,#DF,#00,#00,#00,#00,#00

sppromuer
	defb #55,#3D,#AA,#00,#00,#00,#BE,#F7,#FF,#AA,#00,#00,#BE,#77,#BF,#AA,#00,#00,#BE,#B3
	defb #37,#AA,#00,#00,#BB,#79,#7F,#FF,#00,#00,#55,#BB,#FF,#AF,#AA,#00,#00,#FF,#FE,#FF
	defb #F7,#00,#00,#FF,#77,#FD,#E6,#AA,#55,#5E,#FE,#FD,#D9,#AA,#55,#4E,#BC,#FC,#FB,#FF
	defb #55,#6C,#BC,#FD,#BF,#F7,#BE,#F7,#3C,#FE,#BF,#7F,#BE,#F7,#FF,#FC,#FF,#FD,#EE,#DD
	defb #BC,#7D,#AA,#AA,#BE,#F7,#FF,#FE,#AA,#00,#BE,#F7,#BC,#7C,#AA,#00,#BE,#F7,#BC,#FD
	defb #AA,#00,#BE,#F7,#FF,#FE,#AA,#00,#BE,#F7,#EF,#FF,#5D,#00,#FE,#FD,#8E,#5D,#5D,#00
	defb #FF,#FD,#8E,#5D,#FF,#00,#55,#FF,#AE,#FF,#5D,#00,#00,#55,#DF,#AE,#5D,#00,#00,#55
	defb #8E,#AE,#0C,#AA,#00,#EF,#5D,#55,#0C,#AA,#00,#AE,#5D,#55,#0C,#AA,#00,#AF,#75,#55
	defb #8D,#AA,#55,#75,#5F,#55,#30,#AA,#55,#9A,#AA,#00,#AE,#AA,#55,#8E,#AA,#00,#AE,#5D
	defb #55,#5D,#00,#00,#AE,#5D,#AF,#FF,#00,#00,#55,#5D,#EE,#5F,#00,#00,#FF,#AA,#AF,#FF
	defb #00,#00,#AF,#FF,#AF,#AA,#00,#00,#55,#5F,#55,#00,#00,#00,#00,#AA

spprorodi
	defb #00,#00,#55,#AA,#00,#00,#00,#00,#BE,#77,#00,#00,#00,#55,#3C,#39,#AA,#00,#00,#55
	defb #79,#77,#00,#00,#55,#AA,#FB,#77,#FF,#00,#FF,#FD,#BB,#B3,#7F,#00,#AE,#F4,#FF,#BB
	defb #7F,#00,#EB,#FE,#BB,#FF,#AA,#00,#AE,#F5,#5F,#AA,#00,#00,#EB,#AD,#CC,#AA,#00,#00
	defb #AE,#FD,#EE,#FF,#FF,#FF,#EB,#1C,#F7,#FD,#FF,#FF,#AE,#1C,#F7,#3C,#BC,#7D,#FA,#64
	defb #DD,#FC,#FD,#FF,#FA,#34,#F7,#FE,#BC,#FD,#FA,#34,#F3,#F6,#FF,#FF,#FA,#75,#79,#F7
	defb #AA,#00,#FF,#30,#FF,#FF,#00,#00,#55,#FF,#1C,#5D,#FF,#AA,#00,#55,#2C,#5D,#0C,#FF
	defb #00,#55,#AE,#FF,#0C,#5F,#00,#55,#FF,#FF,#AF,#75,#00,#55,#0C,#AA,#BA,#5D,#00,#55
	defb #8E,#AA,#AE,#5D,#FF,#FF,#8E,#AA,#AE,#5D,#DD,#DF,#24,#AA,#EE,#5D,#0E,#0C,#1A,#AA
	defb #FF,#0F,#5F,#5D,#64,#AA,#55,#FF

spprovacio	defs	36*6,0


roca1
	defb #00,#00,#00,#55,#5D,#00,#00,#00,#00,#00,#00,#AE,#59,#AA,#00,#00,#00,#00,#00,#EE
	defb #C8,#AA,#00,#00,#00,#00,#00,#AE,#C4,#AA,#00,#00,#00,#00,#55,#CC,#C4,#F7,#00,#00
	defb #00,#00,#55,#8C,#CC,#F7,#00,#00,#00,#00,#55,#0C,#D9,#DD,#00,#00,#00,#00,#55,#CC
	defb #C0,#F7,#00,#00,#00,#00,#55,#4C,#D1,#F7,#00,#00,#00,#00,#AE,#0C,#D9,#DD,#00,#00
	defb #00,#00,#AE,#C8,#C4,#5F,#00,#00,#00,#00,#EE,#4C,#4E,#E6,#AA,#00,#00,#00,#AE,#48
	defb #C8,#DB,#AA,#00,#00,#00,#EE,#48,#C0,#E6,#AA,#00,#00,#55,#8C,#C8,#D9,#DD,#F7,#00
	defb #00,#55,#8C,#C4,#FF,#EA,#DB,#AA,#00,#EE,#0C,#48,#D5,#EA,#F3,#AA,#00,#EE,#4C,#0C
	defb #FF,#C0,#E6,#AA,#00,#EE,#0C,#CC,#C8,#C4,#CC,#AA,#55,#8C,#8C,#C4,#C4,#CC,#D1,#FF
	defb #55,#0C,#4C,#CC,#CC,#C8,#C5,#F7,#55,#0C,#48,#4C,#C8,#C0,#C5,#F7,#55,#0C,#0C,#0C
	defb #48,#C0,#F3,#AA,#55,#8C,#0C,#84,#0C,#C0,#F7,#00,#00,#EE,#84,#EA,#48,#D5,#AA,#00
	defb #00,#55,#FF,#55,#FF,#AA,#00,#00

roca2
	defb #00,#00,#00,#EE,#AA,#00,#00,#00,#00,#00,#55,#D9,#DD,#00,#00,#00,#00,#00,#EE,#D1
	defb #E6,#AA,#00,#00,#00,#55,#8C,#D1,#DD,#00,#00,#00,#00,#55,#8C,#E2,#DD,#00,#00,#00
	defb #00,#55,#8C,#C4,#E6,#AA,#00,#00,#00,#00,#EE,#5D,#D1,#DD,#00,#00,#00,#00,#FF,#C8
	defb #D1,#E6,#AA,#00,#00,#00,#EE,#C8,#D1,#E6,#AA,#00,#00,#55,#8C,#C8,#D1,#DD,#00,#00
	defb #00,#55,#8C,#EE,#C4,#FF,#00,#00,#00,#55,#8C,#4C,#DD,#5F,#00,#00,#00,#55,#8C,#4C
	defb #AF,#8D,#AA,#00,#00,#55,#EE,#4C,#AF,#8D,#AA,#00,#00,#55,#FF,#DD,#0F,#5F,#AA,#00
	defb #00,#55,#8C,#EA,#8D,#D9,#DD,#00,#00,#55,#8C,#C0,#CC,#D1,#E6,#AA,#00,#55,#EE,#C0
	defb #C4,#D1,#CE,#AA,#00,#EE,#5D,#C0,#C0,#F3,#DB,#DD,#00,#EE,#5D,#EA,#C8,#F3,#F3,#DD
	defb #55,#8C,#48,#FF,#C8,#E2,#F3,#DD,#55,#8C,#0C,#D5,#C0,#C4,#E6,#AA,#00,#FF,#0C,#C4
	defb #C0,#DD,#CC,#AA,#00,#EE,#EA,#EE,#C4,#DD,#D9,#DD,#55,#C8,#DD,#C8,#DD,#CC,#D1,#DD
	defb #55,#8C,#DD,#EE,#EE,#C4,#C5,#E6,#EE,#84,#C4,#DD,#EE,#C0,#E7,#E6,#EE,#C0,#C0,#C4
	defb #C8,#C0,#E7,#E6,#EE,#84,#C0,#C0,#C0,#D1,#DB,#E6,#EE,#0C,#48,#C0,#C0,#D1,#DB,#E6
	defb #EE,#0C,#C0,#48,#C0,#F3,#F3,#DD,#55,#8C,#0C,#0C,#48,#C0,#E6,#AA,#00,#EE,#8C,#84
	defb #0C,#C4,#DD,#00,#00,#55,#EE,#CC,#CC,#DD,#AA,#00,#00,#00,#55,#FF,#FF,#AA,#00,#00

roca3
	defb #00,#00,#00,#55,#00,#00,#00,#00,#00,#00,#00,#EE,#AA,#00,#00,#00,#00,#00,#55,#D9
	defb #DD,#00,#00,#00,#00,#00,#EE,#C5,#DD,#00,#00,#00,#00,#00,#EE,#C0,#E6,#AA,#00,#00
	defb #00,#55,#8C,#D1,#E6,#AA,#00,#00,#00,#55,#8C,#D1,#C4,#AA,#00,#00,#00,#AE,#CC,#C0
	defb #DD,#00,#00,#00,#00,#AE,#4C,#C4,#FF,#00,#00,#00,#00,#AE,#4C,#EE,#5F,#00,#00,#00
	defb #00,#55,#5D,#4E,#4E,#AA,#00,#00,#00,#EE,#DD,#0F,#AF,#AA,#00,#00,#55,#8C,#8D,#AF
	defb #0F,#AA,#00,#00,#55,#0C,#8D,#0F,#0F,#AA,#00,#00,#55,#0C,#0D,#0F,#4E,#AA,#00,#00
	defb #55,#0C,#5D,#4E,#5F,#00,#00,#00,#55,#4C,#CC,#CC,#FB,#DD,#00,#00,#55,#CC,#C4,#DD
	defb #D1,#E6,#AA,#00,#00,#EE,#C0,#EA,#C0,#E6,#AA,#00,#55,#8C,#C0,#C8,#C0,#F3,#DD,#00
	defb #55,#8C,#0C,#C8,#C0,#E7,#DD,#00,#55,#8C,#48,#48,#D1,#E7,#DD,#00,#EE,#4C,#C0,#48
	defb #D1,#DB,#DD,#00,#8C,#48,#CC,#C0,#F3,#E6,#AA,#00,#8C,#48,#C8,#C0,#E6,#DD,#00,#00
	defb #8C,#48,#C8,#C0,#DD,#FF,#00,#00,#EE,#C4,#84,#C4,#FF,#FF,#AA,#00,#55,#CC,#C0,#DD
	defb #FF,#FF,#DD,#00,#55,#C8,#C0,#DD,#FF,#CC,#E6,#AA,#EE,#4C,#C4,#FF,#CC,#F3,#DB,#DD
	defb #8C,#4C,#DD,#EE,#D1,#F3,#DB,#DD,#8C,#48,#C4,#C8,#D1,#F3,#F3,#DD,#C8,#48,#C0,#C0
	defb #F3,#F3,#CF,#E6,#8C,#0C,#C0,#C0,#F3,#F3,#CF,#E6,#8C,#0C,#48,#C0,#D1,#F3,#DB,#E6
	defb #C8,#48,#C0,#C0,#D1,#E7,#DB,#DD,#CC,#0C,#48,#D1,#F3,#CF,#DB,#DD,#EE,#84,#59,#C0
	defb #F3,#DB,#F3,#DD,#EE,#C0,#59,#F3,#F3,#F3,#E6,#AA,#55,#C8,#C0,#F3,#F3,#F3,#DD,#00
	defb #00,#EE,#C0,#F3,#F3,#CC,#AA,#00,#00,#55,#CC,#CC,#CC,#FF,#00,#00,#00,#00,#FF,#FF
	defb #FF,#00,#00,#00

nariz1
	defb #00,#00,#00,#00,#00,#55,#3C,#AA,#00,#00,#00,#00,#00,#00,#00,#00,#AE,#94,#7D,#00
	defb #00,#00,#00,#00,#00,#00,#00,#AE,#C0,#7D,#00,#00,#00,#00,#00,#00,#00,#55,#0C,#C0
	defb #C0,#AA,#00,#00,#00,#00,#00,#00,#55,#0C,#C0,#94,#AA,#00,#00,#00,#00,#00,#00,#55
	defb #8C,#48,#94,#AA,#00,#00,#00,#00,#00,#00,#00,#CC,#0C,#C0,#D5,#00,#00,#00,#00,#00
	defb #00,#00,#EE,#CC,#0C,#DF,#00,#00,#00,#00,#55,#AA,#FF,#AE,#8C,#0C,#DD,#00,#00,#00
	defb #00,#EF,#D5,#DB,#C8,#CE,#4C,#D5,#00,#00,#00,#55,#C8,#4D,#6D,#E6,#C5,#C8,#CA,#AA
	defb #00,#00,#55,#48,#EF,#DB,#F3,#4D,#C8,#C8,#AA,#00,#00,#FF,#CC,#F3,#DB,#73,#C8,#CE
	defb #C6,#AA,#00,#55,#5D,#DD,#DB,#B3,#33,#2E,#0D,#6C,#AA,#00,#55,#8C,#FF,#F3,#33,#3F
	defb #6E,#CE,#4A,#AA,#00,#AE,#CD,#FB,#B3,#37,#CC,#6A,#CA,#CD,#AA,#00,#EE,#DF,#FB,#B3
	defb #66,#CA,#6E,#4D,#C0,#DD,#00,#FF,#DF,#BB,#B3,#2E,#C4,#C4,#8C,#C4,#D5,#00,#75,#5D
	defb #BB,#33,#8C,#8C,#DD,#8C,#C8,#DF,#00,#30,#FF,#BB,#33,#CC,#0C,#C4,#EE,#48,#D5,#00
	defb #BA,#F5,#BF,#37,#6E,#4D,#C4,#FF,#48,#C8,#AA,#BA,#F5,#BF,#3F,#AE,#4D,#DD,#55,#EE
	defb #C5,#AA,#FF,#70,#FF,#6E,#AE,#CA,#DD,#00,#AE,#C0,#AA,#FF,#BA,#D5,#FF,#EE,#C4,#AA
	defb #00,#55,#C4,#AA,#FF,#FA,#FF,#FF,#EE,#DD,#00,#00,#55,#DD,#00,#FF,#EA,#FF,#FF,#8C
	defb #DD,#FF,#55,#AA,#00,#00,#55,#FF,#FF,#FF,#4D,#DD,#FF,#FF,#FF,#AA,#00,#00,#00,#FF
	defb #FF,#EE,#DF,#FF,#FF,#E4,#D5,#00,#00,#00,#55,#FF,#AE,#CE,#FF,#BA,#FF,#FF,#00,#00
	defb #00,#00,#FF,#FF,#CD,#DD,#E4,#70,#FF,#AA,#00,#00,#00,#55,#FF,#4C,#18,#70,#75,#F5
	defb #FF,#00,#00,#00,#55,#FF,#FF,#98,#B0,#F5,#EA,#FF,#00,#00,#00,#00,#FF,#FF,#30,#75
	defb #75,#FF,#FF,#00,#00,#00,#00,#55,#FF,#BA,#FF,#BA,#FF,#AA,#00,#00,#00,#00,#00,#55
	defb #FF,#FF,#EA,#FF,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00


nariz2
	defb #00,#00,#00,#00,#00,#00,#00,#00,#FF,#AA,#00,#00,#00,#00,#00,#00,#00,#00,#55,#C8
	defb #7D,#00,#00,#00,#00,#00,#00,#00,#00,#EE,#48,#68,#AA,#00,#00,#00,#00,#00,#00,#00
	defb #AE,#C0,#94,#AA,#00,#00,#00,#00,#FF,#AA,#FF,#AE,#48,#94,#AA,#00,#00,#00,#FF,#E7
	defb #F7,#D5,#8C,#48,#94,#AA,#00,#00,#55,#F3,#CF,#DB,#D5,#8C,#48,#C0,#AA,#00,#00,#FB
	defb #B3,#F3,#F3,#CD,#CC,#0C,#C0,#AA,#00,#55,#E7,#33,#33,#B3,#6A,#EE,#8C,#84,#AA,#00
	defb #55,#F3,#37,#3B,#37,#6A,#DF,#0C,#4D,#AA,#00,#FB,#B3,#3F,#3F,#3F,#6E,#C4,#0C,#8C
	defb #AA,#00,#FB,#33,#3F,#CC,#9D,#CC,#4C,#4C,#D5,#00,#00,#FB,#37,#6E,#8E,#C4,#DD,#0C
	defb #C8,#C0,#AA,#00,#BF,#37,#AE,#4C,#C8,#FF,#8C,#C1,#C8,#AA,#00,#55,#3F,#AE,#8C,#C4
	defb #FF,#4D,#1E,#DD,#00,#00,#55,#BF,#EE,#0C,#C4,#FF,#CD,#8D,#DD,#00,#00,#EE,#CC,#EE
	defb #4D,#DD,#55,#8C,#CE,#DF,#00,#00,#8C,#CC,#8C,#4D,#DD,#55,#8C,#CA,#DF,#00,#00,#EE
	defb #CE,#8C,#CA,#DD,#00,#EE,#4D,#DD,#00,#00,#AE,#DF,#EE,#C4,#AA,#00,#EE,#CC,#D5,#00
	defb #00,#EE,#5D,#EE,#DD,#00,#FF,#55,#48,#D5,#00,#55,#EE,#5D,#8C,#DD,#FF,#FF,#FF,#48
	defb #DF,#00,#FF,#AE,#DF,#0C,#5D,#FF,#FF,#FF,#C8,#DD,#00,#FF,#FF,#8C,#EE,#DF,#FF,#FF
	defb #FF,#CC,#D5,#00,#FF,#FF,#CD,#AE,#DF,#60,#FF,#FF,#EA,#DF,#00,#55,#FF,#30,#64,#18
	defb #B0,#FF,#FF,#EA,#AA,#00,#00,#FF,#BA,#AE,#5D,#D5,#D5,#FF,#FF,#00,#00,#00,#55,#FF
	defb #EE,#DF,#FF,#FF,#FF,#FF,#00,#00,#00,#55,#FF,#FF,#8C,#FF,#FF,#FF,#FF,#00,#00,#00
	defb #00,#FF,#FF,#EF,#BA,#D5,#FF,#AA,#00,#00,#00,#00,#55,#EE,#75,#70,#FF,#FF,#AA,#00
	defb #00,#00,#00,#55,#BA,#30,#F5,#75,#FF,#AA,#00,#00,#00,#00,#55,#FF,#75,#75,#D5,#FF
	defb #AA,#00,#00,#00,#00,#00,#FF,#FF,#BA,#FF,#FF,#00,#00,#00,#00,#00,#00,#00,#FF,#EA
	defb #FF,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00


nariz3
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#FF,#FF,#00,#00,#00,#00,#00
	defb #00,#00,#00,#55,#F3,#F3,#FF,#00,#00,#00,#00,#00,#00,#00,#FB,#F3,#DB,#F3,#AA,#00
	defb #00,#00,#00,#00,#00,#FB,#33,#B3,#CF,#F7,#00,#00,#00,#FF,#00,#00,#BB,#3F,#3B,#E7
	defb #F3,#AA,#00,#FF,#C0,#AA,#00,#BF,#3F,#3F,#73,#73,#D5,#55,#C8,#94,#D5,#00,#BF,#3F
	defb #3F,#3B,#73,#F7,#55,#48,#C0,#7D,#00,#55,#3F,#3F,#3B,#33,#C4,#EE,#48,#C0,#7D,#00
	defb #55,#3F,#3F,#3F,#3B,#C4,#EE,#48,#C0,#7D,#00,#55,#BF,#3F,#3F,#3F,#CA,#EE,#0C,#C0
	defb #D5,#00,#55,#1D,#3F,#CC,#9D,#C5,#CC,#8C,#C0,#D5,#00,#44,#5D,#6E,#0C,#CC,#EF,#CC
	defb #0C,#48,#DD,#00,#55,#8C,#AE,#48,#4C,#CD,#8C,#CC,#4D,#AA,#00,#00,#FF,#8C,#48,#CE
	defb #8C,#0C,#C0,#8C,#AA,#00,#00,#FF,#0C,#C5,#5D,#CD,#C4,#C2,#D5,#00,#00,#55,#4C,#C8
	defb #CE,#DD,#CD,#85,#6C,#D5,#00,#00,#AE,#8C,#CC,#DD,#FF,#CC,#DF,#4E,#AA,#00,#55,#EE
	defb #4D,#5D,#FF,#DF,#AE,#CA,#C8,#AA,#00,#EE,#AE,#CE,#DD,#AE,#4D,#AE,#C5,#DF,#00,#00
	defb #BA,#4D,#DD,#FF,#FF,#8C,#EE,#CD,#FF,#00,#00,#30,#CC,#FF,#FF,#FF,#5D,#AE,#C8,#FF
	defb #AA,#00,#70,#75,#FF,#FF,#FF,#FF,#48,#DF,#FF,#FF,#AA,#BA,#F5,#FF,#FF,#FF,#FF,#C0
	defb #DF,#FF,#75,#FF,#BA,#F0,#FF,#FF,#FF,#EE,#CD,#FA,#70,#EA,#FF,#FF,#75,#75,#FF,#FF
	defb #EA,#CD,#30,#75,#75,#AA,#FF,#F5,#75,#FF,#FF,#EA,#DF,#75,#BA,#EA,#AA,#FF,#75,#D5
	defb #FF,#FF,#FF,#D5,#FF,#EA,#FF,#AA,#BA,#D5,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#00,#EA
	defb #FF,#FF,#FF,#00,#FF,#FF,#FF,#FF,#FF,#00,#FF,#FF,#FF,#AA,#00,#55,#FF,#FF,#FF,#AA
	defb #00,#55,#FF,#AA,#00,#00,#00,#55,#FF,#AA,#00,#00,#00,#FF,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00


ciempie1
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#00,#00,#00,#00,#00,#00,#00,#05
	defb #44,#0A,#00,#00,#00,#0A,#0A,#05,#50,#00,#00,#00,#00,#00,#00,#05,#8D,#00,#0A,#05
	defb #05,#00,#4E,#4E,#B0,#0A,#00,#00,#00,#00,#00,#EE,#EA,#AF,#00,#0A,#05,#88,#05,#DD
	defb #7D,#88,#00,#00,#00,#00,#55,#D5,#DD,#C8,#CC,#4E,#CC,#88,#CC,#BA,#FA,#1A,#00,#00
	defb #00,#00,#55,#5D,#D5,#D5,#CC,#D5,#8D,#AF,#EE,#98,#70,#30,#A0,#00,#00,#00,#55,#D5
	defb #5D,#D5,#AE,#DD,#AF,#EE,#FA,#CC,#64,#F0,#88,#00,#00,#00,#55,#5F,#5F,#5D,#EA,#FF
	defb #EE,#EE,#B0,#64,#CE,#CC,#08,#00,#00,#00,#00,#CC,#D5,#5F,#AF,#FF,#AF,#EE,#B0,#64
	defb #84,#CF,#88,#00,#00,#00,#00,#44,#5F,#D5,#EA,#FF,#AF,#DD,#9A,#EE,#8C,#CC,#00,#00
	defb #00,#00,#00,#00,#05,#8D,#AF,#FF,#AF,#EE,#24,#8D,#CC,#98,#CC,#00,#00,#00,#00,#00
	defb #00,#05,#8D,#FF,#CC,#FF,#64,#4E,#44,#30,#9A,#88,#00,#00,#00,#00,#00,#00,#00,#4E
	defb #88,#FA,#64,#0A,#00,#CC,#18,#E4,#00,#00,#00,#00,#00,#00,#00,#00,#00,#EF,#08,#00
	defb #00,#00,#CC,#88,#00,#00,#00,#00,#00,#00,#00,#00,#55,#B0,#88,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#55,#64,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#EF,#64,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #30,#88,#00,#00,#00,#00,#00,#00


ciempie2
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#0A,#0A,#10,#8D,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#0A,#4E,#34,#64,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#4E,#CC
	defb #F5,#25,#88,#00,#00,#00,#00,#00,#00,#00,#44,#00,#0A,#00,#CC,#EE,#70,#30,#30,#00
	defb #00,#00,#00,#00,#00,#00,#05,#00,#0A,#44,#4E,#CC,#D8,#70,#64,#20,#00,#05,#05,#00
	defb #05,#00,#4E,#00,#4E,#DD,#5F,#64,#4C,#E4,#CD,#88,#00,#8D,#05,#00,#8D,#44,#0A,#44
	defb #CC,#FF,#98,#E4,#0C,#CD,#CE,#00,#00,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#5D,#AF,#98,#4C
	defb #8C,#8E,#88,#00,#00,#0E,#AE,#DD,#AE,#FF,#4E,#EA,#FF,#EA,#CD,#64,#88,#00,#00,#00
	defb #44,#EA,#EA,#FF,#D5,#EA,#DD,#AF,#FF,#FF,#90,#64,#CC,#88,#00,#00,#44,#EE,#EA,#FF
	defb #D5,#EA,#FF,#EA,#FF,#FF,#5D,#30,#98,#E4,#00,#00,#00,#CC,#EE,#FF,#5D,#AE,#FF,#EA
	defb #FF,#EE,#5F,#8E,#CC,#18,#88,#00,#00,#44,#8D,#CC,#8D,#EE,#DD,#EE,#5D,#EE,#CC,#30
	defb #88,#D8,#88,#00,#00,#00,#00,#44,#CC,#CC,#4E,#CC,#8D,#88,#44,#98,#4C,#44,#00,#00
	defb #00,#00,#00,#00,#00,#00,#44,#CC,#00,#00,#00,#CD,#64,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#44,#E4,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#44,#70,#88,#00,#00


ciempie3
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#10,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#0F,#00,#30,#2D,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#44,#4E,#B0,#EE,#20,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0A,#44,#DD
	defb #F0,#30,#24,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#CC,#EE,#98,#B0,#8E,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#0A,#44,#4E,#98,#CC,#65,#4C,#00,#00,#00,#00,#00
	defb #44,#00,#05,#00,#05,#00,#5F,#B0,#8C,#8E,#88,#00,#00,#00,#00,#00,#05,#00,#8D,#00
	defb #05,#88,#DD,#B0,#4C,#4C,#00,#00,#00,#88,#00,#88,#05,#CC,#CC,#00,#CC,#8D,#DD,#24
	defb #4C,#88,#00,#00,#00,#05,#00,#0A,#CC,#DD,#EA,#00,#EE,#EA,#DD,#CD,#64,#00,#00,#00
	defb #00,#05,#CC,#88,#C4,#FF,#D5,#CC,#D5,#FF,#D5,#98,#30,#88,#00,#00,#00,#44,#D5,#EA
	defb #5F,#EE,#5F,#FF,#5D,#FF,#5D,#EE,#A4,#88,#00,#00,#00,#EA,#FF,#AE,#DD,#AE,#FF,#FF
	defb #5F,#FF,#5F,#FF,#9A,#64,#00,#00,#55,#AE,#FF,#CC,#FF,#AE,#FF,#FF,#DD,#EE,#4E,#EE
	defb #50,#4C,#00,#00,#FF,#5F,#FF,#4E,#FF,#AF,#FF,#FF,#5F,#AF,#CC,#CC,#44,#9A,#CC,#00
	defb #FF,#5F,#FF,#5F,#FF,#AF,#FF,#EE,#8D,#8D,#00,#88,#00,#D8,#18,#88,#55,#AF,#FF,#8D
	defb #DD,#EE,#4E,#CC,#EE,#88,#00,#00,#00,#44,#18,#64,#00,#EE,#CC,#AF,#44,#88,#AA,#00
	defb #00,#00,#00,#00,#00,#00,#CC,#64


robot1
	defb #00,#00,#00,#00,#55,#55,#FF,#AA,#00,#00,#00,#00,#00,#55,#FE,#BE,#3C,#FF,#00,#00
	defb #00,#00,#00,#FE,#BC,#FE,#29,#D7,#AA,#00,#00,#00,#55,#BC,#3C,#FE,#A9,#69,#AA,#00
	defb #00,#00,#FE,#3C,#3C,#FE,#E9,#96,#FF,#00,#00,#00,#FE,#BC,#BC,#FE,#E9,#D6,#D7,#00
	defb #00,#55,#FC,#FC,#BC,#FF,#AB,#C3,#83,#AA,#00,#55,#FC,#FC,#FC,#BE,#29,#C3,#C3,#AA
	defb #00,#55,#FC,#FC,#FD,#FC,#BC,#43,#C3,#57,#00,#55,#FC,#FC,#FD,#FC,#FC,#A9,#C3,#D7
	defb #00,#00,#FE,#FC,#FD,#FD,#FF,#FE,#43,#83,#00,#00,#FF,#FC,#FC,#BE,#3C,#FE,#A9,#43
	defb #00,#00,#55,#FF,#FC,#FD,#3C,#7D,#FC,#29,#00,#00,#00,#FF,#FE,#FC,#FF,#7C,#BC,#3C
	defb #00,#00,#00,#BE,#FE,#FD,#2E,#FE,#EE,#4E,#00,#00,#55,#BC,#FF,#BD,#26,#FE,#BC,#7D
	defb #00,#00,#55,#FD,#55,#3B,#FF,#7C,#7D,#FF,#00,#00,#FE,#FD,#BF,#77,#FC,#7D,#FF,#AA
	defb #00,#00,#DE,#FF,#7D,#FF,#FF,#FF,#AA,#00,#00,#55,#4F,#BE,#FC,#AA,#FF,#AA,#00,#00
	defb #00,#AF,#FF,#BE,#FC,#AA,#00,#00,#00,#00,#55,#DF,#AA,#55,#FF,#00,#00,#00,#00,#00
	defb #55,#CF,#AA,#55,#FC,#FF,#00,#00,#00,#00,#55,#FD,#FD,#00,#FE,#DF,#00,#00,#00,#00
	defb #FF,#FF,#FD,#00,#55,#8F,#FF,#00,#00,#00,#FC,#FD,#FC,#AA,#00,#AF,#DF,#FF,#00,#00
	defb #FE,#FC,#FC,#FD,#00,#55,#CF,#BE,#AA,#00,#FD,#FF,#FF,#AA,#00,#00,#FE,#FD,#7D,#00
	defb #FE,#FC,#FC,#FD,#00,#55,#FF,#FC,#7D,#00,#55,#FF,#FF,#AA,#00,#BE,#3C,#FF,#3C,#AA
	defb #00,#00,#00,#00,#00,#55,#3C,#3C,#3C,#7D,#00,#00,#00,#00,#00,#BE,#FF,#FF,#FF,#AA
	defb #00,#00,#00,#00,#00,#55,#3C,#3C,#3C,#7D

robot2
	defb #00,#00,#00,#55,#55,#FF,#AA,#00,#00,#00,#00,#55,#FE,#BE,#3C,#FF,#00,#00,#00,#00
	defb #FE,#BC,#FE,#29,#D7,#AA,#00,#00,#55,#BC,#3C,#FE,#A9,#69,#AA,#00,#00,#FE,#3C,#3C
	defb #FE,#E9,#96,#FF,#00,#00,#FE,#BC,#BC,#FE,#E9,#D6,#D7,#00,#55,#FC,#FC,#BC,#FF,#AB
	defb #C3,#83,#AA,#55,#FC,#FC,#FC,#BE,#29,#C3,#C3,#AA,#55,#FC,#FC,#FD,#FC,#BC,#43,#C3
	defb #57,#55,#FC,#FC,#FD,#FC,#FC,#A9,#C3,#D7,#00,#FE,#FC,#FD,#FD,#FF,#FE,#43,#83,#00
	defb #55,#FC,#FC,#BE,#3C,#FE,#A9,#43,#00,#00,#FF,#FC,#FD,#3C,#7D,#FC,#29,#00,#00,#55
	defb #FE,#FC,#FF,#7C,#BC,#3C,#00,#00,#FE,#FE,#FD,#2E,#FE,#EE,#4E,#00,#55,#FC,#FF,#BD
	defb #26,#FE,#BC,#7D,#00,#55,#FD,#FF,#3B,#FF,#7C,#7D,#FF,#00,#55,#FD,#BF,#77,#FC,#7D
	defb #FF,#AA,#00,#00,#FF,#BB,#FF,#FF,#FF,#AA,#00,#00,#00,#FF,#7D,#AA,#FF,#AA,#00,#00
	defb #00,#00,#BE,#FC,#AA,#00,#00,#00,#00,#00,#00,#14,#FC,#AA,#00,#00,#00,#00,#00,#00
	defb #55,#FF,#AA,#00,#00,#00,#00,#00,#00,#EF,#DF,#5F,#AA,#00,#00,#00,#00,#00,#AF,#5F
	defb #5F,#FD,#00,#00,#00,#00,#00,#AF,#5F,#FF,#FD,#00,#00,#00,#00,#00,#EF,#DF,#FF,#FC
	defb #AA,#00,#00,#00,#00,#FE,#BC,#FE,#FC,#FD,#00,#00,#00,#00,#55,#FD,#7D,#FF,#AA,#00
	defb #00,#00,#55,#FF,#FC,#7D,#FC,#FD,#00,#00,#00,#BE,#3C,#FF,#3C,#FF,#AA,#00,#00,#00
	defb #FF,#3C,#3C,#3C,#7D,#00,#00,#00,#00,#BE,#FF,#FF,#FF,#AA,#00,#00,#00,#00,#55,#3C
	defb #3C,#3C,#7D,#00,#00,#00


robot3
	defb #00,#00,#00,#00,#55,#55,#FF,#AA,#00,#00,#00,#00,#00,#55,#FE,#BE,#3C,#FF,#00,#00
	defb #00,#00,#00,#FE,#BC,#FE,#29,#D7,#AA,#00,#00,#00,#55,#BC,#3C,#FE,#A9,#69,#AA,#00
	defb #00,#00,#FE,#3C,#3C,#FE,#E9,#96,#FF,#00,#00,#00,#FE,#BC,#BC,#FE,#E9,#D6,#D7,#00
	defb #00,#55,#FC,#FC,#BC,#FF,#AB,#C3,#83,#AA,#00,#55,#FC,#FC,#FC,#BE,#29,#C3,#C3,#AA
	defb #00,#55,#FC,#FC,#FD,#FC,#BC,#43,#C3,#57,#00,#55,#FC,#FC,#FD,#FC,#FC,#A9,#C3,#D7
	defb #00,#00,#FE,#FC,#FD,#FD,#FF,#FE,#43,#83,#00,#00,#55,#FC,#FC,#BE,#3C,#FE,#A9,#43
	defb #00,#00,#00,#FF,#FC,#FD,#3C,#7D,#FC,#29,#00,#00,#00,#55,#FE,#FC,#FF,#7C,#BC,#3C
	defb #00,#00,#00,#FE,#FE,#BD,#2E,#FE,#EE,#4E,#00,#00,#00,#FE,#FF,#3B,#26,#FE,#BC,#7D
	defb #00,#00,#00,#FF,#BF,#77,#FF,#7C,#7D,#FF,#00,#00,#00,#55,#3B,#FF,#FC,#7D,#FF,#AA
	defb #00,#00,#55,#BF,#77,#FF,#FF,#FF,#AA,#00,#00,#00,#FF,#39,#FF,#FF,#55,#AA,#00,#00
	defb #00,#00,#BE,#FC,#00,#EF,#FF,#00,#00,#00,#00,#00,#BE,#FC,#00,#EF,#5F,#AA,#00,#00
	defb #00,#55,#FD,#AA,#00,#55,#4F,#FF,#00,#00,#00,#55,#DE,#AA,#00,#00,#EF,#FD,#AA,#00
	defb #00,#55,#5F,#00,#00,#00,#55,#FD,#FD,#00,#00,#55,#5F,#00,#00,#00,#FF,#FD,#FD,#AA
	defb #00,#55,#DF,#AA,#00,#55,#FC,#FF,#FC,#AA,#00,#55,#BC,#AA,#00,#55,#FE,#FC,#FC,#FD
	defb #00,#FE,#FD,#7D,#00,#55,#FD,#FF,#FF,#FF,#55,#FF,#FD,#7D,#00,#00,#FE,#FC,#FC,#FD
	defb #BE,#3C,#FF,#3C,#AA,#00,#55,#FF,#FF,#AA,#FF,#3C,#3C,#3C,#7D,#00,#00,#00,#00,#00
	defb #BE,#FF,#FF,#FF,#FF,#00,#00,#00,#00,#00,#55,#3C,#3C,#3C,#7D,#00,#00,#00,#00,#00


abeja1
	defb #00,#00,#00,#00,#00,#FB,#DF,#00,#00,#00,#00,#00,#00,#00,#55,#3F,#6F,#AA,#00,#00
	defb #00,#00,#00,#00,#00,#BF,#6F,#AA,#00,#00,#00,#00,#00,#00,#00,#55,#BF,#DF,#00,#00
	defb #00,#00,#00,#00,#FF,#FF,#BF,#DF,#AA,#00,#00,#00,#00,#55,#F3,#CF,#7F,#F7,#F5,#00
	defb #00,#00,#00,#FB,#3F,#3F,#9F,#BA,#F0,#AA,#00,#00,#00,#FF,#BF,#3F,#6F,#30,#25,#F7
	defb #00,#00,#00,#55,#FF,#BF,#3F,#B2,#8D,#5F,#00,#00,#00,#00,#00,#FF,#3F,#EE,#64,#98
	defb #00,#00,#00,#00,#FF,#EE,#7F,#CC,#98,#70,#00,#00,#55,#FF,#C0,#C4,#EE,#98,#EE,#CC
	defb #00,#00,#FF,#E2,#C0,#85,#98,#FF,#75,#70,#00,#55,#79,#E2,#C0,#0F,#DD,#F5,#D5,#CC
	defb #00,#FB,#79,#E2,#85,#4E,#DD,#75,#FF,#F5,#55,#94,#E2,#0F,#85,#4E,#EA,#AA,#55,#DD
	defb #55,#F3,#85,#0F,#0F,#CC,#FF,#00,#55,#F5,#40,#E2,#85,#0F,#4E,#DD,#00,#00,#EE,#DD
	defb #EA,#85,#0F,#0F,#CC,#DD,#00,#55,#D8,#AA,#EA,#0F,#0F,#4E,#CC,#AA,#00,#55,#F5,#00
	defb #EE,#0F,#4E,#CC,#CC,#AA,#00,#00,#AA,#00,#EE,#CC,#CC,#CC,#DD,#00,#00,#00,#00,#00
	defb #55,#CC,#CC,#DD,#AA,#00,#00,#00,#00,#00,#00,#FF,#FF,#AA,#00,#00,#00,#00,#00,#00

abeja2
	defb #00,#55,#FF,#00,#00,#55,#AA,#00,#00,#00,#00,#FB,#79,#AA,#00,#EF,#DF,#55,#00,#00
	defb #55,#B6,#3C,#F7,#FF,#BF,#6F,#FA,#AA,#00,#AF,#D1,#79,#F3,#D5,#BF,#FF,#70,#F5,#00
	defb #AF,#4A,#E2,#E2,#F3,#C4,#BF,#30,#5B,#AA,#CC,#4A,#C0,#C0,#C0,#DD,#7B,#64,#0F,#AA
	defb #CC,#0F,#85,#C0,#D5,#BF,#7B,#98,#CC,#75,#CC,#0F,#0F,#5F,#BF,#3F,#E6,#CC,#30,#F5
	defb #CC,#CC,#0F,#BF,#3F,#3F,#CE,#BA,#CC,#DD,#EE,#CC,#DD,#B7,#3F,#6F,#98,#EE,#30,#F5
	defb #EE,#CC,#CC,#EF,#9F,#CF,#FF,#F5,#EE,#DD,#55,#CC,#CC,#DD,#EF,#DF,#75,#BA,#BA,#F5
	defb #55,#CC,#CC,#CC,#DD,#FF,#F5,#D5,#FF,#DD,#00,#EE,#CC,#CC,#CC,#EA,#AA,#AA,#55,#F5
	defb #00,#55,#EE,#CC,#FF,#55,#00,#00,#55,#DD,#00,#00,#55,#FF,#00,#00,#00,#00,#00,#FA
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#EE,#00,#00,#00,#00,#00,#00,#00,#00,#00,#BA
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#55

rovola1
	defb #00,#00,#55,#44,#AA,#00,#00,#00,#EE,#AF,#AA,#00,#00,#00,#AF,#8D,#AA,#00,#00,#55
	defb #4E,#8D,#AA,#00,#00,#55,#CC,#5F,#00,#00,#00,#EE,#8D,#FE,#AA,#00,#00,#EE,#8D,#FE
	defb #AA,#00,#00,#EE,#AF,#5F,#00,#00,#00,#FF,#DD,#0F,#AA,#00,#55,#5F,#EE,#FF,#00,#00
	defb #55,#4E,#FF,#FF,#00,#00,#55,#0F,#4E,#0F,#AA,#00,#55,#8D,#DD,#EE,#5F,#00,#55,#CC
	defb #FF,#77,#AA,#00,#AF,#AF,#BB,#37,#AA,#00,#EE,#0F,#BF,#77,#FF,#FF,#55,#0F,#3B,#7F
	defb #FC,#3C,#55,#5F,#33,#FF,#BC,#FF,#55,#5F,#BB,#FE,#FC,#3C,#AF,#5F,#3B,#FF,#FE,#FF
	defb #EE,#5F,#3B,#77,#EE,#5F,#55,#5F,#3F,#33,#2F,#AA,#55,#1F,#BF,#3F,#FF,#00,#55,#1F
	defb #77,#FF,#AA,#00,#AF,#1F,#3B,#F7,#00,#00,#EE,#1F,#3B,#F7,#00,#00,#55,#1F,#73,#AA
	defb #00,#00,#55,#5F,#FF,#00,#00,#00,#AF,#BF,#77,#00,#00,#00,#55,#FF,#BB,#AA,#00,#00
	defb #55,#33,#FF,#00,#00,#00,#55,#BF,#77,#00,#00,#00,#BB,#FF,#AA,#00,#00,#00,#FF,#77
	defb #00,#00,#00,#00,#77,#AA,#00,#00,#00,#00,#FF,#00,#00,#00,#00,#00

rovola2
	defb #00,#00,#55,#44,#AA,#00,#00,#00,#EE,#AF,#AA,#00,#00,#00,#AF,#8D,#AA,#00,#00,#55
	defb #4E,#8D,#AA,#00,#00,#55,#CC,#5F,#00,#00,#00,#EE,#8D,#FE,#AA,#00,#00,#EE,#8D,#FE
	defb #AA,#00,#55,#EE,#AF,#5F,#00,#00,#AF,#FF,#DD,#0F,#AA,#00,#AF,#FF,#EE,#FF,#00,#00
	defb #AF,#5F,#FF,#FF,#00,#00,#EE,#0F,#4E,#0F,#AA,#00,#EE,#8D,#DD,#EE,#5F,#00,#5F,#4E
	defb #FF,#77,#AA,#00,#8D,#4E,#BB,#37,#AA,#00,#AF,#1F,#BF,#77,#FF,#FF,#AF,#7F,#3B,#7F
	defb #FC,#3C,#AF,#7F,#33,#FF,#BC,#FF,#0F,#7F,#BB,#FE,#FC,#3C,#8D,#7F,#3B,#FF,#FE,#FF
	defb #AF,#7F,#3B,#77,#EE,#5F,#AF,#7F,#3F,#33,#2F,#AA,#AF,#3F,#BF,#3F,#FF,#00,#0F,#3F
	defb #77,#FF,#AA,#00,#8D,#3F,#3B,#F7,#00,#00,#EE,#BF,#3B,#F7,#00,#00,#AF,#BF,#73,#AA
	defb #00,#00,#8D,#FF,#FF,#00,#00,#00,#5F,#BB,#77,#00,#00,#00,#AA,#55,#AA,#00,#00,#00
	defb #00,#BB,#7F,#00,#00,#00,#00,#55,#FF,#00,#00,#00,#00,#55,#33,#AA,#00,#00,#00,#00
	defb #BF,#AA,#00,#00,#00,#00,#55,#77,#00,#00,#00,#00,#00,#AA,#00,#00


nave1
	defb #00,#00,#00,#55,#AA,#00,#00,#00,#00,#00,#00,#AF,#F7,#00,#00,#00,#00,#00,#55,#8D
	defb #5F,#00,#00,#00,#00,#00,#55,#8D,#FF,#00,#00,#00,#00,#00,#55,#8D,#AF,#AA,#00,#00
	defb #00,#00,#55,#CC,#0F,#AA,#00,#00,#00,#00,#55,#EE,#5F,#00,#00,#00,#00,#00,#BA,#FF
	defb #AA,#00,#00,#00,#00,#00,#BA,#8C,#DD,#AA,#00,#00,#00,#55,#B0,#0C,#8C,#DD,#00,#00
	defb #00,#55,#B0,#8C,#5D,#5C,#AA,#00,#55,#00,#75,#CC,#0C,#9C,#FD,#00,#BE,#FF,#EE,#0C
	defb #AE,#DD,#7C,#AA,#BE,#7C,#EE,#4E,#FF,#FF,#3C,#FD,#55,#FF,#EC,#0F,#DC,#BC,#BE,#7C
	defb #FE,#7D,#7C,#8D,#5F,#BE,#BE,#A9,#55,#FF,#7D,#AF,#9C,#7D,#7C,#03,#FE,#7D,#FD,#1E
	defb #7C,#7D,#7C,#43,#55,#FF,#BE,#7C,#FC,#7D,#7C,#43,#FE,#7C,#FF,#FE,#FC,#7D,#7C,#43
	defb #55,#FE,#FD,#5F,#FE,#FD,#FC,#03,#00,#55,#FF,#AF,#DD,#FE,#FC,#FD,#00,#00,#55,#FC
	defb #3C,#7C,#FD,#AA,#00,#00,#00,#FF,#FF,#FF,#AA,#00,#00,#00,#00,#FE,#3C,#AA,#00,#00
	defb #00,#00,#00,#44,#CC,#AA,#00,#00,#00,#00,#00,#55,#5F,#00,#00,#00,#00,#00,#00,#00
	defb #AA,#00,#00,#00


gusano1
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#55,#AA,#FF,#AA
	defb #00,#00,#00,#00,#00,#55,#AA,#BB,#77,#73,#F7,#00,#00,#00,#00,#AA,#BF,#77,#33,#BB
	defb #B3,#BE,#AA,#00,#55,#55,#77,#BB,#BB,#B3,#FB,#33,#BC,#7D,#00,#BB,#BB,#7F,#B3,#FB
	defb #F7,#73,#77,#BC,#7C,#AA,#B7,#FB,#7F,#B7,#FB,#77,#33,#76,#FC,#3C,#AA,#3F,#BF,#7F
	defb #37,#BB,#77,#3B,#77,#FC,#3C,#FD,#BF,#BF,#7F,#3F,#BF,#77,#3B,#3B,#FE,#FC,#FF,#55
	defb #55,#7F,#BF,#BF,#7F,#3F,#3F,#77,#FF,#77,#00,#00,#AA,#55,#55,#7F,#3F,#3F,#33,#73
	defb #AA,#00,#00,#00,#00,#00,#BF,#BF,#3B,#73,#F7,#00,#00,#00,#00,#00,#00,#55,#55,#3B
	defb #F7,#AA,#00,#00,#00,#00,#00,#00,#00,#00,#FF,#AA,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00

gusano2
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#FF,#AA,#00
	defb #00,#00,#00,#00,#00,#00,#55,#FF,#73,#F7,#00,#00,#00,#00,#00,#FF,#FF,#FB,#3B,#B3
	defb #BE,#AA,#00,#00,#00,#55,#B7,#B7,#33,#7B,#33,#BC,#7D,#00,#00,#00,#FB,#7B,#3F,#B7
	defb #73,#77,#BC,#7C,#AA,#00,#00,#73,#7B,#3F,#B7,#33,#76,#FC,#3C,#AA,#00,#00,#BB,#3B
	defb #3F,#B7,#3B,#77,#FC,#3C,#A8,#00,#00,#55,#37,#37,#37,#3B,#3B,#FE,#FC,#AA,#00,#00
	defb #00,#FF,#37,#33,#3F,#3F,#77,#FF,#22,#00,#00,#00,#00,#FF,#BB,#3F,#3F,#33,#73,#AA
	defb #00,#00,#00,#00,#00,#55,#BF,#3B,#73,#F7,#00,#00,#00,#00,#00,#00,#00,#55,#3B,#F7
	defb #AA,#00,#00,#00,#00,#00,#00,#00,#00,#FF,#AA,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00


ranasu
	defb #00,#00,#55,#AA,#00,#00,#00,#00,#FA,#75,#00,#00,#00,#55,#78,#34,#AA,#00,#00,#55
	defb #FA,#75,#AA,#00,#00,#FA,#B0,#30,#75,#00,#00,#55,#F0,#30,#AA,#00,#00,#00,#FA,#75
	defb #00,#00,#55,#55,#F5,#BA,#00,#AA,#AF,#FF,#FA,#75,#FF,#DD,#55,#0F,#DD,#4C,#CC,#AA
	defb #55,#A5,#5A,#64,#98,#AA,#55,#F5,#70,#30,#FA,#AA,#BA,#75,#B0,#70,#FA,#75,#FA,#70
	defb #65,#9A,#B0,#75,#55,#B0,#EF,#DE,#F0,#AA,#55,#F5,#4E,#EE,#98,#AA,#00,#FF,#4E,#EC
	defb #DD,#00,#00,#AF,#4E,#6C,#CC,#AA,#00,#FF,#4E,#6C,#DD,#00,#00,#55,#AF,#6C,#AA,#00
	defb #00,#BA,#75,#7D,#75,#00,#00,#FA,#FF,#7D,#30,#AA,#00,#FA,#FF,#7D,#FA,#AA,#55,#B0
	defb #FF,#7D,#55,#75,#55,#F5,#55,#7D,#55,#F5,#55,#77,#55,#7D,#00,#BA,#55,#B3,#FF,#7D
	defb #00,#BB,#55,#33,#FF,#7D,#55,#73,#55,#BA,#FF,#7D,#55,#B1,#00,#FA,#AA,#AA,#55,#75
	defb #00,#55,#75,#00,#FA,#AA,#00,#55,#F5,#00,#FA,#AA,#00,#55,#75,#00,#55,#75,#00,#FA
	defb #30,#00,#55,#B0,#55,#F5,#75,#00,#55,#75,#00,#AA,#AA,#00,#00,#AA


ranaba
	defb #00,#00,#55,#AA,#00,#00,#00,#00,#FA,#75,#00,#00,#00,#55,#F0,#30,#AA,#00,#00,#55
	defb #F0,#30,#AA,#00,#00,#FA,#78,#34,#75,#00,#00,#FA,#BA,#75,#75,#00,#00,#55,#F0,#30
	defb #AA,#00,#00,#00,#FA,#75,#00,#00,#55,#55,#F5,#BA,#00,#AA,#AF,#FF,#FA,#75,#FF,#DD
	defb #FF,#0F,#DD,#5D,#CC,#FF,#FA,#25,#1A,#E4,#98,#F5,#70,#FF,#70,#30,#FF,#70,#F5,#FA
	defb #70,#30,#F5,#FA,#30,#B0,#65,#DE,#30,#70,#BA,#75,#EF,#DE,#FA,#F5,#55,#FF,#FF,#FF
	defb #FF,#AA,#55,#F0,#FF,#FD,#75,#AA,#BB,#30,#F5,#38,#70,#F5,#FB,#77,#30,#38,#F0,#B0
	defb #BB,#77,#75,#38,#BA,#BB,#FF,#FF,#FF,#7D,#FF,#73,#55,#75,#55,#7D,#BA,#BB,#55,#B0
	defb #FF,#7D,#FA,#75,#00,#FA,#FF,#7D,#B0,#AA,#00,#55,#75,#7D,#F5,#00,#00,#55,#75,#7D
	defb #F5,#AA,#00,#FA,#FF,#7D,#30,#75,#55,#B0,#75,#7D,#BA,#AA,#00,#BA,#AA,#7D,#55,#00


rued1
	defb #00,#FF,#D9,#CF,#FF,#00,#55,#FB,#C8,#C0,#DF,#AA,#55,#CA,#9D,#6A,#D1,#AA,#55,#C0
	defb #9D,#3F,#C4,#FF,#EF,#95,#EE,#3F,#CC,#F7,#FB,#6E,#FF,#EE,#C8,#DF,#EE,#DD,#FF,#FF
	defb #2E,#DF,#EA,#FF,#EF,#FF,#3F,#D1,#CA,#FF,#CC,#F7,#BF,#C5,#9F,#FF,#CE,#DD,#BF,#D1
	defb #9F,#FF,#D5,#D9,#EE,#CC,#B7,#FF,#FF,#4D,#AE,#D1,#84,#DD,#FF,#D9,#BF,#C5,#EE,#1D
	defb #BF,#4C,#BF,#C5,#EA,#84,#8C,#C4,#EA,#D1,#FF,#CA,#C8,#DF,#4C,#D1,#55,#FB,#C8,#FF
	defb #6A,#DD,#00,#55,#FF,#BF,#C0,#F7,#00,#FF,#30,#8C,#D1,#FF,#00,#BA,#30,#C8,#E7,#AA
	defb #00,#FA,#30,#64,#DF,#AA,#00,#55,#F0,#64,#FF,#00


rued2
	defb #00,#FF,#F0,#AA,#00,#00,#55,#FA,#30,#75,#00,#00,#55,#98,#30,#7F,#00,#00,#FF,#CC
	defb #35,#FF,#FF,#00,#EF,#EE,#7F,#C4,#DF,#AA,#EF,#95,#FB,#C4,#C5,#FF,#DB,#95,#EA,#4C
	defb #48,#D5,#E2,#5D,#84,#FF,#3F,#D5,#CC,#DD,#F7,#FF,#BF,#C8,#C4,#DD,#DD,#DF,#EE,#D1
	defb #CA,#7F,#F7,#C5,#BF,#C5,#E2,#7F,#C4,#EE,#BF,#C5,#E2,#D5,#8C,#7B,#EE,#CC,#C0,#7F
	defb #FB,#DF,#AE,#D1,#C8,#DD,#FF,#FF,#3F,#C5,#CC,#9D,#FF,#FF,#6A,#E7,#EA,#95,#7F,#EE
	defb #C8,#DF,#EF,#C0,#4C,#3F,#CC,#D5,#FF,#CA,#C4,#48,#C4,#FF,#FF,#E2,#C4,#C0,#E2,#AA
	defb #55,#EA,#C8,#D1,#DF,#AA,#00,#FF,#EA,#E7,#FF,#00


rued3
	defb #00,#FF,#D1,#DD,#AA,#00,#55,#FB,#CA,#D9,#FF,#00,#55,#C5,#84,#CD,#F7,#AA,#FF,#C0
	defb #1D,#8C,#CA,#AA,#EE,#9D,#7F,#BF,#C4,#DD,#EF,#CC,#FF,#FF,#6E,#F5,#EF,#7F,#FF,#FF
	defb #98,#F5,#CA,#7F,#EF,#D5,#98,#70,#A6,#7F,#C0,#CA,#BA,#70,#84,#FF,#C8,#C0,#BA,#30
	defb #CC,#EE,#7F,#2E,#D5,#75,#95,#EA,#FF,#EE,#D5,#FF,#84,#AE,#FF,#BF,#5D,#00,#8E,#EF
	defb #EF,#AE,#F7,#00,#9F,#BF,#6F,#EA,#F7,#00,#CA,#FF,#DD,#EA,#F7,#00,#C4,#7F,#FF,#DD
	defb #D5,#00,#CC,#84,#9D,#6E,#AA,#00,#EA,#E2,#8C,#C4,#AA,#00,#EF,#CA,#C8,#E2,#AA,#00
	defb #FF,#DB,#D9,#DF,#00,#00,#55,#EA,#CD,#FF,#00,#00


larg1
	defb #00,#00,#00,#00,#55,#FF,#AA,#00,#FF,#FF,#55,#F5,#AA,#00,#00,#AA,#00,#00,#FF,#CF
	defb #FF,#55,#EF,#DF,#FF,#70,#FF,#00,#55,#FF,#AA,#55,#EF,#C0,#DD,#FF,#CD,#CF,#BA,#43
	defb #75,#AA,#FF,#CE,#FF,#FF,#C8,#3F,#CD,#EF,#C8,#C5,#2B,#96,#92,#FF,#EE,#C4,#DF,#EF
	defb #9D,#FF,#C8,#CA,#C8,#C0,#81,#C3,#83,#75,#DF,#EE,#C4,#CA,#DD,#FF,#EA,#C0,#8C,#48
	defb #90,#43,#03,#B0,#FF,#FF,#6E,#C4,#FF,#00,#BF,#95,#8C,#0C,#81,#C3,#83,#75,#FF,#55
	defb #EE,#DD,#AA,#00,#55,#3F,#8C,#0C,#2B,#96,#92,#FF,#AA,#00,#FF,#FF,#00,#00,#55,#BF
	defb #9D,#1D,#BA,#43,#75,#AA,#00,#00,#55,#AA,#00,#00,#00,#FF,#9D,#7F,#55,#70,#FF,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#FF,#AA,#55,#F5,#AA,#00


larg2
	defb #00,#00,#00,#00,#00,#00,#00,#00,#AA,#55,#F5,#AA,#00,#00,#FF,#55,#AA,#00,#00,#00
	defb #FF,#FF,#FF,#70,#FF,#00,#55,#FF,#FF,#FF,#00,#00,#55,#EF,#DF,#BA,#43,#75,#AA,#FF
	defb #DF,#EA,#DF,#AA,#00,#FF,#EF,#CF,#AB,#96,#92,#FF,#EE,#FF,#9D,#C0,#AA,#55,#EF,#C8
	defb #CF,#AB,#C3,#83,#75,#BF,#FF,#DD,#6A,#FF,#55,#CF,#8C,#4D,#90,#43,#03,#B0,#EA,#EF
	defb #7F,#3F,#DD,#FF,#CA,#8C,#4D,#81,#C3,#83,#75,#BF,#C8,#7F,#EE,#D5,#EF,#95,#8C,#0C
	defb #81,#96,#92,#FF,#55,#9D,#FF,#EE,#DF,#C8,#3F,#8C,#0C,#3A,#43,#75,#AA,#00,#FF,#AA
	defb #BF,#C5,#9D,#BF,#9D,#1D,#FF,#70,#FF,#00,#00,#00,#00,#55,#6A,#DD,#FF,#9D,#7F,#55
	defb #F5,#AA,#00,#00


spexplo1
	defb #00,#EF,#AF,#FF,#6D,#AA,#00,#55,#9E,#2D,#1E,#6D,#7D,#00,#BE,#7C,#AD,#5E,#BC,#DF
	defb #AA,#FF,#7C,#9C,#7D,#FC,#2D,#AA,#FF,#6C,#5A,#9E,#FE,#AD,#7D,#EF,#AF,#78,#9E,#7C
	defb #5F,#7D,#3C,#2D,#6D,#3C,#2D,#1E,#DF,#B4,#FD,#1E,#3C,#0F,#FC,#9E,#9E,#FC,#1E,#2D
	defb #4E,#FC,#78,#BE,#AD,#0F,#9C,#9C,#5E,#78,#55,#0F,#BE,#3C,#3C,#AD,#BC,#BE,#AF,#3C
	defb #7C,#3C,#AD,#BE,#BE,#7D,#3C,#FC,#7D,#5F,#5F,#3C,#7D,#1E,#BC,#2D,#5E,#5F,#2D,#7C
	defb #1E,#9E,#2D,#FC,#FD,#AF,#5E,#1E,#CF,#AF,#BC,#2D,#5E,#4E,#9C,#3C,#0F,#3C,#2D,#3C
	defb #8D,#CC,#2D,#AD,#3C,#FF,#6D,#FC,#8D,#DC,#FD,#3C,#7D,#78,#7C,#8D,#5E,#3C,#BE,#AA
	defb #EF,#9E,#2D,#3C,#9E,#5F,#00,#FF,#3C,#AF,#BE,#F5,#1E,#AA,#55,#FF,#55,#BE,#AA,#BE
	defb #AA,#00

spexplo2
	defb #00,#00,#55,#00,#00,#00,#AF,#AA,#55,#55,#55,#00,#AF,#AF,#AA,#00,#55,#AF,#5F,#00
	defb #FF,#0F,#DF,#00,#AF,#1E,#0F,#AA,#55,#4F,#5F,#00,#55,#0F,#5F,#00,#55,#AF,#AA,#00
	defb #AF,#AF,#FF,#00,#55,#55,#AF,#AA,#00,#00,#55,#00

spbala1

	defb #00,#FF,#00,#55,#6C,#AA,#BE,#0C,#AA,#BE,#0C,#DD,#EF,#0C,#DD,#EF,#0C,#AA,#55,#CE
	defb #AA,#00,#FF,#00

navepro
	defb #BE,#FF,#3D,#AA,#00,#00,#00,#00,#00,#00,#BE,#FB,#7F,#00,#00,#00,#00,#00,#00,#00
	defb #BE,#D3,#77,#AA,#55,#00,#00,#00,#00,#00,#BE,#D7,#B3,#7F,#BB,#AA,#AA,#00,#00,#00
	defb #7D,#83,#BB,#7F,#7F,#FF,#7D,#00,#00,#00,#7C,#A9,#5F,#BF,#FB,#33,#3C,#AA,#00,#00
	defb #3C,#FC,#5B,#7B,#B6,#FF,#7C,#FD,#00,#00,#FF,#FC,#BE,#BE,#FD,#FF,#FC,#FC,#AA,#00
	defb #BE,#7C,#57,#AE,#5F,#BE,#7D,#FF,#FF,#FF,#BE,#FC,#C7,#0C,#8E,#FE,#BC,#3C,#7C,#7C
	defb #FF,#FC,#C6,#4D,#CD,#0D,#FD,#CC,#7D,#FF,#FC,#FE,#E9,#CC,#C6,#5E,#FE,#CC,#7C,#7C
	defb #7C,#FE,#3C,#FC,#FC,#FD,#7C,#9C,#FD,#FF,#7D,#FF,#FD,#FF,#FF,#BE,#FC,#FF,#FF,#00
	defb #FC,#FD,#BA,#24,#F0,#FE,#DD,#AA,#00,#00,#FF,#AA,#AE,#86,#30,#FF,#AA,#00,#00,#00

mar1ac1
	defb #00,#00,#FE,#FC,#FD,#00,#00,#00,#55,#DE,#7C,#BC,#AA,#00,#00,#BE,#E9,#7C,#D6,#7D
	defb #00,#55,#DE,#83,#DE,#43,#BC,#AA,#55,#DE,#83,#DE,#43,#BC,#AA,#14,#E9,#03,#DE,#03
	defb #D6,#28,#45,#E9,#03,#7C,#03,#D6,#28,#55,#FF,#FF,#0F,#FF,#FF,#AA,#00,#00,#55,#03
	defb #AA,#00,#00,#00,#00,#45,#0C,#88,#00,#00,#00,#00,#55,#0F,#AA,#00,#00,#00,#00,#45
	defb #0C,#88,#00,#00,#00,#00,#55,#0F,#AA,#00,#00,#00,#00,#45,#0C,#88,#00,#00,#00,#00
	defb #55,#03,#AA,#00,#00,#55,#FF,#FF,#0F,#FF,#FF,#AA,#14,#E9,#03,#7C,#03,#D6,#28,#14
	defb #E9,#03,#DE,#03,#D6,#28,#55,#7C,#83,#DE,#43,#BC,#AA,#55,#7C,#83,#DE,#43,#BC,#00
	defb #00,#BE,#E9,#7C,#D6,#7D,#00,#00,#55,#7C,#7C,#BC,#AA,#00,#00,#00,#FE,#FC,#FD,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00


mar1ac2
	defb #00,#00,#FE,#FC,#FD,#00,#00,#00,#55,#7C,#7C,#BC,#AA,#00,#00,#BE,#E9,#7C,#D6,#7D
	defb #00,#00,#7C,#83,#7C,#43,#BC,#00,#55,#7C,#83,#7C,#43,#BC,#AA,#14,#E9,#03,#7C,#03
	defb #D6,#28,#14,#E9,#03,#7C,#03,#D6,#28,#55,#FF,#FF,#FF,#FF,#FF,#AA,#14,#E9,#03,#7C
	defb #03,#D6,#28,#14,#E9,#03,#7C,#03,#D6,#28,#55,#7C,#83,#7C,#43,#BC,#AA,#00,#7C,#83
	defb #7C,#43,#BC,#00,#00,#BE,#E9,#7C,#D6,#7D,#00,#00,#55,#7C,#7C,#BC,#AA,#00,#00,#00
	defb #FE,#FC,#FD,#00,#00,#55,#FF,#FF,#0F,#FF,#FF,#AA,#14,#E9,#03,#7C,#03,#D6,#28,#14

mar2ac1
	defb #00,#00,#00,#00,#FF,#FF,#00,#55,#F3,#CD,#DD,#AA,#00,#00,#00,#55,#EF,#F7,#AA,#FB
	defb #CE,#E5,#CE,#FF,#00,#00,#00,#FF,#CF,#DB,#FF,#E7,#E6,#70,#6D,#DD,#55,#00,#00,#FB
	defb #F3,#F3,#77,#E7,#E6,#CC,#3C,#DD,#FF,#AA,#55,#F3,#33,#B3,#37,#73,#98,#F0,#9C,#DD
	defb #EF,#FF,#FF,#B3,#3F,#33,#99,#73,#98,#E5,#CC,#DD,#BF,#F7,#FB,#37,#BF,#33,#99,#33
	defb #D8,#E5,#E4,#DF,#FF,#73,#DB,#7F,#FF,#3B,#9D,#33,#D8,#F0,#E4,#DF,#55,#BF,#33,#7F
	defb #55,#3B,#9D,#37,#98,#F0,#CC,#DD,#00,#FF,#3F,#AA,#55,#BF,#9D,#37,#98,#70,#D8,#DD
	defb #00,#55,#FF,#00,#00,#BF,#9D,#37,#98,#64,#F0,#DD,#00,#00,#00,#00,#00,#55,#6E,#3B
	defb #6E,#D8,#B0,#FF,#00,#00,#00,#00,#00,#00,#FF,#3F,#6E,#70,#B0,#AA,#00,#00,#00,#00
	defb #00,#00,#55,#BF,#6E,#30,#75,#AA,#00,#00,#00,#00,#00,#00,#00,#FF,#3F,#98,#FF,#00


mar2ac2
	defb #00,#00,#00,#00,#00,#00,#00,#55,#FF,#FF,#AA,#00,#00,#00,#00,#00,#00,#00,#FF,#F3
	defb #9C,#FF,#00,#FF,#AA,#00,#00,#00,#55,#EF,#CE,#B4,#6C,#55,#F3,#DF,#AA,#00,#00,#FF
	defb #E7,#E6,#34,#CC,#FB,#7B,#F3,#FF,#00,#FF,#77,#F3,#6E,#CC,#DD,#FB,#7F,#7B,#F7,#FF
	defb #B3,#73,#F3,#98,#DD,#FF,#BF,#FF,#BF,#F3,#F3,#DB,#BF,#F3,#98,#E4,#FF,#55,#00,#BF
	defb #3B,#E7,#DB,#99,#B3,#D8,#E5,#98,#00,#00,#55,#3F,#33,#B7,#99,#B3,#D8,#F0,#98,#00
	defb #00,#00,#BF,#3B,#33,#9D,#33,#98,#E4,#FF,#00,#00,#00,#55,#BF,#37,#9D,#33,#98,#75
	defb #FF,#00,#00,#00,#00,#55,#3B,#3F,#37,#98,#EE,#DD,#00,#00,#00,#00,#00,#FF,#7F,#3F
	defb #6E,#D8,#CC,#00,#00,#00,#00,#00,#55,#FF,#3F,#6E,#F0,#E4,#00,#00,#00,#00,#00,#00
	defb #00,#BF,#6E,#70,#75,#00,#00,#00,#00,#00,#00,#00,#55,#3F,#98,#FF,#00,#00,#00,#00
	defb #00,#00,#00,#00,#FF,#FF,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00


mar3ac1
	defb #FF,#FF,#FF,#FF,#FF,#FF,#F0,#CF,#FF,#FF,#FF,#FA,#E5,#FF,#FF,#FF,#FA,#F0,#DF,#FF
	defb #FF,#FF,#70,#DF,#FF,#FF,#FF,#64,#DD,#FF,#FF,#FF,#DC,#C8,#FF,#FF,#FF,#EC,#8D,#F7
	defb #FF,#FD,#7D,#0F,#C4,#FD,#7D,#7D,#0F,#4A,#FF,#FD,#7D,#0F,#C4,#FF,#FF,#EC,#8D,#F7
	defb #FF,#FF,#DC,#EA,#FF,#FF,#FF,#64,#DD,#FF,#FF,#FF,#70,#DF,#FF,#FF,#FF,#F0,#DF,#FF
	defb #FF,#FA,#E5,#FF,#FF,#FF,#F0,#CF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#D8,#F0,#98,#00
	defb #00,#00,#BF,#3B,#33,#9D,#33,#98,#E4,#FF,#00,#00,#00,#55


mar3ac2
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FA,#F0,#FF,#FF,#FF,#FF,#70,#64,#DD,#FF,#FF,#BA,#DC,#C8,#FF,#FF,#FF,#EC,#8D,#F7
	defb #FF,#FD,#7D,#0F,#C4,#FD,#7D,#7D,#0F,#4A,#FF,#FD,#7D,#0F,#C4,#FF,#FF,#EC,#8D,#F7
	defb #FF,#BA,#DC,#EA,#FF,#FF,#70,#64,#DD,#FF,#FA,#F0,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#D8,#F0,#98,#00
	defb #00,#00,#BF,#3B,#33,#9D,#33,#98,#E4,#FF,#00,#00,#00,#55


mar4ac1
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BE,#3C,#FF,#FF,#FF,#FF,#EF,#FF,#FF
	defb #FF,#5F,#FF,#EF,#FF,#FF,#BE,#EF,#DF,#FF,#AF,#9C,#3C,#EF,#3C,#7D,#69,#EF,#CF,#FF
	defb #4E,#DD,#FF,#AE,#FF,#FF,#3C,#FE,#CF,#DF,#4E,#9C,#3C,#EF,#3C,#7D,#69,#FE,#FC,#CF
	defb #4E,#DD,#FF,#EF,#FF,#FF,#FC,#FE,#FC,#FD,#AF,#DC,#FC,#AE,#FC,#FD,#E9,#FE,#FC,#FF
	defb #FF,#5F,#FF,#AE,#FF,#FF,#FE,#FE,#FD,#FF,#FF,#FE,#FC,#FF,#FF,#FF,#FF,#FE,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF


mar4ac2
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FE,#FC,#FF,#FF,#FF,#FF,#FE,#FF,#FF
	defb #FF,#FF,#FF,#AE,#FF,#FF,#EB,#FE,#FD,#FF,#FF,#FE,#FC,#AE,#FC,#FD,#3C,#FE,#FC,#FF
	defb #FF,#5F,#FF,#AE,#FF,#FF,#69,#FE,#ED,#DF,#AF,#9C,#3C,#EF,#3C,#7D,#3C,#EF,#CF,#CF
	defb #FF,#5F,#FF,#AE,#FF,#FF,#E9,#EF,#DE,#FD,#FF,#BE,#3C,#EF,#3C,#7D,#BC,#FE,#FC,#FF
	defb #FF,#FF,#FF,#EF,#FF,#FF,#EB,#FE,#FD,#FF,#FF,#FE,#FC,#FF,#FF,#FF,#FF,#FE,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF


mar5ac1
	defb #FF,#FF,#FF,#FE,#7D,#FF,#FF,#FF,#FF,#FF,#FF,#FC,#7C,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#BE,#3C,#3C,#3C,#7C,#FC,#FC,#FD,#3C,#3C,#3C,#3C,#3C,#3C,#FC,#FC
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#D9,#E6,#D9,#EC,#D9
	defb #EC,#DC,#E6,#D9,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#D9,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#D9
	defb #E6,#D9,#EC,#D9,#EC,#DC,#E6,#D9,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#D9,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#3C,#3C,#3C,#3C,#3C,#7C,#FC,#FC,#BE,#3C,#3C,#3C,#7C,#FC,#FC,#FD
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FC,#7C,#FF,#FF,#FF,#FF,#FF,#FF,#FE
	defb #7D,#FF,#FF,#FF


mar5ac2
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BE,#FD,#FF,#FF,#FF,#FF,#FF,#FF,#7C
	defb #FC,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BE,#3C,#3C,#3C,#7C,#FC,#FC,#FD
	defb #3C,#3C,#3C,#3C,#3C,#FC,#FC,#FC,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#D9,#EC,#D9,#EC
	defb #DC,#E6,#DC,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#DC,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#DC,#E6
	defb #D9,#EC,#D9,#EC,#DC,#E6,#DC,#E6,#D9,#EC,#D9,#EC,#DC,#E6,#DC,#E6,#D9,#EC,#D9,#EC
	defb #DC,#E6,#DC,#E6,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#3C,#3C,#3C,#3C,#7C,#FC,#FC,#FC
	defb #BE,#3C,#3C,#3C,#7C,#FC,#FC,#FD,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#7C
	defb #FC,#FF,#FF,#FF

cartel
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#14,#28,#00,#00,#14,#00,#00,#DE,#A8,#00,#3C,#3C,#3C,#3C,#00,#00,#00,#7C
	defb #00,#00,#3C,#3C,#00,#00,#DE,#20,#00,#7C,#A8,#00,#7C,#FC,#B8,#30,#00,#00,#00,#7C
	defb #00,#45,#CF,#CF,#8A,#00,#00,#00,#00,#7C,#00,#00,#7C,#FC,#30,#30,#14,#7C,#00,#7C
	defb #00,#00,#CF,#CF,#8A,#00,#7C,#20,#14,#B8,#00,#00,#7C,#20,#00,#00,#14,#FC,#A8,#7C
	defb #00,#00,#45,#CF,#CF,#00,#7C,#20,#45,#B8,#00,#00,#7C,#20,#00,#00,#14,#FC,#A8,#7C
	defb #00,#00,#50,#F0,#F0,#00,#DE,#20,#14,#B8,#00,#00,#7C,#FC,#B8,#20,#14,#B8,#FC,#FC
	defb #00,#00,#10,#F0,#F0,#00,#DE,#20,#14,#A8,#00,#00,#7C,#FC,#B8,#00,#14,#B8,#FC,#FC
	defb #00,#00,#00,#F0,#F0,#00,#7C,#20,#7C,#A8,#00,#00,#7C,#20,#00,#00,#14,#B8,#FC,#FC
	defb #00,#00,#00,#F0,#F0,#00,#7C,#20,#DE,#20,#00,#00,#7C,#20,#00,#00,#14,#A8,#74,#FC
	defb #00,#00,#00,#F0,#F0,#00,#7C,#20,#DE,#20,#00,#00,#7C,#30,#00,#00,#14,#A8,#30,#FC
	defb #00,#00,#10,#F0,#A0,#00,#7C,#20,#7C,#20,#00,#00,#54,#30,#20,#00,#14,#A8,#10,#FC
	defb #00,#00,#10,#F0,#A0,#00,#DE,#20,#7C,#20,#00,#30,#00,#FC,#30,#00,#14,#A8,#10,#74
	defb #14,#00,#50,#F0,#A0,#00,#14,#00,#7C,#30,#30,#30,#20,#54,#B8,#20,#14,#A8,#00,#74
	defb #14,#8A,#50,#F0,#00,#00,#00,#00,#7C,#FC,#FC,#FC,#FC,#00,#FC,#30,#14,#A8,#00,#00
	defb #6D,#DA,#A0,#F0,#00,#14,#00,#00,#7C,#FC,#A8,#00,#00,#A8,#54,#B8,#14,#A8,#00,#00
	defb #6D,#F0,#F0,#50,#00,#14,#28,#00,#14,#9E,#28,#3C,#28,#30,#00,#00,#00,#00,#00,#00
	defb #CF,#F0,#F0,#A0,#00,#45,#3C,#00,#00,#00,#00,#3C,#28,#00,#14,#00,#3C,#28,#00,#00
	defb #45,#F0,#F0,#38,#00,#45,#CF,#00,#00,#00,#45,#CF,#00,#00,#7C,#A8,#7C,#BC,#28,#00
	defb #00,#F0,#F0,#38,#20,#45,#CF,#00,#00,#00,#45,#CF,#00,#14,#FC,#A8,#7C,#54,#FC,#A8
	defb #00,#50,#B4,#30,#30,#45,#CF,#00,#00,#00,#45,#CF,#00,#14,#B8,#A8,#7C,#00,#10,#FC
	defb #00,#00,#B4,#30,#30,#50,#F0,#00,#F0,#00,#50,#F0,#00,#7C,#B8,#A8,#14,#A8,#00,#74
	defb #00,#20,#50,#30,#30,#50,#F0,#00,#F0,#00,#F0,#A0,#00,#7C,#20,#7C,#14,#A8,#00,#74
	defb #00,#B0,#00,#30,#30,#50,#F0,#50,#F0,#A0,#F0,#A0,#14,#B8,#00,#7C,#14,#A8,#00,#74
	defb #00,#B0,#20,#10,#30,#50,#F0,#50,#F0,#A0,#F0,#A0,#14,#B8,#00,#7C,#14,#A8,#10,#FC
	defb #50,#30,#20,#00,#30,#50,#F0,#F0,#F0,#F0,#F0,#A0,#7C,#20,#00,#7C,#00,#7C,#54,#A8
	defb #50,#30,#00,#00,#10,#50,#F0,#F0,#F0,#F0,#F0,#00,#7C,#20,#7C,#FC,#A8,#7C,#14,#A8
	defb #50,#30,#00,#00,#00,#50,#F0,#F0,#F0,#F0,#F0,#00,#7C,#20,#7C,#FC,#A8,#7C,#14,#A8
	defb #B0,#30,#00,#00,#00,#50,#F0,#F0,#00,#F0,#F0,#00,#7C,#20,#7C,#FC,#A8,#7C,#14,#A8
	defb #B0,#30,#00,#00,#00,#10,#30,#30,#00,#30,#30,#00,#7C,#20,#00,#14,#20,#14,#A8,#7C
	defb #B0,#20,#00,#00,#00,#10,#30,#30,#00,#30,#20,#00,#7C,#20,#00,#14,#30,#14,#A8,#7C
	defb #FA,#20,#00,#00,#00,#00,#30,#30,#00,#30,#20,#00,#7C,#20,#00,#14,#30,#14,#A8,#7C


finsp	defb	0


	ORG	30208

	; SUPERMAPA

	defb #D1,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#D1,#00
	defb #00,#00,#D1,#00,#00,#00,#00,#D3,#00,#D1,#00,#00,#00,#00,#00,#00
	defb #00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#D3
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#D1,#D1,#00,#00,#00,#D3,#00,#00
	defb #00,#00,#00,#D2,#00,#D1,#00,#00,#00,#00,#D1,#00,#00,#D3,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#D1,#CF,#00,#00
	defb #00,#00,#D1,#00,#00,#D1,#00,#00,#00,#D1,#00,#00,#D3,#00,#00,#00
	defb #00,#00,#00,#D1,#00,#00,#D1,#00,#00,#00,#00,#D3,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#D1,#00,#00,#00,#D2
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#D1,#00,#00,#00,#00,#D0,#00,#00,#00,#00,#D1,#00,#00,#D3,#00
	defb #00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#D3,#00
	defb #D1,#00,#00,#CF,#00,#00,#00,#CE,#00,#D1,#00,#00,#00,#D3,#00,#D1
	defb #00,#D1,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#D1,#00,#00
	defb #D1,#00,#00,#00,#00,#00,#D2,#00,#00,#D3,#00,#00,#00,#00,#00,#00
	defb #00,#D0,#00,#00,#00,#00,#00,#00,#D1,#00,#CC,#CD,#00,#D3,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#D1,#00
	defb #D0,#00,#00,#00,#00,#00,#D2,#D1,#00,#D1,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#D1,#D1,#00,#CF,#00,#00,#D1,#00,#00
	defb #D1,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#D1,#D0
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00
	defb #D1,#00,#00,#00,#D1,#00,#00,#D1,#00,#00,#00,#00,#D0,#D0,#D1,#00
	defb #00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#D1,#00,#00,#D3,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D3,#00
	defb #00,#00,#00,#D3,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00
	defb #D1,#00,#D0,#D1,#00,#D1,#00,#00,#00,#00,#00,#D1,#D2,#00,#00,#D1
	defb #00,#00,#00,#00,#00,#D1,#00,#00,#D1,#00,#D1,#00,#00,#00,#00,#00
	defb #D1,#00,#00,#00,#D1,#00,#00,#00,#D3,#00,#00,#00,#D1,#00,#00,#D0
	defb #00,#00,#D1,#00,#00,#D1,#00,#D1,#00,#00,#D1,#00,#00,#D1,#00,#00
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#D1,#00,#00,#D3,#00,#00
	defb #00,#D0,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#D1
	defb #00,#D1,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#D1,#00,#00,#00,#D1
	defb #00,#00,#00,#D1,#00,#00,#00,#00,#00,#CE,#00,#00,#00,#00,#00,#00
	defb #00,#00,#D1,#00,#00,#D1,#D1,#00,#00,#00,#00,#00,#00,#00,#D3,#00
	defb #D1,#00,#D1,#00,#00,#00,#D1,#D1,#D1,#00,#00,#00,#00,#00,#00,#D1
	defb #00,#D0,#00,#D3,#00,#00,#D1,#00,#00,#D1,#CA,#CB,#00,#00,#00,#00
	defb #D1,#00,#00,#D3,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D1
	defb #CE,#00,#D1,#00,#00,#00,#D1,#00,#D1,#00,#00,#D0,#00,#00,#D0,#00
	defb #00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#D1,#00,#D3,#00,#00,#CA
	defb #CB,#00,#00,#D1,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#D1,#00
	defb #00,#00,#00,#00,#00,#D3,#00,#00,#00,#D1,#00,#D0,#00,#D1,#00,#00
	defb #00,#00,#00,#00,#D3,#00,#00,#D1,#00,#D1,#00,#00,#00,#D1,#00,#CC
	defb #CD,#00,#00,#00,#D1,#00,#00,#D3,#00,#00,#00,#D1,#00,#00,#D1,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#D1
	defb #00,#D3,#00,#D1,#00,#00,#00,#00,#00,#D1,#00,#D1,#00,#00,#00,#00
	defb #D3,#00,#00,#00,#00,#00,#D1,#00,#00,#D3,#00,#00,#00,#00,#D1,#D3
	defb #00,#00,#D1,#00,#00,#00,#00,#CE,#00,#D1,#00,#00,#CC,#CD,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00
	defb #00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#D1
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#D3,#00,#D1,#00,#00,#D3
	defb #00,#00,#00,#00,#D0,#00,#00,#D1,#00,#00,#00,#D3,#00,#00,#00,#00
	defb #00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#C9,#D0,#CF,#D1
	defb #00,#00,#00,#00,#00,#D1,#00,#00,#00,#D1,#00,#00,#00,#00,#D3,#00
	defb #00,#00,#00,#00,#00,#00,#D1,#00,#00,#D1,#00,#00,#D1,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D3,#00,#00
	defb #00,#00,#D1,#00,#00,#00,#D1,#00,#D1,#00,#D1,#00,#00,#00,#00,#00
	defb #00,#D3,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#D3
	defb #00,#D1,#00,#D1,#00,#D0,#00,#00,#D1,#00,#00,#D1,#D1,#00,#00,#00
	defb #00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00
	defb #00,#00,#00,#00,#D1,#00,#D3,#00,#D1,#00,#00,#00,#D1,#00,#D1,#00
	defb #D1,#00,#00,#CE,#D1,#00,#00,#00,#00,#D1,#00,#00,#CF,#00,#D0,#00
	defb #00,#00,#00,#D1,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #D1,#00,#00,#00,#00,#D1,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#D1,#00,#00,#D0,#00,#00,#00,#D1,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#D1,#00,#D0,#D3,#00,#D1,#00,#00,#00,#D1,#00
	defb #00,#00,#00,#00,#00,#00,#D1,#00,#00,#D3,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#D3,#CE,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00
	defb #00,#00,#00,#00,#00,#D1,#00,#00,#D1,#00,#D1,#00,#00,#00,#00,#00
	defb #D1,#00,#00,#00,#00,#D3,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #D1,#00,#00,#00,#00,#00,#C9,#D1,#00,#00,#D3,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1
	defb #00,#00,#D0,#00,#D3,#00,#00,#00,#D1,#00,#00,#D1,#00,#00,#CA,#CB
	defb #00,#D1,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00
	defb #00,#10,#00,#00,#D1,#00,#00,#00,#00,#00,#D1,#00,#10,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#D0,#00,#00,#00,#00,#00,#00
	defb #D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#33,#34,#35,#36
	defb #00,#D1,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#D1,#00,#00,#00,#10
	defb #00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#3F,#40
	defb #41,#42,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#D1
	defb #D3,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#00
	defb #D1,#00,#D3,#00,#00,#00,#00,#00,#00,#00,#00,#D1,#00,#00,#00,#D1
	defb #00,#00,#10,#00,#00,#00,#00,#00,#D3,#00,#00,#00,#00,#00,#86,#87
	defb #88,#89,#8A,#8B,#8C,#00,#00,#00,#D3,#D1,#00,#00,#00,#00,#00,#00
	defb #00,#A9,#AA,#AB,#AC,#AD,#AE,#AF,#00,#00,#00,#00,#CF,#00,#00,#00
	defb #00,#00,#00,#00,#00,#D1,#00,#00,#00,#00,#00,#BC,#BD,#BE,#BF,#00
	defb #00,#00,#BC,#BD,#BE,#BF,#00,#D3,#00,#BC,#BD,#BE,#BF,#00,#00,#00
	defb #00,#00,#00,#BC,#BD,#BE,#BF,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#D1,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #27,#28,#29,#2A,#27,#28,#29,#2A,#00,#00,#00,#00,#00,#00,#00,#00
	defb #11,#12,#13,#00,#00,#00,#27,#28,#29,#2A,#00,#11,#12,#13,#00,#00
	defb #00,#27,#28,#29,#2A,#27,#28,#29,#2A,#00,#00,#00,#27,#28,#29,#2A
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#2F,#30,#31,#32
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#11,#12
	defb #13,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#3B,#3C
	defb #3D,#3E,#00,#00,#27,#28,#29,#2A,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#27,#28,#29,#2A,#27,#28,#29,#2A,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#27,#28,#29,#2A,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#11,#12,#13,#00,#00,#00,#00,#00,#00,#27,#28,#29,#7E,#7F,#80
	defb #81,#82,#83,#84,#85,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#A1,#A2,#A3,#A4,#A5,#A6,#A7,#A8,#00,#00,#00,#00,#00,#00,#27
	defb #28,#29,#2A,#00,#00,#00,#00,#00,#00,#00,#00,#B8,#B9,#BA,#BB,#00
	defb #00,#00,#B8,#B9,#BA,#BB,#00,#00,#00,#B8,#B9,#BA,#BB,#00,#00,#00
	defb #00,#00,#00,#B8,#B9,#BA,#BB,#00,#00,#00,#00,#00,#27,#28,#29,#2A
	defb #27,#28,#29,#2A,#00,#00,#00,#00,#00,#00,#00,#C6,#C7,#C8,#27,#28
	defb #0B,#0C,#0D,#0E,#0F,#0B,#0C,#0D,#0E,#0F,#0B,#0C,#0D,#0E,#0F,#08
	defb #14,#15,#16,#17,#0B,#0C,#0D,#0E,#0F,#0B,#08,#14,#15,#16,#17,#0B
	defb #0C,#0D,#0D,#0B,#0C,#0D,#1F,#20,#0B,#0A,#0D,#1F,#20,#0C,#0A,#0D
	defb #0D,#0C,#1F,#20,#0C,#0B,#09,#0B,#0C,#1F,#20,#0E,#2B,#2C,#2D,#2E
	defb #0D,#24,#25,#25,#26,#0C,#0C,#0B,#0C,#0D,#0E,#0F,#0B,#0A,#14,#15
	defb #16,#17,#0B,#0C,#0D,#24,#25,#25,#26,#0D,#0E,#0F,#0B,#0C,#37,#38
	defb #39,#3A,#0D,#0E,#0D,#0C,#0B,#0C,#0D,#0F,#0D,#54,#55,#56,#57,#58
	defb #59,#5A,#5B,#5C,#5D,#5E,#5F,#58,#59,#5A,#59,#5B,#5C,#5D,#55,#56
	defb #57,#58,#59,#5A,#5B,#5C,#5D,#5E,#5F,#5E,#5B,#60,#0B,#0C,#0D,#0E
	defb #0F,#14,#15,#16,#17,#0B,#0C,#0D,#0E,#0F,#0D,#74,#75,#76,#77,#78
	defb #79,#7A,#7B,#7C,#7D,#54,#55,#56,#57,#58,#59,#5A,#5B,#5C,#5D,#5E
	defb #60,#97,#98,#99,#9A,#9B,#9C,#9D,#9E,#9F,#A0,#0B,#0C,#0D,#0E,#0F
	defb #1F,#20,#0D,#0E,#0B,#09,#0B,#0D,#0E,#0F,#0B,#B4,#B5,#B6,#B7,#54
	defb #55,#60,#B4,#B5,#B6,#B7,#54,#57,#60,#B4,#B5,#B6,#B7,#54,#5A,#5F
	defb #5C,#5A,#60,#B4,#B5,#B6,#B7,#24,#25,#26,#0B,#0F,#0B,#0C,#0D,#0E
	defb #0C,#0B,#0C,#0D,#0E,#0B,#09,#0C,#0D,#0E,#0F,#C3,#C4,#C5,#0E,#0F
	defb #06,#07,#08,#09,#0A,#06,#07,#08,#09,#0A,#06,#07,#08,#09,#0A,#18
	defb #19,#1A,#1B,#1C,#06,#07,#08,#09,#0A,#06,#18,#19,#1A,#1B,#1C,#07
	defb #08,#09,#0A,#06,#07,#08,#1D,#1E,#07,#07,#08,#1D,#1E,#06,#07,#08
	defb #09,#09,#1D,#1E,#08,#09,#0A,#08,#08,#1D,#1E,#09,#06,#07,#08,#09
	defb #09,#21,#22,#22,#23,#09,#08,#09,#08,#07,#09,#08,#09,#18,#19,#1A
	defb #1B,#1C,#07,#08,#09,#21,#22,#22,#23,#08,#09,#08,#09,#08,#07,#09
	defb #08,#07,#08,#08,#09,#09,#08,#07,#07,#06,#08,#50,#51,#52,#52,#61
	defb #62,#63,#52,#61,#62,#63,#52,#51,#64,#62,#63,#52,#51,#51,#66,#67
	defb #68,#69,#52,#51,#52,#66,#67,#69,#52,#61,#69,#53,#06,#07,#08,#09
	defb #18,#19,#1A,#1B,#1C,#0A,#06,#07,#08,#09,#06,#6A,#6B,#6C,#6D,#6E
	defb #6F,#70,#71,#72,#73,#50,#51,#64,#68,#63,#52,#51,#61,#62,#63,#52
	defb #53,#8D,#8E,#8F,#90,#91,#92,#93,#94,#95,#96,#06,#07,#08,#09,#0A
	defb #1D,#1E,#08,#09,#08,#07,#08,#08,#09,#0A,#06,#B0,#B1,#B2,#B3,#50
	defb #51,#53,#B0,#B1,#B2,#B3,#50,#52,#53,#B0,#B1,#B2,#B3,#50,#61,#62
	defb #65,#51,#53,#B0,#B1,#B2,#B3,#21,#22,#23,#08,#09,#0A,#06,#07,#08
	defb #06,#08,#06,#07,#08,#08,#07,#06,#07,#08,#09,#C0,#C1,#C2,#08,#09
	defb #01,#02,#03,#04,#03,#01,#02,#03,#04,#05,#01,#02,#03,#04,#03,#01
	defb #02,#03,#04,#03,#01,#02,#03,#04,#04,#01,#02,#03,#04,#03,#01,#02
	defb #03,#04,#03,#01,#02,#03,#04,#04,#01,#02,#03,#04,#03,#01,#02,#03
	defb #04,#03,#01,#02,#03,#04,#04,#01,#02,#03,#04,#03,#01,#02,#03,#04
	defb #03,#01,#02,#03,#04,#04,#01,#02,#03,#04,#04,#01,#02,#03,#03,#04
	defb #05,#02,#02,#03,#04,#05,#02,#03,#04,#05,#01,#02,#03,#04,#04,#01
	defb #02,#03,#04,#03,#01,#02,#03,#04,#04,#03,#05,#43,#44,#45,#46,#4D
	defb #4A,#4B,#49,#49,#4A,#4D,#4B,#49,#45,#45,#4D,#44,#45,#48,#4A,#4C
	defb #4E,#4C,#4A,#48,#46,#46,#46,#44,#45,#45,#45,#53,#01,#02,#03,#04
	defb #04,#01,#02,#03,#04,#03,#01,#02,#03,#04,#01,#02,#03,#04,#05,#02
	defb #02,#03,#04,#05,#01,#43,#44,#45,#46,#47,#48,#49,#4A,#4B,#4C,#4D
	defb #4F,#01,#02,#03,#04,#03,#01,#02,#03,#04,#05,#01,#02,#03,#04,#04
	defb #01,#02,#03,#04,#03,#01,#02,#03,#04,#03,#01,#02,#03,#04,#04,#43
	defb #44,#4F,#01,#02,#03,#01,#43,#49,#53,#01,#02,#03,#01,#43,#45,#45
	defb #47,#4A,#4F,#01,#02,#03,#04,#05,#02,#02,#03,#04,#05,#03,#02,#03
	defb #04,#03,#01,#02,#03,#04,#04,#01,#02,#03,#04,#05,#01,#02,#03,#01

	ENDIF

	IF JU2=1

	ORG	32768

	; VIRTUAL

	; INFO DEL MARCADOR

	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#FB,#F3,#F3,#F3,#F7,#73,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#FB,#F3,#F3,#F3,#F7
	defb #73,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BB
	defb #FF,#33,#33,#33,#FF,#77,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#BB,#FF,#33,#33,#33,#FF,#77,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FB,#7F,#7F,#3F,#3F,#3F,#BF,#BF,#F7,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FB,#7F,#7F,#3F,#3F,#3F,#BF
	defb #BF,#F7,#FF,#FF,#FF,#FF,#FF,#FF,#C3,#C3,#C3,#C3,#C3,#D7,#FB,#77
	defb #7F,#CC,#CC,#CC,#BF,#BB,#F7,#EB,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3
	defb #D7,#FB,#77,#7F,#CC,#CC,#CC,#BF,#BB,#F7,#EB,#C3,#C3,#C3,#C3,#C3
	defb #83,#03,#03,#03,#03,#57,#B3,#3F,#EE,#CC,#CC,#CC,#77,#3F,#73,#FF
	defb #03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03
	defb #03,#03,#03,#03,#03,#03,#03,#03,#FF,#B3,#3F,#FF,#FF,#FF,#FF,#FF
	defb #3F,#73,#AB,#03,#03,#03,#03,#43,#83,#03,#03,#03,#03,#FF,#B3,#6E
	defb #CC,#CC,#CC,#CC,#37,#BF,#73,#FF,#AB,#03,#03,#03,#03,#03,#03,#03
	defb #03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#57
	defb #FF,#B3,#7F,#EF,#BA,#30,#75,#DF,#BF,#73,#FF,#AB,#03,#03,#03,#43
	defb #FF,#FF,#FF,#FF,#FF,#FB,#37,#CC,#DD,#FF,#CC,#CC,#37,#FF,#3B,#F7
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FB,#37,#DD,#67,#EE,#CC,#DD,#9B
	defb #EE,#3B,#F7,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FB,#37,#CC
	defb #FB,#CF,#EE,#CC,#37,#FF,#3B,#F7,#FF,#FF,#FF,#FF,#FF,#FF,#F3,#B7
	defb #F3,#B7,#F3,#B7,#F3,#B7,#F3,#B7,#F3,#B7,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FB,#37,#FF,#67,#BA,#30,#75,#9B,#FF,#3B,#F7,#FF,#FF,#FF,#FF,#FF
	defb #C3,#C3,#C3,#C3,#FF,#B3,#6E,#DD,#6D,#CF,#F7,#CC,#37,#EE,#BF,#73
	defb #FF,#C3,#C3,#C3,#C3,#FF,#F3,#B7,#F3,#B7,#F3,#B7,#F3,#B7,#F3,#B7
	defb #F3,#B7,#EB,#C3,#C3,#C3,#C3,#FF,#B3,#6E,#BB,#9F,#EE,#CC,#DD,#6F
	defb #77,#9D,#73,#FF,#C3,#C3,#C3,#C3,#83,#03,#03,#03,#FF,#B3,#6E,#BE
	defb #9E,#DB,#B7,#EE,#37,#EE,#BF,#73,#FF,#AB,#03,#03,#03,#FF,#1D,#1D
	defb #1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#AB,#03,#03,#03,#57,#FF
	defb #B3,#7F,#BB,#9F,#BA,#30,#75,#6F,#77,#BF,#73,#FF,#AB,#03,#03,#43
	defb #83,#03,#03,#57,#FB,#37,#CC,#BE,#3C,#F3,#3F,#EE,#37,#EE,#DD,#3B
	defb #F7,#AB,#03,#03,#03,#FF,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D
	defb #1D,#1D,#AB,#03,#03,#03,#FF,#FB,#37,#DD,#33,#9F,#EE,#CC,#DD,#6F
	defb #33,#EE,#3B,#F7,#AB,#03,#03,#43,#FF,#FF,#FF,#FF,#FB,#37,#DD,#DB
	defb #E7,#F3,#3B,#EE,#37,#EE,#DD,#3B,#F7,#FF,#FF,#FF,#AB,#FF,#1D,#1D
	defb #1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#1D,#FF,#FF,#FF,#FF,#FF,#FB
	defb #37,#FF,#33,#9F,#BA,#30,#75,#6F,#33,#FF,#3B,#F7,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#B3,#6E,#DD,#E6,#D9,#B3,#33,#7F,#37,#EE,#CC,#BF
	defb #73,#FF,#FF,#FF,#FF,#FF,#0F,#1F,#0F,#1F,#0F,#1F,#0F,#1F,#0F,#1F
	defb #0F,#1F,#FF,#FF,#FF,#FF,#FF,#B3,#6E,#BB,#67,#3F,#EE,#CC,#DD,#3F
	defb #9B,#77,#9D,#73,#FF,#FF,#FF,#FF,#C3,#C3,#D7,#FF,#B3,#6E,#DD,#7C
	defb #EC,#33,#37,#7F,#37,#EE,#CC,#BF,#73,#FF,#C3,#C3,#D7,#FF,#0F,#1F
	defb #0F,#1F,#0F,#1F,#0F,#1F,#0F,#1F,#0F,#1F,#FF,#C3,#C3,#C3,#FF,#B3
	defb #7F,#BB,#67,#3F,#BA,#30,#75,#3F,#9B,#77,#BF,#73,#FF,#C3,#C3,#C3
	defb #83,#03,#57,#FB,#37,#CC,#FE,#7C,#FC,#D9,#3B,#7F,#37,#EE,#CC,#DD
	defb #3B,#F7,#AB,#03,#43,#FF,#0F,#1F,#0F,#1F,#0F,#1F,#0F,#1F,#0F,#1F
	defb #0F,#1F,#EB,#83,#03,#57,#FB,#37,#DD,#33,#67,#3F,#EE,#CC,#DD,#3F
	defb #9B,#33,#EE,#3B,#F7,#03,#03,#43,#83,#03,#FF,#FB,#37,#CC,#BE,#FC
	defb #FC,#D9,#37,#7F,#37,#EE,#CC,#DD,#3B,#F7,#AB,#03,#03,#D7,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#C3,#03,#03,#FF,#FB,#37
	defb #FF,#33,#67,#3F,#BA,#30,#75,#3F,#9B,#33,#FF,#3B,#F7,#AB,#03,#43
	defb #FF,#FF,#FF,#B3,#6E,#CC,#BE,#FC,#CC,#9B,#37,#7F,#37,#EE,#CC,#CC
	defb #BF,#73,#FF,#FF,#AB,#43,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#EB,#83,#57,#FF,#FF,#B3,#6E,#BB,#33,#9F,#3F,#EE,#CC,#DD,#3F
	defb #6F,#33,#77,#9D,#73,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#6E,#DD,#CC,#CC
	defb #CF,#33,#33,#7F,#37,#EE,#CC,#CC,#BF,#73,#FF,#03,#FF,#03,#C3,#C3
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#03,#FF,#03,#FF,#B3,#7F
	defb #BB,#33,#9F,#3F,#AF,#0F,#5F,#3F,#6F,#33,#77,#BF,#73,#FF,#FF,#FF
	defb #C3,#D7,#FB,#37,#CC,#DD,#9E,#CF,#33,#33,#37,#EE,#37,#EE,#CC,#CC
	defb #DD,#3B,#F7,#03,#57,#AB,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03
	defb #03,#03,#57,#AB,#03,#FB,#37,#DD,#33,#33,#9F,#3F,#EE,#CC,#DD,#3F
	defb #6F,#33,#33,#EE,#3B,#F7,#C3,#C3,#83,#57,#FB,#37,#CC,#DD,#9E,#9B
	defb #33,#33,#37,#EE,#37,#EE,#CC,#CC,#DD,#3B,#F7,#AB,#03,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#03,#57,#FB,#37,#FF
	defb #33,#67,#BD,#3F,#AF,#0F,#5F,#3F,#7E,#9B,#33,#FF,#3B,#F7,#AB,#43
	defb #83,#FF,#B3,#6E,#CC,#DD,#6D,#F3,#33,#33,#7F,#CC,#37,#EE,#CC,#CC
	defb #CC,#BF,#73,#FF,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03
	defb #03,#03,#03,#03,#FF,#B3,#6E,#BB,#33,#9B,#76,#3F,#EE,#CC,#DD,#3F
	defb #B9,#67,#33,#77,#9D,#73,#AB,#43,#FF,#FF,#B3,#6E,#CC,#DD,#9E,#F3
	defb #33,#3F,#EE,#CC,#37,#EE,#CC,#CC,#CC,#BF,#73,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#7F,#BB
	defb #67,#33,#76,#3F,#AF,#0F,#5F,#3F,#B9,#33,#9B,#77,#BF,#73,#FF,#FF
	defb #FF,#FB,#37,#CC,#CC,#DD,#F3,#79,#B7,#FF,#CC,#CC,#37,#EE,#CC,#CC
	defb #CC,#DD,#3B,#F7,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FB,#37,#DD,#33,#9B,#33,#33,#BD,#EE,#CC,#DD,#7E	
	defb #33,#33,#67,#33,#EE,#3B,#F7,#FF,#C3,#FB,#37,#CC,#CC,#DD,#FF,#FF
	defb #FF,#BF,#EE,#CC,#37,#EE,#CC,#CC,#CC,#DD,#3B,#F7,#EB,#C3,#C3,#C3
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#D7,#FB,#37,#FF,#67
	defb #33,#33,#33,#BD,#AF,#0F,#5F,#7E,#33,#33,#33,#9B,#FF,#3B,#F7,#C3
	defb #D7,#FF,#6E,#CC,#CC,#CC,#CC,#CC,#FB,#7F,#CC,#CC,#37,#EE,#CC,#CC
	defb #CC,#CC,#BF,#FF,#FF,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03
	defb #03,#03,#03,#FF,#FF,#6E,#BB,#9B,#33,#33,#33,#76,#EE,#CC,#DD,#B9
	defb #33,#33,#33,#67,#77,#9D,#FF,#43,#D7,#F7,#EE,#CC,#CC,#CC,#CC,#CC
	defb #FF,#BF,#EE,#CC,#37,#EE,#CC,#CC,#CC,#CC,#FF,#FB,#FF,#AB,#03,#03
	defb #03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#57,#FF,#F7,#FF,#EF,#33
	defb #33,#33,#33,#76,#AF,#0F,#5F,#B9,#33,#33,#33,#33,#DF,#FF,#FB,#EB
	defb #FF,#B3,#7F,#CC,#CC,#CC,#CC,#CC,#BF,#F7,#CC,#CC,#37,#EE,#CC,#CC
	defb #CC,#CC,#BF,#73,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#B3,#7F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#BF,#73,#FF,#FF,#B3,#EE,#CC,#CC,#CC,#CC,#CC
	defb #DD,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#73,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#EE,#CC,#CC
	defb #CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#DD,#73,#FF
	defb #FF,#FF,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F
	defb #3F,#3F,#3F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F
	defb #3F,#3F,#3F,#3F,#3F,#3F,#FF,#FF,#FF,#FB,#33,#33,#33,#33,#33,#33
	defb #33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#F7,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FB,#33,#33,#33
	defb #33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#F7,#FF
	defb #FF,#FB,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3
	defb #F3,#F3,#F7,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FB,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3,#F3
	defb #F3,#F3,#F3,#F3,#F3,#F7,#FF,#FF


	ORG	43008

	; CARACTERES DECORADO

	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#77,#FF,#DF,#FF,#F7,#73,#E7,#FF,#F7,#FF,#DF,#FF,#77,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#30
	defb #FF,#FF,#FF,#F7,#FF,#7F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#BA,#FF,#FA,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FD,#FF,#FD,#FF,#7D,#BC,#BC,#FF,#7D,#FF,#FD,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FA,#FF,#9A,#FF,#DB,#BA,#6F,#BA,#B5,#EF,#B0,#EF,#F0
	defb #FF,#FF,#30,#FF,#30,#75,#30,#75,#B0,#DD,#CC,#30,#30,#B8,#30,#30
	defb #FF,#FF,#FF,#F7,#FB,#37,#FB,#3F,#BB,#3F,#FF,#7F,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#BB,#FF,#BF,#FF,#73,#FF,#F3,#BB,#9B,#BF,#33,#BF,#33
	defb #73,#3F,#B3,#37,#73,#37,#3B,#37,#37,#3F,#F3,#37,#33,#3F,#33,#37
	defb #FF,#FF,#7F,#FF,#7F,#FF,#9D,#FF,#3F,#FF,#3F,#7F,#3F,#DD,#3F,#FF
	defb #EF,#DD,#E7,#4C,#A6,#9D,#EE,#7F,#FF,#FF,#DF,#7F,#6E,#FF,#1D,#FF
	defb #8E,#1D,#F7,#B7,#FF,#DD,#E6,#FF,#F3,#EE,#CE,#DD,#3F,#DD,#3F,#DD
	defb #FF,#E7,#FB,#8E,#BF,#0C,#FF,#BF,#FB,#DF,#E7,#1D,#CF,#8E,#EF,#1D
	defb #CA,#E7,#CF,#DB,#E7,#B7,#1D,#3F,#AE,#3F,#BF,#3F,#FF,#CC,#FF,#FF
	defb #E6,#FF,#E6,#7F,#FB,#DD,#EE,#FF,#FF,#FB,#DD,#E6,#7F,#A6,#FF,#EE
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FA,#FF,#FA,#FF,#EF,#FF,#EF,#FF,#B0
	defb #FA,#30,#B0,#9A,#DF,#FF,#75,#75,#BA,#FF,#BA,#FF,#BA,#FF,#BA,#FF
	defb #75,#FF,#DF,#30,#30,#BA,#EF,#BA,#FA,#BA,#FF,#30,#FF,#DF,#FF,#DF
	defb #FF,#FF,#FF,#FF,#F5,#FF,#F0,#FF,#F0,#DF,#F0,#DF,#70,#CF,#30,#E5
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#B3,#FB,#39,#FF,#79,#7D,#BE,#3C,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#7F,#BF,#B3,#99,#F3,#6E,#39,#33,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#F3,#6E,#79,#E6,#36,#F3,#CC,#79,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#7F,#FF,#3F,#FF,#EE,#DD
	defb #FA,#9A,#BA,#F0,#BF,#E5,#FF,#7A,#FF,#35,#FF,#BA,#FF,#FF,#FF,#FF
	defb #30,#30,#30,#30,#B0,#64,#30,#DD,#CC,#75,#B0,#FF,#FF,#FF,#FF,#FF
	defb #AF,#FF,#3F,#7F,#4E,#DD,#3F,#7F,#AF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BB,#FF,#B7,#FF,#3F,#FF,#BF
	defb #BB,#3F,#BB,#33,#FF,#B3,#FF,#73,#FF,#BF,#7F,#BB,#7F,#FF,#FF,#FF
	defb #33,#3F,#3F,#6E,#33,#3F,#33,#3F,#33,#37,#3F,#6E,#73,#3F,#FF,#FF
	defb #DD,#7F,#3F,#7F,#3F,#FF,#3F,#FF,#7F,#FF,#DD,#FF,#FF,#FF,#FF,#FF
	defb #7F,#8C,#FF,#FF,#EF,#F7,#CF,#E2,#CF,#E2,#F3,#C0,#D9,#95,#EA,#6A
	defb #FE,#FC,#FE,#FC,#FE,#7C,#FE,#7C,#FE,#7C,#FE,#3C,#FE,#7C,#FF,#7D
	defb #FC,#FC,#FC,#FC,#FC,#FC,#BC,#FC,#BC,#FC,#3C,#FC,#FC,#FC,#FF,#FF
	defb #FF,#B0,#FF,#DF,#FF,#DF,#FF,#DF,#FF,#75,#BA,#75,#BA,#75,#FA,#BA
	defb #BA,#FF,#75,#FF,#75,#FF,#75,#FF,#75,#FF,#75,#FF,#75,#FF,#FF,#FF
	defb #FF,#DF,#FF,#75,#FF,#75,#FF,#30,#FF,#EF,#FF,#EF,#FF,#38,#BE,#BE
	defb #30,#F0,#70,#F0,#30,#F0,#BA,#70,#BA,#70,#BA,#30,#BA,#30,#BA,#30
	defb #F5,#FF,#F5,#FF,#F0,#FF,#F0,#FF,#70,#F5,#70,#F5,#30,#F5,#30,#F0
	defb #73,#BF,#77,#7B,#77,#73,#37,#B3,#77,#B7,#7F,#37,#7D,#37,#7D,#6E
	defb #B7,#6E,#37,#3B,#3F,#3B,#3F,#3F,#6E,#9D,#3B,#CC,#3B,#37,#3F,#73
	defb #FF,#CC,#DD,#7B,#CC,#7B,#B7,#9D,#B3,#3F,#3F,#6E,#9D,#7F,#FF,#CC
	defb #F3,#3F,#B7,#3F,#37,#3F,#B3,#6E,#99,#6E,#9D,#99,#66,#BB,#B7,#DD
	defb #37,#6E,#6E,#3F,#6E,#9D,#37,#EE,#3F,#99,#37,#33,#37,#66,#66,#6E
	defb #7F,#FF,#3F,#FF,#9D,#7F,#9D,#7F,#73,#3F,#B7,#3F,#B7,#3F,#37,#3F
	defb #FF,#FB,#FF,#EF,#FF,#EF,#FF,#F3,#FF,#DB,#FF,#9B,#FB,#B3,#FB,#9B
	defb #0C,#3F,#BF,#7F,#BF,#FF,#FF,#FF,#FF,#8E,#EF,#CF,#EF,#E7,#CA,#F3
	defb #FE,#7C,#FE,#DC,#FE,#AD,#FB,#AD,#FB,#FC,#FB,#FD,#FB,#F6,#EF,#F3
	defb #FC,#FC,#FC,#FC,#5E,#FF,#5E,#FC,#FC,#FC,#FC,#FE,#FC,#FC,#FC,#FC
	defb #AB,#03,#AB,#A9,#AB,#03,#AB,#03,#AB,#03,#AB,#03,#AB,#A9,#AB,#03
	defb #43,#C3,#57,#EB,#56,#57,#03,#57,#03,#03,#03,#03,#03,#03,#03,#03
	defb #C3,#3F,#6B,#3F,#C3,#97,#97,#97,#EB,#97,#EB,#97,#57,#97,#FD,#C3
	defb #7F,#FB,#FF,#FF,#CF,#FF,#DB,#DD,#E2,#F7,#CA,#D5,#CF,#C4,#C0,#6E
	defb #EF,#BA,#EF,#BA,#EF,#BA,#FA,#BA,#BA,#BA,#B0,#BA,#F5,#75,#DF,#75
	defb #BE,#57,#BE,#43,#BE,#EB,#BE,#DD,#BE,#8D,#BE,#8D,#BE,#AF,#FF,#7D
	defb #38,#30,#FE,#30,#56,#30,#56,#30,#FE,#30,#DC,#30,#DC,#30,#DC,#30
	defb #30,#F0,#30,#70,#30,#70,#30,#70,#30,#70,#30,#30,#30,#30,#30,#30
	defb #FF,#FF,#FF,#FF,#F5,#FF,#F5,#FF,#F5,#FF,#F5,#FF,#F5,#FF,#F0,#FF
	defb #BB,#6E,#FB,#6E,#BB,#D9,#BF,#D9,#7F,#3B,#3F,#3B,#B7,#BF,#7B,#7F
	defb #37,#EE,#B7,#7F,#37,#6E,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#6E,#FF,#FF
	defb #9D,#DD,#CC,#BF,#EE,#99,#99,#CC,#D9,#6E,#D9,#37,#EE,#B7,#FF,#FF
	defb #9D,#6E,#9D,#CC,#6E,#BF,#CC,#66,#BB,#B7,#99,#B7,#DD,#3F,#FF,#FF
	defb #99,#B7,#73,#3F,#73,#3F,#99,#B7,#9D,#77,#CC,#7F,#6E,#FF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#BE,#FF,#3C,#BE,#39,#EF,#3C,#B6,#33,#39,#3B
	defb #BB,#6E,#FB,#6E,#BB,#D9,#BF,#D9,#FF,#3B,#FF,#3B,#FF,#BF,#FF,#FF
	defb #FF,#AF,#FF,#6C,#BE,#4E,#BE,#4E,#3C,#85,#79,#A7,#2D,#E2,#D1,#0F
	defb #DD,#FF,#CC,#FF,#CC,#DD,#CC,#DD,#CC,#CC,#4E,#CC,#4E,#CC,#0F,#CC
	defb #FF,#FF,#FF,#FF,#FF,#FF,#5D,#FF,#FF,#5D,#FF,#FF,#FF,#FF,#AE,#FF
	defb #AB,#03,#AB,#03,#AB,#03,#AB,#A9,#AB,#03,#AB,#03,#AB,#03,#AB,#03
	defb #03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03,#03
	defb #57,#97,#57,#C3,#03,#EB,#03,#EB,#56,#BF,#57,#BF,#EB,#BF,#BE,#C3
	defb #AE,#1D,#CC,#3F,#EE,#FF,#FF,#FB,#FF,#E7,#DF,#EF,#A6,#FF,#F3,#FF
	defb #FF,#FF,#BF,#DD,#F7,#6F,#F3,#6F,#CE,#FF,#FF,#5D,#AE,#E6,#EE,#F7
	defb #FF,#FF,#DF,#EE,#E6,#EF,#E6,#7B,#9D,#6E,#EF,#5D,#3F,#F7,#FF,#7F
	defb #DF,#75,#DF,#75,#F5,#75,#75,#75,#75,#75,#30,#EE,#75,#CC,#FF,#CC
	defb #FF,#FE,#FF,#FF,#FF,#FA,#FF,#EF,#FF,#EF,#FF,#EF,#FF,#FA,#FF,#BA
	defb #FE,#30,#FD,#30,#FF,#30,#75,#30,#75,#30,#75,#30,#75,#30,#75,#30	
	defb #30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30
	defb #70,#EE,#70,#8C,#70,#EE,#70,#EE,#70,#FF,#F0,#F5,#F0,#F5,#F0,#F5
	defb #BB,#9B,#BF,#CF,#BF,#67,#6F,#3F,#9E,#E6,#9B,#67,#B3,#33,#33,#3F
	defb #FF,#FF,#FF,#FF,#7F,#FF,#66,#FF,#3F,#DD,#37,#7F,#37,#CC,#3F,#CC
	defb #FF,#DF,#FF,#FF,#FF,#FF,#EF,#FF,#FF,#EF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #D1,#0F,#4A,#0F,#0F,#0F,#0F,#0F,#AF,#8F,#AF,#0F,#FF,#4E,#FF,#EE
	defb #0F,#CC,#0F,#CC,#0E,#CC,#4E,#CC,#4E,#DD,#CC,#DD,#CC,#FF,#DD,#FF
	defb #9D,#7F,#3F,#7F,#7F,#FF,#FF,#CF,#FB,#DB,#EF,#CF,#FF,#CF,#FB,#DB
	defb #AB,#03,#AB,#A9,#AB,#03,#AB,#03,#AB,#03,#AB,#03,#AB,#03,#AB,#A9
	defb #BE,#C3,#EB,#EB,#57,#BF,#56,#BF,#03,#EB,#03,#EB,#57,#C3,#FD,#C3
	defb #DD,#EE,#E6,#FF,#A6,#FB,#7F,#D9,#FF,#AE,#FF,#FF,#FB,#DF,#E7,#8E
	defb #E6,#FF,#E7,#FF,#8E,#7F,#CC,#7F,#9D,#FF,#3F,#FB,#FF,#CF,#FF,#E7
	defb #FF,#F7,#FB,#E6,#EF,#E6,#FF,#5D,#F7,#FF,#1D,#FB,#9D,#EF,#7F,#FF
	defb #FF,#FF,#7F,#FF,#FF,#EF,#6F,#FF,#EE,#F7,#FF,#B7,#7F,#3F,#DD,#BF
	defb #FF,#BA,#FF,#BA,#FF,#FA,#FF,#EF,#FF,#EF,#FF,#EF,#FF,#EF,#FF,#EF
	defb #75,#30,#75,#30,#75,#30,#75,#30,#75,#30,#75,#30,#75,#30,#75,#30
	defb #70,#F5,#70,#F5,#30,#F0,#30,#F0,#70,#F0,#70,#F0,#70,#30,#30,#30
	defb #FF,#FF,#FF,#EE,#EE,#FB,#FB,#EE,#F3,#DD,#E6,#DD,#EE,#DD,#EE,#FF
	defb #FF,#FF,#EE,#FF,#E6,#DD,#EE,#DD,#FF,#FB,#FF,#EF,#DD,#EF,#DD,#EF
	defb #FB,#CE,#EF,#9E,#E7,#67,#9B,#73,#9B,#33,#B3,#33,#33,#37,#33,#3F
	defb #FB,#3F,#FB,#3F,#FF,#B7,#FF,#6E,#FF,#FB,#FF,#7B,#BF,#9D,#BF,#6E
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#7F,#FF,#6E,#FF,#EE,#DD
	defb #A6,#5D,#2E,#7F,#3F,#DD,#3F,#DD,#6E,#DD,#CC,#FF,#BF,#77,#FF,#FF
	defb #AB,#03,#AB,#03,#AB,#03,#AB,#03,#AB,#03,#AB,#A9,#AB,#03,#FF,#FF
	defb #03,#03,#03,#03,#03,#03,#03,#57,#56,#57,#57,#EB,#43,#C3,#FF,#FF
	defb #57,#C3,#EB,#97,#EB,#3F,#C3,#3F,#C3,#6B,#97,#3F,#6B,#6B,#FF,#FF
	defb #E7,#DD,#DB,#1D,#59,#9D,#CC,#7F,#EE,#FF,#FF,#FB,#7F,#E7,#5D,#A6
	defb #FF,#FF,#FF,#DF,#FB,#DF,#FB,#4C,#FF,#5D,#DD,#EE,#E6,#FB,#DF,#9D
	defb #EE,#FF,#FB,#DD,#E7,#5D,#AE,#FF,#FF,#FF,#DD,#EF,#DD,#DB,#FF,#AE
	defb #FB,#FF,#E7,#DD,#AE,#DD,#DF,#FB,#5D,#FB,#6E,#FF,#6E,#EE,#DD,#DF
	defb #DD,#BA,#DD,#FA,#FF,#FA,#EE,#FA,#CC,#FA,#CC,#98,#EE,#DD,#EE,#DD
	defb #30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#30,#75,#FF,#EE
	defb #30,#30,#30,#30,#30,#30,#30,#30,#30,#BA,#75,#DD,#FF,#CC,#EE,#CC
	defb #DD,#BE,#CC,#BE,#EE,#BB,#FF,#BB,#DD,#BE,#DD,#BE,#FF,#BE,#EE,#BF
	defb #FB,#FF,#A6,#DD,#B7,#5D,#EE,#DD,#FF,#FF,#FF,#FF,#DD,#F7,#FB,#9F
	defb #6E,#FB,#6E,#FB,#7F,#BB,#CC,#CC,#BB,#6E,#B7,#6E,#B7,#6E,#37,#6E
	defb #CC,#3F,#33,#3F,#B7,#7F,#B7,#7F,#9D,#FF,#3F,#7F,#3F,#3F,#3B,#B7
	defb #F7,#FF,#DD,#DD,#FF,#5D,#FF,#4C,#BF,#5D,#AE,#CC,#AE,#CC,#FF,#AE
	defb #3B,#6E,#7F,#6E,#7F,#D9,#FF,#D9,#FF,#3B,#FF,#3B,#FF,#BF,#FF,#FF
	defb #BF,#A6,#DD,#7F,#5D,#FF,#FF,#CF,#FB,#D9,#EF,#CD,#EE,#CD,#EE,#CC
	defb #CC,#73,#9D,#3B,#DD,#3F,#B7,#BF,#3F,#EE,#3F,#EE,#6E,#99,#CC,#EE
	defb #FF,#BF,#FF,#7B,#FF,#73,#BF,#B3,#BB,#B7,#BB,#37,#BF,#37,#BB,#6E
	defb #FF,#DD,#CC,#F7,#DD,#DD,#DD,#FB,#FF,#E7,#FF,#A6,#DD,#EE,#DD,#FF
	defb #FB,#1D,#FF,#CC,#F7,#EE,#CF,#FF,#8E,#DD,#59,#DD,#4C,#FF,#CC,#FF
	defb #FF,#E6,#FB,#E7,#FF,#A6,#FF,#EE,#DB,#FF,#CF,#DD,#A6,#6E,#1D,#3F
	defb #FF,#BE,#FF,#BE,#FF,#BB,#FF,#BB,#FF,#BE,#FF,#BE,#FF,#BE,#FF,#BF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BB
	defb #FF,#FB,#FF,#B3,#BB,#B3,#BB,#33,#33,#33,#33,#33,#37,#3B,#33,#3F
	defb #33,#FF,#33,#3F,#37,#3F,#37,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F
	defb #FF,#FF,#FF,#FF,#7F,#BF,#3F,#FF,#3F,#CC,#3F,#CC,#3F,#6E,#3F,#6E
	defb #FF,#FF,#3F,#FF,#B7,#7F,#3F,#3F,#BF,#3F,#DD,#BF,#CC,#FF,#CC,#DD
	defb #FF,#FF,#FF,#FF,#FF,#FF,#DD,#FF,#CC,#3F,#6E,#3F,#6E,#6E,#EE,#9D
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#DD,#FF,#CC,#DD,#CC,#CC,#CC,#CC
	defb #DB,#37,#DB,#37,#B3,#3F,#37,#3F,#37,#3F,#3F,#3F,#3F,#3F,#37,#3F
	defb #6E,#CC,#6E,#CC,#6E,#CC,#3F,#CC,#3F,#6E,#3F,#6E,#3F,#6E,#3F,#6E
	defb #DD,#FF,#DD,#FF,#DD,#FF,#CC,#FF,#CC,#FF,#CC,#FF,#CC,#DD,#CC,#DD
	defb #FF,#FF,#FF,#FF,#FF,#FF,#EE,#CC,#CC,#CC,#CC,#DD,#CC,#DD,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#F7,#FF,#9D,#7F,#BF,#7B,#CC,#6E,#FF,#FF
	defb #FF,#BB,#FF,#BB,#FF,#33,#FF,#33,#FF,#33,#BB,#33,#33,#BB,#77,#FF
	defb #33,#3F,#33,#37,#33,#33,#33,#33,#33,#33,#33,#33,#33,#33,#BB,#BB
	defb #3F,#3F,#3F,#3F,#33,#3F,#33,#37,#33,#37,#33,#37,#33,#3F,#37,#7F
	defb #3F,#CC,#6E,#CC,#CC,#CC,#3F,#6E,#3F,#3F,#3F,#3F,#3F,#3F,#7F,#3F
	defb #CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#6E,#DD,#EE,#DD
	defb #FF,#CC,#DD,#EE,#CC,#FF,#CC,#DD,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#DD
	defb #6E,#CC,#CC,#CC,#CC,#CC,#FF,#6E,#DD,#EE,#9D,#7F,#CC,#9D,#FF,#FF
	defb #DD,#FF,#CC,#FF,#CC,#DD,#CC,#CC,#CC,#DD,#FF,#FF,#7F,#BF,#FF,#FF
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#BF,#FF,#EF,#FF,#9C
	defb #37,#3F,#33,#3F,#DB,#37,#73,#5C,#99,#37,#66,#9D,#73,#37,#33,#33
	defb #3F,#6E,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#6E,#3F,#3F,#3F,#3F
	defb #CC,#DD,#CC,#DD,#CC,#DD,#6E,#FF,#6E,#CC,#CC,#CC,#CC,#6E,#6E,#CC
	defb #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#DD,#FF,#DD,#FF,#DD,#FF
	defb #FF,#FF,#DF,#DD,#5D,#FF,#A6,#EF,#DD,#FF,#FF,#5D,#EF,#E6,#EE,#F7
	defb #FF,#FF,#5D,#FB,#5D,#E6,#DD,#E7,#FF,#EF,#FB,#7F,#D9,#7F,#EE,#7F
	defb #FF,#F7,#EF,#4C,#FF,#5D,#DD,#FF,#BF,#E6,#EE,#A6,#9D,#5D,#BF,#FF
	defb #FF,#DF,#EF,#F7,#FB,#4C,#FB,#AE,#FF,#5D,#6E,#A6,#DD,#F7,#BF,#FF
	defb #FF,#FF,#FF,#F7,#AE,#7F,#FB,#DD,#EE,#AE,#FF,#D9,#FF,#BF,#EE,#DF
	defb #FF,#FF,#FB,#FF,#7B,#5D,#A6,#FF,#EE,#FF,#5D,#FB,#F7,#E6,#FF,#EE
	defb #FF,#FF,#FB,#BF,#A6,#FF,#B7,#5D,#BF,#7F,#FF,#FF,#DD,#DD,#FF,#FF
	defb #FF,#B6,#FF,#DB,#DD,#9B,#FF,#9B,#FF,#E2,#FF,#BE,#FF,#FB,#FF,#E6
	defb #37,#3F,#37,#3F,#37,#3F,#33,#3F,#33,#3F,#33,#3F,#39,#37,#F3,#37
	defb #3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F
	defb #6E,#CC,#3F,#CC,#3F,#CC,#3F,#6E,#3F,#6E,#3F,#3F,#3F,#3F,#3F,#3F
	defb #CC,#EE,#6E,#AE,#3F,#FF,#9D,#FF,#CC,#DD,#CC,#DD,#CC,#DD,#CC,#DD
	defb #FF,#FF,#F7,#FB,#5D,#0C,#FF,#EE,#FB,#FF,#CD,#77,#CC,#FF,#FF,#FF
	defb #FF,#FF,#EF,#EE,#FB,#4C,#FF,#F7,#DF,#FF,#4C,#FB,#BF,#AE,#FF,#FF
	defb #EF,#FF,#DB,#CC,#AE,#E6,#FF,#7F,#DF,#FF,#E6,#EF,#1D,#FB,#BF,#FF
	defb #DF,#FF,#4C,#EF,#2E,#BF,#FF,#FF,#F7,#DD,#1D,#FF,#9D,#FB,#FF,#FF
	defb #FF,#FF,#FF,#F7,#EF,#7F,#FB,#4C,#BF,#4C,#FF,#DD,#EB,#FF,#EB,#EB
	defb #FF,#FF,#FF,#FF,#7F,#F7,#FB,#9F,#FB,#4C,#BF,#0C,#D7,#DD,#43,#FF
	defb #FF,#FF,#FB,#DD,#CD,#5D,#BF,#0C,#7F,#6E,#AB,#DD,#AB,#FF,#C3,#43
	defb #FF,#FF,#FF,#FF,#7F,#F7,#EF,#4C,#FB,#4C,#7F,#DD,#EB,#EB,#C3,#03
	defb #FF,#4C,#DD,#DD,#DD,#FF,#FF,#B3,#FB,#39,#FF,#79,#7D,#BE,#3C,#FF
	defb #FB,#CC,#EE,#5D,#FF,#FF,#7F,#BF,#B3,#99,#F3,#6E,#39,#33,#FF,#FF
	defb #A6,#DD,#FF,#FF,#FF,#FF,#F3,#6E,#79,#E6,#36,#F3,#CC,#79,#FF,#FF
	defb #FF,#FF,#DD,#FB,#3F,#FB,#7F,#D9,#7F,#EE,#FF,#FF,#EF,#F7,#EF,#8E
	defb #FF,#FF,#EF,#DD,#EE,#E6,#F7,#DD,#DD,#FB,#CC,#EF,#5D,#9F,#FF,#EE
	defb #DD,#AE,#FF,#FF,#FF,#F7,#EE,#5D,#EE,#FF,#FF,#FB,#DD,#DB,#DD,#AE
	defb #FF,#FF,#EF,#EE,#DB,#FB,#3F,#EE,#AE,#FF,#FF,#CC,#F7,#A6,#DD,#F7
	defb #DD,#FF,#CE,#EF,#E6,#FB,#B7,#FB,#7F,#FF,#FF,#DF,#EF,#F7,#FF,#A6
	defb #DD,#DD,#DD,#EF,#CE,#FB,#59,#BF,#F3,#FF,#FF,#7F,#BF,#A6,#FF,#1D
	defb #DF,#FF,#D9,#BF,#E6,#EF,#4C,#FB,#7F,#FF,#FF,#F7,#FB,#6E,#FF,#7F
	defb #DD,#EF,#F7,#6E,#6E,#B7,#7F,#2E,#7F,#FF,#EF,#FF,#BF,#DF,#FB,#5D
	defb #BF,#BF,#7F,#6E,#DD,#7B,#FB,#E6,#FF,#4C,#AE,#FF,#A6,#F7,#5D,#FF
	defb #FF,#EF,#DD,#CE,#7F,#DB,#FF,#A6,#FB,#FB,#8E,#7F,#F3,#7F,#5D,#EE
	defb #EF,#4C,#EE,#A6,#7F,#F7,#6E,#FF,#E6,#FB,#DD,#EF,#FF,#EE,#EF,#F7
	defb #D9,#B3,#CC,#D9,#33,#E6,#9B,#33,#73,#B3,#33,#33,#3B,#33,#3F,#3F
	defb #37,#3F,#B3,#3F,#D9,#B7,#73,#F3,#33,#3F,#9B,#33,#37,#3F,#3F,#3F
	defb #3F,#3F,#3F,#3F,#3F,#6E,#3F,#CC,#6E,#CC,#3F,#CC,#3F,#CC,#3F,#6E
	defb #CC,#DD,#CC,#EE,#FF,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#3F,#9D,#3F,#CC
	defb #FF,#CD,#DD,#D9,#CC,#EE,#CC,#FF,#CC,#FF,#CC,#DD,#CC,#DD,#CC,#DD
	defb #F7,#FF,#DD,#5F,#FF,#5F,#FF,#4E,#AF,#5F,#AF,#CC,#AF,#CC,#FF,#8D
	defb #FF,#FF,#DD,#5F,#DD,#DD,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#AF,#DD
	defb #AF,#FF,#8D,#FF,#8D,#EE,#EE,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	defb #FF,#EE,#DD,#E6,#EE,#EF,#EE,#FF,#FF,#FF,#FF,#AF,#FF,#4E,#5F,#5F
	defb #83,#C3,#AB,#C3,#EB,#C3,#EB,#C3,#83,#C3,#03,#C3,#AB,#C3,#EB,#C3
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3
	defb #C3,#C3,#C3,#C3,#D6,#C3,#A9,#C3,#A9,#C3,#03,#43,#83,#C3,#C3,#C3
	defb #C3,#C3,#C3,#C3,#D6,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3
	defb #C3,#57,#C3,#57,#C3,#57,#C3,#03,#C3,#83,#C3,#83,#C3,#83,#C3,#57
	defb #DD,#CC,#DD,#9D,#DD,#9D,#DD,#EE,#FF,#EE,#FF,#EE,#EE,#FF,#FF,#FF
	defb #BF,#FF,#2E,#FF,#B7,#2E,#DD,#FB,#FB,#FF,#F3,#5D,#73,#FB,#BF,#FB
	defb #EE,#FF,#8E,#FB,#9F,#DD,#BF,#DD,#FF,#DD,#5D,#EF,#9F,#EF,#3F,#EE
	defb #DF,#FF,#F3,#7F,#8C,#FF,#5D,#7F,#FF,#FF,#E6,#EF,#1D,#FF,#7F,#FF
	defb #FF,#BF,#FB,#9D,#F3,#CC,#FF,#A6,#F7,#FF,#8E,#FF,#3F,#AE,#7F,#FF
	defb #EF,#7B,#BF,#CE,#FF,#DD,#FF,#FF,#FF,#EF,#5D,#DB,#7F,#2E,#DD,#AE
	defb #FF,#CF,#DD,#9B,#DD,#9B,#FF,#9B,#FF,#9B,#FB,#33,#FB,#33,#EF,#33
	defb #37,#3B,#37,#3B,#37,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#37,#3F
	defb #3F,#3F,#B3,#3F,#37,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F
	defb #9D,#6E,#9D,#CC,#6E,#CC,#6E,#CC,#3F,#CC,#3F,#9D,#3F,#CC,#3F,#CC
	defb #CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#DD,#6E,#EE,#6E,#CC
	defb #DD,#8D,#DD,#0F,#DD,#1F,#DD,#AF,#FF,#AF,#FF,#AF,#EE,#FF,#FF,#FF
	defb #0F,#DD,#0F,#9D,#4E,#CC,#4E,#CC,#CC,#CC,#CC,#DD,#CC,#FF,#EE,#DD
	defb #4E,#EE,#4E,#FF,#0F,#FF,#8D,#FF,#8D,#5F,#CC,#5F,#CC,#DD,#CC,#DD
	defb #5F,#CD,#5F,#D9,#0F,#EE,#8D,#FF,#8D,#FF,#8D,#DD,#CC,#DD,#CC,#DD
	defb #EB,#C3,#43,#C3,#43,#C3,#AB,#C3,#AB,#C3,#43,#C3,#43,#C3,#C3,#C3
	defb #83,#C3,#43,#43,#C3,#03,#C3,#43,#83,#43,#83,#03,#C3,#43,#C3,#C3
	defb #43,#C3,#43,#C3,#83,#C3,#83,#C3,#83,#D6,#03,#FC,#56,#FD,#43,#FD
	defb #C3,#C3,#C3,#FF,#D7,#FF,#D7,#BB,#FF,#33,#BB,#33,#BF,#33,#37,#33
	defb #FF,#FF,#FF,#FF,#BB,#33,#73,#B3,#73,#F3,#33,#B3,#33,#33,#3B,#33
	defb #FF,#FF,#FF,#FF,#37,#3F,#33,#3F,#37,#3F,#3F,#3F,#3F,#3F,#3F,#3F
	defb #C3,#C3,#FF,#C3,#FF,#EB,#3F,#EB,#3F,#7F,#3F,#7F,#3F,#3F,#6E,#3F
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#EB,#C3,#EB,#C3
	defb #C3,#C3,#C3,#C3,#C3,#83,#C3,#D7,#C3,#D7,#C3,#C3,#C3,#C3,#C3,#83
	defb #FF,#FF,#F7,#FB,#8E,#FB,#B7,#FF,#3F,#FF,#7F,#E6,#FF,#E7,#FB,#8E
	defb #EF,#B3,#BB,#9B,#DD,#73,#FF,#BB,#EE,#FF,#E6,#DD,#E6,#DD,#FB,#FF
	defb #37,#3F,#33,#3F,#9B,#33,#67,#33,#33,#67,#FF,#33,#CC,#FF,#CC,#FF
	defb #3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#33,#3F,#33,#33,#FF,#33,#DD,#FF
	defb #3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#3F,#33,#37,#33,#33,#33,#33
	defb #3F,#3F,#3F,#3F,#3F,#3F,#3F,#CC,#3F,#6E,#3F,#6E,#3F,#3F,#3F,#7F
	defb #6E,#9D,#6E,#9D,#CC,#CC,#CC,#CC,#CC,#CC,#CC,#FF,#FF,#FF,#FF,#DD
	defb #CC,#DD,#CC,#FF,#CC,#FF,#DD,#FF,#FF,#F7,#FB,#CE,#FB,#5D,#FF,#DD
	defb #C3,#D7,#E9,#D7,#C3,#FD,#C3,#FD,#D6,#83,#C3,#83,#C3,#E9,#C3,#C3
	defb #BB,#37,#99,#37,#FF,#DD,#EE,#6E,#AE,#6E,#AE,#3F,#57,#1D,#03,#FF
	defb #33,#37,#33,#3B,#BB,#3B,#FF,#FF,#EE,#6E,#DD,#4C,#DD,#DD,#AB,#AB
	defb #3F,#9D,#3F,#6E,#37,#6E,#FF,#FF,#FF,#EE,#BF,#FF,#4C,#DD,#FF,#AB
	defb #3F,#9D,#3F,#FF,#FF,#EE,#EE,#EE,#BF,#EE,#BF,#CC,#46,#5D,#57,#AB
	defb #AB,#C3,#AB,#C3,#AB,#43,#AB,#43,#AB,#43,#AB,#83,#03,#03,#03,#43
	defb #DD,#BF,#DD,#BF,#3F,#EE,#CC,#EE,#FF,#EE,#FF,#7F,#EE,#FF,#FF,#FF
	defb #3F,#3F,#3F,#7F,#9D,#6E,#9D,#CC,#EE,#9D,#EE,#DD,#DD,#FF,#FF,#FF
	defb #FF,#3F,#FF,#3F,#EE,#3F,#BF,#9D,#FF,#CC,#FF,#CC,#FF,#FF,#EE,#FF
	defb #7F,#9D,#7F,#9D,#DD,#CC,#DD,#EE,#FF,#EE,#FF,#EE,#EE,#FF,#FF,#FF
	defb #DD,#CD,#DD,#D9,#CC,#EE,#CC,#FF,#CC,#FF,#CC,#DD,#CC,#DD,#CC,#DD
	defb #3F,#7F,#3F,#FB,#FF,#B6,#FB,#9E,#FF,#CF,#FF,#F3,#7F,#B7,#7F,#EA
	defb #FF,#EE,#DB,#FF,#CE,#E6,#F3,#F3,#B7,#D1,#7B,#6A,#3F,#3F,#3F,#3F
	defb #FF,#FB,#FF,#E7,#FB,#8E,#FB,#DB,#FF,#A6,#FF,#E7,#7F,#6F,#7F,#3F
	defb #DD,#BF,#FF,#EE,#CF,#FF,#DB,#DD,#E2,#F7,#CA,#D5,#CF,#C4,#C0,#6E
	defb #EF,#F3,#BF,#B7,#BF,#3F,#EE,#3F,#EE,#9D,#CC,#CC,#CC,#EE,#FF,#FF
	defb #6E,#CC,#3F,#CC,#6E,#CC,#CC,#CC,#CC,#CC,#CC,#DD,#FF,#FF,#DD,#EE
	defb #3F,#3F,#3F,#6E,#3F,#CC,#3F,#CC,#CC,#CC,#CC,#EE,#DD,#FF,#FF,#FF
	defb #C3,#C3,#43,#C3,#03,#C3,#03,#03,#03,#03,#FF,#03,#57,#AB,#FF,#FF
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#83,#03,#03,#03,#57,#FF,#FF,#AB,#AB
	defb #C3,#C3,#C3,#C3,#03,#C3,#03,#C3,#03,#43,#03,#03,#AB,#03,#FF,#03
	defb #C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#C3,#03,#C3,#03,#43,#AB,#03
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00


	ORG	47744

	; INFORMACION SUPERCARACTERES

	defb #01,#01,#01,#01,#31,#4A,#11,#66,#37,#57,#EE,#F6,#0F,#22,#F7,#EF
	defb #F2,#F3,#ED,#F8,#F4,#77,#F0,#F0,#C8,#C9,#5A,#DF,#A6,#CA,#6A,#7C
	defb #A5,#A4,#AE,#5B,#5C,#CB,#0E,#10,#CC,#6C,#7A,#6D,#6B,#5D,#B0,#B1
	defb #97,#4B,#B2,#B3,#4C,#98,#B4,#B5,#99,#9A,#B6,#B7,#9B,#9C,#B8,#AF
	defb #01,#01,#42,#53,#01,#30,#92,#52,#85,#86,#93,#94,#87,#01,#95,#96
	defb #9E,#9F,#63,#B9,#A0,#A0,#BA,#A0,#A1,#A2,#BB,#BC,#A3,#6C,#BD,#9C
	defb #72,#CD,#7B,#E0,#CE,#CF,#E1,#E2,#A0,#A0,#E3,#A0,#A0,#D0,#E4,#E5
	defb #D1,#61,#E6,#97,#D2,#D3,#5A,#5B,#D4,#D5,#6A,#9A,#6C,#72,#BE,#BF
	defb #A4,#A5,#C0,#C1,#D2,#D3,#AE,#5B,#D4,#D3,#0E,#10,#D4,#D5,#7A,#6D
	defb #4C,#98,#BE,#BF,#99,#9A,#BF,#C0,#9B,#9C,#C0,#C1,#7E,#7F,#8A,#8B
	defb #80,#81,#8C,#8D,#82,#83,#8E,#8F,#84,#01,#90,#91,#52,#73,#76,#73
	defb #3F,#58,#78,#67,#48,#59,#68,#69,#2C,#74,#79,#64,#52,#32,#63,#2E
	defb #33,#34,#41,#47,#35,#36,#48,#49,#43,#53,#64,#3E,#01,#30,#42,#23
	defb #2C,#2F,#24,#43,#2C,#2F,#3F,#40,#01,#01,#2F,#01,#31,#4A,#11,#66
	defb #57,#58,#11,#67,#48,#59,#68,#69,#31,#4A,#11,#66,#31,#32,#37,#31
	defb #33,#34,#0F,#47,#35,#36,#48,#49,#31,#37,#31,#4A,#0E,#0F,#22,#23
	defb #10,#11,#24,#23,#0F,#10,#24,#23,#0F,#12,#24,#22,#D6,#D7,#F9,#FA
	defb #C3,#C5,#FB,#FC,#C3,#C5,#FA,#FB,#C3,#C3,#F9,#FA,#C5,#C3,#FB,#FA
	defb #D7,#C4,#FC,#FA,#C5,#C3,#F9,#FB,#C3,#C4,#FC,#F9,#C5,#C3,#FB,#FA
	defb #C5,#C3,#FB,#FA,#D7,#C4,#FB,#FC,#D7,#C5,#FB,#FC,#C4,#C6,#FB,#C6
	defb #D6,#D7,#C2,#C5,#D7,#C3,#C3,#C5,#C5,#C3,#C3,#D7,#C4,#C6,#FB,#C6
	defb #A7,#A8,#C2,#C3,#A9,#AA,#C3,#C3,#A9,#A9,#C3,#C3,#AA,#A9,#C4,#C3
	defb #A7,#AA,#C3,#C5,#A7,#AA,#C3,#C3,#A7,#A9,#C5,#C3,#A8,#AA,#C3,#C5
	defb #A7,#A8,#C3,#C3,#A9,#A7,#C3,#C5,#AA,#A8,#C3,#C3,#A9,#A7,#C4,#C3
	defb #A8,#AA,#C5,#C6,#D8,#D9,#E7,#E8,#DA,#DB,#E9,#EA,#DC,#DD,#EB,#EC
	defb #D8,#D9,#E7,#E8,#DA,#DC,#EA,#EB,#D8,#D9,#E7,#E8,#DA,#DB,#E9,#EA
	defb #DA,#DB,#E9,#EA,#DC,#DD,#EB,#EC,#75,#76,#5A,#DF,#3E,#3F,#4A,#E5
	defb #40,#3F,#ED,#EE,#41,#43,#EF,#E5,#3E,#3F,#C7,#F0,#40,#3F,#C7,#E5
	defb #41,#43,#ED,#C7,#3E,#3F,#C7,#F1,#40,#3F,#E5,#C7,#41,#8F,#E5,#A2
	defb #7B,#AB,#71,#2A,#AC,#AD,#2B,#2C,#43,#3E,#2D,#2E,#3F,#40,#2F,#79
	defb #3F,#41,#2B,#2C,#43,#3E,#2D,#2E,#3F,#40,#2F,#79,#3F,#41,#2B,#2C
	defb #43,#3E,#2D,#2E,#41,#AE,#2F,#C7,#17,#18,#2A,#2B,#19,#43,#2C,#2D
	defb #3E,#3F,#2E,#2F,#40,#3F,#79,#2B,#41,#43,#2C,#2D,#3E,#3F,#2E,#2F
	defb #40,#3F,#79,#2B,#41,#01,#2F,#01,#01,#17,#01,#2A,#18,#19,#2B,#2C
	defb #19,#19,#2D,#2E,#1A,#17,#2F,#79,#19,#19,#2B,#2C,#19,#19,#2D,#2E
	defb #1A,#01,#2F,#01,#6D,#43,#6A,#10,#3E,#3F,#5A,#DF,#40,#3F,#5B,#7C
	defb #41,#43,#5B,#7C,#3E,#3F,#6A,#6D,#40,#3F,#DF,#6A,#41,#43,#7C,#5A
	defb #3E,#3F,#DF,#7C,#40,#3F,#5A,#DF,#41,#7A,#5B,#6A,#AF,#43,#A6,#2A
	defb #3E,#41,#2B,#2C,#43,#3E,#2D,#2E,#3F,#40,#2F,#79,#3F,#41,#2B,#2C
	defb #43,#3E,#2D,#2E,#3F,#40,#2F,#79,#3F,#41,#2B,#2C,#88,#89,#2D,#2E
	defb #1A,#62,#2F,#B0,#01,#3D,#01,#2A,#3E,#3F,#2B,#2F,#40,#3F,#79,#2B
	defb #41,#43,#2C,#2D,#3E,#3F,#2E,#2F,#40,#3F,#79,#2B,#41,#88,#2C,#2D
	defb #89,#1A,#2E,#2F,#01,#17,#01,#2A,#18,#19,#2B,#2C,#19,#19,#2D,#2E
	defb #65,#17,#2F,#79,#19,#19,#2B,#2C,#19,#19,#2D,#2E,#1A,#01,#2F,#01
	defb #75,#76,#5A,#7A,#3E,#3F,#7B,#6A,#40,#3F,#7C,#5B,#41,#77,#7C,#5A
	defb #61,#3D,#71,#2A,#3E,#3F,#2B,#2C,#40,#3F,#2D,#2E,#41,#62,#2F,#72
	defb #01,#3D,#01,#2A,#3E,#3F,#2B,#2C,#40,#3F,#2D,#2E,#41,#01,#2F,#01
	defb #01,#17,#01,#2A,#18,#19,#2B,#2C,#19,#19,#2D,#2E,#1A,#01,#2F,#01
	defb #5C,#5D,#6C,#6D,#5E,#5F,#6E,#5F,#50,#60,#6F,#70,#38,#01,#4D,#01
	defb #39,#3A,#4E,#4F,#3B,#3C,#50,#51,#13,#14,#25,#26,#15,#16,#27,#28
	defb #01,#01,#29,#01,#08,#09,#1B,#1C,#01,#44,#54,#55,#45,#46,#56,#01
	defb #0A,#0B,#1E,#1F,#0C,#0D,#20,#21,#01,#01,#01,#1D,#07,#01,#01,#01
	defb #06,#01,#01,#01,#01,#01,#03,#01,#02,#01,#01,#01,#01,#01,#05,#01
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
	ENDIF






























	














