// Einstellungen des Zeitverhaltens

#include "pc64.h"

BOOL FAR PASCAL TimingDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  TIMING timing;
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    if (pfw->rPerformance) {
      char ac[80];
      wsprintf(ac, acPerformance, pfw->rPerformance);
      SetDlgItemText(hwnd, IDT_PERFORMANCE, ac);
    }
    SetDlgItemInt(hwnd, IDE_REFRESH, pfw->c.timing.wRefresh, FALSE);
    SetDlgItemInt(hwnd, IDE_ALGORITHM, pfw->c.timing.wAlgorithm, FALSE);
    SetDlgItemInt(hwnd, IDE_CLOCKSPERINT, pfw->c.timing.iClocksPerInt, TRUE);
    SetDlgItemInt(hwnd, IDE_NEWLINE, pfw->c.timing.wNewLine, FALSE);
    SetDlgItemInt(hwnd, IDE_PERFORMANCE, pfw->c.timing.wPerformance, FALSE);
    CheckDlgButton(hwnd, IDB_VICDELAY, pfw->c.timing.fVICDelay);
    CheckRadioButton(hwnd, IDB_NTSC, IDB_NTSC + 1, IDB_NTSC + pfw->c.timing.fNTSC);
    for (i = 0; i < 6; i++) {
      CheckDlgButton(hwnd, IDB_REALTIME + i, pfw->c.timing.wRealTime & (1 << i));
    }
    wDialogHelp = IDM_OPTIONSTIMING;
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      timing.wRefresh = GetDlgItemInt(hwnd, IDE_REFRESH, NULL, FALSE);
      if (!timing.wRefresh) {
        timing.wRefresh = 1;
      } else if (timing.wRefresh > 60) {
        timing.wRefresh = 60;
      }
      timing.wPerformance = GetDlgItemInt(hwnd, IDE_PERFORMANCE, NULL, FALSE);
      if (!timing.wPerformance) {
        timing.wPerformance = 1;
      }
      timing.wAlgorithm = GetDlgItemInt(hwnd, IDE_ALGORITHM, NULL, FALSE);
      if (timing.wAlgorithm < 1) {
        timing.wAlgorithm = 1;
      } else {
        if (timing.wAlgorithm > 3) {
          timing.wAlgorithm = 3;
        }
      }
      timing.iClocksPerInt = GetDlgItemInt(hwnd, IDE_CLOCKSPERINT, NULL, TRUE);
      if (timing.iClocksPerInt > 30) {
        timing.iClocksPerInt = 30;
      } else {
        if (timing.iClocksPerInt < -30) {
          timing.iClocksPerInt = -30;
        }
      }
      timing.wNewLine = GetDlgItemInt(hwnd, IDE_NEWLINE, NULL, FALSE);
      if (timing.wNewLine > 100) {
        timing.wNewLine = 100;
      }
      timing.fVICDelay = IsDlgButtonChecked(hwnd, IDB_VICDELAY);
      timing.fNTSC = IsDlgButtonChecked(hwnd, IDB_NTSC + 1);
      timing.wRealTime = 0;
      for (i = 0; i < 6; i++) {
        if (IsDlgButtonChecked(hwnd, IDB_REALTIME + i)) {
          timing.wRealTime |= 1 << i;
        }
      }
      assert(pfw);
      if (memcmp(&timing, &pfw->c.timing, sizeof timing)) {
        pfw->c.timing = timing;
        pfw->fModified = TRUE;
        Database(pfw, TRUE);
      }
      if (IsDlgButtonChecked(hwnd, IDB_DEFTIMING)) {
        if (memcmp(&timing, &def.c.timing, sizeof timing)) {
          def.c.timing = timing;
          SaveDefault();
        }
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}
