// Emulation ausfhren

#include "pc64.h"

#pragma optimize("leg", off)
BOOL SetTextCharHeight(WORD wHeight) {
  WORD wMode;
  if (*(WORD __far *)0x00000485L == wHeight) return TRUE;
  switch (wHeight) {
  case 8:
    wMode = 0x1112;
    break;
  case 14:
    wMode = 0x1111;
    break;
  case 16:
    wMode = 0x1114;
    break;
  default:
    return FALSE;
  }
  __asm {
    mov AX,wMode
    xor BL,BL
    int 10h
  }
  return (BOOL)(*(WORD __far *)0x00000485L == wHeight);
}
#pragma optimize("", on)

extern "C" word __cdecl wMainsFreq;
word wMainsFreq;
extern "C" char __near * __cdecl gpcAutotype;
char __near * gpcAutotype;

#pragma optimize("leg", off)
flag RunStart(word wReset) {
  assert(pfw);
  assert(wReset < 4);
  assert(hwndChild);
  if (!SwitchToFileWnd(pfw)) {
    return FALSE;
  }
  PrepareToRun(pfw);
  fCtrlBreak = FALSE;
  wRefresh = pfw->c.timing.wRefresh;
  wAlgorithm = pfw->c.timing.wAlgorithm;
  iClocksPerInt = pfw->c.timing.iClocksPerInt;
  wPerformance = pfw->c.timing.wPerformance;
  wNewLine = 100 - pfw->c.timing.wNewLine;
  wRealTime = (pfw->c.timing.wRealTime & 0x3FFF) | (def.c.timing.wRealTime & 0xC000);
  *(long*)L64AlternateJoy = -1;
  if (pfw->c.timing.fVICDelay) {
    wLineDelay = 40;
    wSpriteDelay = 2;
  } else {
    wLineDelay = 0;
    wSpriteDelay = 0;
  }
  dword dSystemClock;
  if (pfw->c.timing.fNTSC) {
    dSystemClock = 1022727;
    wMainsFreq = 60;
    wLinesPerFrame = 263;
    awUpdate[0] = awUpdate[1] = 65;
    adTimeAdd[0] = dSystemClock / 10;
    adTimeAdd[1] = dSystemClock * 50 / 60 / 10;
  } else {
    dSystemClock = 985248;
    wMainsFreq = 50;
    wLinesPerFrame = 312;
    awUpdate[0] = awUpdate[1] = 63;
    adTimeAdd[0] = dSystemClock * 60 / 50 / 10;
    adTimeAdd[1] = dSystemClock / 10;
  }
  dClocksPerRefresh = dSystemClock / wMainsFreq;
  dRealTicksPerRefresh = 1193182 / wMainsFreq;
  dTicksPerRefresh = 119318200 / wMainsFreq / pfw->c.timing.wPerformance;
  dSIDtoAdlib = dSystemClock * 2048 / 50000;
  fLocalBus = def.fLocalBus;
  byte bLoad = lpKernel[0x05CD];
  switch (wReset) {
  case 3:
    assert(bLoad == 0xA5);
    lpKernel[0x05CD] = 0xB2;
    gpcAutotype = acLoad;
    break;
  case 2:
    memset(lpRam + 2, 0, 65534);
    memset(abColor, 0, 1024);
  case 1:
    fTotalReset = wReset == 2;
    Reset();
  }
  MOUSE_HideCursor();
  KBDTerminate();
  WORD wMode;
  WORD wShape;
  WORD wPosition;
  WORD wHeight = *(WORD __far*)0x00000485L;
  __asm {
    mov AH,0Fh
    int 10h
    xor AH,AH
    mov wMode,AX
    mov AH,03h
    int 10h
    mov wShape,CX
    mov wPosition,DX
    mov AX,0013h
    int 10h
  }
  pfnLinkAbortProc = RunAbortProc;
  *(long*)L64State = -1;
  acRunError[0] = 0;
  if (fRunDebug) {
    if (!pfw->acLogName[0]) {
      GetTempFileName(0, "LOG", 0, pfw->acLogName);
      hLogFile = _lcreat(pfw->acLogName, 0);
      strcpy(sLogFile, pfw->acLogName);
      pfw->lStart = pfw->lPosition = pfw->lSize = 0;
      pfw->lSelection = -1;
      pfw->iLine = pfw->iRow = 0;
    } else {
      assert(hLogFile);
      _llseek(hLogFile, 0, 2);
      _lwrite(hLogFile, "\r\n", 80);
    }
    wRunDebug = pfw->c.filters.wFlags;
    Emulate_D();
    wRunDebug = 0;
    if (hLogFile > 0) {
      assert(_tell(hLogFile) % 80 == 0);
      pfw->lSize = _tell(hLogFile) / 80;
      if (!pfw->lSize) {
        DeleteLogFile(pfw);
        assert(!pfw->acLogName[0]);
        assert(!hLogFile);
      } else AdjustFileWnd(pfw, hwndChild);
    }
  } else {
    Emulate_R();
  }
  pfnLinkAbortProc = DefAbortProc;
  lpKernel[0x05CD] = bLoad;
  __asm {
    mov AX,wMode
    int 10h
  }
  SetTextCharHeight(wHeight);
  VidSetBlinking(FALSE);
  __asm {
    mov AX,1000h
    mov BX,0606h
    int 10h
    mov AH,01h
    xor BH,BH
    mov CX,wShape
    int 10h
    mov AH,02h
    mov DX,wPosition
    int 10h
  }
  KBDInit();
  {
    MOUSEPARAMS par;
    memset((char*)&par, 0, sizeof par);
    par.m1 = 0x07;
    par.m4 = VideoInfo.width * ((VID_IN_GRAPHICS_MODE()) ? FONT_WIDTH : 8) - 1;
    MOUSECALL(&par);
    memset((char*)&par, 0, sizeof par);
    par.m1 = 0x08;
    par.m4 = VideoInfo.length * ((VID_IN_GRAPHICS_MODE()) ? VideoInfo.yFontHeight : 8) - 1;
    MOUSECALL(&par);
  }
  MOUSE_ShowCursor();
  WinDrawAllWindows();
  if (acRunError[0]) {
    wCtrlTab = 0;
    wResume = 0;
    ErrorBox(NULL, acRunError);
  }
  if (wCtrlTab) {
    wResume = 0;
    PostMessage(hwndChild, WM_KEYDOWN, wCtrlTab, 0);
    HANDLE hTimer = SetTimer(hwndFrame, 1, 50, NULL);
    assert(hTimer);
  }
  switch (wResume & 0xFF00) {
  case VK_F4:
    PostMessage(hwndFrame, WM_CLOSE, 0, 0);
    wResume = 0;
    break;
  case VK_F9:
    PostMessage(hwndFrame, WM_COMMAND, IDM_OPTIONSFLOPPIES, 0);
    break;
  case VK_F10:
    if (wResume & 0x0008) {
      if (pfw->c.joystick.awPort[0] == pfw->c.joystick.awPort[1]) {
        // set port 1 to none
        pfw->c.joystick.awPort[0] = 0;
      } else {
        // swap ports 1 and 2
        word wTemp = pfw->c.joystick.awPort[0];
        pfw->c.joystick.awPort[0] = pfw->c.joystick.awPort[1];
        pfw->c.joystick.awPort[1] = wTemp;
      }
      pfw->fModified = TRUE;
      Database(pfw, TRUE);
      PostMessage(hwndFrame, WM_COMMAND, IDM_RUNSTART, fRunDebug);
      wResume = 0;
    } else {
      PostMessage(hwndFrame, WM_COMMAND, IDM_OPTIONSJOYSTICKS, 0);
    }
    break;
  case 0x5700:
    if (wResume & 0x0003) {
      PostMessage(hwndFrame, WM_COMMAND, IDM_FILESAVE, 0);
    } else {
      PostMessage(hwndFrame, WM_COMMAND, IDM_FILERELOAD, 0);
    }
    break;
  case VK_DELETE:
  case 0x0E00:
    PostMessage(hwndFrame, WM_COMMAND, IDM_RUNRESET, fRunDebug);
    break;
  case VK_INSERT:
    PostMessage(hwndFrame, WM_COMMAND, IDM_RUNTOTALRESET, fRunDebug);
    break;
  default:
    wResume = 0;
    fRunDebug = FALSE;
    break;
  }
  pfw->c.iec = iec;
  pfw->c.joystick.alCount[0] = alJoyCount[0];
  pfw->c.joystick.alCount[1] = alJoyCount[1];
  pfw->c.joystick.awFlags[0] = awJoyFlags[0];
  pfw->c.joystick.awFlags[1] = awJoyFlags[1];
  if (adPCTicks[0] | adPCTicks[1]) {
    real rPCTicks = adPCTicks[0] + adPCTicks[1] * 65536.0 * 65536.0;
    real rC64Ticks = adC64Ticks[0] + adC64Ticks[1] * 65536.0 * 65536.0;
    pfw->rPerformance = (rC64Ticks / dSystemClock) / (rPCTicks / 1193182) * 100;
  }
  pfw->fModified = TRUE;
  if (iClocksPerInt != pfw->c.timing.iClocksPerInt || 100 - wNewLine != pfw->c.timing.wNewLine || wPerformance != pfw->c.timing.wPerformance) {
    pfw->c.timing.iClocksPerInt = iClocksPerInt;
    pfw->c.timing.wNewLine = 100 - wNewLine;
    pfw->c.timing.wPerformance = wPerformance;
    Database(pfw, TRUE);
  }
  return TRUE;
}
#pragma optimize("", on)

// Einstellungen aus Datenbank lesen oder schreiben
flag Database(FILEWND* pfw, flag fWrite) {
  assert(pfw);
  if (pfw->acFileName[0] || !pfw->acC64Name[0]) {
    return FALSE;
  }
  const iDataSize = sizeof FILEOPT + sizeof ROMS + sizeof KEYBOARD + sizeof JOYSTICK + sizeof TIMING + sizeof SOUND;
  flag fReturn = FALSE;
  char* pcBuffer;
  int iBlock;
  int iOffset;
  char acNull[16];
  srand(1965);
  for (int i = 15; i >= 0; i--) {
    acNull[i] = (char)rand();
  }
  int hFile = _lopen(acDatabase, READ_WRITE);
  if (hFile <= 0) {
    goto Error0;
  }
  pcBuffer = (char*)malloc(16384);
  assert(pcBuffer);
  if (!pcBuffer) {
    goto Error1;
  }
  char acName[16];
  srand(1965);
  for (i = 15; i >= 0; i--) {
    acName[i] = (char)(pfw->acC64Name[i] + rand());
  }
  iBlock = 0;
  for (;;) {
    iOffset = 0;
    long lPos = iBlock * (16384L + 1024L * iDataSize);
    if (_llseek(hFile, lPos, 0) == -1) {
      goto Error2;
    }
    int iCount = _lread(hFile, pcBuffer, 16384);
    if (iCount == -1) {
      goto Error2;
    }
    if (!iCount) {
      if (fWrite) {
        for (i = 0; i < 16384; i += 16) {
          memcpy(pcBuffer + i, acNull, 16);
        }
      Write:
        memcpy(pcBuffer + iOffset, acName, 16);
        srand(1406 + iBlock);
        for (i = 0; i < 16384; i++) {
          pcBuffer[i] ^= (char)rand();
        }
        if (_llseek(hFile, lPos, 0) == -1) {
          goto Error2;
        }
        if (_lwrite(hFile, pcBuffer, 16384) != 16384) {
          goto Error2;
        }
        if (_llseek(hFile, lPos + 16384 + (long)iOffset / 16 * iDataSize, 0) == -1) {
          goto Error2;
        }
        if (_lwrite(hFile, &pfw->c.fileopt, sizeof FILEOPT) != sizeof FILEOPT) {
          goto Error2;
        }
        if (_lwrite(hFile, &pfw->c.roms, sizeof ROMS) != sizeof ROMS) {
          goto Error2;
        }
        if (_lwrite(hFile, &pfw->c.keyboard, sizeof KEYBOARD) != sizeof KEYBOARD) {
          goto Error2;
        }
        if (_lwrite(hFile, &pfw->c.joystick, sizeof JOYSTICK) != sizeof JOYSTICK) {
          goto Error2;
        }
        if (_lwrite(hFile, &pfw->c.timing, sizeof TIMING) != sizeof TIMING) {
          goto Error2;
        }
        if (_lwrite(hFile, &pfw->c.sound, sizeof SOUND) != sizeof SOUND) {
          goto Error2;
        }
        fReturn = TRUE;
      }
      goto Error2;
    }
    if (iCount != 16384) {
      goto Error2;
    }
    srand(1406 + iBlock);
    for (i = 0; i < 16384; i++) {
      pcBuffer[i] ^= (char)rand();
    }
    while (iOffset < 16384) {
      if (!memcmp(pcBuffer + iOffset, acNull, 16)) {
        // Name nicht gefunden
        if (fWrite) {
          goto Write;
        }
        goto Error2;
      }
      if (!memcmp(pcBuffer + iOffset, acName, 16)) {
        // Name gefunden
        if (fWrite) {
          goto Write;
        }
        if (_llseek(hFile, lPos + 16384 + (long)iOffset / 16 * iDataSize, 0) == -1) {
          goto Error2;
        }
        if (_lread(hFile, &pfw->c.fileopt, sizeof FILEOPT) != sizeof FILEOPT) {
          goto Error2;
        }
        if (_lread(hFile, &pfw->c.roms, sizeof ROMS) != sizeof ROMS) {
          goto Error2;
        }
        if (_lread(hFile, &pfw->c.keyboard, sizeof KEYBOARD) != sizeof KEYBOARD) {
          goto Error2;
        }
        if (_lread(hFile, &pfw->c.joystick, sizeof JOYSTICK) != sizeof JOYSTICK) {
          goto Error2;
        }
        if (_lread(hFile, &pfw->c.timing, sizeof TIMING) != sizeof TIMING) {
          goto Error2;
        }
        if (_lread(hFile, &pfw->c.sound, sizeof SOUND) != sizeof SOUND) {
          goto Error2;
        }
        fReturn = TRUE;
        goto Error2;
      }
      // Weitersuchen bis zum Blockende
      iOffset += 16;
    }
    // Weitersuchen nchster Block
    iBlock++;
  }
Error2:
  free(pcBuffer);
Error1:
  _lclose(hFile);
Error0:
  return fReturn;
}

// <Eingabe> im Linkfenster: Neues Dateifenster erzeugen, laden und ausfhren
HWND LinkExecute() {
  assert(IsWindow(hwndChild));
  LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
  assert(plw->hwnd == hwndChild);
  if (!SendMessage(plw->hwndListBox, LB_GETCOUNT, 0, 0)) {
    return NULL;
  }
  int iFocus = (int)SendMessage(plw->hwndListBox, LB_GETCARETINDEX, 0, 0);
  if (iFocus < 0) {
    return NULL;
  }
  SendMessage(plw->hwndListBox, LB_GETTEXT, iFocus, (LONG)(LPSTR)acRunName);
  assert(acRunName[0]);
  assert(strlen(acRunName) < 19);
  if (strchr(acRunName, ',')) {
    return NULL;
  }
  assert(plw->pDevice);
  iRetries = 50;
  plw->pDevice->Open(0, acRunName, strlen(acRunName));
  char acError[40];
  if (plw->pDevice->GetError(acError, 40)) {
    ErrorBox(NULL, acError);
    return NULL;
  }
  lRunStart = (byte)plw->pDevice->Get(0);
  lRunStart |= plw->pDevice->Get(0) << 8;
  plw->pDevice->Close(0);
  if (plw->pDevice->GetError(acError, 40)) {
    ErrorBox(NULL, acError);
    return NULL;
  }
  GetWindowText(plw->hwndDirTree, acRunDir, 80);
  ReplaceFileWnd();
  return RunC64Program();
}

int HexToBin(char cHex) {
  if (cHex >= 'A') {
    cHex += 9;
  }
  return cHex & 15;
}

HWND RunC64Program() {
  extern char __near gacAutotype[80];
  if (gacAutotype[0] == 0) {
    if (lRunStart < 0) {
      wsprintf(acLoad, "LOAD\"%s\",8,1\rRUN\r", acRunName);
    } else {
      word wRunStart = (word)lRunStart;
      if ((wRunStart & 0x03FF) == 1 && wRunStart > 0x0400 && wRunStart < 0xA000) {
        wsprintf(acLoad, "LOAD\"%s\",8:REM $%04X\rRUN\r", acRunName, wRunStart);
      } else {
        wsprintf(acLoad, "LOAD\"%s\",8,1:REM $%04X\r", acRunName, wRunStart);
        if (wRunStart >= 0x0800 && wRunStart < 0xA000 || wRunStart >= 0xC000 && wRunStart < 0xD000) {
          wsprintf(strend(acLoad), "SYS%u:NEW", wRunStart);
        }
      }
    }
  } else {
    char* pcSrc = gacAutotype;
    char* pcDest = acLoad;
    while (*pcSrc != 0) {
      if (*pcSrc == '$' && pcSrc[1] != 0 && pcSrc[2] != 0) {
        *pcDest++ = (char)(HexToBin(pcSrc[1]) * 16 + HexToBin(pcSrc[2]));
        pcSrc += 3;
      } else {
        if (isalpha(*pcSrc)) {
          *pcDest++ = (char)(*pcSrc++ ^ 32);
        } else {
          *pcDest++ = *pcSrc++;
        }
      }
    }
    *pcDest = 0;
    char* pc1 = strchr(acLoad, '"');
    if (pc1 != NULL) {
      pc1++;
      char* pc2 = strchr(pc1, '"');
      if (pc2 != NULL) {
        int iLength = pc2 - pc1;
        if (iLength <= 16) {
          memcpy(acRunName, pc1, iLength);
          acRunName[iLength] = 0;
        }
      }
    }
  }
  FILEWND* pfw = AllocFileWnd();
  assert(pfw);
  strcpy(pfw->acC64Name, acRunName);
  pfw->c = def.c;
  if (!Database(pfw, FALSE)) {
    pfw->c = def.c;
  }
  memset(pfw->c.floppies.aacName[0], 0, 80);
  strcpy(pfw->c.floppies.aacName[0], acRunDir);
  HWND hwnd = CreateFileWnd(pfw, NULL);
  if (hwnd == NULL) {
    return NULL;
  }
  if (fDoArrange) {
    AutoArrange();
    fDoArrange = FALSE;
  }
  if (!RunStart(3)) {
    return NULL;
  }
  return hwnd;
}
