;Sprungtabelle fr den Zugriff auf den IO-Bereich an Adresse D000

include pc64.inc

const
extrn c acC64Version:byte
extrn c lVersion:dword
data?
extrn awError:word
extern c UIReadIO:dword
extern c UIWriteIO:dword
code
IMP Stop,near

ifdef DEBUG

data?
extrn c abColor:byte
extrn c wRunDebug:word
extrn fnContinue:word
extrn wParam:word
code
extrn DumpText:far

else

data? 4
abColor db 1024 dup (?)                 ;Inhalt des Farbram an Adresse D800
  public c abColor

endif

;Mehrere externe Funktionen mit angehngten Ziffern deklarieren
IODEF macro Name,Start,Count
  i=Start
  rept Count
    ifdef DEBUG
      IOProc CATSTR <Name>,%i,<_D>
    else
      IOProc CATSTR <Name>,%i,<_R>
    endif
    extrn c IOProc:near
    i=i+1
  endm
endm

;Die Adressen einer Funktionsreihe ablegen
IOTAB macro Name,Start,Count
  i=Start
  rept Count
    ifdef DEBUG
      IOProc CATSTR <Name>,%i,<_D>
    else
      IOProc CATSTR <Name>,%i,<_R>
    endif
    dw IOProc
    i=i+1
  endm
endm

;Deklaration der externen Funktionen
code
IODEF ReadVIC,0,47
IODEF WriteVIC,0,47
IODEF ReadSID0to,24,1
IODEF ReadSID,25,4
IODEF WriteSID,0,29
IODEF ReadCIA1,0,16
IODEF WriteCIA1,0,16
IODEF ReadCIA2,0,16
IODEF WriteCIA2,0,16

;Tabelle der Funktionsadressen zum Lesen eines Registers
code 2
EXP ReadIOTable,word
ReadIOTable label word
  rept 16                               ;VIC von D000 bis D3FF
    IOTAB ReadVIC,0,47                  ;47 Register
    dw 17 dup (ReadNone)                ;alle 64 Byte gespiegelt
  endm
  rept 32                               ;SID von D400 bis D7FF
    ifdef DEBUG                         ;Register 0..24 sind write-only
      dw 25 dup (ReadSID0to24_D)
    else
      dw 25 dup (ReadSID0to24_R)
    endif
    IOTAB ReadSID,25,4                  ;Die lesbaren Register
    dw 3 dup (ReadNone)                 ;alle 32 Byte gespiegelt
  endm
  dw 1024 dup (ReadColorRam)            ;Farbram von D800 bis DBFF
  rept 16                               ;CIA1 von DC00 bis DCFF
    IOTAB ReadCIA1,0,16                 ;16 Register alle 16 Byte gespiegelt
  endm
  rept 16                               ;CIA2 von DE00 bis DEFF
    IOTAB ReadCIA2,0,16                 ;16 Register alle 16 Byte gespiegelt
  endm
  dw 256 dup (UserportIORead)           ;IO0 ist nicht belegt
  dw 160 dup (UserportIORead)           ;IO1 reserviert fr REU
  dw 92 dup (ReadC64Version)            ;Copyright-Meldung
  dw ReadVersionLow                     ;Versionsnummer
  dw ReadVersionHigh
  dw ReadManufacturer                   ;Herstellerkennung
  dw ReadQuery                          ;An DFFFh abwechselnd 55h und AAh

;Dasselbe nochmal fr die Schreibzugriffe
code 2
EXP WriteIOTable,word
WriteIOTable label word
  rept 16
    IOTAB WriteVIC,0,47
    dw 17 dup (WriteNone)
  endm
  rept 32
    IOTAB WriteSID,0,29
    dw 3 dup (WriteNone)
  endm
  dw 1024 dup (WriteColorRam)
  rept 16
    IOTAB WriteCIA1,0,16
  endm
  rept 16
    IOTAB WriteCIA2,0,16
  endm
  dw 256 dup (UserportIOWrite)
  dw 160 dup (UserportIOWrite)
  dw 96 dup (WriteNone)

;Byte aus IO-Bereich lesen
code 4
EXP ReadIO,near
ReadIO proc near
  shrd DI,BX,15                         ;Index in Tabelle holen
  and DI,0001111111111110b
  jmp ReadIOTable[DI]                   ;Zur ausfhrenden Funktion springen
ReadIO endp

;Byte in IO-Bereich schreiben
code 4
EXP WriteIO,near
WriteIO proc near
  shrd DI,BX,15                         ;Index in Tabelle holen
  and DI,0001111111111110b
  jmp WriteIOTable[DI]                  ;Zur ausfhrenden Funktion springen
WriteIO endp

;Byte aus dem Farbram lesen
code 4
ReadColorRam proc near
  mov AL,abColor[BX-0D800h]
  jmp CX                                ;Zurck zur CPU
ReadColorRam endp

;Byte in das Farbram schreiben
code 4
WriteColorRam proc near
  and AL,00001111b                      ;Das Farbram ist nur 4 Bit breit,
  mov abColor[BX-0D800h],AL             ;  die oberen Bits sind immer 0
  jmp CX
WriteColorRam endp

code 4
UserportIORead proc near
  cmp UIReadIO,0
  je ReadNone
  call UIReadIO
  ifdef DEBUG
    TBEG CIA
    xor AH,AH
    if GERMAN
      INFO "IO-Register %04X ber Userport Interface lesen (%02X)",<BX,AX>
    else
      INFO "Reading I/O register %04X via the Userport interface (%02X)",<BX,AX>
    endif
    TEND
  endif
  jmp CX
UserportIORead endp

code 4
UserportIOWrite proc near
  cmp UIWriteIO,0
  je WriteNone
  ifdef DEBUG
    TBEG CIA
    xor AH,AH
    if GERMAN
      INFO "IO-Register %04X ber Userport Interface schreiben (%02X)",<BX,AX>
    else
      INFO "Writing I/O register %04X via the Userport interface (%02X)",<BX,AX>
    endif
    TEND
  endif
  call UIWriteIO
  jmp CX
UserportIOWrite endp

;Zeichen aus Copyright-String lesen
code 4
ReadC64Version proc near
  mov AL,acC64Version[BX-0DFA0h]
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      INFO "Zeichen aus Emulator Copyrightstring lesen (%02X)",<AX>
    else
      INFO "Reading characters from the emulator Copyright string (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
ReadC64Version endp

;Unterversion lesen
code 4
ReadVersionLow proc near
  mov AL,byte ptr lVersion[0]
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      INFO "Emulator Nebenversionsnummer lesen (%02X)",<AX>
    else
      INFO "Reading emulator secondary version number (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
ReadVersionLow endp

code 4
ReadVersionHigh proc near
  mov AL,byte ptr lVersion[1]
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      INFO "Emulator Hauptversionsnummer lesen (%02X)",<AX>
    else
      INFO "Reading emulator primary version number (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
ReadVersionHigh endp

code 4
ReadManufacturer proc near
  mov AL,byte ptr lVersion[2]
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      INFO "Emulator Herstellercode lesen (%02X)",<AX>
    else
      INFO "Reading emulator manufacturer code (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
ReadManufacturer endp

;An Adresse DFFFh abwechselnd 55h und AAh zurckgeben
data
extrn QueryState:byte
code 4
ReadQuery proc near
  mov AL,QueryState
  not AL
  mov QueryState,AL
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      INFO "Emulatorkennung lesen (%02X)",<AX>
    else
      INFO "Reading emulator detection (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
ReadQuery endp

;Nicht vorhandenes IO-Register lesen
code 4
ReadNone proc near
  mov AL,11111111b
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      WARN "Nicht vorhandenes IO-Register %04X lesen (%02X)",<BX,AX>
    else
      WARN "Reading unavailable I/O register %04X (%02X)",<BX,AX>
    endif
    TEND
  endif
  jmp CX
ReadNone endp

;Nicht vorhandenes IO-Register beschreiben
code 4
WriteNone proc near
  ifdef DEBUG
    TBEG REM
    xor AH,AH
    if GERMAN
      WARN "Nicht vorhandenes IO-Register %04X schreiben (%02X)",<BX,AX>
    else
      WARN "Writing unavailable I/O register %04X (%02X)",<BX,AX>
    endif
    TEND
  endif
  jmp CX
WriteNone endp

;Sprung in den IO-Bereich, zerstrt nichts auer BX (enthlt neues FS)
JUMPIO segment para public use16 'BSS'
ifndef DEBUG
  db 16 dup (?)
endif
JUMPIO ends
code 4
EXP JumpToIO,near
JumpToIO proc near
  ifdef DEBUG
    TBEG REM
    if GERMAN
      WARN "Sprung in den IO-Bereich an Adresse %04X!",<SI>
    else
      WARN "Jumping to the I/O area to the address %04X!",<SI>
    endif
    TEND
  endif
  push AX
  push CX
  push DI
  mov CX,offset @@Continue
  mov BX,SI                             ;Adresse setzen
  shrd DI,BX,15                         ;Index in Tabelle holen
  and DI,0001111111111110b
  jmp ReadIOTable[DI]                   ;Zur ausfhrenden Funktion springen
@@Continue:
  and AL,AL                             ;Auf BRK, RTS oder RTI prfen
  je @@OK
  cmp AL,60h
  je @@OK
  cmp AL,40h
  jne @@Error
@@OK:
  shr BX,4                              ;Adresse im Puffer berechnen
  neg BX
  add BX,JUMPIO
  mov FS,BX
  mov FS:[SI],AL                        ;Befehlsbyte umkopieren
  pop DI
  pop CX
  pop AX
  ret
@@Error:
  if GERMAN
    ERROR "Sprnge in den IO-Bereich sind nur auf die Befehle BRK, RTS und RTI erlaubt!"
  else
    ERROR "Jumps to the I/O area are only allowed to BRK, RTS and RTI instructions!"
  endif
JumpToIO endp

ende
