// Klassendefinitionen fr die Commodore Floppy 1541

class CFloppy : public CDevice {
  // Fehlernummern
  enum ferr {
    OK         = 00, // Kein Fehler aufgetreten
    Scratched  = 01, // Dateien wurden gelscht
    NoHdr      = 20, // Header nicht gefunden
    NoSync     = 21, // Synchronmarkierung nicht gefunden
    WrongHdr   = 22, // Falsche Prfsumme im Header
    WrongData  = 23, // Falsche Prfsumme in den Daten
    CheckSum   = 24, // Allgemeiner Prfsummenfehler
    Verify     = 25, // Falsche Daten wurden geschrieben
    WriteProt  = 26, // Diskette ist schreibgeschtzt
    CheckHdr   = 27, // Prfsummenfehler im Header
    WriteErr   = 28, // Fehler beim Schreiben
    WrongDisk  = 29, // Diskette wurde unerlaubt gewechselt
    NoCmd      = 30, // Kommando nicht erkannt
    WrongCmd   = 31, // Kommando nicht untersttzt
    TooLong    = 32, // Kommando lnger als 41 Zeichen
    Joker      = 33, // Joker beim Schreiben
    NoName     = 34, // Kein Dateiname vorhanden
    CantExec   = 39, // Kann USR-Datei nicht ausfhren
    NoRecord   = 50, // Ende einer relativen Datei
    Overflow   = 51, // Schreiben ber Recordgrenze hinweg
    TooLarge   = 52, // Relative Datei zu gro
    NotClosed  = 60, // Datei wurde nicht geschlossen
    NotOpen    = 61, // Keine Datei auf diesem Kanal offen
    NotFound   = 62, // Datei nicht gefunden
    Exists     = 63, // Datei existiert bereits
    WrongType  = 64, // Falscher Dateityp PRG/SEQ/USR/REL
    NoBlock    = 65, // Kein Block mehr verfgbar
    NoSector   = 66, // Sektornummer zu gro
    WrongBAM   = 67, // Fehler in der Dateiverkettung
    NoChannel  = 70, // Zu viele Dateien offen
    WrongDir   = 71, // Fehler im Verzeichnis
    NoSpace    = 72, // Diskette ist voll
    ResetMsg   = 73, // Einschaltmeldung
    NotReady   = 74, // Laufwerk nicht bereit
    Unknown    = 255 // Programmierfehler
  };
  // Dateityp
  enum ftype {
    ANY, PRG, SEQ, USR, DEL, REL
  };
  // Dateimodus (Lesen oder Schreiben)
  enum fmode {
    eREAD, eWRITE, eAPPEND
  };
  // Einzelner Datenkanal
  struct channel {
    char sPattern[16 + 1]; // Suchmaske im C64-Format
    byte bRecord;          // Recordlnge bei REL
    flag fDirectory;       // Sonderfall Pattern="$"
    ftype eType;           // PRG, SEQ, USR oder REL
    int hFile;             // Handle der Datei
    long lPos;             // Position wenn Handle = 0
    byte* pbBuffer;        // Zeiger auf Dateipuffer
    word wIn;              // Pufferindex beim Lesen
    word wOut;             // Pufferindex beim Schreiben
  };
  // Dateikopf vor einem C64-File
  struct header {
    char sTag[7 + 1];   // Kennung "C64File"
    char sName[16 + 1]; // Name mit 16 Zeichen
    byte bRecord;       // Recordlnge bei relativen Dateien
  };
  ferr eError;     // Letzter aufgetretener Fehler
  word wScratched; // Anzahl gelschter Dateien
  char sPath[80];  // Verzeichnis unter DOS
  char* pName;     // Zeiger auf Dateinamen in sPath
  flag fWildcards; // Zeichen * oder ? im Namen
  find_t Find;     // Fr findfirst und findnext
  word wFind;      // Rckgabewert von findfirst/next
  fmode eMode;     // Lesen oder Schreiben
  flag fReplace;   // Datei wurde mit @: geffnet
  header hdr;      // Kopf der aktuellen Datei
  ftype eType;     // Typ der aktuellen Datei
  word wBlocks;    // Dateilnge in 256-Byte-Blcken
  channel ch[15];  // Kanle 0 bis 14 (15 = Kommandokanal)
  byte abDir[40];  // Puffer fr Verzeichniszeile
  int iDir;        // Index in Verzeichniszeile
  int iDirLen;     // Lnge der Verzeichniszeile
  // Fehler lschen vor der Ausfhrung eines neuen Befehls
  void NoError() {
    eError = OK;
  }
  // Fehler aufgetreten
  flag SetError(ferr e);
  // Fehler von DOS nach C64 wandeln
  flag DOSError(int hFile);
  // Dateinamen analysieren und setzen
  flag CFloppy::SetName(channel* pch, char* pcName);
  // Nchste passende Datei suchen und ffnen
  flag FindFile(channel* pc, find_t* pEntry, word* pwFind);
  // C64-Datei als DOS-Datei ffnen
  flag ChOpen(channel* pch);
  // Dateityp im Klartext holen
  const char* TypeStr(ftype eType);
  // Daten im Ausgabepuffer schreiben
  word Flush(channel* pc);
public:
  // Konstruktor
  CFloppy();
  // Destruktor
  ~CFloppy();
  // Typ liefern
  word GetType();
  // Neues Verzeichnis setzen
  flag SetDir(char* pDir);
  // Aktuelles Verzeichnis auslesen
  void GetDir(char* pDir, word wMax);
  // Dateigre holen
  long GetFileSize(word wChannel);
  // Floppy zurcksetzen
  word Reset();
  // Befehl abschicken
  word Command(char* sCommand, word wLength);
  // Fehlermeldung holen
  word GetError(char* pBuffer, word wMax);
  // Status in Image schreiben
  flag Save(int hFile);
  // Status aus Image lesen
  flag Load(int hFile);
  // C64-Dateien unter DOS ffnen
  word Start();
  // C64-Dateien unter DOS schlieen
  word Stop();
  // Datei oder Verzeichnis ffnen
  word Open(word wChannel, char* pcName, word wLength);
  // Zeichen in Datei schreiben
  word Put(word wChannel, byte bValue);
  // Ende Schreiben
  word Unlisten();
  // Zeichen aus Datei lesen
  word Get(word wChannel);
  // Block schreiben
  word Write(word wChannel, byte* pbBuffer, word* pwCount);
  // Block lesen
  word Read(word wChannel, byte* pbBuffer, word* pwCount);
  // Datei schliessen
  word Close(word wChannel);
  // Satzlnge einer relativen Datei liefern
  byte GetRelLength(word wChannel);
  // Disketten kopieren
  flag BeginTrack(flag fWrite);
  word ReadNextTrack(byte* pbBuffer);
  flag WriteNextTrack(byte* pbBuffer, word wLength);
  flag EndTrack();
  // Gre holen
  int GetBlocks(word wChannel);
  // Datum holen
  dword GetDateAndTime(word wChannel);
  // Datum setzen
  void SetDateAndTime(word wChannel, dword dwDateAndTime);
};
