// Verzeichnisse und Diskimages verwalten

#include "pc64.h"

// Verzeichnissbume in allen offenen Managerfenstern neu einlesen
void UpdateAllDirTrees(char* pcOld, char* pcNew) {
  assert(hwndClient);
  HWND hwnd = GetWindow(hwndClient, GW_CHILD);
  do {
    if (GetWindowLong(hwnd, GWL_WNDPROC) == (LONG)LinkWndProc) {
      LINKWND* plw = (LINKWND*)GetWindowLong(hwnd, 0);
      assert(plw);
      assert(plw->hwndDirTree);
      long lStyle = GetWindowLong(plw->hwndDirTree, GWL_STYLE);
      SetWindowLong(plw->hwndDirTree, GWL_STYLE, lStyle & ~DTS_NOTIFY);
      char acDir[80];
      GetWindowText(plw->hwndDirTree, acDir, 80);
      SetWindowText(plw->hwndDirTree, "\\");
      if (pcOld) {
        assert(pcNew);
        int iTail = strlen(pcOld);
        if (!memcmp(acDir, pcOld, iTail)) {
          if (acDir[iTail] == '\\' || acDir[iTail] == 0) {
            int iStart = iTail;
            while (acDir[iStart - 1] != '\\') {
              iStart--;
              assert(iStart > 0);
            }
            int iLength = strlen(pcNew);
            assert(iLength);
            memmove(acDir + iStart + iLength, acDir + iTail, strlen(acDir + iTail) + 1);
            memcpy(acDir + iStart, pcNew, iLength);
          }
        }
      }
      SetWindowText(plw->hwndDirTree, acDir);
      SetWindowLong(plw->hwndDirTree, GWL_STYLE, lStyle);
      if (plw->pDevice) {
        ReadNames(plw);
      }
    }
  } while ((hwnd = GetWindow(hwnd, GW_HWNDNEXT)) != NULL);
}

// Neues Verzeichnis erzeugen
BOOL FAR PASCAL MakeDirDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        assert(IsWindow(hwndChild));
        assert(GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc);
        LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
        assert(plw->hwnd == hwndChild);
        assert(plw->hwndDirTree);
        char acDir[80];
        GetWindowText(plw->hwndDirTree, acDir, 80);
        assert(acDir[0]);
        assert(strlen(acDir) < 80);
        char* pc = strend(acDir);
        if (pc[-1] != '\\') {
          *pc++ = '\\';
        }
        GetDlgItemText(hwnd, IDE_MAKEDIR, pc, 12);
        assert(strlen(acDir) < 80);
        if (_mkdir(acDir) == 0) {
          SetWindowText(plw->hwndDirTree, acDir);
          GetWindowText(plw->hwndDirTree, acDestDir, 80);
          UpdateAllDirTrees(NULL, NULL);
          EndDialog(hwnd, TRUE);
          return TRUE;
        }
        ErrorBox(acDir, NULL);
      }
      break;
    case IDCANCEL:
      EndDialog(hwnd, FALSE);
      return TRUE;
    }
  }
  return FALSE;
}

BOOL FAR PASCAL RenameDirDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    {
      CenterWindow(hwnd);
      SendDlgItemMessage(hwnd, IDE_NEWNAME, EM_LIMITTEXT, 12, 0);
      assert(hwndChild);
      assert(GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc);
      LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
      assert(plw);
      assert(plw->hwndDirTree);
      char acOld[80];
      GetWindowText(plw->hwndDirTree, acOld, 80);
      assert(acOld[0]);
      char* pc = strrchr(acOld, '\\');
      assert(pc);
      SetDlgItemText(hwnd, IDT_OLDNAME, pc + 1);
      SetDlgItemText(hwnd, IDE_NEWNAME, pc + 1);
      return TRUE;
    }
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
        assert(plw);
        assert(plw->hwnd == hwndChild);
        char acDir[80];
        GetWindowText(plw->hwndDirTree, acDir, 80);
        char* pc = strrchr(acDir, '\\');
        assert(pc);
        char acNew[13];
        GetDlgItemText(hwnd, IDE_NEWNAME, acNew, 13);
        if (strcmp(pc + 1, acNew)) {
          char acOld[80];
          strcpy(acOld, acDir);
          assert(acDir[1] == ':');
          char acRoot[4];
          wsprintf(acRoot, "%c:\\", acDir[0]);
          _chdir(acRoot);
          strcpy(pc + 1, acNew);
          if (rename(acOld, acDir)) {
            ErrorBox(acDir, NULL);
            return TRUE;
          }
          UpdateAllDirTrees(acOld, acNew);
        }
      }
    case IDCANCEL:
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}

BOOL FAR PASCAL MakeRenameImageDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  static flag fRename;
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    fRename = (flag)lParam;
    if (fRename) {
      SetWindowText(hwnd,
                    #if GERMAN
                      "Diskettenimage umbenennen");
                    #else
                      "Rename disk image");
                    #endif
      LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
      assert(plw);
      assert(plw->hwnd == hwndChild);
      char acFile[80];
      GetWindowText(plw->hwndDirTree, acFile, 80);
      assert(acFile[0]);
      char* pc = strrchr(acFile, '\\');
      assert(pc);
      char ac[24];
      strcpy(ac, pc + 1);
      pc = strchr(ac, '.');
      assert(pc);
      *pc = 0;
      SetDlgItemText(hwnd, IDE_DOSNAME, ac);
      int hFile = _lopen(acFile, OF_READ | OF_SHARE_DENY_NONE);
      if (hFile < 0) {
        ErrorBox(acFile, NULL);
        EndDialog(hwnd, 0);
        return TRUE;
      }
      _llseek(hFile, 17 * 21 * 256L + 144, 0);
      memset(ac, 0, 24);
      _lread(hFile, ac, 24);
      _lclose(hFile);
      pc = ac + 16;
      do {
        *pc-- = 0;
      } while (pc >= ac && (byte)*pc == 160);
      SetDlgItemText(hwnd, IDE_C64NAME, ac);
      ac[23] = 0;
      if ((byte)ac[20] == 160) {
        ac[20] = ' ';
      }
      if (!strcmp(ac + 20, " 2A")) {
        ac[20] = 0;
      }
      SetDlgItemText(hwnd, IDE_DISKID, ac + 18);
    } else {
      SetWindowText(hwnd,
                    #if GERMAN
                      "Diskettenimage neu");
                    #else
                      "New disk image");
                    #endif
      SetDlgItemText(hwnd, IDE_DOSNAME, "DISK");
      SetDlgItemText(hwnd, IDE_C64NAME, "DISK");
      SetDlgItemText(hwnd, IDE_DISKID, "00");
    }
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        char acDOSName[13];
        GetDlgItemText(hwnd, IDE_DOSNAME, acDOSName, 13);
        acDOSName[8] = 0;
        strcat(acDOSName, ".D64");
        char acC64Name[17];
        GetDlgItemText(hwnd, IDE_C64NAME, acC64Name, 17);
        acC64Name[16] = 0;
        char acDiskID[6];
        GetDlgItemText(hwnd, IDE_DISKID, acDiskID, 6);
        acDiskID[5] = 0;
        int iLength = strlen(acDiskID);
        while (iLength < 3) {
          acDiskID[iLength++] = ' ';
        }
        if (iLength == 3) {
          acDiskID[iLength++] = '2';
          acDiskID[iLength++] = 'A';
        } else {
          while (iLength < 5) {
            acDiskID[iLength++] = ' ';
          }
        }
        if (acDiskID[2] == ' ') {
          acDiskID[2] = '\xA0';
        }
        LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
        assert(plw);
        assert(plw->hwnd == hwndChild);
        char ac[80];
        GetWindowText(plw->hwndDirTree, ac, 80);
        if (fRename) {
          char acNew[80];
          strcpy(acNew, ac);
          char* pc = strrchr(acNew, '\\');
          assert(pc);
          strcpy(pc + 1, acDOSName);
          if (strcmp(ac, acNew)) {
            if (rename(ac, acNew)) {
              ErrorBox(ac, NULL);
              return TRUE;
            }
          }
          int hFile = _lopen(acNew, OF_WRITE | OF_SHARE_DENY_NONE);
          if (hFile > 0) {
            _llseek(hFile, 17 * 21 * 256L + 144, 0);
            char acBuffer[24];
            memset(acBuffer, 160, 24);
            memcpy(acBuffer, acC64Name, strlen(acC64Name));
            strcpy(acBuffer + 18, acDiskID);
            _lwrite(hFile, acBuffer, 23);
            _lclose(hFile);
          } else {
            ErrorBox(acNew, NULL);
          }
          UpdateAllDirTrees(ac, acDOSName);
        } else {
          char* pc = strend(ac);
          if (pc[-1] != '\\') {
            *pc++ = '\\';
          }
          strcpy(pc, acDOSName);
          assert(strlen(ac) < 80);
          int hFile = _open(ac, _O_BINARY | _O_CREAT | _O_EXCL | _O_RDWR, _S_IREAD | _S_IWRITE);
          if (hFile < 0) {
            if (errno == EEXIST) {
              SetError(0x50);
            }
            return ErrorBox(ac);
          }
          char* pbBuffer = (char*)malloc(16384);
          assert(pbBuffer);
          memset(pbBuffer, 1, 16384);
          for (int i = 0; i < 16384; i += 256) {
            pbBuffer[i] = 0x4B;
          }
          SetError(EWRITE);
          long l = 174848;
          while (l) {
            int i = 16384;
            if ((long)i > l) {
              i = (int)l;
            }
            if (_lwrite(hFile, pbBuffer, i) != i) {
              free(pbBuffer);
              ErrorBox(ac, NULL);
              _close(hFile);
              remove(ac);
              return FALSE;
            }
            l -= i;
          }
          free(pbBuffer);
          _close(hFile);
          SetDir(&plw->pDevice, ac);
          assert(plw->pDevice);
          assert(plw->pDevice->GetType() == DEVIMAGE);
          char acCmd[40];
          wsprintf(acCmd, "N:%s,%c%c", acC64Name, acDiskID[0], acDiskID[1]);
          plw->pDevice->Command(acCmd, strlen(acCmd));
          if (plw->pDevice->GetError(acCmd, 40)) {
            remove(ac);
            return ErrorBox(ac, acCmd);
          }
          SetWindowText(plw->hwndDirTree, ac);
          GetWindowText(plw->hwndDirTree, acDestDir, 80);
          UpdateAllDirTrees(NULL, NULL);
        }
      }
    case IDCANCEL:
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}

flag DelDir() {
  assert(IsWindow(hwndChild));
  assert(GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc);
  LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
  assert(plw->hwnd == hwndChild);
  assert(plw->hwndDirTree);
  char acDir[80];
  GetWindowText(plw->hwndDirTree, acDir, 80);
  assert(acDir[0]);
  assert(strlen(acDir) < 80);
  if (_rmdir(acDir) == 0) {
    UpdateAllDirTrees(NULL, NULL);
    return TRUE;
  } else {
    return ErrorBox(acDir, acNotEmpty);
  }
}

flag DelImage() {
  assert(IsWindow(hwndChild));
  assert(GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc);
  LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
  assert(plw->hwnd == hwndChild);
  assert(plw->hwndDirTree);
  char acImage[80];
  GetWindowText(plw->hwndDirTree, acImage, 80);
  assert(acImage[0]);
  assert(strlen(acImage) < 80);
  char ac[160];
  wsprintf(ac, acDelImage, acImage);
  MessageBeep(MB_ICONQUESTION);
  if (MessageBox(hwndFrame, ac, acConfirm, MB_ICONQUESTION | MB_OKCANCEL) != IDOK) {
    return FALSE;
  }
  if (remove(acImage) == 0) {
    UpdateAllDirTrees(NULL, NULL);
    return TRUE;
  } else {
    return ErrorBox(acImage, NULL);
  }
}
