// Globale Einstellungen der Oberflche

#include "pc64.h"

#pragma pack(1)
extern "C" {
  #include "winhelp.h"
}
#pragma pack()

void SetLinkAndHelpColors() {
  assert(hwndClient);
  for (HWND hwnd = GetWindow(hwndClient, GW_CHILD); hwnd; hwnd = GetWindow(hwnd, GW_HWNDNEXT)) {
    if (GetWindowLong(hwnd, GWL_WNDPROC) == (LONG)LinkWndProc) {
      LINKWND* plw = (LINKWND*)GetWindowLong(hwnd, 0);
      assert(plw);
      assert(plw->hwndDirTree);
      WinSetAttr(plw->hwndDirTree, def.awColor[DTC_DIRTREEFORE] | def.awColor[DTC_DIRTREEBACK] << 4, FALSE);
      assert(plw->hwndListBox);
      WinSetAttr(plw->hwndListBox, def.awColor[DTC_LISTBOXFORE] | def.awColor[DTC_LISTBOXBACK] << 4, FALSE);
    }
  }
  word wBack = def.awColor[DTC_HELPBACK] << 4;
  HelpSetColor(HELPCLR_NORMAL, def.awColor[DTC_HELPNORMAL] | wBack);
  HelpSetColor(HELPCLR_BOLD, def.awColor[DTC_HELPBOLD] | wBack);
  HelpSetColor(HELPCLR_UNDERLINE, def.awColor[DTC_HELPUNDERLINE] | wBack);
  HelpSetColor(HELPCLR_ITALICS, def.awColor[DTC_HELPITALICS] | wBack);
  HelpSetColor(HELPCLR_BOLDITALICS, def.awColor[DTC_HELPBOLDITALICS] | wBack);
  HelpSetColor(HELPCLR_HOTSPOT, def.awColor[DTC_HELPBACK] | def.awColor[DTC_HELPNORMAL] << 4);
}

BOOL FAR PASCAL DesktopDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  static word wLastTop;
  static word wLastSel;
  static word awColor[DTC_COUNT];
  HDC hdc;
  PAINTSTRUCT ps;
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    for (i = 0; i < DTC_COUNT; i++) {
      awColor[i] = def.awColor[i];
      SendDlgItemMessage(hwnd, IDL_ELEMENT, LB_ADDSTRING, 0, (LONG)(LPSTR)apcColor[i]);
    }
    SendDlgItemMessage(hwnd, IDL_ELEMENT, LB_SETTOPINDEX, wLastTop, 0);
    SendDlgItemMessage(hwnd, IDL_ELEMENT, LB_SETCURSEL, wLastSel, 0);
    CheckRadioButton(hwnd, IDB_COLOR, IDB_COLOR + 15, IDB_COLOR + awColor[wLastSel]);
    CheckDlgButton(hwnd, IDB_SAVENONAME, def.fSaveNoName);
    CheckDlgButton(hwnd, IDB_LOCALBUS, def.fLocalBus);
    CheckDlgButton(hwnd, IDB_28LINES, def.f28Lines);
    CheckDlgButton(hwnd, IDB_EMSXMS, def.fSwapEMS | def.fSwapXMS);
    CheckDlgButton(hwnd, IDB_WINSOUND, def.fWinSound);
    CheckDlgButton(hwnd, IDB_AUTOARRANGE, def.fAutoArrange);
    CheckDlgButton(hwnd, IDB_MAXIMIZESINGLE, def.fMaximizeSingle);
    CheckDlgButton(hwnd, IDB_REPLACE, def.fReplace);
    wDialogHelp = IDM_OPTIONSDESKTOP;
    break;
  case WM_PAINT:
    hdc = BeginPaint(hwnd, &ps);
    assert(hdc);
    for (i = 0; i < 16; i++) {
      SetTextColor(hdc, i);
      TextOut(hdc, i & 8 ? 60 : 50, 2 + (i & 7), "", 4);
    }
    EndPaint(hwnd, &ps);
    break;
  case WM_LBUTTONDOWN:
    for (i = 0; i < 16; i++) {
      if ((int)LOWORD(lParam) >= (i & 8 ? 59 : 49) && (int)LOWORD(lParam) < (i & 8 ? 64 : 54) && (int)HIWORD(lParam) == 2 + (i & 7)) {
        awColor[wLastSel] = i;
        CheckRadioButton(hwnd, IDB_COLOR, IDB_COLOR + 15, IDB_COLOR + awColor[wLastSel]);
        SetFocus(GetDlgItem(hwnd, IDB_COLOR + i));
      }
    }
    break;
  case WM_COMMAND:
    switch (wParam) {
    case IDL_ELEMENT:
      if (HIWORD(lParam) == LBN_SELCHANGE) {
        wLastSel = (word)SendDlgItemMessage(hwnd, IDL_ELEMENT, LB_GETCURSEL, 0, 0);
        assert(wLastSel < DTC_COUNT);
        CheckRadioButton(hwnd, IDB_COLOR, IDB_COLOR + 15, IDB_COLOR + awColor[wLastSel]);
      }
      break;
    case IDOK:
      for (i = 0; i < DTC_COUNT; i++) def.awColor[i] = awColor[i];
      def.fSaveNoName = IsDlgButtonChecked(hwnd, IDB_SAVENONAME);
      def.fLocalBus = IsDlgButtonChecked(hwnd, IDB_LOCALBUS);
      def.f28Lines = IsDlgButtonChecked(hwnd, IDB_28LINES);
      def.fSwapEMS = def.fSwapXMS = IsDlgButtonChecked(hwnd, IDB_EMSXMS);
      def.fWinSound = IsDlgButtonChecked(hwnd, IDB_WINSOUND);
      if (!def.fAutoArrange && IsDlgButtonChecked(hwnd, IDB_AUTOARRANGE)) {
        if (wChildren) {
          fDoArrange = TRUE;
        }
      }
      def.fAutoArrange = IsDlgButtonChecked(hwnd, IDB_AUTOARRANGE);
      if (!def.fMaximizeSingle && IsDlgButtonChecked(hwnd, IDB_MAXIMIZESINGLE)) {
        if (wChildren == 1) {
          fDoArrange = TRUE;
        }
      }
      def.fMaximizeSingle = IsDlgButtonChecked(hwnd, IDB_MAXIMIZESINGLE);
      def.fReplace = IsDlgButtonChecked(hwnd, IDB_REPLACE);
      SetLinkAndHelpColors();
      InitSound();
      SaveDefault();
      WinDrawAllWindows();
    case IDCANCEL:
      wLastTop = (word)SendDlgItemMessage(hwnd, IDL_ELEMENT, LB_GETTOPINDEX, 0, 0);
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    default:
      i = wParam - IDB_COLOR;
      if (i >= 0 && i < 16) awColor[wLastSel] = i;
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
