// L64 auf einen externen C64 bertragen

#include "pc64.h"

word GetLptPort(word wLpt) {
  assert(wLpt < 4);
  word __far* pwBase = (word __far*)0x00000408L;
  word wPort = pwBase[wLpt];
  if (wPort < 0x0100 || wPort & 3) {
    return 0;
  }
  while (wLpt--) {
    if (*pwBase++ == wPort) {
      return 0;
    }
  }
  return wPort;
}

flag SearchPorts(HWND hwnd, int iFirstButton) {
  int iHighest = -1;
  for (int i = 0; i < 4; i++) {
    if (GetLptPort(i)) {
      iHighest = i;
    } else {
      EnableWindow(GetDlgItem(hwnd, iFirstButton + i), FALSE);
    }
  }
  if (iHighest == -1) {
    return ErrorBox(NULL, acNoLptPorts);
  }
  if (!GetLptPort(def.wLpt)) {
    def.wLpt = iHighest;
    SaveDefault();
  }
  CheckRadioButton(hwnd, iFirstButton, iFirstButton + 3, iFirstButton + def.wLpt);
  SetFocus(GetDlgItem(hwnd, iFirstButton + def.wLpt));
  return TRUE;
}

BOOL FAR PASCAL CloningDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  static flag fAbort;
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    PostMessage(hwnd, WM_ENTERIDLE, 0, 0);
    return TRUE;
  case WM_ENTERIDLE:
    {
      fAbort = FALSE;
      word wPort = GetLptPort(def.wLpt);
      assert(wPort);
      CFloppy* pFloppy = new CFloppy;
      assert(pFloppy);
      *pcStart = 0;
      flag fOK = pFloppy->SetDir(acStart);
      assert(fOK);
      fOK = !pFloppy->Open(0, "L64", 3);
      assert(fOK);
      int iLast = (int)pFloppy->GetFileSize(0) - 1;
      assert(iLast > 0);
      char acError[128];
      strcpy(acError, acCloneStopped);
      flag fReturn = FALSE;
      for (int i = 0; i <= iLast; i++) {
        word wByte = pFloppy->Get(0);
        if (wByte & 0xFF00 & ~ENDOFFILE) {
          pFloppy->GetError(acError, 40);
          strcat(acError, acErrorReadingL64);
          goto Stop;
        }
        while (!(_inp(wPort + 1) & 0x80)) {
          SetDlgItemProgress(hwnd, IDT_PROGRESS, i, iLast);
          if (fAbort) {
            goto Stop;
          }
        }
        _outp (wPort, wByte & 0x0F | 0x80);
        _outp (wPort, wByte & 0x0F);
        while (_inp(wPort + 1) & 0x80) {
          SetDlgItemProgress(hwnd, IDT_PROGRESS, i, iLast);
          if (fAbort) {
            goto Stop;
          }
        }
        _outp (wPort, wByte / 16 | 0x80);
        _outp (wPort, wByte / 16);
        assert((i == iLast) ^ !(wByte & ENDOFFILE));
      }
      fReturn = TRUE;
    Stop:
      delete pFloppy;
      if (!fReturn) {
        ErrorBox(NULL, acError);
      }
      EndDialog(hwnd, fReturn);
    }
    return TRUE;
  case WM_COMMAND:
    fAbort = TRUE;
    return TRUE;
  }
  return FALSE;
}

BOOL FAR PASCAL CloneDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    {
      CFloppy* pFloppy = new CFloppy;
      assert(pFloppy);
      char acError[256];
      acError[0] = 0;
      *pcStart = 0;
      if (!pFloppy->SetDir(acStart) || pFloppy->Open(0, "L64", 3) || pFloppy->GetError(acError, 40)) {
        delete pFloppy;
        strcat(acError, acCantFindL64);
        ErrorBox(NULL, acError);
        EndDialog(hwnd, FALSE);
        return TRUE;
      } else {
        delete pFloppy;
      }
      if (!SearchPorts(hwnd, IDB_CLONEPORT)) {
        EndDialog(hwnd, FALSE);
        return TRUE;
      }
      CenterWindow(hwnd);
    }
    return FALSE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        for (int i = 0; i < 4; i++) {
          if (IsDlgButtonChecked(hwnd, IDB_CLONEPORT + i)) {
            break;
          }
        }
        assert(i < 4);
        if (i != (int)def.wLpt) {
          def.wLpt = i;
          SaveDefault();
        }
        if (!DialogBox(hInst, "Cloning", hwnd, (FARPROC)CloningDlgProc)) {
          break;
        }
      }
    case IDCANCEL:
      EndDialog(hwnd, wParam == IDOK);
      return TRUE;
    }
    break;
  }
  return FALSE;
}
