// Infobox anzeigen

#include "pc64.h"

void CenterWindow(HWND hwnd) {
  RECT rc;
  GetWindowRect(hwnd, &rc);
  int iWidth = rc.right - rc.left;
  int iHeight = rc.bottom - rc.top;
  MoveWindow(hwnd, (GetSystemMetrics(SM_CXSCREEN) - iWidth) / 2, (GetSystemMetrics(SM_CYSCREEN) - iHeight) / 2, iWidth, iHeight, TRUE);
}

void SetOptionDlgTitle(HWND hwnd, FILEWND* pfw) {
  assert(hwnd);
  CenterWindow(hwnd);
  assert(pfw);
  char acOld[128];
  char acNew[128];
  GetWindowText(hwnd, acOld, 128);
  wsprintf(acNew, acOld, GetFileWndTitle(pfw));
  SetWindowText(hwnd, acNew);
  SwitchToFileWnd(pfw);
}

BOOL FAR PASCAL AboutDlgProc(HWND hwnd, WORD wMsg, WORD, LONG) {
  HDC hdc;
  PAINTSTRUCT ps;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetDlgItemText(hwnd, IDT_VERSION, "Personal C64 Version " VERSION BETA);
    SetDlgItemText(hwnd, IDT_COPYRIGHT, COPYRIGHT);
    CenterWindow(hwnd);
    wDialogHelp = IDM_HELPABOUT;
    break;
  case WM_PAINT:
    hdc = BeginPaint(hwnd, &ps);
#if 0
    SetTextColor(hdc, BLUE);
    TextOut(hdc, 2, 1, "        ", 12);
    TextOut(hdc, 2, 2, " ", 12);
    TextOut(hdc, 2, 3, "    ", 12);
    TextOut(hdc, 2, 4, "    ", 8);
    TextOut(hdc, 2, 5, "   ", 8);
    TextOut(hdc, 2, 6, " ", 8);
    TextOut(hdc, 2, 7, "    ", 8);
    SetTextColor(hdc, RED);
    TextOut(hdc, 10, 5, " ", 4);
    TextOut(hdc, 10, 6, "", 4);
#endif
    {
      _heapmin();
      word wParas;
      _dos_allocmem(0xFFFF, &wParas);
      char ac[40];
      wsprintf(ac,
               #if GERMAN
                 "%d KByte frei",
               #else
                 "%d Kbyte free",
               #endif
               wParas >> 6);
      SetTextColor(hdc, BLACK);
      TextOut(hdc, 2, 14, ac, -1);
    }
    EndPaint(hwnd, &ps);
    break;
  case WM_COMMAND:
    EndDialog(hwnd, 0);
    wDialogHelp = 0;
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
