/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>
#include <netdb.h>

struct sockaddr_in from;
static int sock;
extern int errno;

initnet(port)
	int port;
{
	struct sockaddr_in sin;
	static struct servent *sp;
	int on = 1;

	if (!port) {
		if ((sp = getservbyname("ngetty", "udp")) == 0) {
			fprintf(stderr, "ngetty/udp: unknown service\n");
			return 0;
		}
	}
	if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		fprintf(stderr, "socket: %s\n", strerror(errno));
		return 0;
	}
	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on)) < 0) {
		fprintf(stderr, "setsockopt SO_REUSEADDR: %s\n", strerror(errno));
		return 0;
	}
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = port ? port : sp->s_port;
	if (bind(sock, (struct sockaddr *)&sin, sizeof (sin)) < 0) {
		fprintf(stderr, "bind: %s\n", strerror(errno));
		return 0;
	}
	return 1;
}

char *
waitmsg()
{
	register i;
	int len = sizeof(from);
	static char msgbuf[128];

	while ((i = recvfrom(sock, (char *)msgbuf, sizeof(msgbuf)-1, 0,
			(struct sockaddr *)&from, &len)) < 1)
		if (i < 0 && errno != EINTR)
			return NULL;
	msgbuf[i] = '\0';
	return msgbuf;
}
