/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <syslog.h>
#include <setjmp.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include "pathnames.h"
#include "modem.h"

extern char *mytty;

int connected = 0;

static jmp_buf dontanswer;

static void
waitforanswer()
{
	alarm(0);
	signal(SIGALRM, SIG_DFL);
	longjmp(dontanswer, 1);
}

static int
tofile(string)
	char *string;
{
	FILE *fp;
	char buf[80];

	sprintf(buf, _PATH_CONNECT, mytty);
	if ((fp = fopen(buf, "w")) == NULL) {
		syslog(LOG_ERR, "%s: %s: %m", mytty, buf);
		message("E:%s: %s", buf, strerror(errno));
		return 0;
	}
	fprintf(fp, "%s\n", string);
	fclose(fp);
	return 1;
}

static int
sendtomdm(fd, string)
	register int fd;
	char *string;
{
#ifdef	DEBUG
	syslog(LOG_ERR, "DEBUG> `%s'", string);
#endif
	if (write(fd, string, strlen(string)) < 0) {
		syslog(LOG_ERR, "%s: write: %m", mytty);
		message("E:write: %s", strerror(errno));
		return 0;
	}
	return 1;
}

static char *
getmdmresp(fd, maxwait)
	register int fd;
	int maxwait;
{
	register i = 0;
	int rval;
	static char response[80];

	if (setjmp(dontanswer)) {
#ifdef	DEBUG
		syslog(LOG_ERR, "DEBUG< no answer for %d sec", maxwait);
#endif
		return NULL;
	}
	signal(SIGALRM, waitforanswer);
	alarm(maxwait);

	while ((rval = read(fd, &response[i], 1)) > 0) {
		if (i && (response[i] == '\r' || response[i] == '\n')) {
			response[i] = '\0';
			alarm(0);
			signal(SIGALRM, SIG_DFL);
#ifdef	DEBUG
			syslog(LOG_ERR, "DEBUG< `%s'", response);
#endif
			return response;
		}
		if (response[i] >= ' ')
			if (++i >= sizeof(response)) break;
	}
	alarm(0);
	signal(SIGALRM, SIG_DFL);
	if (rval < 0 && errno != EINTR) {
		syslog(LOG_ERR, "%s: read: %m", mytty);
		message("E:read: %s", strerror(errno));
	}
#ifdef	DEBUG
	syslog(LOG_ERR, "DEBUG< interrupted?");
#endif
	return NULL;
}

static int
wantanswer(fd, nrep, string, maxwait)
	int fd, nrep, maxwait;
	char *string;
{
	register i = 0, cnt = 0;
	char *ptr;
	extern int bidir_mode;

	while (cnt != nrep) {
		if (i++ > nrep*2) return -1;
		ptr = getmdmresp(fd, maxwait);
		if (bidir_mode && seize_lock(mytty, -1) == 0) {
			message("M:<Wait line>");
			return -1;
		}
		if (ptr == NULL) return 0;
		message("M:\"%s\"", ptr);
		if (strncmp(ptr, string, strlen(string)) == 0)
			cnt++;
		else 	cnt = 0;
	}
	return 1;
}

int
talkmdm(fd, nring)
	int fd, nring;
{
	int rval;
	char *resp;
	extern int initcnt, minspeed;

	message("M:<Init line>");
	sendtomdm(fd, SEND_INIT_1);
	sleep(2);
	sendtomdm(fd, SEND_INIT_2);
	flush_echos(fd);

	do {
		sendtomdm(fd, SEND_TOUCH);
		if (wantanswer(fd, 1, RESP_OK, 4) < 1) return 0;
		initcnt = 0;
	} while ((rval = wantanswer(fd, nring, RESP_RING, 60)) == 0);
	if (rval < 0) return 0;

	flush_echos(fd);
	sendtomdm(fd, SEND_ATA);

	while ((resp = getmdmresp(fd, 30)) != NULL) {
		message("M:\"%s\"", resp);
		if (!strncmp(resp, RESP_NOCARR, sizeof(RESP_NOCARR)-1)) break;
		if (!strncmp(resp, RESP_CONNECT, sizeof(RESP_CONNECT)-1)) {
			tofile(resp);
			resp += sizeof(RESP_CONNECT)-1;
			while (*resp == ' ' || *resp == '\t') resp++;
			connected = atoi(resp);
			while (isdigit(*resp)) resp++;
			if (*resp == '.')
				connected = connected * 1000 + atoi(++resp) * 100;

			flush_echos(fd);
			if (connected < minspeed)
				exit(0);
			return 1;
		}
	}
	return 0;
}
