/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/param.h>
#include <sys/stat.h>

typedef	void (*sigfunc) ();

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#define	ECHOENABLE	TRUE
#define	ECHODISABLE	FALSE
#define	FIRSTOPEN	2

#define	MAXBBSUSERS		256
#define	MAXUSRNAMELEN		24
#define	MAXPRIVLEVEL		99
#define	MAXCONFLINES		2048
#define	MAXSTACKSIZE		2048	/* max files or msgs in single area */
#define	MAXCONFENTRIES		100
#define	MAXFILENAMELEN		14
#define	MAXSEARCHSTRINGS	10
#define	MAXSTRINGLENGTH		79
#define	MAXDESCLINES		5
#define	MAXFATTACHSIZE		102400	/* bytes */
#define	DEFMSGZONE		2
#define	USRBUFSIZE		4096	/* 4kb */

#define	BBS			"bbs"
#define	ID			"TNSDrive"
#define	UNREGISTERED		"* unregistered copy *"

#define	PID			"PID"
#define	USER			"USER"
#define	HOMEDIR			"HOME"
#define	MENUPATH		"MENUPATH"
#define	DEFMENUPATH		"Main_menu"

#define	PASSWORD		"PASSWORD"

#define	REALNAME		"REALNAME"
#define	CALLSIGN		"CALLSIGN"
#define	DEFREALNAME		"TNS User"
#define	USERLOCATION		"LOCATION"
#define	USERORG			"ORGANIZATION"
#define	DEFORG			"Unknown"
#define	SIGNATURE		"SIGNATURE"
#define	LANGUAGE		"LANGUAGE"
#define	LANGNUMBER		"LANGNUMBER"
#define	CODEPAGE		"CODEPAGE"
#define	DEFLANGUAGE		"English"
#define	PROTOCOL		"PROTOCOL"
#define	USERDEFFROM		"DEFINE-FROM"
#define	USERGROUP		"GROUP"
#define	USERDEFGROUP		"default"

#define	LASTCALLTIME		"LASTCALLTIME"
#define	CALLNUMBER		"CALLNUMBER"
#define	FILEAREAPATH		"FILEAREAPATH"
#define	MSGAREAPATH		"MSGAREAPATH"
#define	NEWSSORT		"NEWSSORT"

#define	DAILYDLSIZE		"DAILYDLSIZE"
#define	DAILYULSIZE		"DAILYULSIZE"
#define	DAILYDLLIMIT		"DAILYDLLIMIT"
#define	DEFDLSIZELIMIT		1024		/* Kb */
#define	USERDLSIZE		"USERDLSIZE"
#define	USERULSIZE		"USERULSIZE"
#define	ULMULTIPLIER		"ULMULTIPLIER"
#define	DEFULMULTIPLIER		2
#define	SCRLINES		"SCRLINES"
#define	MAXSCRLINES		43
#define	DEFSCRLINES		24
#define	HOTKEY			"HOTKEY"
#define	SHORTMENU		"SHORTMENU"
#define	SYSDLULRATIO		"SYSDLULRATIO"
#define	USERARTREAD		"ARTREAD"
#define	USERARTPOST		"ARTPOST"
#define	USERARTSIZE		"ARTSIZE"
#define	ARTREADLIMIT		"ARTREADLIMIT"
#define	ARTPOSTLIMIT		"ARTPOSTLIMIT"
#define	ARTSIZELIMIT		"ARTSIZELIMIT"
#define	USERMSGREAD		"MSGREAD"
#define	USERMSGPOST		"MSGPOST"
#define	MSGREADLIMIT		"MSGREADLIMIT"
#define	MSGPOSTLIMIT		"MSGPOSTLIMIT"

#define	READFILESDIR		"READFILESDIR"
#define	DEFREADFILES		".readfiles"
#define	UPLOADPATH		"UPLOADPATH"
#define	DEFUPLOADPATH		".files"
#define	DEFFILESLIST		"files.bbs"
#define	HIDEDIRS		"HIDEDIRS"
#define	USERLISTFILE		".userlist"

#define	XFERLOG			"XFERLOG"
#define	LOGFILE			"LOGFILE"
#define	LOGLEVEL		"LOGLEVEL"
#define	MONITOR			"MONITOR"
#define	SYSTEMNAME		"SYSTEMNAME"
#define	SYSMAILTO		"SYSMAILTO"
#define	SYSADMNAME		"SYSADMNAME"
#define	MAXUSERS		"MAXUSERS"
#define	MYHOSTNAME		"MYHOSTNAME"
#define	INFINITY		"INFINITY"

#define	EDITOR			"EDITOR"
#define	DEFEDITOR		"bin/pico"	/* We use Restricted PICO */
#define	SHELL			"SHELL"
#define	DEFSHELL		"bin/sh"

/* Timer section */
#define	INACTTIMER		3		/* 3min - inactivity timer */
#define	LOGINTIMELEFT		3		/* 3min - max login time */
#define	DEFTIMELEFT		60		/* time left 60 minuts */
#define	USERTIMELEFT		"TIMELEFT"
#define	DAILYTIMELEFT		"DAILYTIMELEFT"
#define	SESSIONTIME		"SESSIONTIME"
#define	TIMECOUNTER		10
#define	TIMERATE		"TIMERATE"
#define	INTERRUPT		"INTERRUPT"

/* User's limits */
#define	DEFPRIVLEVEL		0		/* 0 - minimum priv level */
#define	USERPRIVLEVEL		"PRIVLEVEL"

/* Terminal section */
#define	TERM			"TERM"
#define	DUMP			"dump"
#define	VT52			"vt52"		/* Dump terminal */
#define	VT100			"vt100"		/* ANSI support */
#define	ANSI			"ansi"		/* ANSI support */
#define	IBMPC3			"ibmpc3"	/* ANSI support */
#define	AT386			"at386"		/* ANSI support */
#define	RIP			"rip"		/* RIP<tm> support */
#define	MAXTERMLEN		7

#define	NODESCONFILE		"NODESCONFILE"
#define	DEFNODESCONFILE		"*** No description on file ***"

/* Log level */
#define	LOG_ERROR	0
#define	LOG_WARNING	1
#define	LOG_NOTICE	2
#define	LOG_INFO	3
#define	LOG_DEBUG	4

/* Error reports */
#define	RPTHEADER	"*** TNS Report ***"	/* system report header	*/
#define	ERR_MAIL	1			/* error report via mail */
#define	ERR_LOG		2			/* error report to logfile */
#define	ERR_PRINT	4			/* error report to user */
#define	PANIC		(ERR_MAIL|ERR_LOG|ERR_PRINT) /* fatal error - exit */

#if defined(SVR4)
#define	SYS_LS		"/usr/bin/ls -lLFq"
#define	SYS_MV		"/usr/bin/mv"
#else	/* BSD, SVR3, Linux */
#define	SYS_LS		"/bin/ls -lLFq"
#define	SYS_MV		"/bin/mv"
#endif

#if defined(BSD) || defined(SVR4)
#define	SYS_MAIL	"/usr/bin/mail"
#else	/* SVR3, Linux */
#define	SYS_MAIL	"/bin/mail"
#endif

#if defined(SVR3)
#define	SYS_TALK	"/usr/ucb/talk"
#define	SYS_FINGER	"/usr/ucb/finger"
#else	/* BSD, SVR4, Linux */
#define	SYS_TALK	"/usr/bin/talk"
#define	SYS_FINGER	"/usr/bin/finger"
#endif

#define	MAILER			"MAILER"
#define	DEFMAILER		"bin/send_mail"
#define	INEWS			"INEWS"
#define	DEFINEWS		"bin/send_news"
#define	LOGOUT			"LOGOUT"
#define	DEFLOGOUT		"bin/logout"

#define	MYPIDFILE		"/tmp/%s.%s"
#define	CONNECTFILE		"/tmp/CONNECT.%s"
#define	CONNECT			"CONNECT"
#define	RECVBATCH		"/tmp/recv-batch.%s"
#define	SENDBATCH		"/tmp/send-batch.%s"
#define	TMPFILEMASK		"/tmp/dlXXXXXX"
#define	ONLINEFILE		"/tmp/on-line.%s"
#define	LOGINFOFILE		"/tmp/loginfo"
#define	DSZLOG			"/tmp/dszlog"
#define	MAILBOX			".mbox"
#define	MONITORDIR		"/tmp/tnsmon"
#define	TNSMONPID		"/tmp/tnsmon/PID"

/* Some useful menu driven files */
#define	HELPFILE		".help"
#define	HEADERFILE		".header"
#define	FOOTERFILE		".footer"

#define	MENUPASSWORD		".password"
#define	MENUPASSSHOW		".password.show"

/* Config files */
#define	MAINSYSTEMCONF		"/etc/tns/system"
#define	SYSTEMCONF		".system.conf"
#define	MAINLIMITSCONF		"/etc/tns/limits"
#define	LIMITSCONF		".limits.conf"
#define	MAINTTYCONF		"/etc/tns/tty"
#define	TTYCONF			".tty.conf"
#define	MAINVIEWERSCONF		"/etc/tns/viewers"
#define	VIEWERSCONF		".viewers.conf"
#define	MAINFTPCONF		"/etc/tns/ftp"
#define	FTPCONF			".ftp.conf"
#define	MAINLANGCONF		"/etc/tns/language"
#define	LANGCONF		".language.conf"
#define	MAINFILESLIST		"/etc/tns/filelist"
#define	FILESLIST		".filelist.conf"
#define	USRHOMEDIR		"usr"
#define	USERCONF		".user.conf"
#define	CHARGEUSERCONF		".cuser.conf"
#define	FILEAREACONF		".filearea.conf"
#define	MSGAREACONF		".msgarea.conf"
#define	USENETPATHCONF		".usenetpath.conf"
#define	USENETAREACONF		".usenetarea.conf"
#define	BADNAMESLIST		".badnames.conf"
#define	CALLSIGNLIST		".callsign.conf"
#define	FTPLISTCONF		".ftplist.conf"

/* Seachable in user home directory first */
#define	STARTUPFILE		".startup"
#define	BADADDRFILE		".badaddr.conf"
#define	ALIASESFILE		".aliases.conf"
#define	USERFORWARDFILE		".forward"

/* Show to user files */
#define	TTYALLOWED		"./.ttyallow.show"	/* showfile() */
#define	BANNER			"~.banner.show"		/* display() */
#define	NEWUSERSWELCOME		"~.newusers.show"
#define	USERDENY		"~.userdeny.show"
#define	BADPASSWORD		"~.badpasswd.show"
#define	DAYLIMIT		"~.daylimit.show"
#define	CHARGELIMIT		"~.climit.show"
#define	USERNOTFOUND		"~.notfound.show"
#define	NEWUSER			"~.newuser.show"
#define	ROOKIE			"~.rookie.show"
#define	WELCOME			"~.welcome.show"
#define	GOODBYE			"~.goodbye.show"

/* Flag files */
#define	NOLOGIN			"./.nologin"
#define	NEWUSERSDENY		"~.nonewuser"
#define	SETUSERFILE		".setuser"

/* Global flags section */
extern int globalflags;		/* bit mapped */
#define	LISTMODE_EXT		1	/* execute external program */
#define	LISTMODE_RAW		2	/* raw list, do not stat() files */
#define	LISTMODE_ALL		4	/* show off-line files */
#define	INACTIVITY		8
#define	SEARCHPATH		16
#define	SEARCHFILE		32
#define	NEWFILES		64
#define	MSGFORYOU		128
#define	NOKEYWORDS		256
#define	IMMQUIT			512
#define	BEGINCHAT		1024
#define	EXTERNALMENUFLAG	2048
#define	SENDINPROGRESS		4096
#define	RECVINPROGRESS		8192
#define	USENETREADERINUSE	16384
#define	WANTTALK		32768
#define	NOMOREFLAG		65536
#define	LANGPRESELECTED		131072

extern int termflags;		/* value */
#define	DUMPTERM		0
#define	ANSITERM		1
#define	RIPTERM			2
#define	RIPTERM2		4
#define	RIPMOUSE		8
#define	CLEARBUTTONS		16
#define	HOTKEYON		32
#define	SHORTMENUON		64

/*
 * Global variables from drive.c
 */
extern char *orgdir;		/* myself home dir		*/
extern char username[];		/* User login name		*/
extern char callsign[];		/* User call signature		*/
extern char homedir[];		/* User home directory		*/
extern char term[];		/* Term type. VT100, ANSI, etc	*/
extern char mytty[];		/* Tty name. tty00, ttyp1, etc	*/
extern char fntty[];
extern char *editprog;		/* Path to prefered system editor*/
extern char *talkprog;		/* Path to external talk program*/
extern char *fingerprog;	/* Path to the finger program	*/
extern char *logoutprog;	/* Path to logout procedure	*/
extern char *mailerprog;
extern char *inewsprog;
extern int privlevel;		/* User Access Level (0-99max)	*/
extern time_t loggedontime;	/* User logged on time		*/
extern time_t lastcalltime;	/* User last logged time	*/
extern int scrlines;		/* How many lines on screen	*/
extern int connectspeed;	/* Current connect speed	*/
extern char *sysmailto;		/* E-mail of Sys Admin		*/
extern char *sysadmname;	/* Name of Sys Admin		*/
extern char *usergroup;		/* Group name of current user	*/

#if !defined(_CURSES_H_) && !defined(_CURSES_H) && !defined(CURSES_H)
/*
 * Global functions and variables from io.c
 *	if flag = 0 - any char, if 1 - only < 0x80
 */
extern int nchr;	/* How many chars contain input buffer */
extern int getchr();	/* int getchr(flag),		<Enter> = '\0'	*/
extern int getkey();	/* stdbuf, int getkey(echo),	<Enter> = '\r'	*/
extern char *getstr();	/* stdbuf, char *getstr(max, flag, echo)	*/
extern char *gettok();	/* stdbuf, char *gettok(max, flag, echo)	*/
extern char *editstr();	/* char *editstr(str, max, flag)		*/
extern char *prompt_str(); /* char *prompt_str(MSG_num, defstr | NULL)	*/
extern int putchr();	/* int putchr(int c)				*/
extern int putstr(const char *fmt, ...);
extern char *putstrmax(); /* char *putstrmax(char *str, int maxchars)	*/
#define	hotkey()	(termflags & HOTKEYON) ? getask(ECHOENABLE) : getkey(ECHOENABLE)
#endif

/* Some other needed definition */
extern int _scandir();
extern int _alphasort();
#define	scandir _scandir
#define	alphasort _alphasort
#ifdef	HAVE_NOT_SNPRINTF
extern int snprintf();
extern int vsnprintf();
#endif
#ifdef	HAVE_NOT_STRCASECMP
extern int strcasecmp();
extern int strncasecmp();
#endif
extern char tmpbuf[];
extern char *writeletter;
extern char *editorworkfile;
extern char *onlinefile;
extern char *talkaddrfile;
extern char *ftpcachfile;
extern char *sysmsg();
extern char *itoa();
extern char *strippath();
extern char *sec2str();
extern char *get_env();
extern char *strlwr();
extern char *strupr();
extern char *strnlwr();
extern char *strnupr();
extern char *strcasestr();
extern char *strdupf(char *fmt,...);
extern char *systemid;
extern char userconf[];
extern char *makestrotime();
extern int display(int,...);
extern char *newssort;
extern void freedir();
extern void quit();
extern char *setarea();
extern char *getarea();
extern char *getkeyinfo();
extern char *getfileconf();
extern void putuserconf();
extern char *getuserconf();
extern char *getsysconf();
extern char *mesgtty();
extern void externaltalk();
extern char *fixfname();
extern char *loadfile();
extern char *makeshowpath();
extern void proctitle(char *fmt,...);

struct mkst {
	char ch;
	struct stat st;
};

/* userinfo record */
struct loginfo {
	char	tty[12];
	char	name[26];
	time_t	ltime;
	pid_t	pid;
	int	baud;
	int	port;
	int	flags;
};

extern int userflags;

/* userinfo flags are */
#define	MESGNO		1
#define	INTALK		2
#define	INCONF		4
#define	KICKER		8
#define TERMINATOR	16
#define	INFINITYCONF	32
#define	EXECEXT		64
#define	CHARGEUSER	128
#define	INFINITYUSER	256
#define	HIDDENUSER	512
#define	INRECVF		1024
#define	INSENDF		2048
