/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "userbase.h"

extern char *orgdir;
static char tmphome[1024];
static int u_charge;

int
isuserexist(user)
	char *user;
{
	int n;
	struct stat st;
	char *ptr, tmp[256];

	strcpy(tmp, USRHOMEDIR);
	if (tmp[0] == '/') strcpy(tmphome, tmp);
	else	sprintf(tmphome, "%s/%s", orgdir, tmp);
	for (ptr = tmp; *user; ptr++, user++) *ptr = tolower(*user);
	*ptr = '\0';
	if (tmp[0] == '\0') return 0;
	for (n = 0, ptr = tmp; (ptr = strtok(ptr, " .")) != NULL; n++, ptr = NULL) {
		strcat(tmphome, "/");
		*ptr = toupper(*ptr);
		strcat(tmphome, ptr);
	}
	return (n == 2 && stat(tmphome, &st) == 0 && (st.st_mode & S_IFMT) == S_IFDIR);
}

/*
 * Get string value from conf file
 */
char *
getstrpathconf(path, nam, def)
	char *path, *nam, *def;
{
	int len, flag = 0;
	char *p;
	FILE *fp;
	static char strval[512];

	len = strlen(nam);
	if ((fp = fopen(path, "r")) != NULL) {
		memset(strval, 0, sizeof(strval));
		while (fgets(strval, sizeof(strval), fp) != NULL) {
			if ((p = strchr(strval, '\n')) != NULL) *p = '\0';
			if (strval[0] && strval[0] != '#' && strval[len] == '=' &&
			    !strncmp(strval, nam, len)) {
				flag = 1;
				break;
			}
		}
		fclose(fp);
	}
	if (flag && strval[len+1] != '\0') return &strval[len+1];
	return def;
}

char *
getuserinfo(user, nam, def)
	char *user, *nam, *def;
{
	struct stat st;
	static char u_name[MAXUSRNAMELEN+1];
	static char u_file[1024];

	if (strcmp(user, u_name)) {
		u_name[0] = '\0';
		u_charge = 0;
		if (!isuserexist(user)) return NULL;
		(void)sprintf(u_file, "%s/%s", tmphome, CHARGEUSERCONF);
		if (stat(u_file, &st) < 0) {
			(void)sprintf(u_file, "%s/%s", tmphome, USERCONF);
			if (stat(u_file, &st) < 0) return NULL;
		} else 	u_charge = 1;
		(void)strcpy(u_name, user);
	}
	return getstrpathconf(u_file, nam, def);
}

static char *
makeshowpath(showpath)
	char *showpath;
{
	int i;
	register char *ptr, *ptr2;
	char buf[1024];
	static char makestrbuf[1024];

	makestrbuf[0] = 0;
	i = strlen(orgdir);
	if (strncmp(orgdir, showpath, i) != 0) i = 0;
	strcpy(buf, &showpath[i]);
	for (ptr = buf; *ptr != '\0'; ptr++) if (*ptr == '_') *ptr = ' ';
	ptr2 = buf;
	while ((ptr = strtok(ptr2, "/")) != NULL) {
		if ((ptr2 = strchr(ptr, '.')) != NULL) i = ptr2-ptr;
		else i = strlen(ptr);
		if (i) {
			strcat(makestrbuf, "<");
			strncat(makestrbuf, ptr, i);
			strcat(makestrbuf, ">-");
		}
		ptr2 = NULL;
	}
	i = strlen(makestrbuf);
	if (i && makestrbuf[i-1] == '-') makestrbuf[--i] = '\0';
	return makestrbuf;
}

void
who_is_user(user, fp)
	char *user;
	FILE *fp;
{
	int i;
	time_t lc_time;
	char *ptr;

	if ((ptr = getuserinfo(user, USERPRIVLEVEL, "0")) == NULL) {
		fprintf(fp, "Information not found! Probably this user coming from Unix\n");
		return;
	}
	fprintf(fp, "%16s: %s\n", "User name", user);
	fprintf(fp, "%16s: level %d, ", "User access", atoi(ptr));
	ptr = getuserinfo(user, USERGROUP, USERDEFGROUP);
	fprintf(fp, "group %s, status %s", ptr, u_charge ? "Charge" : "Regular");
	i = -1;
	if ((ptr = getuserinfo(user, DAILYTIMELEFT, NULL)) != NULL) {
		i = atoi(ptr);
		if (!i) fprintf(fp, ",Infinity");
	}
	if (getuserinfo(user, PASSWORD, NULL) == NULL)
		fprintf(fp, ",Blocked");
	fprintf(fp, "\n");
	ptr = getuserinfo(user, DAILYDLLIMIT, NULL);
	if (i >= 0 || ptr != NULL) {
		fprintf(fp, "%16s: ", "Daily limits");
		if (i > 0)	fprintf(fp, "%dmin ", i);
		else if (!i)	fprintf(fp, "Free-Time ");
		if (ptr != NULL) {
			i = atoi(ptr);
			if (i)	fprintf(fp, "%dkb ", i);
			else	fprintf(fp, "Free-DL-size ");
		}
		fprintf(fp, "\n");
	}
	if ((ptr = getuserinfo(user, LASTCALLTIME, NULL)) != NULL) {
		lc_time = atoi(ptr);
		fprintf(fp, "%16s: %s", "Last call", ctime(&lc_time));
	}
	if ((ptr = getuserinfo(user, CALLNUMBER, NULL)) != NULL)
		fprintf(fp, "%16s: %d\n", "Call number", atoi(ptr));
	if ((ptr = getuserinfo(user, TERM, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Terminal", ptr);
	if ((ptr = getuserinfo(user, LANGUAGE, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Language", ptr);
	if ((ptr = getuserinfo(user, MENUPATH, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Menu path", makeshowpath(ptr));
	if ((ptr = getuserinfo(user, USERDLSIZE, NULL)) != NULL)
		fprintf(fp, "%16s: %dkb\n", "Download", atoi(ptr));
	if ((ptr = getuserinfo(user, USERULSIZE, NULL)) != NULL)
		fprintf(fp, "%16s: %dkb\n", "Upload", atoi(ptr));
	if ((ptr = getuserinfo(user, USERARTREAD, NULL)) != NULL)
		fprintf(fp, "%16s: %d articles\n", "ArtRead", atoi(ptr));
	if ((ptr = getuserinfo(user, USERARTPOST, NULL)) != NULL)
		fprintf(fp, "%16s: %d articles\n", "ArtPost", atoi(ptr));
	if ((ptr = getuserinfo(user, USERMSGREAD, NULL)) != NULL)
		fprintf(fp, "%16s: %d messages\n", "MsgRead", atoi(ptr));
	if ((ptr = getuserinfo(user, USERMSGPOST, NULL)) != NULL)
		fprintf(fp, "%16s: %d messages\n", "MsgPost", atoi(ptr));
	if ((ptr = getuserinfo(user, REALNAME, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Real name", ptr);
	if ((ptr = getuserinfo(user, USERORG, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Organization", ptr);
	if ((ptr = getuserinfo(user, USERLOCATION, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Location", ptr);
	if ((ptr = getuserinfo(user, "PHONE", NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Phone number", ptr);
	if ((ptr = getuserinfo(user, USERDEFFROM, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "E-mail addr", ptr);
	if ((ptr = getuserinfo(user, SIGNATURE, NULL)) != NULL)
		fprintf(fp, "%16s: %s\n", "Signature", ptr);
}
