/*
 *	Copyright (c) 1996 The CAD lab of the
 *	Siberian State Academy of Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>

/* main.c */

#define	NC		"NetChat v1.2"
#define	BBS		"bbs"
#define	NETCHAT		"netchat"
#define	NETCHATCONF	"/etc/tns/netchat.conf"
#define	NETCHATHELP	"/etc/tns/netchat.help"
#define	NETCHATNAME	"[netchat]"

extern char *configfile;
extern char *helpfile;
extern char *username;
extern char *psysmode;
extern int dflag;

/* netchat.c */

#define	MAXHOSTS	100 /* max number of entries in conf file */
#define	MAXWAIT		10 /* max timeout for accepting data connection */
#define	MAXSILENT	90 /* max interval of silent time to mark host down */
#define	TRICKLE		30 /* trickle packet sent interval to mark host up */
#define	MAXCMDPOOL	3 /* max number of child tasks per time */
#define	LOOPBACK	"127.0.0.1"
#define	TMPFILEMASK	"/tmp/ncXXXXXX"
#define	MONITORDIR	"/tmp/tnsmon"
#define	TNSMONPID	"/tmp/tnsmon/PID"
#define	GETINFOMARKER	"<get info>"
#define	CMDSERVMARKER	"<cmd serv>"

/*
 * Format of config file.
 *   host[:port] [nick]
 */
struct conf {
	struct sockaddr_in *hin;	/* trusted host */
	char *nick;			/* it short name */
	time_t alive;			/* last time when host is alive */
};

/*
 * Message arguments.
 */
struct args {
	char *cmd;	/* command */
	char *host;	/* host arg */
	char *user;	/* user arg */
	char *txt;	/* text */
};

typedef	void (*sigfunc) ();

extern struct conf cf[];
extern int myport;
extern int userport;
extern int hn;

char *waitmsg(void);
void msgremote(int, ...);
void msglocal(char *, int, ...);
void msgreply(const char *, ...);
void hostcmd(int, char *, char *);
void mainloop(void);
FILE *opendata(int, char *);
void remotedata(int, struct args *);

/* loginfo.c */

#define	LOGINFOFILE	"/tmp/loginfo"
#define	MAXBBSUSERS	256
#define	MYTTY		"daemon"

/*
 * Format of loginfo record.
 */
struct loginfo {
	char	tty[12];
	char	name[26];
	time_t	ltime;
	pid_t	pid;
	int	baud;
	int	port;
	int	flags;
};

/* loginfo flags */
#define	MESGNO		1
#define	INTALK		2
#define	INCONF		4
#define	KICKER		8
#define TERMINATOR	16
#define	INFINITYCONF	32
#define	EXECEXT		64
#define	CHARGEUSER	128
#define	INFINITYUSER	256
#define	HIDDENUSER	512
#define	INRECVF		1024
#define	INSENDF		2048

struct loginfo *getinfo();
int saveinfo();
int purgeinfo();
void closeinfo();
char *flag2str();

/* cmds.c */

/*
 * Format of command table.
 */
struct cmd {
	char *name;	/* name of command */
	char host;	/* flag: host arg required */
	char user;	/* flag: user arg required */
	char txt;	/* flag: text arg required */
	void (*func) (int, int, struct args *); /* function to call */
};

extern struct cmd cmdtab[];

/* psys.c */

int initpsys(char *);
char *psys(char *, char *);
