/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#ifdef	HAVE_UTMPX_H
#include <utmpx.h>
#define ut_name	ut_user
#define	ut_time	ut_tv.tv_sec
#else
#include <utmp.h>
#endif

#include "utmpent.h"

static int fd = -1;

void
endutmpent()
{
	if (fd < 0) return;
	(void)close(fd);
	fd = -1;
}

struct utmpent *
getutmpent(user)
	char *user;
{
	int found;
	static struct utmpent e;
#ifdef	HAVE_UTMPX_H
	struct utmpx u;
#else
	struct utmp u;
#endif
	if (fd < 0) {
#if defined(UTMPX_FILE)
		fd = open(UTMPX_FILE, O_RDONLY);
#elif defined(UTMP_FILE)
		fd = open(UTMP_FILE, O_RDONLY);
#elif defined(_PATH_UTMP)
		fd = open(_PATH_UTMP, O_RDONLY);
#else
		if ((fd = open(VAR_RUN_UTMP, O_RDONLY)) < 0)
			fd = open(VAR_ADM_UTMP, O_RDONLY);
#endif
	}
	if (fd < 0) return NULL;

	found = 0;
	while (read(fd, (char *)&u, sizeof(u)) == sizeof(u)) {
		/* skip over empty fields */
		if (*u.ut_name == '\0') continue;
#ifdef	USER_PROCESS
		/* skip over system fields (if any) */
		if (u.ut_type != USER_PROCESS) continue;
#endif
		if (user != NULL && *user != '\0') {
			if (!strncmp(u.ut_name, user, sizeof(u.ut_name))) {
				found++;
				break;
			}
		} else if (strncmp(u.ut_name, "bbs", sizeof(u.ut_name)) &&
			   strncmp(u.ut_name, "tns", sizeof(u.ut_name))) {
			found++;
			break;
		}
	}
	if (!found) {
		endutmpent();
		return NULL;
	}
	(void)strncpy(e.name, u.ut_name, sizeof(u.ut_name));
	e.name[UTMPENT_NAMESIZE-1] = '\0';
	(void)strncpy(e.line, u.ut_line, sizeof(u.ut_line));
	e.line[UTMPENT_LINESIZE-1] = '\0';
	(void)strncpy(e.host, u.ut_host, sizeof(u.ut_host));
	e.host[UTMPENT_HOSTSIZE-1] = '\0';
	e.time = u.ut_time;

	return &e;
}

time_t
utmptime()
{
	int rcode;
	struct stat st;

#if defined(UTMPX_FILE)
	rcode = stat(UTMPX_FILE, &st);
#elif defined(UTMP_FILE)
	rcode = stat(UTMP_FILE, &st);
#elif defined(_PATH_UTMP)
	rcode = stat(_PATH_UTMP, &st);
#else
	if ((rcode = stat(VAR_RUN_UTMP, &st)) < 0)
		rcode = stat(VAR_ADM_UTMP, &st);
#endif
	if (rcode < 0) return 0;

	return st.st_mtime;
}
