/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <string.h>
#include <ctype.h>

char *
range_left(p)
	register char *p;
{
	while (*p != '\0' && *p != '(' && *p != '<') p++;
	if (*p == '\0') return (char *)0;
	*p++ = '\0';
	return p;
}

char *
range_right(s)
	char *s;
{
	register char *p = s + strlen(s);
	while (p != s && *p != ')' && *p != '>') p--;
	if (p == s) return (char *)0;
	*p = '\0';
	return s;
}

char *
addrnamecpy(t, s)
	char *t;
	register char *s;
{
	register char *p = t;
	int flag = 0;

	while (*s) {
		if (*s != '"' && ((unsigned char)*s > 0x20 || flag)) {
			*p++ = *s;
			flag = 1;
		}
		s++;
	}
	while (p != t) {
		if ((unsigned char)*(p-1) > 0x20) break;
		p--;
	}
	*p = '\0';
	return t;
}

/*
 *  Parse various From: lines into the component mail addresses and
 *  real names
 */
parsefrom(str, addr, name)
	char *str, *addr, *name;
{
	if (name != NULL) *name = '\0';
	if (strlen(str) > 79) strcpy(addr, "joe@foo.bar");	/* fake */
	else {
		register char *p, *p2;
		char buf[80];
		for (p = strcpy(buf, str); *p; p++)
			if ((unsigned char)*p < 0x20) *p = ' ';
		p = buf;
		if ((p2 = range_left(p)) != NULL && range_right(p2) != NULL) {
			if (strchr(p2, '@') != NULL) {
				p = p2;
				p2 = buf;
			}
			if (name != NULL) addrnamecpy(name, p2);
		}
		addrnamecpy(addr, p);
	}
}

int
maketrueaddr(sp, tp)
	char *sp, *tp;
{
	register sc, tc;
	sc = tc = 0;
	while (*sp) {
		*tp = chrlwr(*sp++);
		sc++;
		if (*tp <= ' ' || *tp == ',' || *tp == ';') break;
		if (islower(*tp) || isdigit(*tp) || strchr(".!@#%-_:/=", *tp)) {
			tp++;
			tc++;
		}
	}
	*tp = '\0';
	return (sc == tc);
}
