/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>

extern int errno;

/*
 * Load filename into memory. Return pointer or NULL
 */
char *
loadfile(filename)
	char *filename;
{
	int fd, nb;
	size_t size;
	struct stat st;
	static char *top = NULL;

	if (top != NULL) {
		free(top);
		top = NULL;
	}
	while ((fd = open(filename, O_RDONLY)) < 0 && errno == EINTR);
	if (fd < 0 || fstat(fd, &st) < 0) return NULL;
	size = st.st_size;
	if (size < 2 || (top = malloc(size + 2)) == NULL) {
		close(fd);
		return NULL;
	}
	while ((nb = read(fd, top, size)) < 0 && errno == EINTR);
	close(fd);
	if (nb != size) return NULL;
	if (top[nb-1] != '\n') top[nb++] = '\n';
	top[nb] = '\0';
	return top;
}
