/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef	HAVE_KVM_GETPROCS

#include <sys/types.h>
#include <sys/param.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/sysctl.h>
#include <sys/stat.h>
#include <kvm.h>
#include <fcntl.h>
#include <string.h>

int
killprocs(tty, sig)
	char *tty;
	int sig;
{
	kvm_t *kd;
	struct kinfo_proc *kp;
	int i, arg, cnt;
	struct stat st;
	char path[20];

	if (*tty != '/') {
		(void) strcpy(path, "/dev/");
		(void) strcat(path, tty);
		tty = path;
	}
	kd = kvm_open(NULL, NULL, NULL, O_RDONLY, "kvm_open");
	if (kd == NULL || stat(tty, &st) < 0) return -1;
	arg = st.st_rdev;
	kp = kvm_getprocs(kd, KERN_PROC_TTY, arg, &cnt);
	for (i = 0; i < cnt; i++)
		kill(kp[i].kp_proc.p_pid, sig);
	kvm_close(kd);
	return 0;
}

#else	/* HAVE_KVM_GETPROCS */

#include <sys/types.h>
#include <stdio.h>
#include <string.h>

int
killprocs(tty, sig)	/* quick hack */
	char *tty;
	int sig;
{
	FILE *fp;
	int cnt;
	pid_t pid;
	char buf[100];

	sprintf(buf, "/bin/ps -t%s", tty);
	fp = popen(buf, "r");
	if (fp == NULL) return -1;
	fgets(buf, sizeof(buf), fp);	/* eat header line */
	for (cnt = 0; fgets(buf, sizeof(buf), fp) != NULL &&
	     sscanf(buf, "%d", &pid) == 1; cnt++)
		kill(pid, sig);
	pclose(fp);
	if (cnt) return 0;

	if (*tty != '/')
		sprintf(buf, "/bin/ps -t/dev/%s", tty);
	else	sprintf(buf, "/bin/ps -t%s", tty+5);
	fp = popen(buf, "r");
	if (fp == NULL) return -1;
	fgets(buf, sizeof(buf), fp);	/* eat header line */
	for (cnt = 0; fgets(buf, sizeof(buf), fp) != NULL &&
	     sscanf(buf, "%d", &pid) == 1; cnt++)
		kill(pid, sig);
	pclose(fp);
	if (cnt) return 0;
	return -1;
}

#endif
