/*
 *	Copyright (c) 1997 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_UTMPENT_H_
#define	_TNS_UTMPENT_H_

#include <sys/types.h>

/* it maybe used as last resort */
#define	VAR_RUN_UTMP		"/var/run/utmp"
#define	VAR_ADM_UTMP		"/var/adm/utmp"

#define	UTMPENT_NAMESIZE	32
#define	UTMPENT_LINESIZE	32
#define	UTMPENT_HOSTSIZE	256

/*
 * System-independent utmp record.
 */
struct utmpent {
	char name[UTMPENT_NAMESIZE];	/* user login name */
	char line[UTMPENT_LINESIZE];	/* device name (ttyXX, ptsXXX, etc) */
	char host[UTMPENT_HOSTSIZE];	/* remote host name */
	time_t time;			/* user login time */
};

/*
 * Return a pointer to a next utmp record. If `user' non nil then match
 * it exactly. If the utmpfile is not open, it opens it.
 */
extern struct utmpent *getutmpent(char *user);

/* close utmpfile */
extern void endutmpent(void);

/* return time of last data modification */
extern time_t utmptime(void);

#endif	/* !_TNS_UTMPENT_H_ */
