/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_LOGINFO_H_
#define	_TNS_LOGINFO_H_

#include <sys/types.h>

/*
 * on-line shared info file.
 */
#define	LOGINFO_FILE		"/tmp/loginfo"
#define	LOGINFO_MAXENT		256	/* max entries (actually users) */
#define	LOGINFO_TTYLEN		12
#define	LOGINFO_NAMELEN		26

/*
 * loginfo record.
 */
struct loginfo {
	char	tty[LOGINFO_TTYLEN];	/* device name (ttyXX, ptsXXX, etc) */
	char	name[LOGINFO_NAMELEN];	/* user name */
	time_t	ltime;		/* login time */
	pid_t	pid;		/* drive PID */
	int	baud;		/* baud rate */
	int	port;		/* listening udp port (net bytes order) */
	int	flags;		/* state flags */
};

/*
 * state flags.
 */
#define	MESGNO		1	/* user have `mesg no' */
#define	INTALK		2	/* user in talk */
#define	INCONF		4	/* user in conference */
#define	KICKER		8	/* user have kicker permission in conf. */
#define TERMINATOR	16	/* user have terminator permission in conf. */
#define	INFINITYCONF	32	/* user trusted to be infinity in conf. */
#define	EXECEXT		64	/* drive swapned for external program */
#define	CHARGEUSER	128	/* used .cuser.conf instead of .user.conf */
#define	INFINITYUSER	256	/* infinity bbs user */
#define	HIDDENUSER	512	/* user temporary invisible in bbs system */
#define	INRECVF		1024	/* receiving file (bbs->user) */
#define	INSENDF		2048	/* sending file (user->bbs) */

/*
 * function prototypes.
 */
extern int saveinfo(struct loginfo *info);
extern void purgeinfo(struct loginfo *info);
extern struct loginfo *getinfo(int myself); /* include myself info or not */
extern void closeinfo(void);
extern time_t infotime(void);

#endif	/* !_TNS_LOGINFO_H_ */
