/*
 *	Copyright (c) 1994-1996 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_GROUP_H_
#define	_TNS_GROUP_H_

#include "rematch.h"

#define	MAINGROUPCONF	"/etc/tns/group"
#define	GROUPCONF	".group.conf"

/*
 * Group service ID (GSID)
 */
#define	GSID_NONE	0
#define	GSID_GROUP	1
#define	GSID_INCLUDE	2
#define	GSID_MENU	3	/* Menu elements	*/
#define	GSID_FILE	4	/* File operations	*/
#define	GSID_USENET	5	/* Usenet groups	*/
#define	GSID_MESSAGE	6	/* Messages areas	*/
#define	GSID_EMAIL	7	/* E-mail addresses	*/
#define	GSID_FTP	8	/* FTP addr/paths	*/

/*
 * Group right flags (GRF_x); bit mapped!
 */
#define	GRF_S		1	/* Scan permission	*/
#define	GRF_R		2	/* Read permission	*/
#define	GRF_W		4	/* Write permission	*/
#define	GRF_D		8	/* Delete permission	*/
#define	GRF_DEFAULT	(GRF_S|GRF_R|GRF_W)


/* internal magic cookie */

struct group_keyword {
	char *word;
	int key;
};
#define	BEGIN_GSID	2

extern struct group_keyword group_keywords[];

typedef struct grp_desc__ {
	char *expr;
	regex *rgc;
	unsigned char grf;
	unsigned char gsid;
	struct grp_desc__ *next;
} *grp_desc;

typedef struct grp_ent__ {
	char *name;
	grp_desc entry;
	struct grp_ent__ *next;
} *grp_ent;

extern grp_ent grp_first, grp_top;


/* Function prototypes */

/*
 * Initialize groups functions; must be called before any other functions.
 * Return -1 on error, 0 no groups or 1 if sucess.
 */
extern int initgrpbase(char *groupfile);

/*
 * Setup group for current user.
 * Return FALSE if such group not found or TRUE if succesfull.
 */
extern int setgrpname(char *groupname);

/*
 * Return group right flags (GRF_x) in group service ID (GSID)
 * for selected resource string.
 */
extern int getgrpright(int gsid, char *resource);

/*
 * Check GRF_x permission for recource string in group service ID (GSID)
 * Return TRUE if permission granted or FALSE if not.
 */
extern int isgrpright(int gsid, char *resource, int grf);

#endif	/* !_TNS_GROUP_H_ */
