/*
 *	Copyright (c) 1994-1996 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_CALLSIGN_H_
#define	_TNS_CALLSIGN_H_

#define	CALLSIGNLIST	".callsign.conf"

/*
 * Initialize callsign functions; must be called before any other functions.
 * The `orgdir' is a directory where plased CALLSIGNLIST file.
 * Return number of callsign entries.
 */
extern int initcallsign(char *orgdir);

/*
 * Search name by sign. Return name or NULL if not found.
 */
extern char *getnamebysign(char *sign);

/*
 * Search sign by name. Return sign or NULL if not found.
 */
extern char *getsignbyname(char *name);

/*
 * Add sign entry to callsign file. Return -1 on error, 0 if succesfull.
 */
extern int addsignent(char *sign, char *name);

/*
 * Return callsign entry; each next call return next entry or NULL if EOF.
 */
extern char *getsignent(void);

/*
 * Rewind callsign entries; after that getsignent() return first entry.
 */
extern void closesignent(void);

#endif	/* !_TNS_CALLSIGN_H_ */
