/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "drive.h"
#include "sysmsg.h"
#include "scandir.h"

char readfilesdir[80];

void
readfiles()
{
	int n, i, lncnt, rval, fidx[MAXSCRLINES];
	char *ptr, *file, path[1024], buf[100];
	struct dir_ent *flst;
	FILE *fp;

	pleasewait(1);
	if (*dirpath != '/')
		(void)sprintf(path, "%s/%s/%s", orgdir, dirpath, readfilesdir);
	else	(void)sprintf(path, "%s/%s", dirpath, readfilesdir);

	n = scan_dir(path, &flst, files_only, SCAN_SORTBYDATE);
	if (n < 1) {
		warning(MSG_NOFILESTOREAD, 1);
		return;
	}
	file = &path[strlen(path)-1];
	if (*file != '/') *++file = '/';
	file++;

	lncnt = 1;
	for (i = 0; i < n; i++) {
		(void)strcpy(file, flst[i].name);
		if ((fp = fopen(path, "r")) == NULL) continue;
		ptr = "";
		while (fgets(buf, sizeof(buf), fp) != NULL) {
			buf[sizeof(buf)-1] = '\0';
			if ((ptr = strchr(buf, '\n')) != NULL)
				*ptr = '\0';
			for (ptr = buf; *ptr; ptr++)
				if (*ptr == '\t') *ptr = ' ';
			for (ptr = buf;
			     (u_char)*ptr <= 0x20 && *ptr; ptr++);
			if (*ptr != '\0' && *ptr != '#') break;
		}
		fclose(fp);
		if (!*ptr) ptr = flst[i].name;
		if (lncnt == 1) {
			lncnt += 2;
			memset(fidx, 0, sizeof(fidx));
			fidx[0] = -1;
			snprintf(tmpbuf, MAXSTRINGLENGTH-8, "%s %s",
				 sysmsg(MSG_READFILESHEAD), makeshowpath(dirpath));
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[H\033[J\033[1;37;44m %-72.72s %5d\033[K\033[40m\n\n", tmpbuf, n);
			else {
				clearline();
				putstr("\n %s (%4d)\n\n", tmpbuf, n);
			}
		}
		fidx[lncnt-1] = i+1;
		if (termflags & (ANSITERM | RIPTERM))
			putstr("\033[1;33m%3d  \033[0;32m%-.20s  \033[36m%-.50s\n", i+1,
			       ctime(&flst[i].date)+4, ptr);
		else	putstr("%3d) [%-.20s] %-.50s\n", i+1,
			       ctime(&flst[i].date)+4, ptr);
more_again:
		rval = morenum(MSG_SELECTFILETOREAD, &lncnt, n);
		if (rval == -1) {
			free_dir(&flst, n);
			return;
		}
		if (rval > 0) {
			if (rval > n) {
				rval = fidx[(rval-n-1)/2];
				if (rval < 0) {
					free_dir(&flst, n);
					return;
				}
				if (!rval) {
					lncnt = scrlines;
					goto more_again;
				}
			}
			savescr();
			(void)strcpy(file, flst[rval-1].name);
			if (display(1, path) == 1)
				anykey();
			if (termflags & RIPTERM) {
				restorescr();
				lncnt = scrlines;
				goto more_again;
			}
			rval = -2;
		}
		if (rval == -2)	i -= (scrlines - 2) * 2;
		else if (rval == -3) i = n - (scrlines - 2) - 1;
		else if (rval == -4) i = -1;
		if (i < -1) i = -1;
	}
	lncnt = scrlines;
	goto more_again;
}
