/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include "compat.h"
#include "drive.h"
#include "sysmsg.h"
#include "usenet.h"
#include "callsign.h"
#include "group.h"
#include "variables.h"
#include "getconf.h"
#include "loginfo.h"
#include "version.h"

#define	MAX_ADDR_LEN		50

extern struct loginfo process;

extern char note_h_followup[];
extern char note_h_subj[];
extern char note_h_distrib[];
extern char note_h_messageid[];
extern char note_h_from[];
extern char note_h_newsgroups[];
extern char note_h_reply[];
extern char note_h_date[];
extern char note_h_keywords[];
extern char note_h_xcomment[];
extern char note_from_addr[];
extern char note_full_name[];
extern FILE *note_fp;
extern int canpost;

char *
fromfield(realname)
	int realname;
{
	register char *p;
	static char from[128];

	if ((p = getuserconf(USERDEFFROM, NULL)) == NULL) {
		if (realname && (p = getuserconf(REALNAME, NULL)) != NULL)
			sprintf(from, "%s@%s (%s)", callsign, systemhost, p);
		else	sprintf(from, "%s@%s", callsign, systemhost);
		p = from;
	} else	p = strcpy(from, p);
	return p;
}

void
mail_to_sysop()
{
	FILE *fp, *fpw;

	unlink(editorworkfile);
	if (!invoke_editor(0)) return;
	if ((fp = sfopen(editorworkfile, "r")) == NULL) return;
	if ((fpw = sfopen(writeletter, "w")) == NULL) {
		sfclose(fp);
		return;
	}
	fprint_msgid(fpw, systemhost);
	fprintf(fpw, "From: %s\n", fromfield(TRUE));
	fprintf(fpw, "To: %s\n", sysmailto);
	fprintf(fpw, "Subject: Comment to SysOp from %s\n", process.name);
	fprintf(fpw, "Organization: %s\n", getuserconf(USERORG, systemname));

/*		Patched by SLA		*/
	fprintf(fpw, "MIME-Version: 1.0\n");
	fprintf(fpw, "Content-Type: text/plain; charset=koi8-r\n");
	fprintf(fpw, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

	fprintf(fpw, "X-Mailer: %s\n\n", systemid);

        copy_fp(fp, fpw, "");
	sfclose(fp);
	add_signature(fpw);
	sfclose(fpw);
	chmod(writeletter, 0640);
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;36m");
	putstr("\r%s %s", sysmsg(MSG_MAILING), sysmailto);
	putstr("... ");
	if (!invoke_syscmd("%s %s %s", mailerprog, sysmailto, writeletter)) {
		putstr("\n%s\n", sysmsg(MSG_CANTOPENFILE));
		LOGIT(LOG_WARNING, "Mail for %s rejected", sysmailto);
	} else {
		putstr("\n%s\n", sysmsg(MSG_MSGPOSTED));
		LOGIT(LOG_NOTICE, "Post mail for %s", sysmailto);
	}
	unlink(editorworkfile);
}

/*
 *  Post an original article (not a followup)
 */
post_base(group)
	char *group;
{
	int rval;
	FILE *fp, *fpw;
	char subj[256], keyw[80], dist[80], *ptr;

	if (!canpost) {
		putstr("%s\n", sysmsg(MSG_YOUCANTPOST));
		return FALSE;
	}
	unlink(editorworkfile);
	subj[0] = '\0';
	keyw[0] = '\0';
	dist[0] = '\0';
	rval = 1;
	do {
		switch (rval) {
		case 1:
			clearscr();
			(void)prompt_str(MSG_NEWSGROUPS, group, -1);
			(void)prompt_str(MSG_MSGFROM, fromfield(TRUE), -1);
			if ((ptr = prompt_str(MSG_MSGSUBJECT, subj, 0)) == NULL) return FALSE;
			putchr('\n');
			strncpy(subj, ptr, 255);
			subj[255] = 0;
			if ((ptr = prompt_str(MSG_MSGKEYWORD, keyw, 0)) != NULL) {
				putchr('\n');
				strncpy(keyw, ptr, 79);
				keyw[79] = 0;
			}
			if ((ptr = prompt_str(MSG_MSGDISTRIB, dist, 0)) != NULL) {
				putchr('\n');
				strncpy(dist, ptr, 79);
				dist[79] = 0;
			}

			if (!invoke_editor(0)) return FALSE;

			if ((fp = sfopen(editorworkfile, "r")) == NULL)
				return FALSE;
			if ((fpw = sfopen(writearticle, "w")) == NULL) {
				sfclose(fp);
				return FALSE;
			}
			fprint_msgid(fpw, systemhost);
			fprintf(fpw, "From: %s\n", fromfield(TRUE));
			fprintf(fpw, "Subject: %s\n", subj);
			fprintf(fpw, "Newsgroups: %s\n", group);
			fprintf(fpw, "Organization: %s\n",
				getuserconf(USERORG, systemname));
			if (*keyw != '\0')
				fprintf(fpw, "Keywords: %s\n", keyw);
			fprintf(fpw, "Distribution: %s\n", dist);

/*		Patched by SLA		*/
			fprintf(fpw, "MIME-Version: 1.0\n");
			fprintf(fpw, "Content-Type: text/plain; charset=koi8-r\n");
			fprintf(fpw, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

			fprintf(fpw, "X-Newsreader: %s\n\n", systemid);

			copy_fp(fp, fpw, "");
			sfclose(fp);
			add_signature(fpw);
			sfclose(fpw);
			chmod(writearticle, 0640);
			break;
		case 2:
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[1;36m");
			putstr("\r%s  ", sysmsg(MSG_POSTING));
			if (invoke_syscmd("%s %s", inewsprog, writearticle)) {
				putstr("\n%s\n", sysmsg(MSG_ARTICLEPOSTED));
				LOGIT(LOG_NOTICE, "Post article to \"%s\"", group);
				unlink(editorworkfile);
				return TRUE;
			} else {
				putstr("\n%s\n", sysmsg(MSG_ARTICLEREJECTED));
				LOGIT(LOG_WARNING, "Article to \"%s\" rejected", group);
				break;
			}
		}
	} while ((rval = MsgAfterEditor()) != 0);
	return FALSE;
}

post_cancel(group)
	char *group;
{
	FILE *fp;

	if (!canpost) {
		putstr("%s\n", sysmsg(MSG_YOUCANTPOST));
		return FALSE;
	}
	if (prompt_yn(MSG_CANCELARTICLE, NULL, 'N')) return FALSE;
	if ((fp = sfopen(writearticle, "w")) == NULL) return FALSE;
	fprint_msgid(fp, systemhost);
	fprintf(fp, "From: %s\n", fromfield(TRUE));
	fprintf(fp, "Subject: Re: %s\n", eat_re(note_h_subj));
	fprintf(fp, "Newsgroups: %s\n", note_h_newsgroups);
	fprintf(fp, "Organization: %s\n", getuserconf(USERORG, systemname));

/*		Patched by SLA		*/
	fprintf(fp, "MIME-Version: 1.0\n");
	fprintf(fp, "Content-Type: text/plain; charset=koi8-r\n");
	fprintf(fp, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

	fprintf(fp, "X-Newsreader: %s\n", systemid);
	if (*note_h_distrib) fprintf(fp, "Distribution: %s\n", note_h_distrib);
	fprintf(fp, "Control: cancel %s\n\n", note_h_messageid);
	fprintf(fp, "cancel %s\n", note_h_messageid);
	add_signature(fp);
	sfclose(fp);
	chmod(writearticle, 0640);

	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;36m");
	putstr("\r%s  ", sysmsg(MSG_POSTING));
	if (!invoke_syscmd("%s %s", inewsprog, writearticle)) {
		putstr("\n%s\n", sysmsg(MSG_ARTICLEREJECTED));
		LOGIT(LOG_WARNING, "Cancel to \"%s\" rejected", group);
		return FALSE;
	}
	putstr("\n%s\n", sysmsg(MSG_ARTICLEPOSTED));
	LOGIT(LOG_WARNING, "Cancel article in \"%s\"", group);
	return TRUE;
}

post_response(group, copy_text)
	char *group;
	int copy_text;
{
	int rval, lines, followup = 0;
	FILE *fp, *fpw;
	char subj[256], *ptr;

	if (!canpost) {
		warning(MSG_YOUCANTPOST, 0);
		anykey();
		return FALSE;
	}
	unlink(editorworkfile);
	if (strcmp(note_h_followup, "poster") == 0) {
		putstr("%s\n\n", sysmsg(MSG_RESPTOPOSTER));
		if (prompt_yn(MSG_POSTANYWAY, NULL, 'N')) return FALSE;
		followup++;
	} else if ((*note_h_followup && strcmp(note_h_followup, group) != 0) ||
		   (*note_h_newsgroups && strcmp(note_h_newsgroups, group) != 0)) {
		char *ptr2;
		putstr("%s:\n\n", sysmsg(MSG_RESPTOGROUPS));
		if (strcmp(note_h_followup, group) != 0)
			ptr = note_h_followup;
		else	ptr = note_h_newsgroups;
		ptr2 = strcpy(subj, ptr);
		while (ptr = strtok(ptr2, ", \t")) {
			putstr("        %s\n", ptr);
			ptr2 = NULL;
		}
		putchr('\n');
		if (prompt_yn(MSG_POSTANYWAY, NULL, 'N')) return FALSE;
		followup++;
	}
	if (copy_text) {
		if ((fp = sfopen(editorworkfile, "w")) == NULL) return FALSE;
		sprintf(subj, sysmsg(MSG_MSGREPLYHEADER),
			note_h_date, note_h_from);
		fprintf(fp, "%s\n", subj);
		fseek(note_fp, note_mark[0], 0);
		lines = copy_fp(note_fp, fp, "> ") + 2;
		sfclose(fp);
	} else	lines = 0;
	snprintf(subj, 255, "Re: %s", eat_re(note_h_subj));
	rval = 1;
	do {
		switch (rval) {
		case 1:
			clearscr();
			(void)prompt_str(MSG_NEWSGROUPS, group, -1);
			(void)prompt_str(MSG_MSGFROM, fromfield(TRUE), -1);
			if ((ptr = prompt_str(MSG_MSGSUBJECT, subj, 0)) == NULL) return FALSE;
			putchr('\n');
			strncpy(subj, ptr, 255);
			subj[255] = 0;

			if (!invoke_editor(lines)) return FALSE;
			lines = 0;

			if ((fp = sfopen(editorworkfile, "r")) == NULL)
				return FALSE;
			if ((fpw = sfopen(writearticle, "w")) == NULL) {
				sfclose(fp);
				return FALSE;
			}
			fprint_msgid(fpw, systemhost);
			fprintf(fpw, "From: %s\n", fromfield(TRUE));
			fprintf(fpw, "Subject: %s\n", subj);
			fprintf(fpw, "Newsgroups: %s\n", group);
			if (followup)
				fprintf(fpw, "Followup-To: %s\n", note_h_followup);
			fprintf(fpw, "Organization: %s\n", getuserconf(USERORG, systemname));
			if (*note_h_keywords != '\0')
				fprintf(fpw, "Keywords: %s\n", note_h_keywords);
			if (*note_h_distrib != '\0')
				fprintf(fpw, "Distribution: %s\n", note_h_distrib);
			fprintf(fpw, "References: %s\n", note_h_messageid);
			if (*note_h_xcomment != '\0')
				fprintf(fpw, "X-Comment-To: %s\n", note_h_from);

/*		Patched by SLA		*/
			fprintf(fpw, "MIME-Version: 1.0\n");
			fprintf(fpw, "Content-Type: text/plain; charset=koi8-r\n");
			fprintf(fpw, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

			fprintf(fpw, "X-Newsreader: %s\n\n", systemid);

			copy_fp(fp, fpw, "");
			sfclose(fp);
			add_signature(fpw);
			sfclose(fpw);
			chmod(writearticle, 0640);
			break;
		case 2:
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[1;36m");
			putstr("\r%s  ", sysmsg(MSG_POSTING));
			if (invoke_syscmd("%s %s", inewsprog, writearticle)) {
				putstr("\n%s\n", sysmsg(MSG_ARTICLEPOSTED));
				LOGIT(LOG_NOTICE, "Post response to \"%s\"", group);
				unlink(editorworkfile);
				return TRUE;
			} else {
				putstr("\n%s\n", sysmsg(MSG_ARTICLEREJECTED));
				LOGIT(LOG_WARNING, "Response to \"%s\" rejected", group);
				break;
			}
		}
	} while ((rval = MsgAfterEditor()) != 0);
	return FALSE;
}

mail_to_someone(bounce)
	int bounce;
{
	int rval, lines;
	FILE *fp, *fpw;
	char mail_to[256], *ptr;

	if (!canpost) {
		warning(MSG_YOUCANTPOST, 0);
		anykey();
		return FALSE;
	}
	unlink(editorworkfile);
	if ((fp = sfopen(editorworkfile, "w")) == NULL)	return FALSE;
	fseek(note_fp, 0L, 0);
	lines = copy_fp(note_fp, fp, "") + 2;
	sfclose(fp);
	mail_to[0] = '\0';
	rval = 1;
	do {
		switch (rval) {
		case 1:
			if (!ask_emailaddr(bounce ? MSG_BOUNCEARTICLETO :
					   MSG_MAILARTICLETO, mail_to))
				return FALSE;
			if (!invoke_editor(lines)) return FALSE;
			lines = 0;

			if ((fp = sfopen(editorworkfile, "r")) == NULL)
				return FALSE;
			if ((fpw = sfopen(writeletter, "w")) == NULL) {
				sfclose(fp);
				return FALSE;
			}
			fprint_msgid(fpw, systemhost);
			fprintf(fpw, "From: %s\n", fromfield(TRUE));
			fprintf(fpw, "To: %s\n", mail_to);
			if (!bounce) {
				fprintf(fpw, "Subject: %s\n", note_h_subj);
				if (*note_h_followup) ptr = note_h_followup;
				else ptr = note_h_newsgroups;
				fprintf(fpw, "Newsgroups: %s\n", ptr);
				fprintf(fpw, "Organization: %s\n",
					getuserconf(USERORG, systemname));

/*		Patched by SLA		*/
				fprintf(fpw, "MIME-Version: 1.0\n");
				fprintf(fpw, "Content-Type: text/plain; charset=koi8-r\n");
				fprintf(fpw, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

				fprintf(fpw, "X-Mailer: %s\n", systemid);
			}
			fprintf(fpw, "\n");
			copy_fp(fp, fpw, "");
			sfclose(fp);
			if (!bounce) add_signature(fpw);
			sfclose(fpw);
			chmod(writeletter, 0640);
			break;
		case 2:
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[1;36m");
			putstr("\r%s %s... ", sysmsg(MSG_MAILING), mail_to);
			if (invoke_syscmd("%s %s %s", mailerprog, mail_to, writeletter)) {
				putstr("\n%s\n", sysmsg(MSG_MSGPOSTED));
				LOGIT(LOG_NOTICE, "Post mail for %s", mail_to);
				unlink(editorworkfile);
				return TRUE;
			} else {
				putstr("\n%s\n", sysmsg(MSG_CANTOPENFILE));
				LOGIT(LOG_WARNING, "Mail for %s rejected", mail_to);
				break;
			}
		}
	} while ((rval = MsgAfterEditor()) != 0);
	return FALSE;
}

mail_to_author(copy_text)
	int copy_text;
{
	int rval, lines;
	FILE *fp, *fpw;
	char header[2048], buf[LEN];

	if (!canpost) {
		warning(MSG_YOUCANTPOST, 0);
		anykey();
		return FALSE;
	}
	unlink(editorworkfile);
	header[0] = 0;
	strcatf(header, "From: %s\n", fromfield(TRUE));
	strcatf(header, "To: %s", note_from_addr);
	if (*note_full_name != '\0') strcatf(header, " (%s)", note_full_name);
	strcat(header, "\n");
	strcatf(header, "Subject: Re: %s\n", eat_re(note_h_subj));
	strcatf(header, "Newsgroups: %s\n", note_h_newsgroups);
	strcatf(header, "Organization: %s\n", getuserconf(USERORG, systemname));

/*		Patched by SLA		*/
	strcatf(header, "MIME-Version: 1.0\n");
	strcatf(header, "Content-Type: text/plain; charset=koi8-r\n");
	strcatf(header, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

	strcatf(header, "X-Mailer: %s\n\n", systemid);
	if (copy_text) {
		if ((fp = sfopen(editorworkfile, "w")) == NULL) return FALSE;
		sprintf(buf, sysmsg(MSG_MSGARTREPLYHEAD), note_h_messageid);
		fprintf(fp, "%s\n", buf);
		fseek(note_fp, note_mark[0], 0);
		lines = copy_fp(note_fp, fp, "> ") + 2;
		sfclose(fp);
	} else	lines = 0;
	rval = 1;
	do {
		switch (rval) {
		case 1:
			if (!invoke_editor(lines)) return FALSE;
			lines = 0;

			if ((fp = sfopen(editorworkfile, "r")) == NULL)
				return FALSE;
			if ((fpw = sfopen(writeletter, "w")) == NULL) {
				sfclose(fp);
				return FALSE;
			}
			fprintf(fpw, header);
			copy_fp(fp, fpw, "");
			sfclose(fp);
			add_signature(fpw);
			sfclose(fpw);
			chmod(writeletter, 0640);
			break;
		case 2:
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[1;36m");
			putstr("\r%s %s...  ", sysmsg(MSG_MAILING), note_from_addr);
			if (invoke_syscmd("%s %s %s", mailerprog, note_from_addr, writeletter)) {
				putstr("\n%s\n", sysmsg(MSG_MSGPOSTED));
				LOGIT(LOG_NOTICE, "Post mail for %s", note_from_addr);
				unlink(editorworkfile);
				return TRUE;
			} else {
				putstr("\n%s\n", sysmsg(MSG_CANTOPENFILE));
				LOGIT(LOG_WARNING, "Mail for %s rejected", note_from_addr);
				break;
			}
		}
	} while ((rval = MsgAfterEditor()) != 0);
	return FALSE;
}

char *
email_forward(home)
	char *home;
{
	FILE *fp;
	char *p;
	static char buf[256];

	snprintf(buf, sizeof(buf), "%s/%s", home, USERFORWARDFILE);
	if ((fp = fopen(buf, "r")) == NULL) return NULL;
	buf[0] = '\0';
	fgets(buf, sizeof(buf), fp);
	fclose(fp);
	buf[sizeof(buf)-1] = '\0';
	if ((p = strchr(buf, '\n')) != NULL) *p = '\0';
	return *buf ? buf : NULL;
}

enter_mail(addr, rsubj, msgid, lines)
	char *addr, *rsubj, *msgid;
	int lines;
{
	int rval, sysmail;
	FILE *fp, *fpw;
	char email[256], email_cc[256], subj[256], mail_to[512], *ptr, *ptr2;
	extern int UserMsgPost, MsgPostLimit;

	if (addr != NULL) {
		strncpy(email, addr, 255);
		email[255] = '\0';
	} else	email[0] = '\0';
	if (rsubj != NULL) strcpy(subj, rsubj);
	else {
		subj[0] = '\0';
		unlink(editorworkfile);
	}
	email_cc[0] = '\0';
	rval = 1;

	do {
		switch (rval) {
		case 1:
			clearscr();
			(void)prompt_str(MSG_MESSAGEAREA, makeshowpath(homedir), -1);
			(void)prompt_str(MSG_MSGFROM, fromfield(TRUE), -1);
			if (!ask_emailaddr(MSG_MSGTO, email)) return FALSE;
			sysmail = !strcasecmp(email, sysmailto);
			if (!sysmail && MsgPostLimit && UserMsgPost >= MsgPostLimit) {
				warning(MSG_MSGPOSTLIMIT, 1);
				anykey();
				return FALSE;
			}

			if ((ptr = prompt_str(MSG_MSGSUBJECT, subj, 0)) == NULL)
				return FALSE;
			putchr('\n');
			strncpy(subj, ptr, 255);
			subj[255] = 0;

			if (ask_emailaddr(MSG_MSGCC, email_cc)) {
				if (MsgPostLimit && strcasecmp(email_cc, sysmailto) &&
				    UserMsgPost >= MsgPostLimit) {
					warning(MSG_MSGPOSTLIMIT, 1);
					anykey();
					return FALSE;
				}
			} else email_cc[0] = '\0';

			rval = !prompt_yn(MSG_ASKRETURNRECEIPT, NULL, 'N');

			if (!invoke_editor(lines)) return FALSE;
			lines = 0;

			if ((fp = sfopen(editorworkfile, "r")) == NULL)
				return FALSE;
			if ((fpw = sfopen(writeletter, "w")) == NULL) {
				sfclose(fp);
				return FALSE;
			}
			fprint_msgid(fpw, systemhost);
			if (msgid != NULL) fprintf(fpw, "References: %s\n", msgid);
			ptr = fromfield(FALSE);
			fprintf(fpw, "From: %s (%s)\n", ptr, getuserconf(REALNAME, DEFREALNAME));
			fprintf(fpw, "To: %s\n", email);
			if (email_cc[0]) fprintf(fpw, "Cc: %s\n", email_cc);
			fprintf(fpw, "Subject: %s\n", subj);
			fprintf(fpw, "Organization: %s\n",
				getuserconf(USERORG, systemname));
			if ((ptr2 = email_forward(homedir)) != NULL) ptr = ptr2;
			fprintf(fpw, "Reply-To: %s\n", ptr);
			if (rval) fprintf(fpw, "Return-Receipt-To: %s\n", ptr);

/*		Patched by SLA		*/
			fprintf(fpw, "MIME-Version: 1.0\n");
			fprintf(fpw, "Content-Type: text/plain; charset=koi8-r\n");
			fprintf(fpw, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

			fprintf(fpw, "X-Folder: E-mail\n");
			fprintf(fpw, "X-Mailer: %s\n\n", systemid);
			copy_fp(fp, fpw, "");
			sfclose(fp);
			add_signature(fpw);
			fputc('\n', fpw);
			sfclose(fpw);
			chmod(writeletter, 0640);
			break;
		case 2:
			strcpy(mail_to, email);
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[1;36m");
			putstr("\r%s %s", sysmsg(MSG_MAILING), email);
			if (email_cc[0]) {
				putstr(", %s", email_cc);
				strcatf(mail_to, ",%s", email_cc);
			}
			putstr("... ");
			if (invoke_syscmd("%s %s %s", mailerprog, mail_to, writeletter)) {
				if (!sysmail) UserMsgPost++;
				putstr("\n%s\n", sysmsg(MSG_MSGPOSTED));
				LOGIT(LOG_NOTICE, "Post mail for %s", mail_to);
				unlink(editorworkfile);
				return TRUE;
			} else {
				putstr("\n%s\n", sysmsg(MSG_CANTOPENFILE));
				LOGIT(LOG_WARNING, "Mail for %s rejected", mail_to);
				break;
			}
		}
	} while ((rval = MsgAfterEditor()) != 0);
	return FALSE;
}

char *
isitalias(addr)
	char *addr;
{
	char *ptr, *p2, *line, buf[1024];
	static char alias[80];
	
	sprintf(buf, "%s/%s", homedir, ALIASESFILE);
	if ((ptr = loadfile(buf)) == NULL &&
	    (ptr = loadfile(ALIASESFILE)) == NULL) return 0;

	for (; (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		for (p2 = ptr; (u_char)*p2 > 0x20; p2++);
		if (*p2) for (*p2++ = 0; (u_char)*p2 <= 0x20 && *p2 != 0; p2++);
		if (!*p2) continue;
		if (rematch(ptr, addr)) return strcpy(alias, p2);
	}
	return NULL;
}

char *
user2addr(user)
	char *user;
{
	char *p, *p2, temp[80];
	static char addr[80];

	if (!strcasecmp(user, "sysop") || !strcasecmp(user, "sysadm"))
		user = sysadmname;

	if ((p = getuserfile(user)) == NULL) return NULL;
	if ((p = getusername(p)) == NULL) return NULL;

	if ((p2 = getsignbyname(p)) == NULL) {
		strcpy(temp, p);
		if ((p2 = strchr(temp, ' ')) != NULL) {
			*p2 = '.';
			p2 = temp;
		}
	}
	sprintf(addr, "\"%s\" <%s@%s>", p, p2, systemhost);
	return addr;
}

ask_emailaddr(pnum, email)
	int pnum;
	char *email;
{
	int maxlen = MAX_ADDR_LEN;
	char *ptr, *ptr2;

to_again:
	if ((ptr = prompt_str(pnum, email, maxlen)) == NULL) return FALSE;
	if (maxlen < 0) {
		char buf[256];
		parsefrom(strcpy(buf, email), email, NULL);
		return TRUE;
	}
	if (*ptr == '?') {
		*email = '\0';
		if (!display(1, "%s/%s", homedir, ALIASESFILE))
			warning(MSG_NOALIASES, 1);
		goto to_again;
	}
	if (!strcasecmp(ptr, "sysop") || !strcasecmp(ptr, "sysadm") ||
	    !strcasecmp(ptr, sysadmname)) {
		strcpy(email, sysmailto);
		maxlen = -1;
		goto to_again;
	}
	if (strchr(ptr, '@') == NULL) {
		if ((ptr2 = isitalias(ptr)) != NULL) {
			strcpy(email, ptr2);
			maxlen = -1;
			goto to_again;
		}
		if ((ptr = user2addr(ptr)) == NULL) {
			warning(MSG_NOSUCHALIAS, 1);
			strcpy(email, "?");
		} else {
			strcpy(email, ptr);
			maxlen = -1;
		}
		goto to_again;
	}
	if (!maketrueaddr(ptr, email)) {
		warning(MSG_ILLEGALADDR, 1);
		goto to_again;
	}
	if (isillegaladdr(email) || !isgrpright(GSID_EMAIL, email, GRF_W)) {
		*email = '\0';
		warning(MSG_ILLEGALADDR, 1);
		goto to_again;
	}
	maxlen = -1;	/* all done */
	goto to_again;
}

enter_folder(folder, user, rsubj, msgid, lines)
	char *folder, *user, *rsubj, *msgid;
	int lines;
{
	int rval;
	struct stat st;
	FILE *fp, *fpw;
	char buf[1024], from[256], to[256], subj[256], *ptr;
	extern char *bigbuf;

	sprintf(from, "\"%s\" <%s>", process.name, fromfield(FALSE));
	if (user != NULL) {
		strncpy(to, user, sizeof(to));
		to[sizeof(to)-1] = '\0';
	} else	strcpy(to, "All");
	if (rsubj != NULL) strcpy(subj, rsubj);
	else {
		subj[0] = '\0';
		unlink(editorworkfile);
	}
	rval = 1;
	do {
		switch (rval) {
		case 1:
			clearscr();
			(void)prompt_str(MSG_MESSAGEAREA, makeshowpath(folder), -1);
			(void)prompt_str(MSG_MSGFROM, from, -1);
			if (!ask_useraddr(to)) return FALSE;
			if ((ptr = prompt_str(MSG_MSGSUBJECT, subj, 0)) == NULL)
				return FALSE;
			putchr('\n');
			strncpy(subj, ptr, sizeof(subj));
			subj[sizeof(subj)-1] = 0;

			if (!invoke_editor(lines)) return FALSE;
			lines = 0;

			if ((fp = sfopen(editorworkfile, "r")) == NULL)
				return FALSE;
			if ((fpw = sfopen(writeletter, "w")) == NULL) {
				sfclose(fp);
				return FALSE;
			}
			fprint_msgid(fpw, systemhost);
			if (msgid != NULL) fprintf(fpw, "References: %s\n", msgid);
			fprintf(fpw, "From: %s\n", from);
			fprintf(fpw, "Organization: %s\n", getuserconf(USERORG, systemname));
			if (to[0]) fprintf(fpw, "To: %s\n", to);
			fprintf(fpw, "Subject: %s\n", subj);
			fprintf(fpw, "X-Folder: %s\n", strippath(folder));

/*		Patched by SLA		*/
			fprintf(fpw, "MIME-Version: 1.0\n");
			fprintf(fpw, "Content-Type: text/plain; charset=koi8-r\n");
			fprintf(fpw, "Content-Transfer-Encoding: 8bit\n");
/*		End Patch		*/

			fprintf(fpw, "X-Mailer: %s\n\n", systemid);
			rval = 1;
			while (fgets(buf, sizeof(buf), fp) != NULL) {
				buf[sizeof(buf)-1] = '\0';
				if (rval && !strncmp(buf, "From ", 5))
					fputc('>', fpw);
				fputs(buf, fpw);
				rval = (*buf == '\0' || *buf == '\n');
			}
			sfclose(fp);
			add_signature(fpw);
			sfclose(fpw);
			chmod(writeletter, 0640);
			break;
		case 2:
			if ((fp = sfopen(writeletter, "r")) == NULL)
				return FALSE;
			rval = -1;
			if (fstat(fileno(fp), &st) == 0 &&
			    (fpw = sfopen(folder, "a")) != NULL) {
				time_t now = time(NULL);
				flock(fileno(fpw), LOCK_EX);
				fprintf(fpw, "From %s %s", package, ctime(&now));
				rval = fast_copy_fp(fp, fpw, (int)st.st_size);
				fputc('\n', fpw);
				flock(fileno(fpw), LOCK_UN);
				sfclose(fpw);
				if (bigbuf != NULL) {
					free(bigbuf);
					bigbuf = NULL;
				}
			}
			sfclose(fp);
			if (rval == 0) {
				putstr("\r%s\n", sysmsg(MSG_MSGPOSTED));
				LOGIT(LOG_NOTICE, "Post msg to \"%s\"", folder);
				unlink(editorworkfile);
				return TRUE;
			} else {
				warning(MSG_CANTOPENFILE, 1);
				LOGIT(LOG_WARNING, "Msg to \"%s\" rejected", folder);
				break;
			}
		}
	} while ((rval = MsgAfterEditor()) != 0);
	return FALSE;
}

ask_useraddr(user)
	char *user;
{
	int maxlen = MAX_ADDR_LEN;
	char *p, *p2;

to_again:
	if ((p = prompt_str(MSG_MSGTO, user, maxlen)) == NULL) return FALSE;
	if (maxlen < 0) return TRUE;
	if (*p == '?') {
		*user = '\0';
		user_list();
		goto to_again;
	}
	if (!strcasecmp(p, "All")) {
		*user = '\0';
		return TRUE;
	}
	if ((p2 = strchr(p, '@')) != NULL) *p2 = '\0';
	if ((p = user2addr(p)) == NULL) {
		warning(MSG_NOSUCHUSER, 1);
		strcpy(user, "?");
	} else {
		strcpy(user, p);
		maxlen = -1;	/* all done */
	}
	goto to_again;
}
