/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include "drive.h"
#include "usenet.h"
#include "sysmsg.h"
#include "group.h"

char note_h_path[LEN];			/* Path:	*/
char note_h_date[LEN];			/* Date:	*/
char note_h_subj[LEN];			/* Subject:	*/
char note_h_from[LEN];			/* From:	*/
char note_h_reply[LEN];			/* Reply-To:	*/
char note_h_org[LEN];			/* Organization: */
char note_h_newsgroups[LEN];		/* Newsgroups:	*/
char note_h_messageid[LEN];		/* Message-ID:	*/
char note_h_distrib[LEN];		/* Distribution: */
char note_h_followup[LEN];		/* Followup-To: */
char note_h_keywords[LEN];		/* Keywords:	*/
char note_h_xcomment[LEN];		/* X-Comment-To */

int	note_line;
int	note_page;		/* what page we're on */
long	note_mark[MAX_PAGES];	/* ftells on beginnings of pages */
FILE	*note_fp = NULL;	/* the body of the current article */
int	note_end;		/* we're done showing this article */
int	rotate;			/* 0=normal, 13=rot13 decode */

extern long note_size;		/* stat size in bytes of article */

char	note_full_name[LEN];
char	note_from_addr[LEN];

int ch_instead = 0;

int last_resp;		/* current & previous article for - command */
int this_resp;

int glob_respnum;
char *glob_page_group;

extern int curgrpidx;

int
show_page(respnum, group, group_path)
int respnum;
char *group;
char *group_path;
{
	char ch;
	int n, i;
	long art;

	globalflags |= USENETREADERINUSE;
restart:
	glob_respnum = respnum;
	glob_page_group = group;

	if (respnum != this_resp) {	   /* remember current & previous */
		last_resp = this_resp;	   /* articles for - command */
		this_resp = respnum;
	}

	rotate = 0;			/* normal mode, not rot13 */
	art = arts[respnum].artnum;
	arts[respnum].unread = 0;	/* mark article as read */
	open_note(art, group_path);

	if (note_page == NOTE_UNAVAIL) warning(MSG_ARTICLEUNAVAIL, 1);
	else if (show_note_page(respnum, group) < 0) {
		globalflags &= ~USENETREADERINUSE;
		return which_base(respnum);
	}
	showbuttons(1);
	while (1) {
		if (ch_instead) {
			ch = ch_instead;
			ch_instead = 0;
		} else	ch = getchr(1);

		if (ch >= '0' && ch <= '9') {
			if ((n = prompt_num(MSG_ENTERRESPNUM, ch - '0', 0)) > 0) {
				respnum = choose_resp(which_base(respnum), n);
				goto restart;
			}
		} else switch (ch) {
			case 'a':	/* author search forward */
			case 'A':	/* author search backward */
				i = (ch == 'a');
				if ((n = search_author(respnum, i)) >= 0) {
					respnum = n;
					goto restart;
				}
				break;
			case 's':	/* subject search forward */
			case 'S':	/* subject search backward */
				i = (ch == 's');
				if ((n = search_subject(respnum, i)) >= 0) {
					respnum = n;
					goto restart;
				}
				break;
			case 'B':	/* body search */
				if ((n = search_body(respnum, group_path)) >= 0) {
					respnum = n;
					goto restart;
				}
				break;
			case ctrl('X'):
			case '%':	/* toggle rot-13 mode */
				if (rotate)	rotate = 0;
				else		rotate = 13;
				redraw_page(respnum, group);
				break;
			case 'P':	/* previous unread article */
				if ((n = prev_unread(prev_response(respnum))) == -1) {
					warning(MSG_NOPREVUNREADART, -1);
					break;
				}
				note_cleanup();
				respnum = n;
				goto restart;
			case 'C':	/* cancel article */
				if (!isgrpright(GSID_USENET, group, GRF_D)) {
					nopermission(GRF_D);
					goto restart;
				}
				if (!post_cancel(group)) goto restart;
				goto reindex_group;
			case 'F':	/* post a followup to this article */
			case 'f':
				if (!isgrpright(GSID_USENET, group, GRF_W)) {
					nopermission(GRF_W);
					goto restart;
				}
				if (!post_response(group, (ch == 'F')))
					break;
reindex_group:
				update_newsrc(group, my_group[curgrpidx]);
				n = which_base(respnum);
				note_cleanup();
				index_group(group, group_path);
				read_newsrc_line(group);
				if (n >= top_base) return top_base - 1;
				respnum = choose_resp(n, nresp(n));
				goto restart;
			case 'z':	/* mark article as unread (to return) */
				arts[respnum].unread = 2;
				warning(MSG_ARTMARKASUNREAD, -1);
				break;
			case 'K':	/* mark rest of thread as read */
				note_cleanup();
				for (n = respnum; n >= 0; n = arts[n].thread)
					arts[n].unread = 0;
				if ((n = next_unread(next_response(respnum))) == -1)
					goto return_page;
				respnum = n;
				goto restart;
			case 'q':	/* return */
			case 'Q':
				note_cleanup();
				goto return_page;
			case ctrl('R'):	  /* redraw beginning of article */
				if (note_page == NOTE_UNAVAIL)
					warning(MSG_ARTICLEUNAVAIL, -1);
				else {
					note_page = 0;
					note_end = FALSE;
					fseek(note_fp, note_mark[0], 0);
					if (show_note_page(respnum, group) < 0)
						goto return_page;
				}
				break;
			case ctrl('L'):
			case ctrl('W'):
				redraw_page(respnum, group);
				break;
			case '\b':
			case 'b':	/* back a page */
			case 'U':
				if (note_page == NOTE_UNAVAIL ||  note_page <= 1) {
					note_cleanup();
					if ((n = prev_response(respnum)) == -1)
						goto return_page;
					respnum = n;
					goto restart;
				}
				note_page -= 2;
				note_end = FALSE;
				fseek(note_fp, note_mark[note_page], 0);
				if (show_note_page(respnum, group) < 0)
					goto return_page;
				break;
			case 'm':	/* mail article to somebody */
			case 'M':	/* bounce article to somebody */
				mail_to_someone(ch == 'M');
				goto restart;
			case 'r':	/* reply to author through mail */
			case 'R':
				mail_to_author(ch == 'R');
				goto restart;
			case '-':	/* show last viewed article */
				if (last_resp < 0) {
					warning(MSG_NOLASTMESSAGE, -1);
					break;
				}
				note_cleanup();
				respnum = last_resp;
				goto restart;
			case 'p':	/* previous article */
			case '<':
				note_cleanup();
				if ((n = prev_response(respnum)) == -1)
					goto return_page;
				respnum = n;
				goto restart;
			case 'n':	/* skip to next article */
			case '>':
				note_cleanup();
				if ((n = next_response(respnum)) == -1)
					goto return_page;
				respnum = n;
				goto restart;
			case 'k':
				if (note_page != NOTE_UNAVAIL) note_cleanup();
				if ((n = next_unread(next_response(respnum))) == -1)
					goto return_page;
				respnum = n;
				goto restart;
			case ' ': 	/* next page or response */
			case 'D':
				if (note_page == NOTE_UNAVAIL) {
					if ((n = next_response(respnum)) == -1)
						goto return_page;
					respnum = n;
					goto restart;
				} else if (note_end) {
					note_cleanup();
					if ((n = next_response(respnum)) == -1)
						goto return_page;
					respnum = n;
					goto restart;
				} else	if (show_note_page(respnum, group) < 0)
					goto return_page;
				break;
			case '\t': 	/* next page or unread response */
				if (note_page == NOTE_UNAVAIL) {
					if ((n = next_unread(next_response(respnum))) == -1)
						goto return_page;
					respnum = n;
					goto restart;
				} else if (note_end) {
					note_cleanup();
					if ((n = next_unread(next_response(respnum))) == -1)
						goto return_page;
					respnum = n;
					goto restart;
				} else	if (show_note_page(respnum, group) < 0)
					goto return_page;
				break;
			case 'N':	/* next unread article */
				if ((n = next_unread(next_response(respnum))) == -1) {
					warning(MSG_NONEXTUNREADART, -1);
					break;
				}
				note_cleanup();
				respnum = n;
				goto restart;
			case '\r':
			case '\n':	/* go to start of next thread */
				note_cleanup();
				if ((n = next_basenote(respnum)) == -1)
					goto return_page;
				respnum = n;
				goto restart;
			case 'H':	/* show article headers */
				if (note_page == NOTE_UNAVAIL) {
					if ((n = next_response(respnum)) == -1)
						goto return_page;
					respnum = n;
					goto restart;
				}
				note_page = 0;
				note_end = FALSE;
				rewind(note_fp);
				if (show_note_page(respnum, group) < 0)
					goto return_page;
				break;
			case 'x':	/* extract/decode files */
			case 'X':
				if ((n = extract_art_to_file(ch != 'x')) < 0)
					warning(MSG_NOTHINGTOEXTRACT, -1);
				else {
					clearline();
					putstr(sysmsg(MSG_FILESEXTRACTED), n);
				}
				break;
			case 'w':
			case 'W':
				if (ch == 'w') n = save_art_to_file();
				else n = save_thread_to_file(respnum, group_path);
				clearline();
				putstr(sysmsg(MSG_SAVEMSGCOMPLETE), n);
				break;
			case 'h':
			case '?':
				if (termflags & (ANSITERM | RIPTERM))
					putstr("\033[1;44m\033[H\033[J");
				psysmsg(MSG_USENETREADERHELP);
				anykey();
				if (termflags & (ANSITERM | RIPTERM))
					putstr("\033[40m\033[J");
				redraw_page(respnum, group);
				break;
			default:
				putchr('\007');
				warning(MSG_BADCOMMAND, -1);
		}
	}
return_page:
	globalflags &= ~USENETREADERINUSE;
	update_newsrc(group, my_group[curgrpidx]);
	return which_base(respnum);
}

note_cleanup() {
	if (note_page != NOTE_UNAVAIL) fclose(note_fp);
	note_fp = NULL;
}

redraw_page(respnum, group)
	int respnum;
	char *group;
{

	if (note_page == NOTE_UNAVAIL) warning(MSG_ARTICLEUNAVAIL, 1);
	else if (note_page > 0) {
		note_page--;
		fseek(note_fp, note_mark[note_page], 0);
		show_note_page(respnum, group);
	}
}

show_note_page(respnum, group)
	int respnum;
	char *group;
{
	char *p, buf[LEN], buf2[LEN+50];
	int percent;
	int ctrl_L;		/* form feed character detected */
	extern int UserArtRead, ArtReadLimit;

	if (ArtReadLimit && UserArtRead >= ArtReadLimit) {
		warning(MSG_ARTREADLIMIT, 1);
		return -1;
	}
	note_line = 1;
	if (termflags & (ANSITERM | RIPTERM)) {
		putstr("\033[H\033[J\033[0;36m");
		if (note_page == 0)	show_first_header(respnum, group);
		else			show_cont_header(respnum);
	} else	{
		clearline();
		if (note_page == 0) {
			putstr("\n%s\n", sysmsg(MSG_DELIMITER));
			show_first_header(respnum, group);
		}
	}
	ctrl_L = FALSE;
	while (note_line < scrlines) {
		if (fgets(buf, sizeof(buf), note_fp) == NULL) {
			note_end = TRUE;
			break;
		}
		buf[sizeof(buf)-1] = '\0';
		ctrl_L = unrot(buf, buf2);
		if (termflags & (ANSITERM | RIPTERM))
			putstr("\033[%dm", isquotedstr(buf2) ? 0 : 1);
		p = buf2;
		note_line++;
		while ((p = putstrmax(p, 79)) != NULL) {
			if (note_line >= scrlines) {
				fseek(note_fp, -(strlen(p)+1), SEEK_CUR);
				break;
			}
			note_line++;
		}
		if (ctrl_L) break;
	}
	note_mark[++note_page] = ftell(note_fp);

	if (termflags & (ANSITERM | RIPTERM)) {
		while (note_line++ < scrlines) putchr('\n');
		putstr("\033[0;7m");
	}
	if (note_end) {
		if (arts[respnum].thread != -1) putstr("- next -\r");
		else putstr("- last -\r");
	} else {
		if (note_size > 0) {
			percent = note_mark[note_page] * 100 / note_size;
			putstr("- more - (%d%%)\r", percent);
		} else	putstr("- more -\r");
	}
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[0m");
	return 0;
}

unrot(buf, buf2)
char *buf;
char *buf2;
{
	char *p, *q;
	int ctrl_L = FALSE;
	int i, j;

	if (rotate) {
		for (p = buf, q = buf2; *p && *p != '\n' && q<&buf2[LEN]; p++) {
			if (*p == '\b' && q > buf2) {
				q--;
			} else if (*p == 12) {		/* ^L */
				*q++ = '^';
				*q++ = 'L';
				ctrl_L = TRUE;
			} else if (*p == '\t') {
				i = q - buf2;
				j = (i|7) + 1;

				while (i++ < j)
					*q++ = ' ';
			} else if (((unsigned char)(*p)) < 32) {
				*q++ = '^';
				*q++ = (*p) + '@';
			} else if (*p >= 'A' && *p <= 'Z')
				*q++ = 'A' + (*p - 'A' + rotate) % 26;
			else if (*p >= 'a' && *p <= 'z')
				*q++ = 'a' + (*p - 'a' + rotate) % 26;
			else
				*q++ = *p;
			}
	} else {
		for (p = buf, q = buf2; *p && *p != '\n' && q<&buf2[LEN]; p++) {
			if (*p == '\b' && q > buf2) {
				q--;
			} else if (*p == 12) {		/* ^L */
				*q++ = '^';
				*q++ = 'L';
				ctrl_L = TRUE;
			} else if (*p == '\t') {
				i = q - buf2;
				j = (i|7) + 1;

				while (i++ < j)
					*q++ = ' ';
			} else if (((unsigned char)(*p)) < 32) {
				*q++ = '^';
				*q++ = (*p) + '@';
			} else
				*q++ = *p;
		}
	}
	*q = '\0';
	return ctrl_L;
}

show_first_header(respnum, group)
	int respnum;
	char *group;
{

	int whichresp, whichbase, x_resp;
	char buf[LEN], *ptr;
	extern int UserArtRead;

	whichresp = which_resp(respnum);
	whichbase = which_base(respnum);
	x_resp = nresp(whichbase);

	if (whichresp)	sprintf(buf, "Response %4d of %-4d", whichresp, x_resp);
	else {
		if (x_resp == 0)	strcpy(buf, "No responses");
		else if (x_resp == 1)	strcpy(buf, "1 Response");
		else			sprintf(buf, "%d Responses", x_resp);
	}
	UserArtRead++;
	LOGIT(LOG_INFO, "ReadArt #%d in \"%s\"", arts[respnum].artnum, group);
	putstr("Note %4d of %-4d  %-21.21s  Article %-8d  %19.19s\n",
	       whichbase+1, top_base, buf, arts[respnum].artnum, ctime(&arts[respnum].date));
	if (*note_h_org)
		snprintf(buf, sizeof(buf)-1, "%s at %s", note_full_name, note_h_org);
	else	strcpy(buf, note_full_name);
	if (termflags & (ANSITERM | RIPTERM))
		putstr("\033[1;33;44m\033[K%-30.30s \033[32m%48.48s\n\033[37m", note_from_addr, buf);
	else	putstr("%-30.30s %48.48s\n", note_from_addr, buf);
	note_line += 2;
	ptr = note_h_subj;
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[44m\033[K");
	while ((ptr = putstrmax(ptr, 79)) != NULL) {
		if (termflags & (ANSITERM | RIPTERM)) putstr("\033[44m\033[K");
		note_line++;
	}
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[40m");
	else {
		putstr("%s\n", sysmsg(MSG_DELIMITER));
		note_line++;
	}
}

show_cont_header(respnum)
	int respnum;
{
	int whichresp;
	int whichbase;
	char buf[LEN];

	whichresp = which_resp(respnum);
	whichbase = which_base(respnum);

	assert (whichbase < top_base);

	if (whichresp)
		sprintf(buf, "Note %d of %d, Resp %d (page %d):  %s",
			whichbase + 1,
			top_base,
			whichresp,
			note_page + 1,
			note_h_subj);
	else	sprintf(buf, "Note %d of %d (page %d):  %s",
			whichbase + 1,
			top_base,
			note_page + 1,
			note_h_subj);
	buf[79] = '\0';
	putstr("%s\n\n", buf);
	note_line++;
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[37m");
}

open_note(art, group_path)
long art;
char *group_path;
{
	char buf[2048];
	char *p;
	extern FILE *open_art_fp();

	note_page = 0;
	if (note_fp != NULL) fclose(note_fp);
	note_fp = open_art_fp(group_path, art);
	if (note_fp == NULL) {
		note_page = NOTE_UNAVAIL;
		return;
	}
	note_h_from[0] = '\0';
	note_h_reply[0] = '\0';
	note_h_path[0] = '\0';
	note_h_subj[0] = '\0';
	note_h_org[0] = '\0';
	note_h_date[0] = '\0';
	note_h_newsgroups[0] = '\0';
	note_h_messageid[0] = '\0';
	note_h_distrib[0] = '\0';
	note_h_followup[0] = '\0';
	note_h_keywords[0] = '\0';
	note_h_xcomment[0] = '\0';

	while (fgets(buf, sizeof(buf), note_fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		for (p = buf; *p && *p != '\n'; p++)
			if (((*p)&0x7F) < 32) *p = ' ';
		*p = '\0';
		if (*buf == '\0') break;

		if (strncmp(buf, "From: ", 6) == 0) {
			strncpy(note_h_from, &buf[6], LEN);
			note_h_from[LEN-1] = '\0';
		} else if (strncmp(buf, "Path: ", 6) == 0) {
			strncpy(note_h_path, &buf[6], LEN);
			note_h_path[LEN-1] = '\0';
		} else if (strncmp(buf, "Subject: ", 9) == 0) {
			strncpy(note_h_subj, &buf[9], LEN);
			note_h_subj[LEN-1] = '\0';
		} else if (strncmp(buf, "Organization: ", 14) == 0) {
			strncpy(note_h_org, &buf[14], LEN);
			note_h_org[LEN-1] = '\0';
		} else if (strncmp(buf, "Date: ", 6) == 0) {
			strncpy(note_h_date, &buf[6], LEN);
			note_h_date[LEN-1] = '\0';
		} else if (strncmp(buf, "Newsgroups: ", 12) == 0) {
			strncpy(note_h_newsgroups, &buf[12], LEN);
			note_h_newsgroups[LEN-1] = '\0';
		} else if (strncasecmp(buf, "Message-Id: ", 12) == 0) {
			strncpy(note_h_messageid, &buf[12], LEN);
			note_h_messageid[LEN-1] = '\0';
		} else if (strncmp(buf, "Distribution: ", 14) == 0) {
			strncpy(note_h_distrib, &buf[14], LEN);
			note_h_distrib[LEN-1] = '\0';
		} else if (strncmp(buf, "Reply-To: ", 10) == 0) {
			strncpy(note_h_reply, &buf[10], LEN);
			note_h_reply[LEN-1] = '\0';
		} else if (strncmp(buf, "Followup-To: ", 13) == 0) {
			strncpy(note_h_followup, &buf[13], LEN);
			note_h_followup[LEN-1] = '\0';
		} else if (strncmp(buf, "Keywords: ", 10) == 0) {
			strncpy(note_h_keywords, &buf[10], LEN);
			note_h_keywords[LEN-1] = '\0';
		} else if (strncmp(buf, "X-Comment-To: ", 14) == 0) {
			strncpy(note_h_xcomment, &buf[14], LEN);
			note_h_xcomment[LEN-1] = '\0';
		}
	}
	note_page = 0;
	note_mark[0] = ftell(note_fp);
	parsefrom(note_h_from, note_from_addr, note_full_name);
	note_end = FALSE;
	return;
}

/*
 *  return response number n from thread i
 */
int
choose_resp(i, n)
	int i, n;
{
	int j = base[i];
	while (n-- && arts[j].thread >= 0) j = arts[j].thread;
	return j;
}

/*
 * Find binary (uuencode/base64) files in article and save it.
 */
int
extract_art_to_file(method)
	int method;
{
	int found, saved;
	char ct[256];

	found = saved = 0;
	rewind(note_fp);
	if (method == 0) {	/* check for uuencode */
		while (get_begin(note_fp, note_size, ct)) {
			found++;
			saved += extract_file(note_fp, uudecode, ct);
		}
	} else {	/* check for MIME files in base64 */
		char *p, ce[256];

		while (get_content(note_fp, note_size, ct, ce)) {
			if (!strcasecmp(ce, "base64")) {
				found++;
				if ((p = __strcasestr(ct, "name=")) != NULL)
					p += 5;
				saved += extract_file(note_fp, frombase64, p);
			}
		}
	}
	fseek(note_fp, note_mark[note_page], 0);
	return found ? saved : -1;
}

int
save_art_to_file()
{
	FILE *fp;
	char name[LEN], *p;

	do {
		p = prompt_str(MSG_SAVEARTFILE,
			       getuserconf("SAVEARTFILE", NULL), MAXFILENAMELEN);
		if (p == NULL) return 0;
	} while (!legalfname(p));

	sprintf(name, "%s/%s", homedir, p);
	if ((fp = sfopen(name, "a+")) == NULL) return 0;
	putuserconf("SAVEARTFILE", p);
	fprintf(fp, "From %s %s\n", note_h_path, note_h_date);
	rewind(note_fp);
	copy_fp(note_fp, fp, "");
	fputc('\n', fp);
	sfclose(fp);

	fseek(note_fp, note_mark[note_page], 0);
	LOGIT(LOG_INFO, "WriteArt to \"%s\"", name);
	return 1;
}

int
save_thread_to_file(respnum, group_path)
	int respnum;
	char *group_path;
{
	FILE *fp;
	char name[LEN], *p;
	int i, count, save_note_page, save_note_end;
	long save_note_mark[MAX_PAGES];

	do {
		p = prompt_str(MSG_SAVETHREADFILE,
			       getuserconf("SAVETHREADFILE", NULL), MAXFILENAMELEN);
		if (p == NULL) return 0;
	} while (!legalfname(p));

	sprintf(name, "%s/%s", homedir, p);
	if ((fp = sfopen(name, "a+")) == NULL) return 0;
	putuserconf("SAVETHREADFILE", p);

	/* note save */
	save_note_page = note_page;
	save_note_end = note_end;
	for (i = 0; i <= note_page; i++) save_note_mark[i] = note_mark[i];
	note_cleanup();

	count = 0;
	for (i = base[which_base(respnum)]; i >= 0; i = arts[i].thread) {
		open_note(arts[i].artnum, group_path);
		fprintf(fp, "From %s %s\n", note_h_path, note_h_date);
		rewind(note_fp);
		copy_fp(note_fp, fp, "");
		fputc('\n', fp);
		note_cleanup();
		putstr("\b\b\b\b%4d", ++count);
	}
	sfclose(fp);

	/* note reopen */
	open_note(arts[respnum].artnum, group_path);
	if (note_page != NOTE_UNAVAIL) {
		note_page = save_note_page;
		note_end = save_note_end;
		for (i = 0; i <= note_page; i++)
			note_mark[i] = save_note_mark[i];
	}
	fseek(note_fp, note_mark[note_page], 0);

	LOGIT(LOG_INFO, "WriteThread to \"%s\"", name);
	return count;
}
