/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <setjmp.h>
#include <stdio.h>
#include <string.h>
#ifdef	__STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <errno.h>
#include <pwd.h>

#include "drive.h"
#include "callsign.h"
#include "loginfo.h"
#include "variables.h"
#include "udpserv.h"
#include "utmpent.h"

#ifndef	EXTERN_APPS
#include "sysmsg.h"
#include "group.h"
#endif

extern int errno;
extern struct loginfo process;
int talkportid = 0;

static jmp_buf rcvmsginconf;
static jmp_buf rcvmsgintalk;
static jmp_buf quitconf;
static void onrcvmsg(unsigned long, char *, int);

int
initIPC()
{
	int port;

	if ((port = udpserv(onrcvmsg)) < 0)
		return -1;

	process.port = port;

#ifndef	EXTERN_APPS
	if (*mesgtty(getuserconf("MESG", "Yes")) == '\0')
		return -1;
#endif
	if (saveinfo(&process) < 0)
		return -1;

	return 0;
}

static int
#ifdef	__STDC__
message(int port, char *fmt, ...)
#else
message(port, fmt, va_alist)
	char *fmt;
	int port;
	va_dcl
#endif
{
	int len, cnt;
	struct loginfo *info;
	char msgbuf[256];
	va_list ap;

	(void)strcpy(msgbuf, callsign);
	if (port) (void)strcat(msgbuf, "> ");
	else (void)strcat(msgbuf, ": ");
	len = strlen(msgbuf);
#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)vsnprintf(&msgbuf[len], sizeof(msgbuf) - len, fmt, ap);
	va_end(ap);

	cnt = 0;
	len = strlen(msgbuf);

	if (port) {
		if (!(globalflags & BEGINCHAT))
			putstr("\r%-79.79s\n", msgbuf);
		if (udpsend(port, msgbuf, len) > 0)
			cnt++;
	} else {
		while ((info = getinfo(TRUE)) != NULL &&
		       (info->flags & HIDDENUSER) == 0) {
			if (info->pid == process.pid) {
				if (!(globalflags & BEGINCHAT))
					putstr("\r%-79.79s\n", msgbuf);
			} else if (info->flags & INCONF) {
				if (udpsend(info->port, msgbuf, len) > 0)
					cnt++;
			}
		}
	}

	return cnt;
}

void
onrcvmsg(from, msg, out_flag)
	unsigned long from;
	register char *msg;
	int out_flag;
{
	register char *p;

#ifndef	EXTERN_APPS
	if (!strncmp(msg, GETINFOMARKER, sizeof(GETINFOMARKER)-1)) {
		p = getvariables(&msg[sizeof(GETINFOMARKER)-1]);
		udpreply(p, strlen(p));
		return;
	}
	if (!strncmp(msg, CMDSERVMARKER, sizeof(CMDSERVMARKER)-1)) {
		/* need more security; md5? */
		if (from == localhost)
			setvariables(&msg[sizeof(CMDSERVMARKER)-1]);
		return;
	}
#endif
	if (strstr(msg, ENDTALKMARKER) == NULL) {
		if (strstr(msg, STARTTALKMARKER) != NULL &&
		    (p = strstr(msg, TALKPORTID)) != NULL) {
			*p = '\0';
			talkportid = atoi(&p[sizeof(TALKPORTID)-1]);
#ifndef	EXTERN_APPS
			if (talkportid)
				putstr("\n%s %s\n", msg, sysmsg(MSG_RESPONDTALK));
#endif
			return;
		}
	} else talkportid = 0;

	if (process.flags & INTALK) {
		if (globalflags & BEGINCHAT) {
			if (strstr(msg, ALIVETALKMARKER) != NULL &&
			    (p = strstr(msg, TALKPORTID)) != NULL) {
				talkportid = atoi(&p[sizeof(TALKPORTID)-1]);
				globalflags |= WANTTALK;
			}
			return;
		}
	        if(*msg) putstr("\r%-79.79s\n", msg);
		if(out_flag) longjmp(rcvmsgintalk, 1);
		return;
	}

	if(*msg) putstr("\r%-79.79s\n", msg);
	if(out_flag) if (process.flags & INCONF) longjmp(rcvmsginconf, 1);
}

void
onsigquit()
{
	longjmp(quitconf, 1);
}

char *
check_ban(user)
	char *user;
{
	FILE *fp;
	char *p, *msg = NULL;
	static char buf[256];

	if ((fp = fopen(BANLIST, "r")) == NULL) return NULL;
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if (buf[0] == '#' || buf[0] == '\n') continue;
		if ((msg = strchr(buf, ':')) != NULL) {
			*msg++ = '\0';
			if (!strcasecmp(buf, user)) {
				if ((p = strchr(msg, '\n')) != NULL) *p = '\0';
				break;
			} else msg = NULL;
		}
	}
	fclose(fp);
	return msg;
}

int
add_ban(user, msg)
	char *user, *msg;
{
	FILE *fp;
	char *p;

	if ((p = check_ban(user)) != NULL) {
		putstr("baned by %-.70s\n", p);
		return 0;
	}
	if ((fp = fopen(BANLIST, "a")) == NULL) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return -1;
	}
	fchmod(fileno(fp), 0660);
	fchown(fileno(fp), getuid(), getgid());
	fprintf(fp, "%s: %s: %s\n", user, callsign, msg);
	fclose(fp);
	return 1;
}
 
int
del_ban(user)
	char *user;
{
	FILE *fp, *ft;
	int match;
	char *msg, buf[256], temp[sizeof(BANLIST)+20];

	if (!strcmp(user, "*") || !strcasecmp(user, "all")) {
		if ((fp = fopen(BANLIST, "w")) == NULL) {
#ifndef	EXTERN_APPS
			putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
			putstr("Permission denied\n");
#endif
			return -1;
		}
		fchmod(fileno(fp), 0660);
		fchown(fileno(fp), getuid(), getgid());
		fclose(fp);
		return 1;
	}

	if ((fp = fopen(BANLIST, "r")) == NULL) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOSUCHUSER));
#else
		putstr("No such user\n");
#endif
		return 0;
	}
	(void) sprintf(temp, "%s.%d", BANLIST, process.pid);
	if ((ft = fopen(temp, "w")) == NULL) {
		fclose(fp);
		return -1;
	}
	fchmod(fileno(ft), 0660);
	fchown(fileno(ft), getuid(), getgid());

	match = 0;
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if ((msg = strchr(buf, ':')) != NULL) {
			*msg = '\0';
			if (!strcasecmp(buf, user)) {
				match++;
				continue;
			}
			*msg = ':';
		}
		fputs(buf, ft);
	}
	fclose(ft);
	fclose(fp);
	if (!match) {
		unlink(temp);
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOSUCHUSER));
#else
		putstr("No such user\n");
#endif
		return 0;
	}
	match = rename(temp, BANLIST);
	unlink(temp);
	if (match < 0) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return -1;
	}
	return 1;
}

void
go_conf()
{
	int n;
	char *ptr;
	sigfunc intsave, quitsave;
	extern char *chatinput();

	if ((ptr = check_ban(process.name)) != NULL) {
		putstr("\nBaned by %-.70s\n\n", ptr);
		if (!(process.flags & INFINITYCONF)) {
#ifndef	EXTERN_APPS
			warning(MSG_NOPERMISSION, 1);
#else
			putstr("Permission denied\n");
#endif
			return;
		}
	}
#ifndef	EXTERN_APPS
	LOGIT(LOG_INFO, "Come in conference");
#endif
	intsave = signal(SIGINT, SIG_IGN);
	quitsave = signal(SIGQUIT, onsigquit);
	if (setjmp(quitconf)) {
		process.flags &= ~(INCONF|KICKER);
		message(0, KICKEDCONFMARKER);
		saveinfo(&process);
		(void)signal(SIGINT, intsave);
		(void)signal(SIGQUIT, quitsave);
#ifndef	EXTERN_APPS
		LOGIT(LOG_INFO, "Kicked from conference");
#endif
		return;
	}
	globalflags |= BEGINCHAT;
	if (!message(0, COMINCONFMARKER)) {
		process.flags |= KICKER;
#ifdef	EXTERN_APPS
		putstr("The only YOU in conference right now. You are kicker!\n");
#else
		putstr("%s\n", sysmsg(MSG_YOUONLYINCONF));
#endif
	}
	if (!setjmp(rcvmsginconf)) {
		process.flags |= INCONF;
		saveinfo(&process);
		who_in_conf();
		putchr('\n');
	}
	do {
		ptr = chatinput(callsign);
		n = chatcmds(ptr);
		if (n > 0) message(0, ptr);
	} while (n >= 0);
	process.flags &= ~INCONF;
	message(0, LEAVECONFMARKER);
	if (process.flags & KICKER) random_grant();
	saveinfo(&process);
	(void)signal(SIGINT, intsave);
	(void)signal(SIGQUIT, quitsave);
#ifndef	EXTERN_APPS
	LOGIT(LOG_INFO, "Leave conference");
#endif
}

void
go_talk()
{
	int i, lncnt;
	char *ptr;
	time_t mtime;
	struct loginfo *info;

again:
	mtime = infotime();
	if (!(i = whodo(FALSE))) {
#ifdef	EXTERN_APPS
		putstr("No users for talk\n");
#else
		putstr("%s\n", sysmsg(MSG_NOUSERSFORTALK));
#endif
		return;
	}
#ifdef	EXTERN_APPS
	putstr("Select user to talk: ");
	ptr = getstr(0, 1, ECHOENABLE);
	putchr('\n');
	lncnt = atoi(ptr);
	if (lncnt < 1 || lncnt > i) return;
#else
	if ((lncnt = prompt_num(MSG_SELECTUSERTOTALK, 0, i)) == 0) return;
#endif

	if (infotime() != mtime) {
#ifdef	EXTERN_APPS
		putstr("Status of users was changed, refresh...\n");
#else
		putstr("%s\n", sysmsg(MSG_USERINFOWASCHANGED));
#endif
		goto again;
	}

	i = 0;
	while ((info = getinfo(FALSE)) != NULL && (info->flags & HIDDENUSER) == 0) {
		if (++i == lncnt) {
			closeinfo();
			break;
		}
	}
	if (info == NULL) {
#ifdef	EXTERN_APPS
		putstr("Status of users was changed, refresh...\n");
#else
		putstr("%s\n", sysmsg(MSG_USERINFOWASCHANGED));
#endif
		return;
	}
	if (!(info->flags & (MESGNO|INCONF|INTALK|INRECVF|INSENDF|EXECEXT))) {
#ifndef	EXTERN_APPS
		LOGIT(LOG_INFO, "Request talk to %s", info->name);
		if (globalflags & EXTERNALTALK) {
			process.flags |= INTALK;
			invoke_cmd("%s bbs#%s", talkprog, &info->tty[3]);
			return;
		}
#endif
		talkportid = info->port;
		globalflags |= BEGINCHAT;
		message(info->port, "\007%s %s%d to %s", STARTTALKMARKER,
			TALKPORTID, process.port, info->name);
		talk(-1);
		talkportid = 0;
		return;
	}
#ifdef	EXTERN_APPS
	putstr("This user carrently unavailable for talk\n");
#else
	putstr("%s\n", sysmsg(MSG_USERCANTBETALKED));
#endif
	goto again;
}

int
talk(request)
	int request;
{
	int n;
	char *ptr, pgshow[] = { 'O', 'o', 'O', 'o', '|', '/', '\\', '|' };
	sigfunc intsave;
	extern char *chatinput();
	extern int gettimer(); extern int settimer();

	if (request < 0 && !talkportid) return -1;

	intsave = signal(SIGINT, SIG_IGN);
	if (!setjmp(rcvmsgintalk)) {
		process.flags |= INTALK;
		saveinfo(&process);
		if (request > -2) {
			putstr("Please wait... (max 30 sec). :-o");
			for (n = 0; n < 30; n++) {
				putstr("\b%c", pgshow[n & 7]);
				sleep(1);
				if (globalflags & WANTTALK) {
					globalflags &= ~WANTTALK;
					goto begintalk;
				}
			}
			putstr("\b(\n");
			if (request < 0)
				message(talkportid, "%s stop waiting", ENDTALKMARKER);
			process.flags &= ~INTALK;
			saveinfo(&process);
			(void)signal(SIGINT, intsave);
/* patched by SLA */
#ifndef	EXTERN_APPS
			(void)settimer(gettimer()/60);

			LOGIT(LOG_INFO, "Talk request refused");
#endif
			return 0;
		} else	message(talkportid, "%s %s%d", ALIVETALKMARKER,
				TALKPORTID, process.port);
	}
begintalk:
	if (talkportid) {
		do {
			ptr = chatinput(callsign);
			n = chatcmds(ptr);
			if (n > 0) message(talkportid, ptr);
		} while (n >= 0);
		message(talkportid, ENDTALKMARKER);
		talkportid = 0;
	}
	process.flags &= ~INTALK;
	saveinfo(&process);
	(void)signal(SIGINT, intsave);

/* patched by SLA */
#ifndef	EXTERN_APPS
	(void)settimer(gettimer()/60);

	LOGIT(LOG_INFO, "End talk");
#endif
	return 1;
}

void
kick_user(user)
	char *user;
{
	char *ptr;
	struct loginfo *info;

	if (!(process.flags & (KICKER|TERMINATOR))) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return;
	}
	while (*user == ' ') user++;
	if (!*user) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_BADCOMMAND));
#else
		putstr("Bad command. Type '?' for help\n");
#endif
		return;
	}
	if ((ptr = strchr(user, '.')) != NULL) *ptr = ' ';
	if ((ptr = getnamebysign(user)) != NULL) user = ptr;

	while ((info = getinfo(TRUE)) != NULL && (info->flags & HIDDENUSER) == 0) {
		if ((info->flags & INCONF) && !strcasecmp(info->name, user)) {
			closeinfo();
			break;
		}
	}
	if (info != NULL) {
		if (info->pid == process.pid ||
		    ((info->flags & TERMINATOR) && !(process.flags & TERMINATOR))) {
#ifndef	EXTERN_APPS
			putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
			putstr("Permission denied\n");
#endif
		} else {
			if ((ptr = getsignbyname(info->name)) == NULL)
				ptr = info->name;
			message(0, ATTEMPTTOKICK, ptr);
			kill(info->pid, SIGQUIT);
#ifndef	EXTERN_APPS
			LOGIT(LOG_INFO, "Kick \"%s\"", info->name);
#endif
		}
	} else
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOSUCHUSERINCONF));
#else
		putstr("No such user in conference\n");
#endif
}

void
grant_kick(user)
	char *user;
{
	char *ptr;
	struct loginfo *info;

	if (!(process.flags & (KICKER|TERMINATOR))) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return;
	}
	while (*user == ' ') user++;
	if (!*user) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_BADCOMMAND));
#else
		putstr("Bad command. Type '?' for help\n");
#endif
		return;
	}
	if ((ptr = strchr(user, '.')) != NULL) *ptr = ' ';
	if ((ptr = getnamebysign(user)) != NULL) user = ptr;

	while ((info = getinfo(TRUE)) != NULL && (info->flags & HIDDENUSER) == 0) {
		if ((info->flags & INCONF) && !strcasecmp(info->name, user)) {
			closeinfo();
			break;
		}
	}
	if (info != NULL) {
		if (info->pid == process.pid || (info->flags & TERMINATOR)) {
#ifndef	EXTERN_APPS
			putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
			putstr("Permission denied\n");
#endif
		} else {
			if ((ptr = getsignbyname(info->name)) == NULL)
				ptr = info->name;
			message(0, ATTEMPTTOGRANT, ptr);
			if (kill(info->pid, SIGPIPE) == 0) {
				process.flags &= ~KICKER;
				saveinfo(&process);
#ifndef	EXTERN_APPS
				LOGIT(LOG_INFO, "Grant \"%s\"", info->name);
#endif
			}
		}
	} else
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOSUCHUSERINCONF));
#else
		putstr("No such user in conference\n");
#endif
}

void
term_user(user)
	char *user;
{
	char *ptr;
	struct loginfo *info;

	if (!(process.flags & TERMINATOR)) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return;
	}
	while (*user == ' ') user++;
	if (!*user) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_BADCOMMAND));
#else
		putstr("Bad command. Type '?' for help\n");
#endif
		return;
	}
	if ((ptr = strchr(user, '.')) != NULL) *ptr = ' ';
	if ((ptr = getnamebysign(user)) != NULL) user = ptr;

	while ((info = getinfo(TRUE)) != NULL && (info->flags & HIDDENUSER) == 0) {
		if ((info->flags & INCONF) && !strcasecmp(info->name, user)) {
			closeinfo();
			break;
		}
	}
	if (info != NULL) {
		if (info->pid == process.pid || (info->flags & TERMINATOR)) {
#ifndef	EXTERN_APPS
			putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
			putstr("Permission denied\n");
#endif
		} else {
			if ((ptr = getsignbyname(info->name)) == NULL)
				ptr = info->name;
			message(0, ATTEMPTTOTERM, ptr);
			kill(info->pid, SIGKILL);
#ifndef	EXTERN_APPS
			LOGIT(LOG_INFO, "Terminate \"%s\"", info->name);
#endif
		}
	} else
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOSUCHUSERINCONF));
#else
		putstr("No such user in conference\n");
#endif
}

void
private_msg(str)
	char *str;
{
	char *user, *ptr;
	struct loginfo *info;

	while (*str == ' ') str++;
	user = str;
	while ((u_char)*str > 0x20) str++;
	if (*str) for (*str++ = 0; *str == ' '; str++);
	if (!*str) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_BADCOMMAND));
#else
		putstr("Bad command. Type '?' for help\n");
#endif
		return;
	}
	if ((ptr = strchr(user, '.')) != NULL) *ptr = ' ';
	if ((ptr = getnamebysign(user)) != NULL) user = ptr;

	while ((info = getinfo(FALSE)) != NULL && (info->flags & HIDDENUSER) == 0) {
		if (!strcasecmp(info->name, user)) {
			closeinfo();
			break;
		}
	}
	if (info != NULL && !(info->flags & (MESGNO|INRECVF|INSENDF|EXECEXT))) {
		message(info->port, str);
		return;
	}
#ifndef	EXTERN_APPS
	putstr("%s\n", sysmsg(MSG_USERUNACCESSIBLE));
#else
	putstr("This user unaccessible right now\n");
#endif
}

void
ban_user(str)
	char *str;
{
	char *user, *ptr;
	struct loginfo *info;

	if (!(process.flags & TERMINATOR)) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return;
	}
	while (*str == ' ') str++;
	user = str;
	while ((u_char)*str > 0x20) str++;
	if (*str) for (*str++ = 0; *str == ' '; str++);
	if (!*str) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_BADCOMMAND));
#else
		putstr("Bad command. Type '?' for help\n");
#endif
		return;
	}
	if ((ptr = strchr(user, '.')) != NULL) *ptr = ' ';
	if ((ptr = getnamebysign(user)) != NULL) user = ptr;

	while ((info = getinfo(TRUE)) != NULL && (info->flags & HIDDENUSER) == 0) {
		if ((info->flags & INCONF) && !strcasecmp(info->name, user)) {
			closeinfo();
			break;
		}
	}
	if (info != NULL) {
		if ((ptr = getsignbyname(info->name)) == NULL)
			ptr = info->name;
		if (add_ban(info->name, str) == 1) {
			message(0, ATTEMPTTOBAN, ptr);
#ifndef EXTERN_APPS
			LOGIT(LOG_INFO, "Ban \"%s\"", info->name);
#endif
		}
	} else
#ifndef EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOSUCHUSERINCONF));
#else
		putstr("No such user in conference\n");
#endif
}

void
unban_user(user)
	char *user;
{
	char *ptr;
	struct loginfo *info;

	if (!(process.flags & TERMINATOR)) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_NOPERMISSION));
#else
		putstr("Permission denied\n");
#endif
		return;
	}
	while (*user == ' ') user++;
	if (!*user) {
#ifndef	EXTERN_APPS
		putstr("%s\n", sysmsg(MSG_BADCOMMAND));
#else
		putstr("Bad command. Type '?' for help\n");
#endif
		return;
	}
	if ((ptr = strchr(user, '.')) != NULL) *ptr = ' ';
	if ((ptr = getnamebysign(user)) != NULL) user = ptr;

	if (del_ban(user) == 1) {
		if ((ptr = getsignbyname(user)) == NULL) ptr = user;
		message(0, ATTEMPTTOUNBAN, ptr);
#ifndef	EXTERN_APPS
		LOGIT(LOG_INFO, "UnBan \"%s\"", user);
#endif
	}
}

int
chatcmds(str)
	char *str;
{
	extern void banlist();

	if (*str == '\0') return 0;
	if (*str++ != '/') {
		if (
#ifndef	EXTERN_APPS
		    privlevel < MAXPRIVLEVEL &&
#endif
		    strstr(str, CMDSERVMARKER) != NULL) return 0;
		return 1;
	}
	if (*str == '\0') return 0;
	putchr('\n');
	switch (*str) {
#ifdef	EXTERN_APPS
		case '?':
		case 'h':
		case 'H': putstr("\
\t/c\twho in Conference\n\
\t/d\twho Do\n\
\t/w\tWho on BBS\n\
\t/q\tQuit from chat\n\
\t/i\twho Is user, usage: /i user.name\n\
\t/k\tKick user, usage: /k user.name\n\
\t/g\tGrant kick rights, usage: /g user.name\n\
\t/t\tTerminate user, usage: /t user.name\n\
\t/b\tBan user, usage: /b user.name reason...\n\
\t/u\tUnBan user(s), usage: /u user.name or /u all\n\
\t/s\tliSt of baned user(s), usage: /s [substr]\n\
\t/m\tsend Msg to user, usage: /m user.name message...\n\
"); break;
#else
		case '?':
		case 'h':
		case 'H': psysmsg(MSG_CHATHELP); break;
#endif
		case 'c':
		case 'C': who_in_conf(); break;
		case 'd':
		case 'D': whodo(TRUE); break;
#ifndef	EXTERN_APPS
		case 'l':
		case 'L': putstr("%s\n", sec2str(gettimer())); break;
#endif
		case 'q':
		case 'Q': return -1;
		case 'i':
		case 'I': if (getuserinfo(putstr, ++str) < 0)
#ifndef	EXTERN_APPS
			putstr("%s\n", sysmsg(MSG_NOSUCHUSER));
#else
			putstr("No such user\n");
#endif
			break;
		case 'k':
		case 'K': kick_user(++str); break;
		case 'g':
		case 'G': grant_kick(++str); break;
		case 't':
		case 'T': term_user(++str); break;
		case 'm':
		case 'M': private_msg(++str); break;
		case 'w':
		case 'W': who_is_there(); break;
		case 'b':
		case 'B': ban_user(++str); break;
		case 'u':
		case 'U': unban_user(++str); break;
		case 's':
		case 'S': banlist(++str); break;
		default:
#ifndef	EXTERN_APPS
		putstr("'%c' %s\n", *str, sysmsg(MSG_BADCOMMAND));
#else
		putstr("'%c' Bad command. Type '?' for help\n", *str);
#endif
	}
	flushinput();
	return 0;
}

void
go_unixchat()
{
	char *ptr, tb[128];
	int lncnt, i;
	time_t mtime;
	struct utmpent *ut;
	struct passwd *pw;

again:
	mtime = utmptime();
	lncnt = i = 0;
	endutmpent();
	while ((ut = getutmpent(NULL)) != NULL) {
		if ((pw = getpwnam(ut->name)) == NULL) continue;
		if (!lncnt) {
#ifdef	EXTERN_APPS
			putstr("The following users are presently in Unix:\n");
#else
			putstr("%s\n", sysmsg(MSG_UNIXCHATHEADER));
#endif
			putstr(" #   UserID   TTY    RealName                 LoginTime        ComingFrom\n");
#ifdef	EXTERN_APPS
			putstr("==============================================================================\n");
#else
			putstr("%s\n", sysmsg(MSG_DELIMITER));
			if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;37m");
#endif
			lncnt = 3;
		}
		if ((ptr = strchr(pw->pw_gecos, ',')) != NULL) *ptr = '\0';
		putstr("%2d)  %-8.8s %-6.6s %-24.24s %-.15s  %-.16s\n",
		       ++i, ut->name, ut->line, pw->pw_gecos,
		       ctime(&ut->time)+4, *ut->host ? ut->host : "localhost");
		if (!more(&lncnt)) break;
	}
	endutmpent();

#ifndef	EXTERN_APPS
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[0;37m");
#endif
	if (!i) {
#ifdef	EXTERN_APPS
		putstr("No users for talk\n");
#else
		putstr("%s\n", sysmsg(MSG_NOUSERSFORTALK));
#endif
		return;
	}
#ifdef	EXTERN_APPS
	putstr("Select user to talk: ");
	ptr = getstr(0, 1, ECHOENABLE);
	putchr('\n');
	lncnt = atoi(ptr);
	if (lncnt < 1 || lncnt > i) return;
#else
	if ((lncnt = prompt_num(MSG_SELECTUSERTOTALK, 0, i)) == 0) return;
#endif

	if (utmptime() != mtime) {
#ifdef	EXTERN_APPS
		putstr("Status of users was changed, refresh...\n");
#else
		putstr("%s\n", sysmsg(MSG_USERINFOWASCHANGED));
#endif
		goto again;
	}

	i = 0;
	while ((ut = getutmpent(NULL)) != NULL) {
		if ((pw = getpwnam(ut->name)) == NULL) continue;
		if (++i == lncnt) break;
	}
	endutmpent();

	if (i != lncnt) {
#ifdef	EXTERN_APPS
		putstr("This user currently unavailable for talk\n");
#else
		putstr("%s\n", sysmsg(MSG_USERCANTBETALKED));
#endif
		return;
	}
	(void)strcpy(tb, "/dev/");
	(void)strcat(tb, ut->line);
	if ((i = open(tb, O_WRONLY)) < 0) {
#ifdef	EXTERN_APPS
		putstr("This user currently unavailable for talk\n");
#else
		putstr("%s\n", sysmsg(MSG_USERCANTBETALKED));
#endif
		goto again;
	}
#ifndef	EXTERN_APPS
	if ((ptr = strchr(pw->pw_gecos, ',')) != NULL) *ptr = '\0';
	LOGIT(LOG_INFO, "Request talk to %s (%s)", pw->pw_name, pw->pw_gecos);
	if (globalflags & EXTERNALTALK) {
		process.flags |= INTALK;
		invoke_cmd("%s %s %s", talkprog, pw->pw_name, ut->line);
		return;
	}
#endif
	snprintf(tb, sizeof(tb), "\007\n\n*** Talk requested by %s (%s) USE: onboard %s ***\n",
		 process.name, process.tty, process.tty);
	write(i, tb, strlen(tb));
	globalflags |= BEGINCHAT;
	if (!talk(i)) {
		mtime = time(NULL);
		snprintf(tb, sizeof(tb), "*** %.15s - %s (%s) has stoped waiting ***\n\n",
			 ctime(&mtime)+4, process.name, process.tty);
		write(i, tb, strlen(tb));
	}
	close(i);
	talkportid = 0;
	return;
}

random_grant()
{
	char *ptr;
	struct loginfo *info;

	process.flags &= ~KICKER;
	while ((info = getinfo(FALSE)) != NULL && (info->flags & HIDDENUSER) == 0)
		if ((info->flags & INCONF) && !(info->flags & KICKER)) {
			closeinfo();
			break;
		}
	if (info != NULL && kill(info->pid, SIGPIPE) == 0) {
		if ((ptr = getsignbyname(info->name)) == NULL)
			ptr = info->name;
		message(0, ATTEMPTTOGRANT, ptr);
#ifndef	EXTERN_APPS
		LOGIT(LOG_INFO, "Random Grant \"%s\"", info->name);
#endif
	}
}

hangnetchat()
{
	if ((process.flags & INTALK) && talkportid)
		message(talkportid, "%s %s", HANGUPLINE, ENDTALKMARKER);
	if (process.flags & INCONF)
		message(0, HANGUPLINE);
}

#ifndef	EXTERN_APPS

char *
mesgtty(state)
	char *state;
{
	char *tty;
	struct stat st;

	if ((tty = (char *)ttyname(2)) == NULL) return "";
	if (stat(tty, &st) < 0) {
		LOGIT(LOG_ERR, "can't stat \"%s\":", tty);
		return "";
	}
	if (*state == 'Y' || *state == 'y') {
		process.flags &= ~MESGNO;
		st.st_mode |= S_IWGRP;
	} else if (*state == 'N' || *state == 'n') {
		process.flags |= MESGNO;
		st.st_mode &= ~S_IWGRP;
	} else return ((st.st_mode & S_IWGRP) ? "Yes" : "No");

	if (chmod(tty, st.st_mode) < 0)
		LOGIT(LOG_ERR, "can't chmod \"%s\":", tty);

	if (stat(tty, &st) < 0) return "";
	if (st.st_mode & S_IWGRP) {
		process.flags &= ~MESGNO;
		tty = "Yes";
	} else {
		process.flags |= MESGNO;
		tty = "No";
	}
	return tty;
}

static char *finghost = NULL;

void
go_finger()
{
	char *ptr, buf[256];

	if (finghost == NULL) finghost = strdup("@localhost");
	if ((ptr = prompt_str(MSG_PROMPTFINGERPROG, finghost, 0)) == NULL)
		return;
	if (!maketrueaddr(ptr, buf) ||
	    isillegaladdr(buf) ||
	    !isgrpright(GSID_EMAIL, buf, GRF_W)) {
		warning(MSG_ILLEGALADDR, 1);
		return;
	}
	if (finghost != NULL) {
		free(finghost);
		finghost = NULL;
	}
	if ((ptr = strrchr(buf, '@')) != NULL) finghost = strdup(ptr);
	LOGIT(LOG_INFO, "Finger \"%s\"", buf);
	putstr("\n%s\n", sysmsg(MSG_PLEASEWAIT));
	display(1, "|%s %s", fingerprog, buf);
}

void
go_nettalk()
{
	int i;
	char *ptr, *ptr2, buf[256];

	if ((ptr = prompt_str(MSG_PROMPTTALKPROG, NULL, 0)) != NULL) {
		i = !maketrueaddr(ptr, buf);
		if ((ptr2 = strrchr(buf, '@')) != NULL) {
			if (finghost != NULL) free(finghost);
			finghost = strdup(ptr2);
		} else	if (finghost != NULL) strcat(buf, finghost);
		if (i && (ptr2 = strchr(ptr, ' ')) != NULL) {
			for (ptr = ++ptr2; *ptr; ptr++)
				if (!isalnum(*ptr)) break;
			if (*ptr == '\0') {
				strcat(buf, " ");
				strcat(buf, ptr2);
			}
		}
		LOGIT(LOG_INFO, "Talk \"%s\"", buf);
		process.flags |= INTALK;
		invoke_cmd("%s %s", talkprog, buf);
	}
}
#endif
